import { RenderType, SideType } from '//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js';
import type { String16 } from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import type { TimeTicks } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
/** Converts a String16 to a JavaScript String. */
export declare function decodeString16(str: String16 | null): string;
/** Converts a JavaScript String to a String16. */
export declare function mojoString16(str: string): String16;
/**
 * Converts a time ticks in milliseconds to TimeTicks.
 * @param timeTicks time ticks in milliseconds
 */
export declare function mojoTimeTicks(timeTicks: number): TimeTicks;
/** Converts a side type to a string to be used in CSS. */
export declare function sideTypeToClass(sideType: SideType): string;
/** Converts a render type to a string to be used in CSS. */
export declare function renderTypeToClass(renderType: RenderType): string;
