// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import { loadTimeData } from '//resources/js/load_time_data.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { getCss } from './searchbox_thumbnail.css.js';
import { getHtml } from './searchbox_thumbnail.html.js';
// Displays a thumbnail in the searchbox input.
export class SearchboxThumbnailElement extends CrLitElement {
    static get is() {
        return 'cr-searchbox-thumbnail';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            //========================================================================
            // Private properties
            //========================================================================
            thumbnailUrl_: { type: String },
            isDeletable_: {
                type: Boolean,
                reflect: true,
            },
            enableThumbnailSizingTweaks_: {
                type: Boolean,
                reflect: true,
            },
        };
    }
    #thumbnailUrl__accessor_storage = '';
    // The URL of the thumbnail to display.
    get thumbnailUrl_() { return this.#thumbnailUrl__accessor_storage; }
    set thumbnailUrl_(value) { this.#thumbnailUrl__accessor_storage = value; }
    #isDeletable__accessor_storage = false;
    // Whether the user can delete the thumbnail.
    get isDeletable_() { return this.#isDeletable__accessor_storage; }
    set isDeletable_(value) { this.#isDeletable__accessor_storage = value; }
    #enableThumbnailSizingTweaks__accessor_storage = loadTimeData.getBoolean('enableThumbnailSizingTweaks');
    // Whether to enable thumbnail sizing tweaks.
    get enableThumbnailSizingTweaks_() { return this.#enableThumbnailSizingTweaks__accessor_storage; }
    set enableThumbnailSizingTweaks_(value) { this.#enableThumbnailSizingTweaks__accessor_storage = value; }
    //============================================================================
    // Event handlers
    //============================================================================
    onRemoveButtonClick_(e) {
        e.preventDefault();
        this.fire('remove-thumbnail-click');
    }
}
customElements.define(SearchboxThumbnailElement.is, SearchboxThumbnailElement);
