import './searchbox_compose_button.js';
import './searchbox_dropdown.js';
import './searchbox_icon.js';
import './searchbox_thumbnail.js';
import '//resources/cr_components/composebox/contextual_entrypoint_and_carousel.js';
import '//resources/cr_components/composebox/error_scrim.js';
import type { ComposeboxFile } from '//resources/cr_components/composebox/common.js';
import type { ContextualEntrypointAndCarouselElement } from '//resources/cr_components/composebox/contextual_entrypoint_and_carousel.js';
import { ComposeboxMode } from '//resources/cr_components/composebox/contextual_entrypoint_and_carousel.js';
import type { ErrorScrimElement } from '//resources/cr_components/composebox/error_scrim.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
import type { AutocompleteMatch, AutocompleteResult, TabInfo } from '//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js';
import type { UnguessableToken } from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';
import type { Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
import type { SearchboxDropdownElement } from './searchbox_dropdown.js';
import type { SearchboxIconElement } from './searchbox_icon.js';
/**
 * Responsible for cycling placeholder text animations on an HTMLInputElement.
 */
export declare class PlaceholderTextCycler {
    private input_;
    private animation_;
    private placeholderTexts_;
    private placeholderTextsCurrentIndex_;
    private changePlaceholderTextIntervalMs_;
    private fadePlaceholderTextDurationMs_;
    constructor(animatedPlaceholderContainer: HTMLInputElement, placeholderTexts: string[], changeTextAnimationIntervalMs: number, fadeTextAnimationDurationMs: number);
    start(): void;
    stop(): void;
    private animate_;
}
interface ComposeClickEventDetail {
    button: number;
    ctrlKey: boolean;
    metaKey: boolean;
    shiftKey: boolean;
}
export interface SearchboxElement {
    $: {
        icon: SearchboxIconElement;
        input: HTMLInputElement;
        inputWrapper: HTMLElement;
        matches: SearchboxDropdownElement;
        context: ContextualEntrypointAndCarouselElement;
        errorScrim: ErrorScrimElement;
    };
}
declare const SearchboxElementBase: typeof CrLitElement & (new (...args: any[]) => import("//resources/cr_elements/web_ui_listener_mixin_lit.js").WebUiListenerMixinLitInterface) & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin_lit.js").I18nMixinLitInterface);
/** A real search box that behaves just like the Omnibox. */
export declare class SearchboxElement extends SearchboxElementBase {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        /**
         * Whether the secondary side can be shown based on the feature state and
         * the width available to the dropdown.
         */
        canShowSecondarySide: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        colorSourceIsBaseline: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /** Whether the cr-searchbox-dropdown should be visible. */
        dropdownIsVisible: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /**
         * Whether the secondary side was at any point available to be shown.
         */
        hadSecondarySide: {
            type: BooleanConstructor;
            reflect: boolean;
            notify: boolean;
        };
        hasSecondarySide: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /** Whether the theme is dark. */
        isDark: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /** Whether the searchbox should match the searchbox. */
        matchSearchbox: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /** The aria description to include on the input element. */
        searchboxAriaDescription: {
            type: StringConstructor;
        };
        /** Whether the Google Lens icon should be visible in the searchbox. */
        searchboxLensSearchEnabled: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        searchboxChromeRefreshTheming: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        searchboxSteadyStateShadow: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        realboxLayoutMode: {
            type: StringConstructor;
            reflect: boolean;
        };
        ntpRealboxNextEnabled: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        cyclingPlaceholders: {
            type: BooleanConstructor;
        };
        composeboxEnabled: {
            type: BooleanConstructor;
        };
        composeButtonEnabled: {
            type: BooleanConstructor;
        };
        placeholderText: {
            type: StringConstructor;
            reflect: boolean;
            notify: boolean;
        };
        inputFocused_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        isLensSearchbox_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        enableThumbnailSizingTweaks_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /**
         * Whether user is deleting text in the input. Used to prevent the default
         * match from offering inline autocompletion.
         */
        isDeletingInput_: {
            type: BooleanConstructor;
        };
        /**
         * The 'Enter' keydown event that was ignored due to matches being stale.
         * Used to navigate to the default match once up-to-date matches arrive.
         */
        lastIgnoredEnterEvent_: {
            type: ObjectConstructor;
        };
        /**
         * Last state of the input (text and inline autocompletion). Updated
         * by the user input or by the currently selected autocomplete match.
         */
        lastInput_: {
            type: ObjectConstructor;
        };
        /** The last queried input text. */
        lastQueriedInput_: {
            type: StringConstructor;
        };
        /**
         * True if user just pasted into the input. Used to prevent the default
         * match from offering inline autocompletion.
         */
        pastedInInput_: {
            type: BooleanConstructor;
        };
        /** Searchbox default icon (i.e., Google G icon or the search loupe). */
        searchboxIcon_: {
            type: StringConstructor;
        };
        /** Whether the voice search icon should be visible in the searchbox. */
        searchboxVoiceSearchEnabled_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /** Whether the Google Lens icon should be visible in the searchbox. */
        searchboxLensSearchEnabled_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        result_: {
            type: ObjectConstructor;
        };
        /** The currently selected match, if any. */
        selectedMatch_: {
            type: ObjectConstructor;
        };
        /**
         * Index of the currently selected match, if any.
         * Do not modify this. Use <cr-searchbox-dropdown> API to change
         * selection.
         */
        selectedMatchIndex_: {
            type: NumberConstructor;
        };
        showThumbnail: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        thumbnailUrl_: {
            type: StringConstructor;
        };
        isThumbnailDeletable_: {
            type: BooleanConstructor;
        };
        /** The value of the input element's 'aria-live' attribute. */
        inputAriaLive_: {
            type: StringConstructor;
        };
        useWebkitSearchIcons_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        tabSuggestions_: {
            type: ArrayConstructor;
        };
    };
    accessor canShowSecondarySide: boolean;
    accessor colorSourceIsBaseline: boolean;
    accessor dropdownIsVisible: boolean;
    accessor hadSecondarySide: boolean;
    accessor hasSecondarySide: boolean;
    accessor isDark: boolean;
    accessor matchSearchbox: boolean;
    accessor searchboxAriaDescription: string;
    accessor searchboxLensSearchEnabled: boolean;
    accessor searchboxChromeRefreshTheming: boolean;
    accessor searchboxSteadyStateShadow: boolean;
    accessor realboxLayoutMode: string;
    accessor ntpRealboxNextEnabled: boolean;
    accessor cyclingPlaceholders: boolean;
    accessor composeboxEnabled: boolean;
    accessor composeButtonEnabled: boolean;
    accessor showThumbnail: boolean;
    accessor placeholderText: string;
    protected accessor inputAriaLive_: string;
    protected accessor inputFocused_: boolean;
    private accessor isLensSearchbox_;
    protected accessor enableThumbnailSizingTweaks_: boolean;
    private accessor isDeletingInput_;
    private accessor lastIgnoredEnterEvent_;
    private accessor lastInput_;
    private accessor lastQueriedInput_;
    private accessor pastedInInput_;
    protected accessor searchboxIcon_: string;
    protected accessor searchboxVoiceSearchEnabled_: boolean;
    protected accessor searchboxLensSearchEnabled_: boolean;
    protected accessor result_: AutocompleteResult | null;
    protected accessor selectedMatch_: AutocompleteMatch | null;
    protected accessor selectedMatchIndex_: number;
    protected accessor thumbnailUrl_: string;
    protected accessor isThumbnailDeletable_: boolean;
    private accessor useWebkitSearchIcons_;
    protected accessor tabSuggestions_: TabInfo[];
    private pageHandler_;
    private callbackRouter_;
    private autocompleteResultChangedListenerId_;
    private inputTextChangedListenerId_;
    private thumbnailChangedListenerId_;
    private onTabStripChangedListenerId_;
    private placeholderCycler_;
    constructor();
    connectedCallback(): Promise<void>;
    disconnectedCallback(): void;
    firstUpdated(): void;
    willUpdate(changedProperties: PropertyValues<this>): void;
    private computeInputAriaLive_;
    getSuggestionsElement(): SearchboxDropdownElement;
    isInputEmpty(): boolean;
    queryAutocomplete(): void;
    setInputText(text: string): void;
    focusInput(): void;
    selectAll(): void;
    private onAutocompleteResultChanged_;
    private onSetInputText_;
    private onSetThumbnail_;
    protected onInputCutCopy_(e: ClipboardEvent): void;
    protected onInputFocus_(): void;
    protected onInputInput_(e: InputEvent): void;
    protected onInputKeydown_(e: KeyboardEvent): void;
    protected onInputKeyup_(e: KeyboardEvent): void;
    protected onInputMouseDown_(e: MouseEvent): void;
    protected onInputPaste_(): void;
    protected onInputWrapperFocusout_(e: FocusEvent): void;
    protected onInputWrapperKeydown_(e: KeyboardEvent): Promise<void>;
    /**
     * @param e Event containing index of the match that received focus.
     */
    protected onMatchFocusin_(e: CustomEvent<number>): Promise<void>;
    protected onMatchClick_(): void;
    protected onVoiceSearchClick_(): void;
    protected onLensSearchClick_(): void;
    protected addFileContext_(e: CustomEvent<{
        files: File[];
        isImage: boolean;
        onContextAdded: (files: Map<UnguessableToken, ComposeboxFile>) => void;
    }>): void;
    protected addTabContext_(e: CustomEvent<{
        id: number;
        title: string;
        url: Url;
        onContextAdded: (file: ComposeboxFile) => void;
    }>): void;
    protected refreshTabSuggestions_(): Promise<void>;
    protected onFileValidationError_(e: CustomEvent<{
        errorMessage: string;
    }>): void;
    protected getTabPreview_(e: CustomEvent<{
        tabId: number;
        onPreviewFetched: (previewDataUrl: string) => void;
    }>): Promise<void>;
    protected onComposeButtonClick_(e: CustomEvent<ComposeClickEventDetail>): void;
    protected setDeepSearchMode_(): void;
    protected setCreateImageMode_(): void;
    protected openComposebox_(files?: ComposeboxFile[], mode?: ComposeboxMode): void;
    hasThumbnail(): boolean;
    protected onRemoveThumbnailClick_(): void;
    private computeSelectedMatch_;
    protected computePlaceholderText_(placeholderText: string): string;
    /**
     * Clears the autocomplete result on the page and on the autocomplete backend.
     */
    private clearAutocompleteMatches_;
    private navigateToMatch_;
    private queryAutocomplete_;
    /**
     * Updates the input state (text and inline autocompletion) with |update|.
     */
    private updateInput_;
    protected getThumbnailTabindex_(): string;
    protected onSelectedMatchIndexChanged_(e: CustomEvent<{
        value: number;
    }>): void;
    protected onHadSecondarySideChanged_(e: CustomEvent<{
        value: boolean;
    }>): void;
    protected onHasSecondarySideChanged_(e: CustomEvent<{
        value: boolean;
    }>): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'cr-searchbox': SearchboxElement;
    }
}
export {};
