// components/page_image_service/mojom/page_image_service.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const ClientIdSpec = { $: mojo.internal.Enum() };
export var ClientId;
(function (ClientId) {
    ClientId[ClientId["MIN_VALUE"] = 0] = "MIN_VALUE";
    ClientId[ClientId["MAX_VALUE"] = 6] = "MAX_VALUE";
    ClientId[ClientId["Journeys"] = 0] = "Journeys";
    ClientId[ClientId["JourneysSidePanel"] = 1] = "JourneysSidePanel";
    ClientId[ClientId["NtpRealbox"] = 2] = "NtpRealbox";
    ClientId[ClientId["NtpQuests"] = 3] = "NtpQuests";
    ClientId[ClientId["Bookmarks"] = 4] = "Bookmarks";
    ClientId[ClientId["NtpTabResumption"] = 5] = "NtpTabResumption";
    ClientId[ClientId["HistoryEmbeddings"] = 6] = "HistoryEmbeddings";
})(ClientId || (ClientId = {}));
export class PageImageServiceHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'page_image_service.mojom.PageImageServiceHandler', scope);
    }
}
export class PageImageServiceHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageImageServiceHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getPageImageUrl(clientId, pageUrl, options) {
        return this.proxy.sendMessage(0, PageImageServiceHandler_GetPageImageUrl_ParamsSpec.$, PageImageServiceHandler_GetPageImageUrl_ResponseParamsSpec.$, [
            clientId,
            pageUrl,
            options
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageImageServiceHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageImageServiceHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageImageServiceHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageImageServiceHandler_GetPageImageUrl_ParamsSpec.$, PageImageServiceHandler_GetPageImageUrl_ResponseParamsSpec.$, impl.getPageImageUrl.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageImageServiceHandler {
    static get $interfaceName() {
        return "page_image_service.mojom.PageImageServiceHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageImageServiceHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageImageServiceHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageImageServiceHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getPageImageUrl;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageImageServiceHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getPageImageUrl =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageImageServiceHandler_GetPageImageUrl_ParamsSpec.$, PageImageServiceHandler_GetPageImageUrl_ResponseParamsSpec.$, this.getPageImageUrl.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const OptionsSpec = { $: {} };
export const ImageResultSpec = { $: {} };
export const PageImageServiceHandler_GetPageImageUrl_ParamsSpec = { $: {} };
export const PageImageServiceHandler_GetPageImageUrl_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(OptionsSpec.$, 'Options', [
    mojo.internal.StructField('suggestImages', 0, 0, mojo.internal.Bool, true, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('optimizationGuideImages', 0, 1, mojo.internal.Bool, true, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ImageResultSpec.$, 'ImageResult', [
    mojo.internal.StructField('imageUrl', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageImageServiceHandler_GetPageImageUrl_ParamsSpec.$, 'PageImageServiceHandler_GetPageImageUrl_Params', [
    mojo.internal.StructField('clientId', 0, 0, ClientIdSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pageUrl', 8, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('options', 16, 0, OptionsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageImageServiceHandler_GetPageImageUrl_ResponseParamsSpec.$, 'PageImageServiceHandler_GetPageImageUrl_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, ImageResultSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
