import './composebox_tool_chip.js';
import './context_menu_entrypoint.js';
import './contextual_entrypoint_and_carousel.js';
import './composebox_dropdown.js';
import './error_scrim.js';
import './file_carousel.js';
import './icons.html.js';
import '//resources/cr_components/localized_link/localized_link.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import type { CrIconButtonElement } from '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { AutocompleteResult, TabInfo } from '//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js';
import type { UnguessableToken } from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';
import type { Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
import type { ComposeboxFile } from './common.js';
import type { ComposeboxDropdownElement } from './composebox_dropdown.js';
import type { ContextualEntrypointAndCarouselElement } from './contextual_entrypoint_and_carousel.js';
import { ComposeboxMode } from './contextual_entrypoint_and_carousel.js';
import type { ErrorScrimElement } from './error_scrim.js';
export interface ComposeboxElement {
    $: {
        cancelIcon: CrIconButtonElement;
        input: HTMLInputElement;
        composebox: HTMLElement;
        submitContainer: HTMLElement;
        matches: ComposeboxDropdownElement;
        context: ContextualEntrypointAndCarouselElement;
        errorScrim: ErrorScrimElement;
    };
}
declare const ComposeboxElement_base: typeof CrLitElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin_lit.js").I18nMixinLitInterface);
export declare class ComposeboxElement extends ComposeboxElement_base {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        input_: {
            type: StringConstructor;
        };
        isCollapsible: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        expanded_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        result_: {
            type: ObjectConstructor;
        };
        submitEnabled_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        /**
         * Index of the currently selected match, if any.
         * Do not modify this. Use <composebox-dropdown> API to change
         * selection.
         */
        selectedMatchIndex_: {
            type: NumberConstructor;
        };
        submitting_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        showDropdown_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        showSubmit_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        enableImageContextualSuggestions_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        inputPlaceholder_: {
            reflect: boolean;
            type: StringConstructor;
        };
        smartComposeEnabled_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        smartComposeInlineHint_: {
            type: StringConstructor;
        };
        showFileCarousel_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        inDeepSearchMode_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        inCreateImageMode_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        showContextMenuDescription_: {
            type: BooleanConstructor;
        };
        lensButtonDisabled_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        ntpRealboxNextEnabled: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        tabSuggestions_: {
            type: ArrayConstructor;
        };
        errorScrimVisible_: {
            type: BooleanConstructor;
        };
        contextFilesSize_: {
            type: NumberConstructor;
        };
        realboxLayoutMode: {
            type: StringConstructor;
            reflect: boolean;
        };
    };
    accessor ntpRealboxNextEnabled: boolean;
    accessor realboxLayoutMode: string;
    protected accessor isCollapsible: boolean;
    protected accessor expanded_: boolean;
    protected accessor input_: string;
    protected accessor showDropdown_: boolean;
    protected accessor showSubmit_: boolean;
    protected accessor enableImageContextualSuggestions_: boolean;
    protected accessor selectedMatchIndex_: number;
    protected accessor submitting_: boolean;
    protected accessor submitEnabled_: boolean;
    protected accessor result_: AutocompleteResult | null;
    protected accessor smartComposeInlineHint_: string;
    protected accessor smartComposeEnabled_: boolean;
    protected accessor inputPlaceholder_: string;
    protected accessor showFileCarousel_: boolean;
    protected accessor inCreateImageMode_: boolean;
    protected accessor inDeepSearchMode_: boolean;
    protected accessor showContextMenuDescription_: boolean;
    protected accessor lensButtonDisabled_: boolean;
    protected accessor tabSuggestions_: TabInfo[];
    protected accessor errorScrimVisible_: boolean;
    protected accessor contextFilesSize_: number;
    protected lastQueriedInput_: string;
    private showTypedSuggest_;
    private showZps;
    private browserProxy;
    private searchboxCallbackRouter_;
    private pageHandler_;
    private searchboxHandler_;
    private eventTracker_;
    private searchboxListenerIds;
    private composeboxCloseByEscape_;
    private selectedMatch_;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    willUpdate(changedProperties: PropertyValues<this>): void;
    updated(changedProperties: PropertyValues<this>): void;
    getText(): string;
    setText(text: string): void;
    resetModes(): void;
    closeDropdown(): void;
    getSmartComposeForTesting(): string;
    protected initializeState_(text?: string, files?: ComposeboxFile[], mode?: ComposeboxMode): void;
    protected computeCancelButtonTitle_(): string;
    private computeShowDropdown_;
    private computeSubmitEnabled_;
    protected shouldShowSuggestionActivityLink_(): boolean;
    protected shouldShowSmartComposeInlineHint_(): boolean;
    protected onFileValidationError_(e: CustomEvent<{
        errorMessage: string;
    }>): void;
    protected deleteContext_(e: CustomEvent<{
        uuid: UnguessableToken;
    }>): Promise<void>;
    protected addFileContext_(e: CustomEvent<{
        files: File[];
        isImage: boolean;
        onContextAdded: (files: Map<UnguessableToken, ComposeboxFile>) => void;
    }>): Promise<void>;
    protected addTabContext_(e: CustomEvent<{
        id: number;
        title: string;
        url: Url;
        onContextAdded: (file: ComposeboxFile) => void;
    }>): Promise<void>;
    protected refreshTabSuggestions_(): Promise<void>;
    protected getTabPreview_(e: CustomEvent<{
        tabId: number;
        onPreviewFetched: (previewDataUrl: string) => void;
    }>): Promise<void>;
    protected onCancelClick_(): void;
    protected onLensClick_(): void;
    protected onLensIconMouseDown_(e: MouseEvent): void;
    private updateInputPlaceholder_;
    protected setDeepSearchMode_(e: CustomEvent<{
        inDeepSearchMode: boolean;
    }>): Promise<void>;
    protected setCreateImageMode_(e: CustomEvent<{
        inCreateImageMode: boolean;
        imagePresent: boolean;
    }>): Promise<void>;
    protected onErrorScrimVisibilityChanged_(e: CustomEvent<{
        showErrorScrim: boolean;
    }>): void;
    protected handleInput_(e: Event): void;
    protected onKeydown_(e: KeyboardEvent): void;
    protected handleInputFocusIn_(): void;
    protected handleInputFocusOut_(): void;
    protected handleComposeboxFocusIn_(e: FocusEvent): void;
    protected handleComposeboxFocusOut_(e: FocusEvent): void;
    protected handleScroll_(): void;
    protected handleSubmitFocusIn_(): void;
    private closeComposebox_;
    protected submitQuery_(e: KeyboardEvent | MouseEvent): void;
    /**
     * @param e Event containing index of the match that received focus.
     */
    protected onMatchFocusin_(e: CustomEvent<{
        index: number;
    }>): void;
    protected onMatchClick_(): void;
    protected onSelectedMatchIndexChanged_(e: CustomEvent<{
        value: number;
    }>): void;
    /**
     * Clears the autocomplete result on the page and on the autocomplete backend.
     */
    private clearAutocompleteMatches_;
    private onAutocompleteResultChanged_;
    private onContextualInputStatusChanged_;
    private adjustInputForSmartCompose;
    private queryAutocomplete;
}
declare global {
    interface HTMLElementTagNameMap {
        'ntp-composebox': ComposeboxElement;
    }
}
export {};
