import type { Uuid } from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import type { Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
import { PageCallbackRouter, ProductSpecificationsHandlerRemote } from './product_specifications.mojom-webui.js';
import type { DisclosureVersion, ShowSetDisposition } from './product_specifications.mojom-webui.ts';
export interface ProductSpecificationsBrowserProxy {
    getCallbackRouter(): PageCallbackRouter;
    showProductSpecificationsSetForUuid(uuid: Uuid, inNewTab: boolean): void;
    showProductSpecificationsSetsForUuids(uuids: Uuid[], disposition: ShowSetDisposition): void;
    showComparePage(inNewTab: boolean): void;
    setAcceptedDisclosureVersion(version: DisclosureVersion): void;
    maybeShowDisclosure(urls: Url[], name: string, setId: string): Promise<{
        disclosureShown: boolean;
    }>;
    declineDisclosure(): void;
    showSyncSetupFlow(): void;
    getPageTitleFromHistory(url: Url): Promise<{
        title: string;
    }>;
    getComparisonTableUrlForUuid(uuid: Uuid): Promise<{
        url: Url;
    }>;
}
export declare class ProductSpecificationsBrowserProxyImpl implements ProductSpecificationsBrowserProxy {
    handler: ProductSpecificationsHandlerRemote;
    callbackRouter: PageCallbackRouter;
    constructor();
    showSyncSetupFlow(): void;
    setAcceptedDisclosureVersion(version: DisclosureVersion): void;
    showProductSpecificationsSetForUuid(uuid: Uuid, inNewTab: boolean): void;
    showProductSpecificationsSetsForUuids(uuids: Uuid[], disposition: ShowSetDisposition): void;
    showComparePage(inNewTab: boolean): void;
    maybeShowDisclosure(urls: Url[], name: string, setId: string): Promise<{
        disclosureShown: boolean;
    }>;
    declineDisclosure(): void;
    getPageTitleFromHistory(url: Url): Promise<{
        title: string;
    }>;
    getComparisonTableUrlForUuid(uuid: Uuid): Promise<{
        url: Url;
    }>;
    getCallbackRouter(): PageCallbackRouter;
    static getInstance(): ProductSpecificationsBrowserProxy;
    static setInstance(obj: ProductSpecificationsBrowserProxy): void;
}
