// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { PageCallbackRouter, PriceTrackingHandlerFactory, PriceTrackingHandlerRemote } from './price_tracking.mojom-webui.js';
let instance = null;
export class PriceTrackingBrowserProxyImpl {
    handler;
    callbackRouter;
    constructor() {
        this.callbackRouter = new PageCallbackRouter();
        this.handler = new PriceTrackingHandlerRemote();
        const factory = PriceTrackingHandlerFactory.getRemote();
        factory.createPriceTrackingHandler(this.callbackRouter.$.bindNewPipeAndPassRemote(), this.handler.$.bindNewPipeAndPassReceiver());
    }
    trackPriceForBookmark(bookmarkId) {
        this.handler.trackPriceForBookmark(bookmarkId);
    }
    untrackPriceForBookmark(bookmarkId) {
        this.handler.untrackPriceForBookmark(bookmarkId);
    }
    setPriceTrackingStatusForCurrentUrl(track) {
        this.handler.setPriceTrackingStatusForCurrentUrl(track);
    }
    getAllPriceTrackedBookmarkProductInfo() {
        return this.handler.getAllPriceTrackedBookmarkProductInfo();
    }
    getAllShoppingBookmarkProductInfo() {
        return this.handler.getAllShoppingBookmarkProductInfo();
    }
    getShoppingCollectionBookmarkFolderId() {
        return this.handler.getShoppingCollectionBookmarkFolderId();
    }
    getParentBookmarkFolderNameForCurrentUrl() {
        return this.handler.getParentBookmarkFolderNameForCurrentUrl();
    }
    showBookmarkEditorForCurrentUrl() {
        this.handler.showBookmarkEditorForCurrentUrl();
    }
    getCallbackRouter() {
        return this.callbackRouter;
    }
    static getInstance() {
        return instance || (instance = new PriceTrackingBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
