// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{BigBufferSpec as mojoBase_mojom_BigBufferSpec}from"../../../mojo/public/mojom/base/big_buffer.mojom-webui.js";import{String16Spec as mojoBase_mojom_String16Spec}from"../../../mojo/public/mojom/base/string16.mojom-webui.js";import{JSTimeSpec as mojoBase_mojom_JSTimeSpec,TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,TimeTicksSpec as mojoBase_mojom_TimeTicksSpec}from"../../../mojo/public/mojom/base/time.mojom-webui.js";import{UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec}from"../../../mojo/public/mojom/base/unguessable_token.mojom-webui.js";import{UrlSpec as url_mojom_UrlSpec}from"../../../url/mojom/url.mojom-webui.js";import{FileUploadErrorTypeSpec as composeboxQuery_mojom_FileUploadErrorTypeSpec,FileUploadStatusSpec as composeboxQuery_mojom_FileUploadStatusSpec}from"../composebox/composebox_query.mojom-webui.js";import{NavigationPredictorSpec as omnibox_mojom_NavigationPredictorSpec}from"./omnibox.mojom-webui.js";export const SideTypeSpec={$:mojo.internal.Enum()};export var SideType;(function(SideType){SideType[SideType["MIN_VALUE"]=0]="MIN_VALUE";SideType[SideType["MAX_VALUE"]=1]="MAX_VALUE";SideType[SideType["kDefaultPrimary"]=0]="kDefaultPrimary";SideType[SideType["kSecondary"]=1]="kSecondary"})(SideType||(SideType={}));export const RenderTypeSpec={$:mojo.internal.Enum()};export var RenderType;(function(RenderType){RenderType[RenderType["MIN_VALUE"]=0]="MIN_VALUE";RenderType[RenderType["MAX_VALUE"]=2]="MAX_VALUE";RenderType[RenderType["kDefaultVertical"]=0]="kDefaultVertical";RenderType[RenderType["kHorizontal"]=1]="kHorizontal";RenderType[RenderType["kGrid"]=2]="kGrid"})(RenderType||(RenderType={}));export const SelectionLineStateSpec={$:mojo.internal.Enum()};export var SelectionLineState;(function(SelectionLineState){SelectionLineState[SelectionLineState["MIN_VALUE"]=1]="MIN_VALUE";SelectionLineState[SelectionLineState["MAX_VALUE"]=4]="MAX_VALUE";SelectionLineState[SelectionLineState["kNormal"]=1]="kNormal";SelectionLineState[SelectionLineState["kKeywordMode"]=2]="kKeywordMode";SelectionLineState[SelectionLineState["kFocusedButtonAction"]=3]="kFocusedButtonAction";SelectionLineState[SelectionLineState["kFocusedButtonRemoveSuggestion"]=4]="kFocusedButtonRemoveSuggestion"})(SelectionLineState||(SelectionLineState={}));export class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"searchbox.mojom.PageHandler",scope)}}export class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}setPage(page){this.proxy.sendMessage(0,PageHandler_SetPage_ParamsSpec.$,null,[page],false)}onFocusChanged(focused){this.proxy.sendMessage(1,PageHandler_OnFocusChanged_ParamsSpec.$,null,[focused],false)}queryAutocomplete(input,preventInlineAutocomplete){this.proxy.sendMessage(2,PageHandler_QueryAutocomplete_ParamsSpec.$,null,[input,preventInlineAutocomplete],false)}stopAutocomplete(clearResult){this.proxy.sendMessage(3,PageHandler_StopAutocomplete_ParamsSpec.$,null,[clearResult],false)}openAutocompleteMatch(line,url,areMatchesShowing,mouseButton,altKey,ctrlKey,metaKey,shiftKey){this.proxy.sendMessage(4,PageHandler_OpenAutocompleteMatch_ParamsSpec.$,null,[line,url,areMatchesShowing,mouseButton,altKey,ctrlKey,metaKey,shiftKey],false)}onNavigationLikely(line,url,navigationPredictor){this.proxy.sendMessage(5,PageHandler_OnNavigationLikely_ParamsSpec.$,null,[line,url,navigationPredictor],false)}deleteAutocompleteMatch(line,url){this.proxy.sendMessage(6,PageHandler_DeleteAutocompleteMatch_ParamsSpec.$,null,[line,url],false)}activateKeyword(line,url,matchSelectionTimestamp,isMouseEvent){this.proxy.sendMessage(7,PageHandler_ActivateKeyword_ParamsSpec.$,null,[line,url,matchSelectionTimestamp,isMouseEvent],false)}executeAction(line,actionIndex,url,matchSelectionTimestamp,mouseButton,altKey,ctrlKey,metaKey,shiftKey){this.proxy.sendMessage(8,PageHandler_ExecuteAction_ParamsSpec.$,null,[line,actionIndex,url,matchSelectionTimestamp,mouseButton,altKey,ctrlKey,metaKey,shiftKey],false)}onThumbnailRemoved(){this.proxy.sendMessage(9,PageHandler_OnThumbnailRemoved_ParamsSpec.$,null,[],false)}getPlaceholderConfig(){return this.proxy.sendMessage(10,PageHandler_GetPlaceholderConfig_ParamsSpec.$,PageHandler_GetPlaceholderConfig_ResponseParamsSpec.$,[],false)}getRecentTabs(){return this.proxy.sendMessage(11,PageHandler_GetRecentTabs_ParamsSpec.$,PageHandler_GetRecentTabs_ResponseParamsSpec.$,[],false)}getTabPreview(tabId){return this.proxy.sendMessage(12,PageHandler_GetTabPreview_ParamsSpec.$,PageHandler_GetTabPreview_ResponseParamsSpec.$,[tabId],false)}notifySessionStarted(){this.proxy.sendMessage(13,PageHandler_NotifySessionStarted_ParamsSpec.$,null,[],false)}notifySessionAbandoned(){this.proxy.sendMessage(14,PageHandler_NotifySessionAbandoned_ParamsSpec.$,null,[],false)}addFileContext(fileInfo,fileBytes){return this.proxy.sendMessage(15,PageHandler_AddFileContext_ParamsSpec.$,PageHandler_AddFileContext_ResponseParamsSpec.$,[fileInfo,fileBytes],false)}addTabContext(tabId){return this.proxy.sendMessage(16,PageHandler_AddTabContext_ParamsSpec.$,PageHandler_AddTabContext_ResponseParamsSpec.$,[tabId],false)}deleteContext(token){this.proxy.sendMessage(17,PageHandler_DeleteContext_ParamsSpec.$,null,[token],false)}clearFiles(){this.proxy.sendMessage(18,PageHandler_ClearFiles_ParamsSpec.$,null,[],false)}submitQuery(queryText,mouseButton,altKey,ctrlKey,metaKey,shiftKey){this.proxy.sendMessage(19,PageHandler_SubmitQuery_ParamsSpec.$,null,[queryText,mouseButton,altKey,ctrlKey,metaKey,shiftKey],false)}}export class PageHandlerReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PageHandler_SetPage_ParamsSpec.$,null,impl.setPage.bind(impl),false);this.helper_internal_.registerHandler(1,PageHandler_OnFocusChanged_ParamsSpec.$,null,impl.onFocusChanged.bind(impl),false);this.helper_internal_.registerHandler(2,PageHandler_QueryAutocomplete_ParamsSpec.$,null,impl.queryAutocomplete.bind(impl),false);this.helper_internal_.registerHandler(3,PageHandler_StopAutocomplete_ParamsSpec.$,null,impl.stopAutocomplete.bind(impl),false);this.helper_internal_.registerHandler(4,PageHandler_OpenAutocompleteMatch_ParamsSpec.$,null,impl.openAutocompleteMatch.bind(impl),false);this.helper_internal_.registerHandler(5,PageHandler_OnNavigationLikely_ParamsSpec.$,null,impl.onNavigationLikely.bind(impl),false);this.helper_internal_.registerHandler(6,PageHandler_DeleteAutocompleteMatch_ParamsSpec.$,null,impl.deleteAutocompleteMatch.bind(impl),false);this.helper_internal_.registerHandler(7,PageHandler_ActivateKeyword_ParamsSpec.$,null,impl.activateKeyword.bind(impl),false);this.helper_internal_.registerHandler(8,PageHandler_ExecuteAction_ParamsSpec.$,null,impl.executeAction.bind(impl),false);this.helper_internal_.registerHandler(9,PageHandler_OnThumbnailRemoved_ParamsSpec.$,null,impl.onThumbnailRemoved.bind(impl),false);this.helper_internal_.registerHandler(10,PageHandler_GetPlaceholderConfig_ParamsSpec.$,PageHandler_GetPlaceholderConfig_ResponseParamsSpec.$,impl.getPlaceholderConfig.bind(impl),false);this.helper_internal_.registerHandler(11,PageHandler_GetRecentTabs_ParamsSpec.$,PageHandler_GetRecentTabs_ResponseParamsSpec.$,impl.getRecentTabs.bind(impl),false);this.helper_internal_.registerHandler(12,PageHandler_GetTabPreview_ParamsSpec.$,PageHandler_GetTabPreview_ResponseParamsSpec.$,impl.getTabPreview.bind(impl),false);this.helper_internal_.registerHandler(13,PageHandler_NotifySessionStarted_ParamsSpec.$,null,impl.notifySessionStarted.bind(impl),false);this.helper_internal_.registerHandler(14,PageHandler_NotifySessionAbandoned_ParamsSpec.$,null,impl.notifySessionAbandoned.bind(impl),false);this.helper_internal_.registerHandler(15,PageHandler_AddFileContext_ParamsSpec.$,PageHandler_AddFileContext_ResponseParamsSpec.$,impl.addFileContext.bind(impl),false);this.helper_internal_.registerHandler(16,PageHandler_AddTabContext_ParamsSpec.$,PageHandler_AddTabContext_ResponseParamsSpec.$,impl.addTabContext.bind(impl),false);this.helper_internal_.registerHandler(17,PageHandler_DeleteContext_ParamsSpec.$,null,impl.deleteContext.bind(impl),false);this.helper_internal_.registerHandler(18,PageHandler_ClearFiles_ParamsSpec.$,null,impl.clearFiles.bind(impl),false);this.helper_internal_.registerHandler(19,PageHandler_SubmitQuery_ParamsSpec.$,null,impl.submitQuery.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PageHandler{static get $interfaceName(){return"searchbox.mojom.PageHandler"}static getRemote(){let remote=new PageHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageHandlerCallbackRouter{helper_internal_;$;router_;setPage;onFocusChanged;queryAutocomplete;stopAutocomplete;openAutocompleteMatch;onNavigationLikely;deleteAutocompleteMatch;activateKeyword;executeAction;onThumbnailRemoved;getPlaceholderConfig;getRecentTabs;getTabPreview;notifySessionStarted;notifySessionAbandoned;addFileContext;addTabContext;deleteContext;clearFiles;submitQuery;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.setPage=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PageHandler_SetPage_ParamsSpec.$,null,this.setPage.createReceiverHandler(false),false);this.onFocusChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,PageHandler_OnFocusChanged_ParamsSpec.$,null,this.onFocusChanged.createReceiverHandler(false),false);this.queryAutocomplete=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,PageHandler_QueryAutocomplete_ParamsSpec.$,null,this.queryAutocomplete.createReceiverHandler(false),false);this.stopAutocomplete=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,PageHandler_StopAutocomplete_ParamsSpec.$,null,this.stopAutocomplete.createReceiverHandler(false),false);this.openAutocompleteMatch=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,PageHandler_OpenAutocompleteMatch_ParamsSpec.$,null,this.openAutocompleteMatch.createReceiverHandler(false),false);this.onNavigationLikely=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,PageHandler_OnNavigationLikely_ParamsSpec.$,null,this.onNavigationLikely.createReceiverHandler(false),false);this.deleteAutocompleteMatch=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,PageHandler_DeleteAutocompleteMatch_ParamsSpec.$,null,this.deleteAutocompleteMatch.createReceiverHandler(false),false);this.activateKeyword=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,PageHandler_ActivateKeyword_ParamsSpec.$,null,this.activateKeyword.createReceiverHandler(false),false);this.executeAction=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,PageHandler_ExecuteAction_ParamsSpec.$,null,this.executeAction.createReceiverHandler(false),false);this.onThumbnailRemoved=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,PageHandler_OnThumbnailRemoved_ParamsSpec.$,null,this.onThumbnailRemoved.createReceiverHandler(false),false);this.getPlaceholderConfig=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,PageHandler_GetPlaceholderConfig_ParamsSpec.$,PageHandler_GetPlaceholderConfig_ResponseParamsSpec.$,this.getPlaceholderConfig.createReceiverHandler(true),false);this.getRecentTabs=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,PageHandler_GetRecentTabs_ParamsSpec.$,PageHandler_GetRecentTabs_ResponseParamsSpec.$,this.getRecentTabs.createReceiverHandler(true),false);this.getTabPreview=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,PageHandler_GetTabPreview_ParamsSpec.$,PageHandler_GetTabPreview_ResponseParamsSpec.$,this.getTabPreview.createReceiverHandler(true),false);this.notifySessionStarted=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(13,PageHandler_NotifySessionStarted_ParamsSpec.$,null,this.notifySessionStarted.createReceiverHandler(false),false);this.notifySessionAbandoned=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(14,PageHandler_NotifySessionAbandoned_ParamsSpec.$,null,this.notifySessionAbandoned.createReceiverHandler(false),false);this.addFileContext=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(15,PageHandler_AddFileContext_ParamsSpec.$,PageHandler_AddFileContext_ResponseParamsSpec.$,this.addFileContext.createReceiverHandler(true),false);this.addTabContext=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(16,PageHandler_AddTabContext_ParamsSpec.$,PageHandler_AddTabContext_ResponseParamsSpec.$,this.addTabContext.createReceiverHandler(true),false);this.deleteContext=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(17,PageHandler_DeleteContext_ParamsSpec.$,null,this.deleteContext.createReceiverHandler(false),false);this.clearFiles=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(18,PageHandler_ClearFiles_ParamsSpec.$,null,this.clearFiles.createReceiverHandler(false),false);this.submitQuery=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(19,PageHandler_SubmitQuery_ParamsSpec.$,null,this.submitQuery.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"searchbox.mojom.Page",scope)}}export class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}autocompleteResultChanged(result){this.proxy.sendMessage(0,Page_AutocompleteResultChanged_ParamsSpec.$,null,[result],false)}updateSelection(oldSelection,selection){this.proxy.sendMessage(1,Page_UpdateSelection_ParamsSpec.$,null,[oldSelection,selection],false)}setInputText(input){this.proxy.sendMessage(2,Page_SetInputText_ParamsSpec.$,null,[input],false)}setThumbnail(thumbnailUrl,isDeletable){this.proxy.sendMessage(3,Page_SetThumbnail_ParamsSpec.$,null,[thumbnailUrl,isDeletable],false)}onContextualInputStatusChanged(token,status,errorType){this.proxy.sendMessage(4,Page_OnContextualInputStatusChanged_ParamsSpec.$,null,[token,status,errorType],false)}onTabStripChanged(){this.proxy.sendMessage(5,Page_OnTabStripChanged_ParamsSpec.$,null,[],false)}}export class PageReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,Page_AutocompleteResultChanged_ParamsSpec.$,null,impl.autocompleteResultChanged.bind(impl),false);this.helper_internal_.registerHandler(1,Page_UpdateSelection_ParamsSpec.$,null,impl.updateSelection.bind(impl),false);this.helper_internal_.registerHandler(2,Page_SetInputText_ParamsSpec.$,null,impl.setInputText.bind(impl),false);this.helper_internal_.registerHandler(3,Page_SetThumbnail_ParamsSpec.$,null,impl.setThumbnail.bind(impl),false);this.helper_internal_.registerHandler(4,Page_OnContextualInputStatusChanged_ParamsSpec.$,null,impl.onContextualInputStatusChanged.bind(impl),false);this.helper_internal_.registerHandler(5,Page_OnTabStripChanged_ParamsSpec.$,null,impl.onTabStripChanged.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class Page{static get $interfaceName(){return"searchbox.mojom.Page"}static getRemote(){let remote=new PageRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageCallbackRouter{helper_internal_;$;router_;autocompleteResultChanged;updateSelection;setInputText;setThumbnail;onContextualInputStatusChanged;onTabStripChanged;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.autocompleteResultChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Page_AutocompleteResultChanged_ParamsSpec.$,null,this.autocompleteResultChanged.createReceiverHandler(false),false);this.updateSelection=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,Page_UpdateSelection_ParamsSpec.$,null,this.updateSelection.createReceiverHandler(false),false);this.setInputText=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,Page_SetInputText_ParamsSpec.$,null,this.setInputText.createReceiverHandler(false),false);this.setThumbnail=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,Page_SetThumbnail_ParamsSpec.$,null,this.setThumbnail.createReceiverHandler(false),false);this.onContextualInputStatusChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,Page_OnContextualInputStatusChanged_ParamsSpec.$,null,this.onContextualInputStatusChanged.createReceiverHandler(false),false);this.onTabStripChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,Page_OnTabStripChanged_ParamsSpec.$,null,this.onTabStripChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const ACMatchClassificationSpec={$:{}};export const ActionSpec={$:{}};export const SuggestionAnswerSpec={$:{}};export const AutocompleteMatchSpec={$:{}};export const TabInfoSpec={$:{}};export const SelectedFileInfoSpec={$:{}};export const SuggestionGroupSpec={$:{}};export const AutocompleteResultSpec={$:{}};export const OmniboxPopupSelectionSpec={$:{}};export const PlaceholderConfigSpec={$:{}};export const PageHandler_SetPage_ParamsSpec={$:{}};export const PageHandler_OnFocusChanged_ParamsSpec={$:{}};export const PageHandler_QueryAutocomplete_ParamsSpec={$:{}};export const PageHandler_StopAutocomplete_ParamsSpec={$:{}};export const PageHandler_OpenAutocompleteMatch_ParamsSpec={$:{}};export const PageHandler_OnNavigationLikely_ParamsSpec={$:{}};export const PageHandler_DeleteAutocompleteMatch_ParamsSpec={$:{}};export const PageHandler_ActivateKeyword_ParamsSpec={$:{}};export const PageHandler_ExecuteAction_ParamsSpec={$:{}};export const PageHandler_OnThumbnailRemoved_ParamsSpec={$:{}};export const PageHandler_GetPlaceholderConfig_ParamsSpec={$:{}};export const PageHandler_GetPlaceholderConfig_ResponseParamsSpec={$:{}};export const PageHandler_GetRecentTabs_ParamsSpec={$:{}};export const PageHandler_GetRecentTabs_ResponseParamsSpec={$:{}};export const PageHandler_GetTabPreview_ParamsSpec={$:{}};export const PageHandler_GetTabPreview_ResponseParamsSpec={$:{}};export const PageHandler_NotifySessionStarted_ParamsSpec={$:{}};export const PageHandler_NotifySessionAbandoned_ParamsSpec={$:{}};export const PageHandler_AddFileContext_ParamsSpec={$:{}};export const PageHandler_AddFileContext_ResponseParamsSpec={$:{}};export const PageHandler_AddTabContext_ParamsSpec={$:{}};export const PageHandler_AddTabContext_ResponseParamsSpec={$:{}};export const PageHandler_DeleteContext_ParamsSpec={$:{}};export const PageHandler_ClearFiles_ParamsSpec={$:{}};export const PageHandler_SubmitQuery_ParamsSpec={$:{}};export const Page_AutocompleteResultChanged_ParamsSpec={$:{}};export const Page_UpdateSelection_ParamsSpec={$:{}};export const Page_SetInputText_ParamsSpec={$:{}};export const Page_SetThumbnail_ParamsSpec={$:{}};export const Page_OnContextualInputStatusChanged_ParamsSpec={$:{}};export const Page_OnTabStripChanged_ParamsSpec={$:{}};mojo.internal.Struct(ACMatchClassificationSpec.$,"ACMatchClassification",[mojo.internal.StructField("offset",0,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("style",4,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ActionSpec.$,"Action",[mojo.internal.StructField("hint",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("suggestionContents",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("iconPath",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("a11yLabel",24,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(SuggestionAnswerSpec.$,"SuggestionAnswer",[mojo.internal.StructField("firstLine",0,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("secondLine",8,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AutocompleteMatchSpec.$,"AutocompleteMatch",[mojo.internal.StructField("a11yLabel",0,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("allowedToBeDefaultMatch",8,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("actions",16,0,mojo.internal.Array(ActionSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("answer",24,0,SuggestionAnswerSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("contents",32,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("contentsClass",40,0,mojo.internal.Array(ACMatchClassificationSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("description",48,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("descriptionClass",56,0,mojo.internal.Array(ACMatchClassificationSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("destinationUrl",64,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("inlineAutocompletion",72,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("fillIntoEdit",80,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("is_weather_answer_suggestion_$flag",8,1,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"is_weather_answer_suggestion_$value",originalFieldName:"isWeatherAnswerSuggestion"},undefined),mojo.internal.StructField("is_weather_answer_suggestion_$value",8,2,mojo.internal.Bool,false,false,0,{isPrimary:false,originalFieldName:"isWeatherAnswerSuggestion"},undefined),mojo.internal.StructField("iconPath",88,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("iconUrl",96,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("imageDominantColor",104,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("imageUrl",112,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("isNoncannedAimSuggestion",8,3,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isRichSuggestion",8,4,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isSearchType",8,5,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isEnterpriseSearchAggregatorPeopleType",8,6,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("type",120,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("removeButtonA11yLabel",128,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("swapContentsAndDescription",8,7,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("suggestionGroupId",12,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("supportsDeletion",9,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("tailSuggestCommonPrefix",136,0,mojoBase_mojom_String16Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("hasInstantKeyword",9,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("keywordChipHint",144,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("keywordChipA11y",152,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,168]]);mojo.internal.Struct(TabInfoSpec.$,"TabInfo",[mojo.internal.StructField("tabId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("title",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("url",16,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("lastActive",24,0,mojoBase_mojom_TimeTicksSpec.$,null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(SelectedFileInfoSpec.$,"SelectedFileInfo",[mojo.internal.StructField("fileName",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("mimeType",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("selectionTime",16,0,mojoBase_mojom_JSTimeSpec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(SuggestionGroupSpec.$,"SuggestionGroup",[mojo.internal.StructField("header",0,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("renderType",8,0,RenderTypeSpec.$,RenderType.kDefaultVertical,false,0,undefined,undefined),mojo.internal.StructField("sideType",12,0,SideTypeSpec.$,SideType.kDefaultPrimary,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(AutocompleteResultSpec.$,"AutocompleteResult",[mojo.internal.StructField("input",0,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("suggestionGroupsMap",8,0,mojo.internal.Map(mojo.internal.Int32,SuggestionGroupSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("matches",16,0,mojo.internal.Array(AutocompleteMatchSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("smartComposeInlineHint",24,0,mojoBase_mojom_String16Spec.$,null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(OmniboxPopupSelectionSpec.$,"OmniboxPopupSelection",[mojo.internal.StructField("line",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("state",4,0,SelectionLineStateSpec.$,1,false,0,undefined,undefined),mojo.internal.StructField("actionIndex",1,0,mojo.internal.Uint8,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PlaceholderConfigSpec.$,"PlaceholderConfig",[mojo.internal.StructField("texts",0,0,mojo.internal.Array(mojoBase_mojom_String16Spec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("changeTextAnimationInterval",8,0,mojoBase_mojom_TimeDeltaSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("fadeTextAnimationDuration",16,0,mojoBase_mojom_TimeDeltaSpec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_SetPage_ParamsSpec.$,"PageHandler_SetPage_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_OnFocusChanged_ParamsSpec.$,"PageHandler_OnFocusChanged_Params",[mojo.internal.StructField("focused",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_QueryAutocomplete_ParamsSpec.$,"PageHandler_QueryAutocomplete_Params",[mojo.internal.StructField("input",0,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("preventInlineAutocomplete",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_StopAutocomplete_ParamsSpec.$,"PageHandler_StopAutocomplete_Params",[mojo.internal.StructField("clearResult",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_OpenAutocompleteMatch_ParamsSpec.$,"PageHandler_OpenAutocompleteMatch_Params",[mojo.internal.StructField("line",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("url",8,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("areMatchesShowing",1,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("mouseButton",2,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("altKey",1,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("ctrlKey",1,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("metaKey",1,3,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("shiftKey",1,4,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_OnNavigationLikely_ParamsSpec.$,"PageHandler_OnNavigationLikely_Params",[mojo.internal.StructField("line",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("url",8,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("navigationPredictor",4,0,omnibox_mojom_NavigationPredictorSpec.$,1,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_DeleteAutocompleteMatch_ParamsSpec.$,"PageHandler_DeleteAutocompleteMatch_Params",[mojo.internal.StructField("line",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("url",8,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_ActivateKeyword_ParamsSpec.$,"PageHandler_ActivateKeyword_Params",[mojo.internal.StructField("line",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("url",8,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("matchSelectionTimestamp",16,0,mojoBase_mojom_TimeTicksSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("isMouseEvent",1,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_ExecuteAction_ParamsSpec.$,"PageHandler_ExecuteAction_Params",[mojo.internal.StructField("line",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("actionIndex",1,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("url",8,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("matchSelectionTimestamp",16,0,mojoBase_mojom_TimeTicksSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("mouseButton",2,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("altKey",3,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("ctrlKey",3,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("metaKey",3,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("shiftKey",3,3,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_OnThumbnailRemoved_ParamsSpec.$,"PageHandler_OnThumbnailRemoved_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetPlaceholderConfig_ParamsSpec.$,"PageHandler_GetPlaceholderConfig_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetPlaceholderConfig_ResponseParamsSpec.$,"PageHandler_GetPlaceholderConfig_ResponseParams",[mojo.internal.StructField("config",0,0,PlaceholderConfigSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetRecentTabs_ParamsSpec.$,"PageHandler_GetRecentTabs_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetRecentTabs_ResponseParamsSpec.$,"PageHandler_GetRecentTabs_ResponseParams",[mojo.internal.StructField("tabs",0,0,mojo.internal.Array(TabInfoSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetTabPreview_ParamsSpec.$,"PageHandler_GetTabPreview_Params",[mojo.internal.StructField("tabId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetTabPreview_ResponseParamsSpec.$,"PageHandler_GetTabPreview_ResponseParams",[mojo.internal.StructField("previewDataUrl",0,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_NotifySessionStarted_ParamsSpec.$,"PageHandler_NotifySessionStarted_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_NotifySessionAbandoned_ParamsSpec.$,"PageHandler_NotifySessionAbandoned_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_AddFileContext_ParamsSpec.$,"PageHandler_AddFileContext_Params",[mojo.internal.StructField("fileInfo",0,0,SelectedFileInfoSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("fileBytes",8,0,mojoBase_mojom_BigBufferSpec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PageHandler_AddFileContext_ResponseParamsSpec.$,"PageHandler_AddFileContext_ResponseParams",[mojo.internal.StructField("token",0,0,mojoBase_mojom_UnguessableTokenSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_AddTabContext_ParamsSpec.$,"PageHandler_AddTabContext_Params",[mojo.internal.StructField("tabId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_AddTabContext_ResponseParamsSpec.$,"PageHandler_AddTabContext_ResponseParams",[mojo.internal.StructField("token",0,0,mojoBase_mojom_UnguessableTokenSpec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_DeleteContext_ParamsSpec.$,"PageHandler_DeleteContext_Params",[mojo.internal.StructField("token",0,0,mojoBase_mojom_UnguessableTokenSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ClearFiles_ParamsSpec.$,"PageHandler_ClearFiles_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_SubmitQuery_ParamsSpec.$,"PageHandler_SubmitQuery_Params",[mojo.internal.StructField("queryText",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("mouseButton",8,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("altKey",9,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("ctrlKey",9,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("metaKey",9,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("shiftKey",9,3,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Page_AutocompleteResultChanged_ParamsSpec.$,"Page_AutocompleteResultChanged_Params",[mojo.internal.StructField("result",0,0,AutocompleteResultSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_UpdateSelection_ParamsSpec.$,"Page_UpdateSelection_Params",[mojo.internal.StructField("oldSelection",0,0,OmniboxPopupSelectionSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("selection",8,0,OmniboxPopupSelectionSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Page_SetInputText_ParamsSpec.$,"Page_SetInputText_Params",[mojo.internal.StructField("input",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_SetThumbnail_ParamsSpec.$,"Page_SetThumbnail_Params",[mojo.internal.StructField("thumbnailUrl",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("isDeletable",8,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Page_OnContextualInputStatusChanged_ParamsSpec.$,"Page_OnContextualInputStatusChanged_Params",[mojo.internal.StructField("token",0,0,mojoBase_mojom_UnguessableTokenSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("status",8,0,composeboxQuery_mojom_FileUploadStatusSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("error_type_$flag",12,0,mojo.internal.Bool,false,false,0,{isPrimary:true,linkedValueFieldName:"error_type_$value",originalFieldName:"errorType"},undefined),mojo.internal.StructField("error_type_$value",16,0,composeboxQuery_mojom_FileUploadErrorTypeSpec.$,0,false,0,{isPrimary:false,originalFieldName:"errorType"},undefined)],[[0,32]]);mojo.internal.Struct(Page_OnTabStripChanged_ParamsSpec.$,"Page_OnTabStripChanged_Params",[],[[0,8]]);