// ui/webui/resources/js/tracked_element/tracked_element.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_JS_TRACKED_ELEMENT_TRACKED_ELEMENT_MOJOM_H_
#define UI_WEBUI_RESOURCES_JS_TRACKED_ELEMENT_TRACKED_ELEMENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/js/tracked_element/tracked_element.mojom-features.h"  // IWYU pragma: export
#include "ui/webui/resources/js/tracked_element/tracked_element.mojom-shared.h"  // IWYU pragma: export
#include "ui/webui/resources/js/tracked_element/tracked_element.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace tracked_element::mojom {

class TrackedElementHandlerProxy;

template <typename ImplRefTraits>
class TrackedElementHandlerStub;

class TrackedElementHandlerRequestValidator;


class TrackedElementHandler
    : public TrackedElementHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tracked_element.mojom.TrackedElementHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TrackedElementHandlerInterfaceBase;
  using Proxy_ = TrackedElementHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = TrackedElementHandlerStub<ImplRefTraits>;

  using RequestValidator_ = TrackedElementHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kTrackedElementVisibilityChangedMinVersion = 0,
    kTrackedElementActivatedMinVersion = 0,
    kTrackedElementCustomEventMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct TrackedElementVisibilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TrackedElementActivated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TrackedElementCustomEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TrackedElementHandler() = default;

  virtual void TrackedElementVisibilityChanged(const std::string& native_identifier, bool visible, const ::gfx::RectF& rect) = 0;

  virtual void TrackedElementActivated(const std::string& native_identifier) = 0;

  virtual void TrackedElementCustomEvent(const std::string& native_identifier, const std::string& custom_event_name) = 0;
};



class  TrackedElementHandlerProxy
    : public TrackedElementHandler {
 public:
  using InterfaceType = TrackedElementHandler;

  explicit TrackedElementHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void TrackedElementVisibilityChanged(const std::string& native_identifier, bool visible, const ::gfx::RectF& rect) final;
  
  void TrackedElementActivated(const std::string& native_identifier) final;
  
  void TrackedElementCustomEvent(const std::string& native_identifier, const std::string& custom_event_name) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  TrackedElementHandlerStubDispatch {
 public:
  static bool Accept(TrackedElementHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TrackedElementHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TrackedElementHandler>>
class TrackedElementHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TrackedElementHandlerStub() = default;
  ~TrackedElementHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrackedElementHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrackedElementHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TrackedElementHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // tracked_element::mojom

namespace mojo {

}  // namespace mojo

#endif  // UI_WEBUI_RESOURCES_JS_TRACKED_ELEMENT_TRACKED_ELEMENT_MOJOM_H_