// ui/webui/resources/js/metrics_reporter/metrics_reporter.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_JS_METRICS_REPORTER_METRICS_REPORTER_MOJOM_H_
#define UI_WEBUI_RESOURCES_JS_METRICS_REPORTER_METRICS_REPORTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/js/metrics_reporter/metrics_reporter.mojom-features.h"  // IWYU pragma: export
#include "ui/webui/resources/js/metrics_reporter/metrics_reporter.mojom-shared.h"  // IWYU pragma: export
#include "ui/webui/resources/js/metrics_reporter/metrics_reporter.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace metrics_reporter::mojom {

class PageMetricsHostProxy;

template <typename ImplRefTraits>
class PageMetricsHostStub;

class PageMetricsHostRequestValidator;
class PageMetricsHostResponseValidator;


class PageMetricsHost
    : public PageMetricsHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "metrics_reporter.mojom.PageMetricsHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageMetricsHostInterfaceBase;
  using Proxy_ = PageMetricsHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageMetricsHostStub<ImplRefTraits>;

  using RequestValidator_ = PageMetricsHostRequestValidator;
  using ResponseValidator_ = PageMetricsHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnPageRemoteCreatedMinVersion = 0,
    kOnGetMarkMinVersion = 0,
    kOnClearMarkMinVersion = 0,
    kOnUmaReportTimeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnPageRemoteCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnGetMark_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnClearMark_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnUmaReportTime_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageMetricsHost() = default;

  virtual void OnPageRemoteCreated(::mojo::PendingRemote<PageMetrics> page) = 0;

  using OnGetMarkCallback = base::OnceCallback<void(std::optional<::base::TimeDelta>)>;
  using OnGetMarkMojoCallback = base::OnceCallback<void(std::optional<::base::TimeDelta>)>;

  virtual void OnGetMark(const std::string& name, OnGetMarkCallback callback) = 0;

  virtual void OnClearMark(const std::string& name) = 0;

  virtual void OnUmaReportTime(const std::string& name, ::base::TimeDelta time) = 0;
};

class PageMetricsProxy;

template <typename ImplRefTraits>
class PageMetricsStub;

class PageMetricsRequestValidator;
class PageMetricsResponseValidator;


class PageMetrics
    : public PageMetricsInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "metrics_reporter.mojom.PageMetrics";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageMetricsInterfaceBase;
  using Proxy_ = PageMetricsProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageMetricsStub<ImplRefTraits>;

  using RequestValidator_ = PageMetricsRequestValidator;
  using ResponseValidator_ = PageMetricsResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnGetMarkMinVersion = 0,
    kOnClearMarkMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnGetMark_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnClearMark_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageMetrics() = default;

  using OnGetMarkCallback = base::OnceCallback<void(std::optional<::base::TimeDelta>)>;
  using OnGetMarkMojoCallback = base::OnceCallback<void(std::optional<::base::TimeDelta>)>;

  virtual void OnGetMark(const std::string& name, OnGetMarkCallback callback) = 0;

  virtual void OnClearMark(const std::string& name) = 0;
};



class  PageMetricsHostProxy
    : public PageMetricsHost {
 public:
  using InterfaceType = PageMetricsHost;

  explicit PageMetricsHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPageRemoteCreated(::mojo::PendingRemote<PageMetrics> page) final;
  
  void OnGetMark(const std::string& name, OnGetMarkCallback callback) final;
  
  void OnClearMark(const std::string& name) final;
  
  void OnUmaReportTime(const std::string& name, ::base::TimeDelta time) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageMetricsProxy
    : public PageMetrics {
 public:
  using InterfaceType = PageMetrics;

  explicit PageMetricsProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnGetMark(const std::string& name, OnGetMarkCallback callback) final;
  
  void OnClearMark(const std::string& name) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageMetricsHostStubDispatch {
 public:
  static bool Accept(PageMetricsHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageMetricsHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageMetricsHost>>
class PageMetricsHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageMetricsHostStub() = default;
  ~PageMetricsHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageMetricsHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageMetricsHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageMetricsStubDispatch {
 public:
  static bool Accept(PageMetrics* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageMetrics* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageMetrics>>
class PageMetricsStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageMetricsStub() = default;
  ~PageMetricsStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageMetricsStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageMetricsStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageMetricsHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageMetricsRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageMetricsHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageMetricsResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // metrics_reporter::mojom

namespace mojo {

}  // namespace mojo

#endif  // UI_WEBUI_RESOURCES_JS_METRICS_REPORTER_METRICS_REPORTER_MOJOM_H_