// ui/webui/resources/js/metrics_reporter/metrics_reporter.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/webui/resources/js/metrics_reporter/metrics_reporter.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/webui/resources/js/metrics_reporter/metrics_reporter.mojom-params-data.h"
#include "ui/webui/resources/js/metrics_reporter/metrics_reporter.mojom-shared-message-ids.h"

#include "ui/webui/resources/js/metrics_reporter/metrics_reporter.mojom-import-headers.h"
#include "ui/webui/resources/js/metrics_reporter/metrics_reporter.mojom-test-utils.h"


namespace metrics_reporter::mojom {
// The declaration includes the definition on other builds.

PageMetricsHost::IPCStableHashFunction PageMetricsHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageMetricsHost>(message.name())) {
    case messages::PageMetricsHost::kOnPageRemoteCreated: {
      return &PageMetricsHost::OnPageRemoteCreated_Sym::IPCStableHash;
    }
    case messages::PageMetricsHost::kOnGetMark: {
      return &PageMetricsHost::OnGetMark_Sym::IPCStableHash;
    }
    case messages::PageMetricsHost::kOnClearMark: {
      return &PageMetricsHost::OnClearMark_Sym::IPCStableHash;
    }
    case messages::PageMetricsHost::kOnUmaReportTime: {
      return &PageMetricsHost::OnUmaReportTime_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageMetricsHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageMetricsHost>(message.name())) {
      case messages::PageMetricsHost::kOnPageRemoteCreated:
            return "Receive metrics_reporter::mojom::PageMetricsHost::OnPageRemoteCreated";
      case messages::PageMetricsHost::kOnGetMark:
            return "Receive metrics_reporter::mojom::PageMetricsHost::OnGetMark";
      case messages::PageMetricsHost::kOnClearMark:
            return "Receive metrics_reporter::mojom::PageMetricsHost::OnClearMark";
      case messages::PageMetricsHost::kOnUmaReportTime:
            return "Receive metrics_reporter::mojom::PageMetricsHost::OnUmaReportTime";
    }
  } else {
    switch (static_cast<messages::PageMetricsHost>(message.name())) {
      case messages::PageMetricsHost::kOnPageRemoteCreated:
            return "Receive reply metrics_reporter::mojom::PageMetricsHost::OnPageRemoteCreated";
      case messages::PageMetricsHost::kOnGetMark:
            return "Receive reply metrics_reporter::mojom::PageMetricsHost::OnGetMark";
      case messages::PageMetricsHost::kOnClearMark:
            return "Receive reply metrics_reporter::mojom::PageMetricsHost::OnClearMark";
      case messages::PageMetricsHost::kOnUmaReportTime:
            return "Receive reply metrics_reporter::mojom::PageMetricsHost::OnUmaReportTime";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageMetricsHost::OnPageRemoteCreated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c9803dc;  // IPCStableHash for metrics_reporter::mojom::PageMetricsHost::OnPageRemoteCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageMetricsHost::OnGetMark_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7d520ded;  // IPCStableHash for metrics_reporter::mojom::PageMetricsHost::OnGetMark
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageMetricsHost::OnClearMark_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde77cfd6;  // IPCStableHash for metrics_reporter::mojom::PageMetricsHost::OnClearMark
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageMetricsHost::OnUmaReportTime_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe9eda6d2;  // IPCStableHash for metrics_reporter::mojom::PageMetricsHost::OnUmaReportTime
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageMetricsHost_OnGetMark_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageMetricsHost_OnGetMark_ForwardToCallback(
      PageMetricsHost::OnGetMarkCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageMetricsHost_OnGetMark_ForwardToCallback(const PageMetricsHost_OnGetMark_ForwardToCallback&) = delete;
  PageMetricsHost_OnGetMark_ForwardToCallback& operator=(const PageMetricsHost_OnGetMark_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageMetricsHost::OnGetMarkCallback callback_;
};

PageMetricsHostProxy::PageMetricsHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageMetricsHostProxy::OnPageRemoteCreated(
    ::mojo::PendingRemote<PageMetrics> in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send metrics_reporter::mojom::PageMetricsHost::OnPageRemoteCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<PageMetrics>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageMetricsHost::kOnPageRemoteCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics_reporter::mojom::internal::PageMetricsHost_OnPageRemoteCreated_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::metrics_reporter::mojom::PageMetricsInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageMetricsHost.OnPageRemoteCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageMetricsHost::Name_);
  message.set_method_name("OnPageRemoteCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageMetricsHostProxy::OnGetMark(
    const std::string& in_name, OnGetMarkCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send metrics_reporter::mojom::PageMetricsHost::OnGetMark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageMetricsHost::kOnGetMark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics_reporter::mojom::internal::PageMetricsHost_OnGetMark_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in PageMetricsHost.OnGetMark request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageMetricsHost::Name_);
  message.set_method_name("OnGetMark");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageMetricsHost_OnGetMark_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageMetricsHostProxy::OnClearMark(
    const std::string& in_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send metrics_reporter::mojom::PageMetricsHost::OnClearMark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageMetricsHost::kOnClearMark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics_reporter::mojom::internal::PageMetricsHost_OnClearMark_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in PageMetricsHost.OnClearMark request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageMetricsHost::Name_);
  message.set_method_name("OnClearMark");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageMetricsHostProxy::OnUmaReportTime(
    const std::string& in_name, ::base::TimeDelta in_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send metrics_reporter::mojom::PageMetricsHost::OnUmaReportTime", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageMetricsHost::kOnUmaReportTime), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics_reporter::mojom::internal::PageMetricsHost_OnUmaReportTime_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in PageMetricsHost.OnUmaReportTime request");
  mojo::internal::MessageFragment<
      typename decltype(params->time)::BaseType> time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_time,
    time_fragment);

  params->time.Set(
      time_fragment.is_null() ? nullptr : time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null time in PageMetricsHost.OnUmaReportTime request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageMetricsHost::Name_);
  message.set_method_name("OnUmaReportTime");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageMetricsHost_OnGetMark_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageMetricsHost::OnGetMarkCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageMetricsHost_OnGetMark_ProxyToResponder> proxy(
        new PageMetricsHost_OnGetMark_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageMetricsHost_OnGetMark_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageMetricsHost_OnGetMark_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageMetricsHost_OnGetMark_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageMetricsHost::OnGetMarkCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::base::TimeDelta> in_marked_time);
};

bool PageMetricsHost_OnGetMark_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageMetricsHost_OnGetMark_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageMetricsHost_OnGetMark_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageMetricsHost.1
  bool success = true;
  std::optional<::base::TimeDelta> p_marked_time{};
  PageMetricsHost_OnGetMark_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMarkedTime(&p_marked_time))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageMetricsHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_marked_time));
  }
  return true;
}

void PageMetricsHost_OnGetMark_ProxyToResponder::Run(
    std::optional<::base::TimeDelta> in_marked_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply metrics_reporter::mojom::PageMetricsHost::OnGetMark", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("marked_time"), in_marked_time,
                        "<value of type std::optional<::base::TimeDelta>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageMetricsHost::kOnGetMark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics_reporter::mojom::internal::PageMetricsHost_OnGetMark_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->marked_time)::BaseType> marked_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_marked_time,
    marked_time_fragment);

  params->marked_time.Set(
      marked_time_fragment.is_null() ? nullptr : marked_time_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageMetricsHost::Name_);
  message.set_method_name("OnGetMark");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageMetricsHostStubDispatch::Accept(
    PageMetricsHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageMetricsHost>(message->header()->name)) {
    case messages::PageMetricsHost::kOnPageRemoteCreated: {
      DCHECK(message->is_serialized());
      internal::PageMetricsHost_OnPageRemoteCreated_Params_Data* params =
          reinterpret_cast<internal::PageMetricsHost_OnPageRemoteCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageMetricsHost.0
      bool success = true;
      ::mojo::PendingRemote<PageMetrics> p_page{};
      PageMetricsHost_OnPageRemoteCreated_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageMetricsHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPageRemoteCreated(        
        std::move(p_page));
      return true;
    }
    case messages::PageMetricsHost::kOnGetMark: {
      break;
    }
    case messages::PageMetricsHost::kOnClearMark: {
      DCHECK(message->is_serialized());
      internal::PageMetricsHost_OnClearMark_Params_Data* params =
          reinterpret_cast<internal::PageMetricsHost_OnClearMark_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageMetricsHost.2
      bool success = true;
      std::string p_name{};
      PageMetricsHost_OnClearMark_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageMetricsHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClearMark(        
        std::move(p_name));
      return true;
    }
    case messages::PageMetricsHost::kOnUmaReportTime: {
      DCHECK(message->is_serialized());
      internal::PageMetricsHost_OnUmaReportTime_Params_Data* params =
          reinterpret_cast<internal::PageMetricsHost_OnUmaReportTime_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageMetricsHost.3
      bool success = true;
      std::string p_name{};
      ::base::TimeDelta p_time{};
      PageMetricsHost_OnUmaReportTime_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadTime(&p_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageMetricsHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUmaReportTime(        
        std::move(p_name), 
        std::move(p_time));
      return true;
    }
  }
  return false;
}

// static
bool PageMetricsHostStubDispatch::AcceptWithResponder(
    PageMetricsHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageMetricsHost>(message->header()->name)) {
    case messages::PageMetricsHost::kOnPageRemoteCreated: {
      break;
    }
    case messages::PageMetricsHost::kOnGetMark: {
      internal::PageMetricsHost_OnGetMark_Params_Data* params =
          reinterpret_cast<
              internal::PageMetricsHost_OnGetMark_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageMetricsHost.1
      bool success = true;
      std::string p_name{};
      PageMetricsHost_OnGetMark_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageMetricsHost::Name_, 1, false);
        return false;
      }
      auto callback =
          PageMetricsHost_OnGetMark_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnGetMark(        
        std::move(p_name), std::move(callback));
      return true;
    }
    case messages::PageMetricsHost::kOnClearMark: {
      break;
    }
    case messages::PageMetricsHost::kOnUmaReportTime: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageMetricsHostValidationInfo[] = {
    { &internal::PageMetricsHost_OnPageRemoteCreated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageMetricsHost_OnGetMark_Params_Data::Validate,
     &internal::PageMetricsHost_OnGetMark_ResponseParams_Data::Validate},
    { &internal::PageMetricsHost_OnClearMark_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageMetricsHost_OnUmaReportTime_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageMetricsHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::metrics_reporter::mojom::PageMetricsHost::Name_,
    kPageMetricsHostValidationInfo);
}

bool PageMetricsHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::metrics_reporter::mojom::PageMetricsHost::Name_,
    kPageMetricsHostValidationInfo);
}
// The declaration includes the definition on other builds.

PageMetrics::IPCStableHashFunction PageMetrics::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageMetrics>(message.name())) {
    case messages::PageMetrics::kOnGetMark: {
      return &PageMetrics::OnGetMark_Sym::IPCStableHash;
    }
    case messages::PageMetrics::kOnClearMark: {
      return &PageMetrics::OnClearMark_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageMetrics::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageMetrics>(message.name())) {
      case messages::PageMetrics::kOnGetMark:
            return "Receive metrics_reporter::mojom::PageMetrics::OnGetMark";
      case messages::PageMetrics::kOnClearMark:
            return "Receive metrics_reporter::mojom::PageMetrics::OnClearMark";
    }
  } else {
    switch (static_cast<messages::PageMetrics>(message.name())) {
      case messages::PageMetrics::kOnGetMark:
            return "Receive reply metrics_reporter::mojom::PageMetrics::OnGetMark";
      case messages::PageMetrics::kOnClearMark:
            return "Receive reply metrics_reporter::mojom::PageMetrics::OnClearMark";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageMetrics::OnGetMark_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb6115ae6;  // IPCStableHash for metrics_reporter::mojom::PageMetrics::OnGetMark
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageMetrics::OnClearMark_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x91261cc8;  // IPCStableHash for metrics_reporter::mojom::PageMetrics::OnClearMark
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageMetrics_OnGetMark_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageMetrics_OnGetMark_ForwardToCallback(
      PageMetrics::OnGetMarkCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageMetrics_OnGetMark_ForwardToCallback(const PageMetrics_OnGetMark_ForwardToCallback&) = delete;
  PageMetrics_OnGetMark_ForwardToCallback& operator=(const PageMetrics_OnGetMark_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageMetrics::OnGetMarkCallback callback_;
};

PageMetricsProxy::PageMetricsProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageMetricsProxy::OnGetMark(
    const std::string& in_name, OnGetMarkCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send metrics_reporter::mojom::PageMetrics::OnGetMark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageMetrics::kOnGetMark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics_reporter::mojom::internal::PageMetrics_OnGetMark_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in PageMetrics.OnGetMark request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageMetrics::Name_);
  message.set_method_name("OnGetMark");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageMetrics_OnGetMark_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageMetricsProxy::OnClearMark(
    const std::string& in_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send metrics_reporter::mojom::PageMetrics::OnClearMark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageMetrics::kOnClearMark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics_reporter::mojom::internal::PageMetrics_OnClearMark_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in PageMetrics.OnClearMark request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageMetrics::Name_);
  message.set_method_name("OnClearMark");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageMetrics_OnGetMark_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageMetrics::OnGetMarkCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageMetrics_OnGetMark_ProxyToResponder> proxy(
        new PageMetrics_OnGetMark_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageMetrics_OnGetMark_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageMetrics_OnGetMark_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageMetrics_OnGetMark_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageMetrics::OnGetMarkCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::base::TimeDelta> in_marked_time);
};

bool PageMetrics_OnGetMark_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageMetrics_OnGetMark_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageMetrics_OnGetMark_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageMetrics.0
  bool success = true;
  std::optional<::base::TimeDelta> p_marked_time{};
  PageMetrics_OnGetMark_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMarkedTime(&p_marked_time))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageMetrics::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_marked_time));
  }
  return true;
}

void PageMetrics_OnGetMark_ProxyToResponder::Run(
    std::optional<::base::TimeDelta> in_marked_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply metrics_reporter::mojom::PageMetrics::OnGetMark", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("marked_time"), in_marked_time,
                        "<value of type std::optional<::base::TimeDelta>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageMetrics::kOnGetMark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::metrics_reporter::mojom::internal::PageMetrics_OnGetMark_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->marked_time)::BaseType> marked_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_marked_time,
    marked_time_fragment);

  params->marked_time.Set(
      marked_time_fragment.is_null() ? nullptr : marked_time_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageMetrics::Name_);
  message.set_method_name("OnGetMark");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageMetricsStubDispatch::Accept(
    PageMetrics* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageMetrics>(message->header()->name)) {
    case messages::PageMetrics::kOnGetMark: {
      break;
    }
    case messages::PageMetrics::kOnClearMark: {
      DCHECK(message->is_serialized());
      internal::PageMetrics_OnClearMark_Params_Data* params =
          reinterpret_cast<internal::PageMetrics_OnClearMark_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageMetrics.1
      bool success = true;
      std::string p_name{};
      PageMetrics_OnClearMark_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageMetrics::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClearMark(        
        std::move(p_name));
      return true;
    }
  }
  return false;
}

// static
bool PageMetricsStubDispatch::AcceptWithResponder(
    PageMetrics* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageMetrics>(message->header()->name)) {
    case messages::PageMetrics::kOnGetMark: {
      internal::PageMetrics_OnGetMark_Params_Data* params =
          reinterpret_cast<
              internal::PageMetrics_OnGetMark_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageMetrics.0
      bool success = true;
      std::string p_name{};
      PageMetrics_OnGetMark_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageMetrics::Name_, 0, false);
        return false;
      }
      auto callback =
          PageMetrics_OnGetMark_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnGetMark(        
        std::move(p_name), std::move(callback));
      return true;
    }
    case messages::PageMetrics::kOnClearMark: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageMetricsValidationInfo[] = {
    { &internal::PageMetrics_OnGetMark_Params_Data::Validate,
     &internal::PageMetrics_OnGetMark_ResponseParams_Data::Validate},
    { &internal::PageMetrics_OnClearMark_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageMetricsRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::metrics_reporter::mojom::PageMetrics::Name_,
    kPageMetricsValidationInfo);
}

bool PageMetricsResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::metrics_reporter::mojom::PageMetrics::Name_,
    kPageMetricsValidationInfo);
}


}  // metrics_reporter::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace metrics_reporter::mojom {


void PageMetricsHostInterceptorForTesting::OnPageRemoteCreated(::mojo::PendingRemote<PageMetrics> page) {
  GetForwardingInterface()->OnPageRemoteCreated(
    std::move(page)
    );
}
void PageMetricsHostInterceptorForTesting::OnGetMark(const std::string& name, OnGetMarkCallback callback) {
  GetForwardingInterface()->OnGetMark(
    std::move(name)
    , std::move(callback));
}
void PageMetricsHostInterceptorForTesting::OnClearMark(const std::string& name) {
  GetForwardingInterface()->OnClearMark(
    std::move(name)
    );
}
void PageMetricsHostInterceptorForTesting::OnUmaReportTime(const std::string& name, ::base::TimeDelta time) {
  GetForwardingInterface()->OnUmaReportTime(
    std::move(name)
    , 
    std::move(time)
    );
}
PageMetricsHostAsyncWaiter::PageMetricsHostAsyncWaiter(
    PageMetricsHost* proxy) : proxy_(proxy) {}

PageMetricsHostAsyncWaiter::~PageMetricsHostAsyncWaiter() = default;


void PageMetricsHostAsyncWaiter::OnGetMark(
    const std::string& name, std::optional<::base::TimeDelta>* out_marked_time) {
  base::RunLoop loop;
  proxy_->OnGetMark(
      std::move(name),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::base::TimeDelta>* out_marked_time
,
             std::optional<::base::TimeDelta> marked_time) {*out_marked_time = std::move(marked_time);
            loop->Quit();
          },
          &loop,
          out_marked_time));
  loop.Run();
}

std::optional<::base::TimeDelta> PageMetricsHostAsyncWaiter::OnGetMark(
    const std::string& name) {
  std::optional<::base::TimeDelta> async_wait_result;
  OnGetMark(std::move(name),&async_wait_result);
  return async_wait_result;
}




void PageMetricsInterceptorForTesting::OnGetMark(const std::string& name, OnGetMarkCallback callback) {
  GetForwardingInterface()->OnGetMark(
    std::move(name)
    , std::move(callback));
}
void PageMetricsInterceptorForTesting::OnClearMark(const std::string& name) {
  GetForwardingInterface()->OnClearMark(
    std::move(name)
    );
}
PageMetricsAsyncWaiter::PageMetricsAsyncWaiter(
    PageMetrics* proxy) : proxy_(proxy) {}

PageMetricsAsyncWaiter::~PageMetricsAsyncWaiter() = default;


void PageMetricsAsyncWaiter::OnGetMark(
    const std::string& name, std::optional<::base::TimeDelta>* out_marked_time) {
  base::RunLoop loop;
  proxy_->OnGetMark(
      std::move(name),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::base::TimeDelta>* out_marked_time
,
             std::optional<::base::TimeDelta> marked_time) {*out_marked_time = std::move(marked_time);
            loop->Quit();
          },
          &loop,
          out_marked_time));
  loop.Run();
}

std::optional<::base::TimeDelta> PageMetricsAsyncWaiter::OnGetMark(
    const std::string& name) {
  std::optional<::base::TimeDelta> async_wait_result;
  OnGetMark(std::move(name),&async_wait_result);
  return async_wait_result;
}






}  // metrics_reporter::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif