// ui/webui/resources/js/browser_command/browser_command.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_JS_BROWSER_COMMAND_BROWSER_COMMAND_MOJOM_H_
#define UI_WEBUI_RESOURCES_JS_BROWSER_COMMAND_BROWSER_COMMAND_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/js/browser_command/browser_command.mojom-features.h"  // IWYU pragma: export
#include "ui/webui/resources/js/browser_command/browser_command.mojom-shared.h"  // IWYU pragma: export
#include "ui/webui/resources/js/browser_command/browser_command.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace browser_command::mojom {

class CommandHandlerFactoryProxy;

template <typename ImplRefTraits>
class CommandHandlerFactoryStub;

class CommandHandlerFactoryRequestValidator;


class CommandHandlerFactory
    : public CommandHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "browser_command.mojom.CommandHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CommandHandlerFactoryInterfaceBase;
  using Proxy_ = CommandHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = CommandHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = CommandHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateBrowserCommandHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateBrowserCommandHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CommandHandlerFactory() = default;

  virtual void CreateBrowserCommandHandler(::mojo::PendingReceiver<CommandHandler> handler) = 0;
};

class CommandHandlerProxy;

template <typename ImplRefTraits>
class CommandHandlerStub;

class CommandHandlerRequestValidator;
class CommandHandlerResponseValidator;


class CommandHandler
    : public CommandHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "browser_command.mojom.CommandHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CommandHandlerInterfaceBase;
  using Proxy_ = CommandHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = CommandHandlerStub<ImplRefTraits>;

  using RequestValidator_ = CommandHandlerRequestValidator;
  using ResponseValidator_ = CommandHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCanExecuteCommandMinVersion = 0,
    kExecuteCommandMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CanExecuteCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CommandHandler() = default;

  using CanExecuteCommandCallback = base::OnceCallback<void(bool)>;
  using CanExecuteCommandMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CanExecuteCommand(Command command_id, CanExecuteCommandCallback callback) = 0;

  using ExecuteCommandCallback = base::OnceCallback<void(bool)>;
  using ExecuteCommandMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ExecuteCommand(Command command_id, ClickInfoPtr click_info, ExecuteCommandCallback callback) = 0;
};



class  CommandHandlerFactoryProxy
    : public CommandHandlerFactory {
 public:
  using InterfaceType = CommandHandlerFactory;

  explicit CommandHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateBrowserCommandHandler(::mojo::PendingReceiver<CommandHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CommandHandlerProxy
    : public CommandHandler {
 public:
  using InterfaceType = CommandHandler;

  explicit CommandHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CanExecuteCommand(Command command_id, CanExecuteCommandCallback callback) final;
  
  void ExecuteCommand(Command command_id, ClickInfoPtr click_info, ExecuteCommandCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CommandHandlerFactoryStubDispatch {
 public:
  static bool Accept(CommandHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CommandHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CommandHandlerFactory>>
class CommandHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CommandHandlerFactoryStub() = default;
  ~CommandHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommandHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommandHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CommandHandlerStubDispatch {
 public:
  static bool Accept(CommandHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CommandHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CommandHandler>>
class CommandHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CommandHandlerStub() = default;
  ~CommandHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommandHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CommandHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CommandHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CommandHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CommandHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  ClickInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClickInfo, T>::value>;
  using DataView = ClickInfoDataView;
  using Data_ = internal::ClickInfo_Data;

  template <typename... Args>
  static ClickInfoPtr New(Args&&... args) {
    return ClickInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClickInfoPtr From(const U& u) {
    return mojo::TypeConverter<ClickInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClickInfo>::Convert(*this);
  }


  ClickInfo();

  ClickInfo(
      bool middle_button,
      bool alt_key,
      bool ctrl_key,
      bool meta_key,
      bool shift_key);


  ~ClickInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClickInfoPtr>
  ClickInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClickInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClickInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClickInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClickInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClickInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClickInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClickInfo_UnserializedMessageContext<
            UserType, ClickInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClickInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClickInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClickInfo_UnserializedMessageContext<
            UserType, ClickInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClickInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool middle_button;
  
  bool alt_key;
  
  bool ctrl_key;
  
  bool meta_key;
  
  bool shift_key;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClickInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClickInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClickInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClickInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ClickInfoPtr ClickInfo::Clone() const {
  return New(
      mojo::Clone(middle_button),
      mojo::Clone(alt_key),
      mojo::Clone(ctrl_key),
      mojo::Clone(meta_key),
      mojo::Clone(shift_key)
  );
}

template <typename T, ClickInfo::EnableIfSame<T>*>
bool ClickInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->middle_button, other_struct.middle_button))
    return false;
  if (!mojo::Equals(this->alt_key, other_struct.alt_key))
    return false;
  if (!mojo::Equals(this->ctrl_key, other_struct.ctrl_key))
    return false;
  if (!mojo::Equals(this->meta_key, other_struct.meta_key))
    return false;
  if (!mojo::Equals(this->shift_key, other_struct.shift_key))
    return false;
  return true;
}

template <typename T, ClickInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.middle_button < rhs.middle_button)
    return true;
  if (rhs.middle_button < lhs.middle_button)
    return false;
  if (lhs.alt_key < rhs.alt_key)
    return true;
  if (rhs.alt_key < lhs.alt_key)
    return false;
  if (lhs.ctrl_key < rhs.ctrl_key)
    return true;
  if (rhs.ctrl_key < lhs.ctrl_key)
    return false;
  if (lhs.meta_key < rhs.meta_key)
    return true;
  if (rhs.meta_key < lhs.meta_key)
    return false;
  if (lhs.shift_key < rhs.shift_key)
    return true;
  if (rhs.shift_key < lhs.shift_key)
    return false;
  return false;
}


}  // browser_command::mojom

namespace mojo {


template <>
struct  StructTraits<::browser_command::mojom::ClickInfo::DataView,
                                         ::browser_command::mojom::ClickInfoPtr> {
  static bool IsNull(const ::browser_command::mojom::ClickInfoPtr& input) { return !input; }
  static void SetToNull(::browser_command::mojom::ClickInfoPtr* output) { output->reset(); }

  static decltype(::browser_command::mojom::ClickInfo::middle_button) middle_button(
      const ::browser_command::mojom::ClickInfoPtr& input) {
    return input->middle_button;
  }

  static decltype(::browser_command::mojom::ClickInfo::alt_key) alt_key(
      const ::browser_command::mojom::ClickInfoPtr& input) {
    return input->alt_key;
  }

  static decltype(::browser_command::mojom::ClickInfo::ctrl_key) ctrl_key(
      const ::browser_command::mojom::ClickInfoPtr& input) {
    return input->ctrl_key;
  }

  static decltype(::browser_command::mojom::ClickInfo::meta_key) meta_key(
      const ::browser_command::mojom::ClickInfoPtr& input) {
    return input->meta_key;
  }

  static decltype(::browser_command::mojom::ClickInfo::shift_key) shift_key(
      const ::browser_command::mojom::ClickInfoPtr& input) {
    return input->shift_key;
  }

  static bool Read(::browser_command::mojom::ClickInfo::DataView input, ::browser_command::mojom::ClickInfoPtr* output);
};

}  // namespace mojo

#endif  // UI_WEBUI_RESOURCES_JS_BROWSER_COMMAND_BROWSER_COMMAND_MOJOM_H_