// ui/webui/resources/js/browser_command/browser_command.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/webui/resources/js/browser_command/browser_command.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/webui/resources/js/browser_command/browser_command.mojom-params-data.h"
#include "ui/webui/resources/js/browser_command/browser_command.mojom-shared-message-ids.h"

#include "ui/webui/resources/js/browser_command/browser_command.mojom-import-headers.h"
#include "ui/webui/resources/js/browser_command/browser_command.mojom-test-utils.h"


namespace browser_command::mojom {
ClickInfo::ClickInfo()
    : middle_button(),
      alt_key(),
      ctrl_key(),
      meta_key(),
      shift_key() {}

ClickInfo::ClickInfo(
    bool middle_button_in,
    bool alt_key_in,
    bool ctrl_key_in,
    bool meta_key_in,
    bool shift_key_in)
    : middle_button(std::move(middle_button_in)),
      alt_key(std::move(alt_key_in)),
      ctrl_key(std::move(ctrl_key_in)),
      meta_key(std::move(meta_key_in)),
      shift_key(std::move(shift_key_in)) {}

ClickInfo::~ClickInfo() = default;
size_t ClickInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->middle_button);
  seed = mojo::internal::Hash(seed, this->alt_key);
  seed = mojo::internal::Hash(seed, this->ctrl_key);
  seed = mojo::internal::Hash(seed, this->meta_key);
  seed = mojo::internal::Hash(seed, this->shift_key);
  return seed;
}

void ClickInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "middle_button"), this->middle_button,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alt_key"), this->alt_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ctrl_key"), this->ctrl_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "meta_key"), this->meta_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shift_key"), this->shift_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClickInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

CommandHandlerFactory::IPCStableHashFunction CommandHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CommandHandlerFactory>(message.name())) {
    case messages::CommandHandlerFactory::kCreateBrowserCommandHandler: {
      return &CommandHandlerFactory::CreateBrowserCommandHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CommandHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CommandHandlerFactory>(message.name())) {
      case messages::CommandHandlerFactory::kCreateBrowserCommandHandler:
            return "Receive browser_command::mojom::CommandHandlerFactory::CreateBrowserCommandHandler";
    }
  } else {
    switch (static_cast<messages::CommandHandlerFactory>(message.name())) {
      case messages::CommandHandlerFactory::kCreateBrowserCommandHandler:
            return "Receive reply browser_command::mojom::CommandHandlerFactory::CreateBrowserCommandHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CommandHandlerFactory::CreateBrowserCommandHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4cef04f1;  // IPCStableHash for browser_command::mojom::CommandHandlerFactory::CreateBrowserCommandHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CommandHandlerFactoryProxy::CommandHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CommandHandlerFactoryProxy::CreateBrowserCommandHandler(
    ::mojo::PendingReceiver<CommandHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send browser_command::mojom::CommandHandlerFactory::CreateBrowserCommandHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<CommandHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandHandlerFactory::kCreateBrowserCommandHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::browser_command::mojom::internal::CommandHandlerFactory_CreateBrowserCommandHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::browser_command::mojom::CommandHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in CommandHandlerFactory.CreateBrowserCommandHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandHandlerFactory::Name_);
  message.set_method_name("CreateBrowserCommandHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CommandHandlerFactoryStubDispatch::Accept(
    CommandHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CommandHandlerFactory>(message->header()->name)) {
    case messages::CommandHandlerFactory::kCreateBrowserCommandHandler: {
      DCHECK(message->is_serialized());
      internal::CommandHandlerFactory_CreateBrowserCommandHandler_Params_Data* params =
          reinterpret_cast<internal::CommandHandlerFactory_CreateBrowserCommandHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CommandHandlerFactory.0
      bool success = true;
      ::mojo::PendingReceiver<CommandHandler> p_handler{};
      CommandHandlerFactory_CreateBrowserCommandHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateBrowserCommandHandler(        
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool CommandHandlerFactoryStubDispatch::AcceptWithResponder(
    CommandHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CommandHandlerFactory>(message->header()->name)) {
    case messages::CommandHandlerFactory::kCreateBrowserCommandHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCommandHandlerFactoryValidationInfo[] = {
    { &internal::CommandHandlerFactory_CreateBrowserCommandHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool CommandHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::browser_command::mojom::CommandHandlerFactory::Name_,
    kCommandHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

CommandHandler::IPCStableHashFunction CommandHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CommandHandler>(message.name())) {
    case messages::CommandHandler::kCanExecuteCommand: {
      return &CommandHandler::CanExecuteCommand_Sym::IPCStableHash;
    }
    case messages::CommandHandler::kExecuteCommand: {
      return &CommandHandler::ExecuteCommand_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CommandHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CommandHandler>(message.name())) {
      case messages::CommandHandler::kCanExecuteCommand:
            return "Receive browser_command::mojom::CommandHandler::CanExecuteCommand";
      case messages::CommandHandler::kExecuteCommand:
            return "Receive browser_command::mojom::CommandHandler::ExecuteCommand";
    }
  } else {
    switch (static_cast<messages::CommandHandler>(message.name())) {
      case messages::CommandHandler::kCanExecuteCommand:
            return "Receive reply browser_command::mojom::CommandHandler::CanExecuteCommand";
      case messages::CommandHandler::kExecuteCommand:
            return "Receive reply browser_command::mojom::CommandHandler::ExecuteCommand";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CommandHandler::CanExecuteCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3c1863cc;  // IPCStableHash for browser_command::mojom::CommandHandler::CanExecuteCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CommandHandler::ExecuteCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa77710eb;  // IPCStableHash for browser_command::mojom::CommandHandler::ExecuteCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CommandHandler_CanExecuteCommand_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CommandHandler_CanExecuteCommand_ForwardToCallback(
      CommandHandler::CanExecuteCommandCallback callback
      ) : callback_(std::move(callback)) {
  }

  CommandHandler_CanExecuteCommand_ForwardToCallback(const CommandHandler_CanExecuteCommand_ForwardToCallback&) = delete;
  CommandHandler_CanExecuteCommand_ForwardToCallback& operator=(const CommandHandler_CanExecuteCommand_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CommandHandler::CanExecuteCommandCallback callback_;
};

class CommandHandler_ExecuteCommand_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CommandHandler_ExecuteCommand_ForwardToCallback(
      CommandHandler::ExecuteCommandCallback callback
      ) : callback_(std::move(callback)) {
  }

  CommandHandler_ExecuteCommand_ForwardToCallback(const CommandHandler_ExecuteCommand_ForwardToCallback&) = delete;
  CommandHandler_ExecuteCommand_ForwardToCallback& operator=(const CommandHandler_ExecuteCommand_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CommandHandler::ExecuteCommandCallback callback_;
};

CommandHandlerProxy::CommandHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CommandHandlerProxy::CanExecuteCommand(
    Command in_command_id, CanExecuteCommandCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send browser_command::mojom::CommandHandler::CanExecuteCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command_id"), in_command_id,
                        "<value of type Command>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandHandler::kCanExecuteCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::browser_command::mojom::internal::CommandHandler_CanExecuteCommand_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::browser_command::mojom::Command>(
    in_command_id,
    &params->command_id);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandHandler::Name_);
  message.set_method_name("CanExecuteCommand");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CommandHandler_CanExecuteCommand_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CommandHandlerProxy::ExecuteCommand(
    Command in_command_id, ClickInfoPtr in_click_info, ExecuteCommandCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send browser_command::mojom::CommandHandler::ExecuteCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command_id"), in_command_id,
                        "<value of type Command>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("click_info"), in_click_info,
                        "<value of type ClickInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandHandler::kExecuteCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::browser_command::mojom::internal::CommandHandler_ExecuteCommand_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::browser_command::mojom::Command>(
    in_command_id,
    &params->command_id);
  mojo::internal::MessageFragment<
      typename decltype(params->click_info)::BaseType> click_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::browser_command::mojom::ClickInfoDataView>(
    in_click_info,
    click_info_fragment);

  params->click_info.Set(
      click_info_fragment.is_null() ? nullptr : click_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->click_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null click_info in CommandHandler.ExecuteCommand request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandHandler::Name_);
  message.set_method_name("ExecuteCommand");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CommandHandler_ExecuteCommand_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CommandHandler_CanExecuteCommand_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CommandHandler::CanExecuteCommandCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CommandHandler_CanExecuteCommand_ProxyToResponder> proxy(
        new CommandHandler_CanExecuteCommand_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CommandHandler_CanExecuteCommand_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CommandHandler_CanExecuteCommand_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CommandHandler_CanExecuteCommand_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CommandHandler::CanExecuteCommandCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_can_execute);
};

bool CommandHandler_CanExecuteCommand_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CommandHandler_CanExecuteCommand_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CommandHandler_CanExecuteCommand_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CommandHandler.0
  bool success = true;
  bool p_can_execute{};
  CommandHandler_CanExecuteCommand_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_can_execute = input_data_view.can_execute();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CommandHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_can_execute));
  }
  return true;
}

void CommandHandler_CanExecuteCommand_ProxyToResponder::Run(
    bool in_can_execute) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply browser_command::mojom::CommandHandler::CanExecuteCommand", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_execute"), in_can_execute,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandHandler::kCanExecuteCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::browser_command::mojom::internal::CommandHandler_CanExecuteCommand_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->can_execute = in_can_execute;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandHandler::Name_);
  message.set_method_name("CanExecuteCommand");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CommandHandler_ExecuteCommand_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CommandHandler::ExecuteCommandCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CommandHandler_ExecuteCommand_ProxyToResponder> proxy(
        new CommandHandler_ExecuteCommand_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CommandHandler_ExecuteCommand_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CommandHandler_ExecuteCommand_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CommandHandler_ExecuteCommand_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CommandHandler::ExecuteCommandCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_command_executed);
};

bool CommandHandler_ExecuteCommand_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CommandHandler_ExecuteCommand_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CommandHandler_ExecuteCommand_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CommandHandler.1
  bool success = true;
  bool p_command_executed{};
  CommandHandler_ExecuteCommand_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_command_executed = input_data_view.command_executed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CommandHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_command_executed));
  }
  return true;
}

void CommandHandler_ExecuteCommand_ProxyToResponder::Run(
    bool in_command_executed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply browser_command::mojom::CommandHandler::ExecuteCommand", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command_executed"), in_command_executed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CommandHandler::kExecuteCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::browser_command::mojom::internal::CommandHandler_ExecuteCommand_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->command_executed = in_command_executed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CommandHandler::Name_);
  message.set_method_name("ExecuteCommand");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CommandHandlerStubDispatch::Accept(
    CommandHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CommandHandler>(message->header()->name)) {
    case messages::CommandHandler::kCanExecuteCommand: {
      break;
    }
    case messages::CommandHandler::kExecuteCommand: {
      break;
    }
  }
  return false;
}

// static
bool CommandHandlerStubDispatch::AcceptWithResponder(
    CommandHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CommandHandler>(message->header()->name)) {
    case messages::CommandHandler::kCanExecuteCommand: {
      internal::CommandHandler_CanExecuteCommand_Params_Data* params =
          reinterpret_cast<
              internal::CommandHandler_CanExecuteCommand_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CommandHandler.0
      bool success = true;
      Command p_command_id{};
      CommandHandler_CanExecuteCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommandId(&p_command_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          CommandHandler_CanExecuteCommand_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanExecuteCommand(        
        std::move(p_command_id), std::move(callback));
      return true;
    }
    case messages::CommandHandler::kExecuteCommand: {
      internal::CommandHandler_ExecuteCommand_Params_Data* params =
          reinterpret_cast<
              internal::CommandHandler_ExecuteCommand_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CommandHandler.1
      bool success = true;
      Command p_command_id{};
      ClickInfoPtr p_click_info{};
      CommandHandler_ExecuteCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommandId(&p_command_id))
        success = false;
      if (success && !input_data_view.ReadClickInfo(&p_click_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CommandHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          CommandHandler_ExecuteCommand_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteCommand(        
        std::move(p_command_id), 
        std::move(p_click_info), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCommandHandlerValidationInfo[] = {
    { &internal::CommandHandler_CanExecuteCommand_Params_Data::Validate,
     &internal::CommandHandler_CanExecuteCommand_ResponseParams_Data::Validate},
    { &internal::CommandHandler_ExecuteCommand_Params_Data::Validate,
     &internal::CommandHandler_ExecuteCommand_ResponseParams_Data::Validate},
};

bool CommandHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::browser_command::mojom::CommandHandler::Name_,
    kCommandHandlerValidationInfo);
}

bool CommandHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::browser_command::mojom::CommandHandler::Name_,
    kCommandHandlerValidationInfo);
}


}  // browser_command::mojom


namespace mojo {


// static
bool StructTraits<::browser_command::mojom::ClickInfo::DataView, ::browser_command::mojom::ClickInfoPtr>::Read(
    ::browser_command::mojom::ClickInfo::DataView input,
    ::browser_command::mojom::ClickInfoPtr* output) {
  bool success = true;
  ::browser_command::mojom::ClickInfoPtr result(::browser_command::mojom::ClickInfo::New());
  
      if (success)
        result->middle_button = input.middle_button();
      if (success)
        result->alt_key = input.alt_key();
      if (success)
        result->ctrl_key = input.ctrl_key();
      if (success)
        result->meta_key = input.meta_key();
      if (success)
        result->shift_key = input.shift_key();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace browser_command::mojom {


void CommandHandlerFactoryInterceptorForTesting::CreateBrowserCommandHandler(::mojo::PendingReceiver<CommandHandler> handler) {
  GetForwardingInterface()->CreateBrowserCommandHandler(
    std::move(handler)
    );
}
CommandHandlerFactoryAsyncWaiter::CommandHandlerFactoryAsyncWaiter(
    CommandHandlerFactory* proxy) : proxy_(proxy) {}

CommandHandlerFactoryAsyncWaiter::~CommandHandlerFactoryAsyncWaiter() = default;





void CommandHandlerInterceptorForTesting::CanExecuteCommand(Command command_id, CanExecuteCommandCallback callback) {
  GetForwardingInterface()->CanExecuteCommand(
    std::move(command_id)
    , std::move(callback));
}
void CommandHandlerInterceptorForTesting::ExecuteCommand(Command command_id, ClickInfoPtr click_info, ExecuteCommandCallback callback) {
  GetForwardingInterface()->ExecuteCommand(
    std::move(command_id)
    , 
    std::move(click_info)
    , std::move(callback));
}
CommandHandlerAsyncWaiter::CommandHandlerAsyncWaiter(
    CommandHandler* proxy) : proxy_(proxy) {}

CommandHandlerAsyncWaiter::~CommandHandlerAsyncWaiter() = default;


void CommandHandlerAsyncWaiter::CanExecuteCommand(
    Command command_id, bool* out_can_execute) {
  base::RunLoop loop;
  proxy_->CanExecuteCommand(
      std::move(command_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_can_execute
,
             bool can_execute) {*out_can_execute = std::move(can_execute);
            loop->Quit();
          },
          &loop,
          out_can_execute));
  loop.Run();
}

bool CommandHandlerAsyncWaiter::CanExecuteCommand(
    Command command_id) {
  bool async_wait_result;
  CanExecuteCommand(std::move(command_id),&async_wait_result);
  return async_wait_result;
}

void CommandHandlerAsyncWaiter::ExecuteCommand(
    Command command_id, ClickInfoPtr click_info, bool* out_command_executed) {
  base::RunLoop loop;
  proxy_->ExecuteCommand(
      std::move(command_id),
      std::move(click_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_command_executed
,
             bool command_executed) {*out_command_executed = std::move(command_executed);
            loop->Quit();
          },
          &loop,
          out_command_executed));
  loop.Run();
}

bool CommandHandlerAsyncWaiter::ExecuteCommand(
    Command command_id, ClickInfoPtr click_info) {
  bool async_wait_result;
  ExecuteCommand(std::move(command_id),std::move(click_info),&async_wait_result);
  return async_wait_result;
}






}  // browser_command::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif