// ui/webui/resources/js/browser_command/browser_command.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/webui/resources/js/browser_command/browser_command.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/webui/resources/js/browser_command/browser_command.mojom-params-data.h"
namespace browser_command {
namespace mojom {

NOINLINE static const char* CommandToStringHelper(Command value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Command::kUnknownCommand:
      return "kUnknownCommand";
    case Command::kOpenSafetyCheck:
      return "kOpenSafetyCheck";
    case Command::kOpenSafeBrowsingEnhancedProtectionSettings:
      return "kOpenSafeBrowsingEnhancedProtectionSettings";
    case Command::kOpenFeedbackForm:
      return "kOpenFeedbackForm";
    case Command::kOpenPrivacyGuide:
      return "kOpenPrivacyGuide";
    case Command::kStartTabGroupTutorial:
      return "kStartTabGroupTutorial";
    case Command::kOpenPasswordManager:
      return "kOpenPasswordManager";
    case Command::kNoOpCommand:
      return "kNoOpCommand";
    case Command::kOpenPerformanceSettings:
      return "kOpenPerformanceSettings";
    case Command::kOpenNTPAndStartCustomizeChromeTutorial:
      return "kOpenNTPAndStartCustomizeChromeTutorial";
    case Command::kStartPasswordManagerTutorial:
      return "kStartPasswordManagerTutorial";
    case Command::kStartSavedTabGroupTutorial:
      return "kStartSavedTabGroupTutorial";
    case Command::kOpenAISettings:
      return "kOpenAISettings";
    case Command::kOpenSafetyCheckFromWhatsNew:
      return "kOpenSafetyCheckFromWhatsNew";
    case Command::kOpenPaymentsSettings:
      return "kOpenPaymentsSettings";
    case Command::kOpenGlic:
      return "kOpenGlic";
    case Command::kOpenGlicSettings:
      return "kOpenGlicSettings";
    case Command::kPrewarmGlicFre:
      return "kPrewarmGlicFre";
    case Command::kOpenSplitView:
      return "kOpenSplitView";
    default:
      return nullptr;
  }
}

std::string CommandToString(Command value) {
  const char *str = CommandToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Command value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Command value) {
  return os << CommandToString(value);
}

namespace internal {


// static
bool ClickInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClickInfo_Data* object =
      static_cast<const ClickInfo_Data*>(data);

  return true;
}

ClickInfo_Data::ClickInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandHandlerFactory_CreateBrowserCommandHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandHandlerFactory_CreateBrowserCommandHandler_Params_Data* object =
      static_cast<const CommandHandlerFactory_CreateBrowserCommandHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CommandHandlerFactory_CreateBrowserCommandHandler_Params_Data::CommandHandlerFactory_CreateBrowserCommandHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandHandler_CanExecuteCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandHandler_CanExecuteCommand_Params_Data* object =
      static_cast<const CommandHandler_CanExecuteCommand_Params_Data*>(data);


  if (!::browser_command::mojom::internal::Command_Data
        ::Validate(object->command_id, validation_context))
    return false;

  return true;
}

CommandHandler_CanExecuteCommand_Params_Data::CommandHandler_CanExecuteCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandHandler_CanExecuteCommand_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandHandler_CanExecuteCommand_ResponseParams_Data* object =
      static_cast<const CommandHandler_CanExecuteCommand_ResponseParams_Data*>(data);

  return true;
}

CommandHandler_CanExecuteCommand_ResponseParams_Data::CommandHandler_CanExecuteCommand_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandHandler_ExecuteCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandHandler_ExecuteCommand_Params_Data* object =
      static_cast<const CommandHandler_ExecuteCommand_Params_Data*>(data);


  if (!::browser_command::mojom::internal::Command_Data
        ::Validate(object->command_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->click_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->click_info, validation_context))
    return false;

  return true;
}

CommandHandler_ExecuteCommand_Params_Data::CommandHandler_ExecuteCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommandHandler_ExecuteCommand_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommandHandler_ExecuteCommand_ResponseParams_Data* object =
      static_cast<const CommandHandler_ExecuteCommand_ResponseParams_Data*>(data);

  return true;
}

CommandHandler_ExecuteCommand_ResponseParams_Data::CommandHandler_ExecuteCommand_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace browser_command

namespace perfetto {

// static
void TraceFormatTraits<::browser_command::mojom::Command>::WriteIntoTrace(
   perfetto::TracedValue context, ::browser_command::mojom::Command value) {
  return std::move(context).WriteString(::browser_command::mojom::CommandToString(value));
}

} // namespace perfetto