// ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  SkColorSpec as skia_mojom_SkColorSpec,
  SkColor as skia_mojom_SkColor
} from '//resources/mojo/skia/public/mojom/skcolor.mojom-webui.js';
import {
  BrowserColorVariantSpec as ui_mojom_BrowserColorVariantSpec,
  BrowserColorVariant as ui_mojom_BrowserColorVariant
} from '//resources/mojo/ui/base/mojom/themes.mojom-webui.js';







export type ThemeColorPickerHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ThemeColorPickerHandlerFactoryPendingReceiver>;

export class ThemeColorPickerHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ThemeColorPickerHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<ThemeColorPickerHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|ThemeColorPickerHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'theme_color_picker.mojom.ThemeColorPickerHandlerFactory',
        scope);
  }
}

export interface ThemeColorPickerHandlerFactoryInterface {
  createThemeColorPickerHandler(handler: ThemeColorPickerHandlerPendingReceiver, client: ThemeColorPickerClientRemote): void;
}

export class ThemeColorPickerHandlerFactoryRemote implements ThemeColorPickerHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ThemeColorPickerHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ThemeColorPickerHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ThemeColorPickerHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ThemeColorPickerHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createThemeColorPickerHandler(
      handler: ThemeColorPickerHandlerPendingReceiver,
      client: ThemeColorPickerClientRemote): void {
    this.proxy.sendMessage(
        0,
        ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsSpec.$,
        null,
        [
          handler,
          client
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ThemeColorPickerHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ThemeColorPickerHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ThemeColorPickerHandlerFactoryRemote, ThemeColorPickerHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ThemeColorPickerHandlerFactoryRemote, ThemeColorPickerHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ThemeColorPickerHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ThemeColorPickerHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsSpec.$,
        null,
        impl.createThemeColorPickerHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ThemeColorPickerHandlerFactory {
  static get $interfaceName(): string {
    return "theme_color_picker.mojom.ThemeColorPickerHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ThemeColorPickerHandlerFactoryRemote {
    let remote = new ThemeColorPickerHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ThemeColorPickerHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ThemeColorPickerHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ThemeColorPickerHandlerFactoryRemote, ThemeColorPickerHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ThemeColorPickerHandlerFactoryRemote, ThemeColorPickerHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createThemeColorPickerHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ThemeColorPickerHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createThemeColorPickerHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsSpec.$,
        null,
        this.createThemeColorPickerHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type ThemeColorPickerHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ThemeColorPickerHandlerPendingReceiver>;

export class ThemeColorPickerHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ThemeColorPickerHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<ThemeColorPickerHandlerPendingReceiver>;
  constructor(handle: MojoHandle|ThemeColorPickerHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'theme_color_picker.mojom.ThemeColorPickerHandler',
        scope);
  }
}

export interface ThemeColorPickerHandlerInterface {
  getChromeColors(isDarkMode: boolean): Promise<{
        colors: ChromeColor[], }>;
  updateTheme(): void;
  setDefaultColor(): void;
  setGreyDefaultColor(): void;
  setSeedColor(seedColor: skia_mojom_SkColor, variant: ui_mojom_BrowserColorVariant): void;
  setSeedColorFromHue(hue: number): void;
  removeBackgroundImage(): void;
}

export class ThemeColorPickerHandlerRemote implements ThemeColorPickerHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ThemeColorPickerHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ThemeColorPickerHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ThemeColorPickerHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ThemeColorPickerHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getChromeColors(
      isDarkMode: boolean): Promise<{
        colors: ChromeColor[], }> {
    return this.proxy.sendMessage(
        0,
        ThemeColorPickerHandler_GetChromeColors_ParamsSpec.$,
        ThemeColorPickerHandler_GetChromeColors_ResponseParamsSpec.$,
        [
          isDarkMode
        ],
        false);
  }

  updateTheme(): void {
    this.proxy.sendMessage(
        1,
        ThemeColorPickerHandler_UpdateTheme_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setDefaultColor(): void {
    this.proxy.sendMessage(
        2,
        ThemeColorPickerHandler_SetDefaultColor_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setGreyDefaultColor(): void {
    this.proxy.sendMessage(
        3,
        ThemeColorPickerHandler_SetGreyDefaultColor_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setSeedColor(
      seedColor: skia_mojom_SkColor,
      variant: ui_mojom_BrowserColorVariant): void {
    this.proxy.sendMessage(
        4,
        ThemeColorPickerHandler_SetSeedColor_ParamsSpec.$,
        null,
        [
          seedColor,
          variant
        ],
        false);
  }

  setSeedColorFromHue(
      hue: number): void {
    this.proxy.sendMessage(
        5,
        ThemeColorPickerHandler_SetSeedColorFromHue_ParamsSpec.$,
        null,
        [
          hue
        ],
        false);
  }

  removeBackgroundImage(): void {
    this.proxy.sendMessage(
        6,
        ThemeColorPickerHandler_RemoveBackgroundImage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ThemeColorPickerHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ThemeColorPickerHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ThemeColorPickerHandlerRemote, ThemeColorPickerHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ThemeColorPickerHandlerRemote, ThemeColorPickerHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ThemeColorPickerHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ThemeColorPickerHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ThemeColorPickerHandler_GetChromeColors_ParamsSpec.$,
        ThemeColorPickerHandler_GetChromeColors_ResponseParamsSpec.$,
        impl.getChromeColors.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ThemeColorPickerHandler_UpdateTheme_ParamsSpec.$,
        null,
        impl.updateTheme.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ThemeColorPickerHandler_SetDefaultColor_ParamsSpec.$,
        null,
        impl.setDefaultColor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ThemeColorPickerHandler_SetGreyDefaultColor_ParamsSpec.$,
        null,
        impl.setGreyDefaultColor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ThemeColorPickerHandler_SetSeedColor_ParamsSpec.$,
        null,
        impl.setSeedColor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ThemeColorPickerHandler_SetSeedColorFromHue_ParamsSpec.$,
        null,
        impl.setSeedColorFromHue.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ThemeColorPickerHandler_RemoveBackgroundImage_ParamsSpec.$,
        null,
        impl.removeBackgroundImage.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ThemeColorPickerHandler {
  static get $interfaceName(): string {
    return "theme_color_picker.mojom.ThemeColorPickerHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ThemeColorPickerHandlerRemote {
    let remote = new ThemeColorPickerHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ThemeColorPickerHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ThemeColorPickerHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ThemeColorPickerHandlerRemote, ThemeColorPickerHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ThemeColorPickerHandlerRemote, ThemeColorPickerHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getChromeColors: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateTheme: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setDefaultColor: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setGreyDefaultColor: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setSeedColor: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setSeedColorFromHue: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  removeBackgroundImage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ThemeColorPickerHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getChromeColors =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ThemeColorPickerHandler_GetChromeColors_ParamsSpec.$,
        ThemeColorPickerHandler_GetChromeColors_ResponseParamsSpec.$,
        this.getChromeColors.createReceiverHandler(true /* expectsResponse */),
        false);
    this.updateTheme =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ThemeColorPickerHandler_UpdateTheme_ParamsSpec.$,
        null,
        this.updateTheme.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setDefaultColor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ThemeColorPickerHandler_SetDefaultColor_ParamsSpec.$,
        null,
        this.setDefaultColor.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setGreyDefaultColor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ThemeColorPickerHandler_SetGreyDefaultColor_ParamsSpec.$,
        null,
        this.setGreyDefaultColor.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setSeedColor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ThemeColorPickerHandler_SetSeedColor_ParamsSpec.$,
        null,
        this.setSeedColor.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setSeedColorFromHue =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ThemeColorPickerHandler_SetSeedColorFromHue_ParamsSpec.$,
        null,
        this.setSeedColorFromHue.createReceiverHandler(false /* expectsResponse */),
        false);
    this.removeBackgroundImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ThemeColorPickerHandler_RemoveBackgroundImage_ParamsSpec.$,
        null,
        this.removeBackgroundImage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type ThemeColorPickerClientPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ThemeColorPickerClientPendingReceiver>;

export class ThemeColorPickerClientPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ThemeColorPickerClient> {

  handle: mojo.internal.interfaceSupport.Endpoint<ThemeColorPickerClientPendingReceiver>;
  constructor(handle: MojoHandle|ThemeColorPickerClientPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'theme_color_picker.mojom.ThemeColorPickerClient',
        scope);
  }
}

export interface ThemeColorPickerClientInterface {
  setTheme(theme: Theme): void;
}

export class ThemeColorPickerClientRemote implements ThemeColorPickerClientInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ThemeColorPickerClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ThemeColorPickerClientPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ThemeColorPickerClientPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ThemeColorPickerClientPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setTheme(
      theme: Theme): void {
    this.proxy.sendMessage(
        0,
        ThemeColorPickerClient_SetTheme_ParamsSpec.$,
        null,
        [
          theme
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ThemeColorPickerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ThemeColorPickerClientReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ThemeColorPickerClientRemote, ThemeColorPickerClientPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ThemeColorPickerClientRemote, ThemeColorPickerClientPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ThemeColorPickerClientInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ThemeColorPickerClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ThemeColorPickerClient_SetTheme_ParamsSpec.$,
        null,
        impl.setTheme.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ThemeColorPickerClient {
  static get $interfaceName(): string {
    return "theme_color_picker.mojom.ThemeColorPickerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ThemeColorPickerClientRemote {
    let remote = new ThemeColorPickerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ThemeColorPickerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ThemeColorPickerClientCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ThemeColorPickerClientRemote, ThemeColorPickerClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ThemeColorPickerClientRemote, ThemeColorPickerClientPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setTheme: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ThemeColorPickerClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setTheme =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ThemeColorPickerClient_SetTheme_ParamsSpec.$,
        null,
        this.setTheme.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ThemeSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ChromeColorSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ThemeColorPickerHandler_GetChromeColors_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ThemeColorPickerHandler_GetChromeColors_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ThemeColorPickerHandler_UpdateTheme_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ThemeColorPickerHandler_SetDefaultColor_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ThemeColorPickerHandler_SetGreyDefaultColor_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ThemeColorPickerHandler_SetSeedColor_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ThemeColorPickerHandler_SetSeedColorFromHue_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ThemeColorPickerHandler_RemoveBackgroundImage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ThemeColorPickerClient_SetTheme_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ThemeMojoType {
  hasBackgroundImage: boolean;
  hasThirdPartyTheme: boolean;
  isDarkMode: boolean;
  colorsManagedByPolicy: boolean;
  isGreyBaseline: boolean;
  followDeviceTheme: boolean;
  seedColorHue: number;
  backgroundImageMainColor: (skia_mojom_SkColor | null);
  seedColor: skia_mojom_SkColor;
  backgroundColor: skia_mojom_SkColor;
  foregroundColor: (skia_mojom_SkColor | null);
  colorPickerIconColor: skia_mojom_SkColor;
  browserColorVariant: ui_mojom_BrowserColorVariant;
}


export type Theme = ThemeMojoType;
mojo.internal.Struct<ThemeMojoType>(
    ThemeSpec.$,
    'Theme',
    [
      mojo.internal.StructField<ThemeMojoType, boolean>(
        'hasBackgroundImage', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, boolean>(
        'hasThirdPartyTheme', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, skia_mojom_SkColor>(
        'backgroundImageMainColor', 8,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, boolean>(
        'isDarkMode', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, skia_mojom_SkColor>(
        'seedColor', 16,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, number>(
        'seedColorHue', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, skia_mojom_SkColor>(
        'backgroundColor', 24,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, skia_mojom_SkColor>(
        'foregroundColor', 32,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, skia_mojom_SkColor>(
        'colorPickerIconColor', 40,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, boolean>(
        'colorsManagedByPolicy', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, boolean>(
        'isGreyBaseline', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, ui_mojom_BrowserColorVariant>(
        'browserColorVariant', 48,
        0,
        ui_mojom_BrowserColorVariantSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, boolean>(
        'followDeviceTheme', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 64],]);





export interface ChromeColorMojoType {
  name: string;
  seed: skia_mojom_SkColor;
  background: skia_mojom_SkColor;
  foreground: skia_mojom_SkColor;
  base: skia_mojom_SkColor;
  variant: ui_mojom_BrowserColorVariant;
}


export type ChromeColor = ChromeColorMojoType;
mojo.internal.Struct<ChromeColorMojoType>(
    ChromeColorSpec.$,
    'ChromeColor',
    [
      mojo.internal.StructField<ChromeColorMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ChromeColorMojoType, skia_mojom_SkColor>(
        'seed', 8,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ChromeColorMojoType, skia_mojom_SkColor>(
        'background', 16,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ChromeColorMojoType, skia_mojom_SkColor>(
        'foreground', 24,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ChromeColorMojoType, skia_mojom_SkColor>(
        'base', 32,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ChromeColorMojoType, ui_mojom_BrowserColorVariant>(
        'variant', 40,
        0,
        ui_mojom_BrowserColorVariantSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsMojoType {
  handler: ThemeColorPickerHandlerPendingReceiver;
  client: ThemeColorPickerClientRemote;
}


export type ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_Params = ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsMojoType;
mojo.internal.Struct<ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsMojoType>(
    ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsSpec.$,
    'ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_Params',
    [
      mojo.internal.StructField<ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsMojoType, ThemeColorPickerHandlerPendingReceiver>(
        'handler', 0,
        0,
        mojo.internal.InterfaceRequest(ThemeColorPickerHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsMojoType, ThemeColorPickerClientRemote>(
        'client', 4,
        0,
        mojo.internal.InterfaceProxy(ThemeColorPickerClientRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ThemeColorPickerHandler_GetChromeColors_ParamsMojoType {
  isDarkMode: boolean;
}


export type ThemeColorPickerHandler_GetChromeColors_Params = ThemeColorPickerHandler_GetChromeColors_ParamsMojoType;
mojo.internal.Struct<ThemeColorPickerHandler_GetChromeColors_ParamsMojoType>(
    ThemeColorPickerHandler_GetChromeColors_ParamsSpec.$,
    'ThemeColorPickerHandler_GetChromeColors_Params',
    [
      mojo.internal.StructField<ThemeColorPickerHandler_GetChromeColors_ParamsMojoType, boolean>(
        'isDarkMode', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ThemeColorPickerHandler_GetChromeColors_ResponseParamsMojoType {
  colors: ChromeColor[];
}


export type ThemeColorPickerHandler_GetChromeColors_ResponseParams = ThemeColorPickerHandler_GetChromeColors_ResponseParamsMojoType;
mojo.internal.Struct<ThemeColorPickerHandler_GetChromeColors_ResponseParamsMojoType>(
    ThemeColorPickerHandler_GetChromeColors_ResponseParamsSpec.$,
    'ThemeColorPickerHandler_GetChromeColors_ResponseParams',
    [
      mojo.internal.StructField<ThemeColorPickerHandler_GetChromeColors_ResponseParamsMojoType, ChromeColor[]>(
        'colors', 0,
        0,
        mojo.internal.Array(ChromeColorSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ThemeColorPickerHandler_UpdateTheme_ParamsMojoType {
}


export type ThemeColorPickerHandler_UpdateTheme_Params = ThemeColorPickerHandler_UpdateTheme_ParamsMojoType;
mojo.internal.Struct<ThemeColorPickerHandler_UpdateTheme_ParamsMojoType>(
    ThemeColorPickerHandler_UpdateTheme_ParamsSpec.$,
    'ThemeColorPickerHandler_UpdateTheme_Params',
    [
    ],
    [[0, 8],]);





export interface ThemeColorPickerHandler_SetDefaultColor_ParamsMojoType {
}


export type ThemeColorPickerHandler_SetDefaultColor_Params = ThemeColorPickerHandler_SetDefaultColor_ParamsMojoType;
mojo.internal.Struct<ThemeColorPickerHandler_SetDefaultColor_ParamsMojoType>(
    ThemeColorPickerHandler_SetDefaultColor_ParamsSpec.$,
    'ThemeColorPickerHandler_SetDefaultColor_Params',
    [
    ],
    [[0, 8],]);





export interface ThemeColorPickerHandler_SetGreyDefaultColor_ParamsMojoType {
}


export type ThemeColorPickerHandler_SetGreyDefaultColor_Params = ThemeColorPickerHandler_SetGreyDefaultColor_ParamsMojoType;
mojo.internal.Struct<ThemeColorPickerHandler_SetGreyDefaultColor_ParamsMojoType>(
    ThemeColorPickerHandler_SetGreyDefaultColor_ParamsSpec.$,
    'ThemeColorPickerHandler_SetGreyDefaultColor_Params',
    [
    ],
    [[0, 8],]);





export interface ThemeColorPickerHandler_SetSeedColor_ParamsMojoType {
  seedColor: skia_mojom_SkColor;
  variant: ui_mojom_BrowserColorVariant;
}


export type ThemeColorPickerHandler_SetSeedColor_Params = ThemeColorPickerHandler_SetSeedColor_ParamsMojoType;
mojo.internal.Struct<ThemeColorPickerHandler_SetSeedColor_ParamsMojoType>(
    ThemeColorPickerHandler_SetSeedColor_ParamsSpec.$,
    'ThemeColorPickerHandler_SetSeedColor_Params',
    [
      mojo.internal.StructField<ThemeColorPickerHandler_SetSeedColor_ParamsMojoType, skia_mojom_SkColor>(
        'seedColor', 0,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeColorPickerHandler_SetSeedColor_ParamsMojoType, ui_mojom_BrowserColorVariant>(
        'variant', 8,
        0,
        ui_mojom_BrowserColorVariantSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ThemeColorPickerHandler_SetSeedColorFromHue_ParamsMojoType {
  hue: number;
}


export type ThemeColorPickerHandler_SetSeedColorFromHue_Params = ThemeColorPickerHandler_SetSeedColorFromHue_ParamsMojoType;
mojo.internal.Struct<ThemeColorPickerHandler_SetSeedColorFromHue_ParamsMojoType>(
    ThemeColorPickerHandler_SetSeedColorFromHue_ParamsSpec.$,
    'ThemeColorPickerHandler_SetSeedColorFromHue_Params',
    [
      mojo.internal.StructField<ThemeColorPickerHandler_SetSeedColorFromHue_ParamsMojoType, number>(
        'hue', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ThemeColorPickerHandler_RemoveBackgroundImage_ParamsMojoType {
}


export type ThemeColorPickerHandler_RemoveBackgroundImage_Params = ThemeColorPickerHandler_RemoveBackgroundImage_ParamsMojoType;
mojo.internal.Struct<ThemeColorPickerHandler_RemoveBackgroundImage_ParamsMojoType>(
    ThemeColorPickerHandler_RemoveBackgroundImage_ParamsSpec.$,
    'ThemeColorPickerHandler_RemoveBackgroundImage_Params',
    [
    ],
    [[0, 8],]);





export interface ThemeColorPickerClient_SetTheme_ParamsMojoType {
  theme: Theme;
}


export type ThemeColorPickerClient_SetTheme_Params = ThemeColorPickerClient_SetTheme_ParamsMojoType;
mojo.internal.Struct<ThemeColorPickerClient_SetTheme_ParamsMojoType>(
    ThemeColorPickerClient_SetTheme_ParamsSpec.$,
    'ThemeColorPickerClient_SetTheme_Params',
    [
      mojo.internal.StructField<ThemeColorPickerClient_SetTheme_ParamsMojoType, Theme>(
        'theme', 0,
        0,
        ThemeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



