// ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_MOJOM_DATA_VIEW_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "components/history_clusters/public/mojom/history_cluster_types.mojom-shared.h"


namespace history_clusters::mojom {
class QueryResultDataView;



}  // history_clusters::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::history_clusters::mojom::QueryResultDataView> {
  using Data = ::history_clusters::mojom::internal::QueryResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace history_clusters::mojom {


enum class ClusterAction : int32_t {
  
  kDeleted = 0,
  
  kOpenedInTabGroup = 1,
  
  kRelatedSearchClicked = 2,
  
  kVisitClicked = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ClusterAction value);
inline bool IsKnownEnumValue(ClusterAction value) {
  return internal::ClusterAction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RelatedSearchAction : int32_t {
  
  kClicked = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, RelatedSearchAction value);
inline bool IsKnownEnumValue(RelatedSearchAction value) {
  return internal::RelatedSearchAction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VisitAction : int32_t {
  
  kClicked = 0,
  
  kHidden = 1,
  
  kDeleted = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, VisitAction value);
inline bool IsKnownEnumValue(VisitAction value) {
  return internal::VisitAction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class VisitType : int32_t {
  
  kSRP = 0,
  
  kNonSRP = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, VisitType value);
inline bool IsKnownEnumValue(VisitType value) {
  return internal::VisitType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class QueryResultDataView {
 public:
  QueryResultDataView() = default;

  QueryResultDataView(
      internal::QueryResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetQueryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuery(UserType* output) {
    
    auto* pointer = data_->query.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetClustersDataView(
      mojo::ArrayDataView<::history_clusters::mojom::ClusterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClusters(UserType* output) {
    
    auto* pointer = data_->clusters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::history_clusters::mojom::ClusterDataView>>(
        pointer, output, message_);
  }
  bool can_load_more() const {
    return data_->can_load_more;
  }
  bool is_continuation() const {
    return data_->is_continuation;
  }
 private:
  internal::QueryResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // history_clusters::mojom

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_MOJOM_DATA_VIEW_H_