// ui/webui/resources/cr_components/history/history.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const FilteringBehaviorSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum FilteringBehavior {

  MIN_VALUE = -1,
  MAX_VALUE = 3,
  kUnknown = -1,
  kAllow = 0,
  kBlock = 2,
  kInvalid = 3,
}



export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'history.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  setPage(page: PageRemote): void;
  queryHistory(query: string, maxResults: number, beginTime: (number | null)): Promise<{
        results: QueryResult, }>;
  queryHistoryContinuation(): Promise<{
        results: QueryResult, }>;
  removeVisits(items: RemovalItem[]): Promise<{
        didDelete: boolean, }>;
  openClearBrowsingDataDialog(): void;
  removeBookmark(url: string): void;
  setLastSelectedTab(lastTab: number): void;
  showSidePanelUI(): void;
  requestAccountInfo(): Promise<{
        accountInfo: AccountInfo, }>;
  turnOnHistorySync(): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setPage(
      page: PageRemote): void {
    this.proxy.sendMessage(
        0,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        [
          page
        ],
        false);
  }

  queryHistory(
      query: string,
      maxResults: number,
      beginTime: (number | null)): Promise<{
        results: QueryResult, }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_QueryHistory_ParamsSpec.$,
        PageHandler_QueryHistory_ResponseParamsSpec.$,
        [
          query,
          maxResults,
          beginTime
        ],
        false);
  }

  queryHistoryContinuation(): Promise<{
        results: QueryResult, }> {
    return this.proxy.sendMessage(
        2,
        PageHandler_QueryHistoryContinuation_ParamsSpec.$,
        PageHandler_QueryHistoryContinuation_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  removeVisits(
      items: RemovalItem[]): Promise<{
        didDelete: boolean, }> {
    return this.proxy.sendMessage(
        3,
        PageHandler_RemoveVisits_ParamsSpec.$,
        PageHandler_RemoveVisits_ResponseParamsSpec.$,
        [
          items
        ],
        false);
  }

  openClearBrowsingDataDialog(): void {
    this.proxy.sendMessage(
        4,
        PageHandler_OpenClearBrowsingDataDialog_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  removeBookmark(
      url: string): void {
    this.proxy.sendMessage(
        5,
        PageHandler_RemoveBookmark_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  setLastSelectedTab(
      lastTab: number): void {
    this.proxy.sendMessage(
        6,
        PageHandler_SetLastSelectedTab_ParamsSpec.$,
        null,
        [
          lastTab
        ],
        false);
  }

  showSidePanelUI(): void {
    this.proxy.sendMessage(
        7,
        PageHandler_ShowSidePanelUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  requestAccountInfo(): Promise<{
        accountInfo: AccountInfo, }> {
    return this.proxy.sendMessage(
        8,
        PageHandler_RequestAccountInfo_ParamsSpec.$,
        PageHandler_RequestAccountInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  turnOnHistorySync(): void {
    this.proxy.sendMessage(
        9,
        PageHandler_TurnOnHistorySync_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        impl.setPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_QueryHistory_ParamsSpec.$,
        PageHandler_QueryHistory_ResponseParamsSpec.$,
        impl.queryHistory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_QueryHistoryContinuation_ParamsSpec.$,
        PageHandler_QueryHistoryContinuation_ResponseParamsSpec.$,
        impl.queryHistoryContinuation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_RemoveVisits_ParamsSpec.$,
        PageHandler_RemoveVisits_ResponseParamsSpec.$,
        impl.removeVisits.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_OpenClearBrowsingDataDialog_ParamsSpec.$,
        null,
        impl.openClearBrowsingDataDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_RemoveBookmark_ParamsSpec.$,
        null,
        impl.removeBookmark.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_SetLastSelectedTab_ParamsSpec.$,
        null,
        impl.setLastSelectedTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_ShowSidePanelUI_ParamsSpec.$,
        null,
        impl.showSidePanelUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_RequestAccountInfo_ParamsSpec.$,
        PageHandler_RequestAccountInfo_ResponseParamsSpec.$,
        impl.requestAccountInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_TurnOnHistorySync_ParamsSpec.$,
        null,
        impl.turnOnHistorySync.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "history.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  queryHistory: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  queryHistoryContinuation: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  removeVisits: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openClearBrowsingDataDialog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  removeBookmark: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setLastSelectedTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showSidePanelUI: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestAccountInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  turnOnHistorySync: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        this.setPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.queryHistory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_QueryHistory_ParamsSpec.$,
        PageHandler_QueryHistory_ResponseParamsSpec.$,
        this.queryHistory.createReceiverHandler(true /* expectsResponse */),
        false);
    this.queryHistoryContinuation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_QueryHistoryContinuation_ParamsSpec.$,
        PageHandler_QueryHistoryContinuation_ResponseParamsSpec.$,
        this.queryHistoryContinuation.createReceiverHandler(true /* expectsResponse */),
        false);
    this.removeVisits =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_RemoveVisits_ParamsSpec.$,
        PageHandler_RemoveVisits_ResponseParamsSpec.$,
        this.removeVisits.createReceiverHandler(true /* expectsResponse */),
        false);
    this.openClearBrowsingDataDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_OpenClearBrowsingDataDialog_ParamsSpec.$,
        null,
        this.openClearBrowsingDataDialog.createReceiverHandler(false /* expectsResponse */),
        false);
    this.removeBookmark =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_RemoveBookmark_ParamsSpec.$,
        null,
        this.removeBookmark.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setLastSelectedTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_SetLastSelectedTab_ParamsSpec.$,
        null,
        this.setLastSelectedTab.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showSidePanelUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_ShowSidePanelUI_ParamsSpec.$,
        null,
        this.showSidePanelUI.createReceiverHandler(false /* expectsResponse */),
        false);
    this.requestAccountInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_RequestAccountInfo_ParamsSpec.$,
        PageHandler_RequestAccountInfo_ResponseParamsSpec.$,
        this.requestAccountInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.turnOnHistorySync =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_TurnOnHistorySync_ParamsSpec.$,
        null,
        this.turnOnHistorySync.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'history.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  onHistoryDeleted(): void;
  onHasOtherFormsChanged(hasOtherForms: boolean): void;
  sendAccountInfo(accountInfo: AccountInfo): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onHistoryDeleted(): void {
    this.proxy.sendMessage(
        0,
        Page_OnHistoryDeleted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onHasOtherFormsChanged(
      hasOtherForms: boolean): void {
    this.proxy.sendMessage(
        1,
        Page_OnHasOtherFormsChanged_ParamsSpec.$,
        null,
        [
          hasOtherForms
        ],
        false);
  }

  sendAccountInfo(
      accountInfo: AccountInfo): void {
    this.proxy.sendMessage(
        2,
        Page_SendAccountInfo_ParamsSpec.$,
        null,
        [
          accountInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_OnHistoryDeleted_ParamsSpec.$,
        null,
        impl.onHistoryDeleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_OnHasOtherFormsChanged_ParamsSpec.$,
        null,
        impl.onHasOtherFormsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_SendAccountInfo_ParamsSpec.$,
        null,
        impl.sendAccountInfo.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "history.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onHistoryDeleted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onHasOtherFormsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  sendAccountInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onHistoryDeleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_OnHistoryDeleted_ParamsSpec.$,
        null,
        this.onHistoryDeleted.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onHasOtherFormsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_OnHasOtherFormsChanged_ParamsSpec.$,
        null,
        this.onHasOtherFormsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.sendAccountInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_SendAccountInfo_ParamsSpec.$,
        null,
        this.sendAccountInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const QueryStateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const HistoryQuerySpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DebugInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const HistoryEntrySpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const QueryResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const RemovalItemSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AccountInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_QueryHistory_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_QueryHistory_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_QueryHistoryContinuation_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_QueryHistoryContinuation_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RemoveVisits_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RemoveVisits_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenClearBrowsingDataDialog_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RemoveBookmark_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetLastSelectedTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShowSidePanelUI_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RequestAccountInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RequestAccountInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_TurnOnHistorySync_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnHistoryDeleted_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnHasOtherFormsChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SendAccountInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface QueryStateMojoType {
  incremental: boolean;
  querying: boolean;
  searchTerm: string;
  after: (string | null);
}


export type QueryState = QueryStateMojoType;
mojo.internal.Struct<QueryStateMojoType>(
    QueryStateSpec.$,
    'QueryState',
    [
      mojo.internal.StructField<QueryStateMojoType, boolean>(
        'incremental', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<QueryStateMojoType, boolean>(
        'querying', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<QueryStateMojoType, string>(
        'searchTerm', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<QueryStateMojoType, string>(
        'after', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface HistoryQueryMojoType {
  term: string;
  finished: boolean;
}


export type HistoryQuery = HistoryQueryMojoType;
mojo.internal.Struct<HistoryQueryMojoType>(
    HistoryQuerySpec.$,
    'HistoryQuery',
    [
      mojo.internal.StructField<HistoryQueryMojoType, string>(
        'term', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryQueryMojoType, boolean>(
        'finished', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface DebugInfoMojoType {
  isUrlInLocalDatabase: boolean;
  visitCount: number;
  typedCount: number;
}


export type DebugInfo = DebugInfoMojoType;
mojo.internal.Struct<DebugInfoMojoType>(
    DebugInfoSpec.$,
    'DebugInfo',
    [
      mojo.internal.StructField<DebugInfoMojoType, boolean>(
        'isUrlInLocalDatabase', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DebugInfoMojoType, number>(
        'visitCount', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DebugInfoMojoType, number>(
        'typedCount', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface HistoryEntryMojoType {
  url: string;
  title: string;
  domain: string;
  fallbackFaviconText: string;
  time: number;
  allTimestamps: number[];
  dateShort: string;
  deviceName: string;
  deviceType: string;
  dateTimeOfDay: string;
  dateRelativeDay: string;
  selected: boolean;
  starred: boolean;
  blockedVisit: boolean;
  isUrlInRemoteUserData: boolean;
  isActorVisit: boolean;
  hostFilteringBehavior: FilteringBehavior;
  readableTimestamp: string;
  snippet: string;
  remoteIconUrlForUma: string;
  debug: (DebugInfo | null);
}


export type HistoryEntry = HistoryEntryMojoType;
mojo.internal.Struct<HistoryEntryMojoType>(
    HistoryEntrySpec.$,
    'HistoryEntry',
    [
      mojo.internal.StructField<HistoryEntryMojoType, string>(
        'url', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, string>(
        'title', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, string>(
        'domain', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, string>(
        'fallbackFaviconText', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, number>(
        'time', 32,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, number[]>(
        'allTimestamps', 40,
        0,
        mojo.internal.Array(mojo.internal.Double, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, string>(
        'dateShort', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, string>(
        'deviceName', 56,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, string>(
        'deviceType', 64,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, string>(
        'dateTimeOfDay', 72,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, string>(
        'dateRelativeDay', 80,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, boolean>(
        'selected', 88,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, string>(
        'readableTimestamp', 96,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, string>(
        'snippet', 104,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, boolean>(
        'starred', 88,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, FilteringBehavior>(
        'hostFilteringBehavior', 92,
        0,
        FilteringBehaviorSpec.$,
        -1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, boolean>(
        'blockedVisit', 88,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, boolean>(
        'isUrlInRemoteUserData', 88,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, boolean>(
        'isActorVisit', 88,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, string>(
        'remoteIconUrlForUma', 112,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<HistoryEntryMojoType, DebugInfo>(
        'debug', 120,
        0,
        DebugInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 136],]);





export interface QueryResultMojoType {
  info: (HistoryQuery | null);
  value: HistoryEntry[];
}


export type QueryResult = QueryResultMojoType;
mojo.internal.Struct<QueryResultMojoType>(
    QueryResultSpec.$,
    'QueryResult',
    [
      mojo.internal.StructField<QueryResultMojoType, HistoryQuery>(
        'info', 0,
        0,
        HistoryQuerySpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<QueryResultMojoType, HistoryEntry[]>(
        'value', 8,
        0,
        mojo.internal.Array(HistoryEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface RemovalItemMojoType {
  url: string;
  timestamps: number[];
}


export type RemovalItem = RemovalItemMojoType;
mojo.internal.Struct<RemovalItemMojoType>(
    RemovalItemSpec.$,
    'RemovalItem',
    [
      mojo.internal.StructField<RemovalItemMojoType, string>(
        'url', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RemovalItemMojoType, number[]>(
        'timestamps', 8,
        0,
        mojo.internal.Array(mojo.internal.Double, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface AccountInfoMojoType {
  accountImageSrc: url_mojom_Url;
  name: string;
  email: string;
}


export type AccountInfo = AccountInfoMojoType;
mojo.internal.Struct<AccountInfoMojoType>(
    AccountInfoSpec.$,
    'AccountInfo',
    [
      mojo.internal.StructField<AccountInfoMojoType, url_mojom_Url>(
        'accountImageSrc', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AccountInfoMojoType, string>(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AccountInfoMojoType, string>(
        'email', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_SetPage_ParamsMojoType {
  page: PageRemote;
}


export type PageHandler_SetPage_Params = PageHandler_SetPage_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetPage_ParamsMojoType>(
    PageHandler_SetPage_ParamsSpec.$,
    'PageHandler_SetPage_Params',
    [
      mojo.internal.StructField<PageHandler_SetPage_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_QueryHistory_ParamsMojoType {
  query: string;
  maxResults: number;
  beginTime: (number | null);
}


export type PageHandler_QueryHistory_Params = PageHandler_QueryHistory_ParamsMojoType;
mojo.internal.Struct<PageHandler_QueryHistory_ParamsMojoType>(
    PageHandler_QueryHistory_ParamsSpec.$,
    'PageHandler_QueryHistory_Params',
    [
      mojo.internal.StructField<PageHandler_QueryHistory_ParamsMojoType, string>(
        'query', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_QueryHistory_ParamsMojoType, number>(
        'maxResults', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_QueryHistory_ParamsMojoType, boolean>(
        'begin_time_$flag', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "begin_time_$value",
          originalFieldName: "beginTime",
        },
        undefined,
    ),
      mojo.internal.StructField<PageHandler_QueryHistory_ParamsMojoType, number>(
        'begin_time_$value', 16,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "beginTime",
        },
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_QueryHistory_ResponseParamsMojoType {
  results: QueryResult;
}


export type PageHandler_QueryHistory_ResponseParams = PageHandler_QueryHistory_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_QueryHistory_ResponseParamsMojoType>(
    PageHandler_QueryHistory_ResponseParamsSpec.$,
    'PageHandler_QueryHistory_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_QueryHistory_ResponseParamsMojoType, QueryResult>(
        'results', 0,
        0,
        QueryResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_QueryHistoryContinuation_ParamsMojoType {
}


export type PageHandler_QueryHistoryContinuation_Params = PageHandler_QueryHistoryContinuation_ParamsMojoType;
mojo.internal.Struct<PageHandler_QueryHistoryContinuation_ParamsMojoType>(
    PageHandler_QueryHistoryContinuation_ParamsSpec.$,
    'PageHandler_QueryHistoryContinuation_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_QueryHistoryContinuation_ResponseParamsMojoType {
  results: QueryResult;
}


export type PageHandler_QueryHistoryContinuation_ResponseParams = PageHandler_QueryHistoryContinuation_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_QueryHistoryContinuation_ResponseParamsMojoType>(
    PageHandler_QueryHistoryContinuation_ResponseParamsSpec.$,
    'PageHandler_QueryHistoryContinuation_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_QueryHistoryContinuation_ResponseParamsMojoType, QueryResult>(
        'results', 0,
        0,
        QueryResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RemoveVisits_ParamsMojoType {
  items: RemovalItem[];
}


export type PageHandler_RemoveVisits_Params = PageHandler_RemoveVisits_ParamsMojoType;
mojo.internal.Struct<PageHandler_RemoveVisits_ParamsMojoType>(
    PageHandler_RemoveVisits_ParamsSpec.$,
    'PageHandler_RemoveVisits_Params',
    [
      mojo.internal.StructField<PageHandler_RemoveVisits_ParamsMojoType, RemovalItem[]>(
        'items', 0,
        0,
        mojo.internal.Array(RemovalItemSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RemoveVisits_ResponseParamsMojoType {
  didDelete: boolean;
}


export type PageHandler_RemoveVisits_ResponseParams = PageHandler_RemoveVisits_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_RemoveVisits_ResponseParamsMojoType>(
    PageHandler_RemoveVisits_ResponseParamsSpec.$,
    'PageHandler_RemoveVisits_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_RemoveVisits_ResponseParamsMojoType, boolean>(
        'didDelete', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OpenClearBrowsingDataDialog_ParamsMojoType {
}


export type PageHandler_OpenClearBrowsingDataDialog_Params = PageHandler_OpenClearBrowsingDataDialog_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenClearBrowsingDataDialog_ParamsMojoType>(
    PageHandler_OpenClearBrowsingDataDialog_ParamsSpec.$,
    'PageHandler_OpenClearBrowsingDataDialog_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_RemoveBookmark_ParamsMojoType {
  url: string;
}


export type PageHandler_RemoveBookmark_Params = PageHandler_RemoveBookmark_ParamsMojoType;
mojo.internal.Struct<PageHandler_RemoveBookmark_ParamsMojoType>(
    PageHandler_RemoveBookmark_ParamsSpec.$,
    'PageHandler_RemoveBookmark_Params',
    [
      mojo.internal.StructField<PageHandler_RemoveBookmark_ParamsMojoType, string>(
        'url', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetLastSelectedTab_ParamsMojoType {
  lastTab: number;
}


export type PageHandler_SetLastSelectedTab_Params = PageHandler_SetLastSelectedTab_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetLastSelectedTab_ParamsMojoType>(
    PageHandler_SetLastSelectedTab_ParamsSpec.$,
    'PageHandler_SetLastSelectedTab_Params',
    [
      mojo.internal.StructField<PageHandler_SetLastSelectedTab_ParamsMojoType, number>(
        'lastTab', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ShowSidePanelUI_ParamsMojoType {
}


export type PageHandler_ShowSidePanelUI_Params = PageHandler_ShowSidePanelUI_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShowSidePanelUI_ParamsMojoType>(
    PageHandler_ShowSidePanelUI_ParamsSpec.$,
    'PageHandler_ShowSidePanelUI_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_RequestAccountInfo_ParamsMojoType {
}


export type PageHandler_RequestAccountInfo_Params = PageHandler_RequestAccountInfo_ParamsMojoType;
mojo.internal.Struct<PageHandler_RequestAccountInfo_ParamsMojoType>(
    PageHandler_RequestAccountInfo_ParamsSpec.$,
    'PageHandler_RequestAccountInfo_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_RequestAccountInfo_ResponseParamsMojoType {
  accountInfo: AccountInfo;
}


export type PageHandler_RequestAccountInfo_ResponseParams = PageHandler_RequestAccountInfo_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_RequestAccountInfo_ResponseParamsMojoType>(
    PageHandler_RequestAccountInfo_ResponseParamsSpec.$,
    'PageHandler_RequestAccountInfo_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_RequestAccountInfo_ResponseParamsMojoType, AccountInfo>(
        'accountInfo', 0,
        0,
        AccountInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_TurnOnHistorySync_ParamsMojoType {
}


export type PageHandler_TurnOnHistorySync_Params = PageHandler_TurnOnHistorySync_ParamsMojoType;
mojo.internal.Struct<PageHandler_TurnOnHistorySync_ParamsMojoType>(
    PageHandler_TurnOnHistorySync_ParamsSpec.$,
    'PageHandler_TurnOnHistorySync_Params',
    [
    ],
    [[0, 8],]);





export interface Page_OnHistoryDeleted_ParamsMojoType {
}


export type Page_OnHistoryDeleted_Params = Page_OnHistoryDeleted_ParamsMojoType;
mojo.internal.Struct<Page_OnHistoryDeleted_ParamsMojoType>(
    Page_OnHistoryDeleted_ParamsSpec.$,
    'Page_OnHistoryDeleted_Params',
    [
    ],
    [[0, 8],]);





export interface Page_OnHasOtherFormsChanged_ParamsMojoType {
  hasOtherForms: boolean;
}


export type Page_OnHasOtherFormsChanged_Params = Page_OnHasOtherFormsChanged_ParamsMojoType;
mojo.internal.Struct<Page_OnHasOtherFormsChanged_ParamsMojoType>(
    Page_OnHasOtherFormsChanged_ParamsSpec.$,
    'Page_OnHasOtherFormsChanged_Params',
    [
      mojo.internal.StructField<Page_OnHasOtherFormsChanged_ParamsMojoType, boolean>(
        'hasOtherForms', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_SendAccountInfo_ParamsMojoType {
  accountInfo: AccountInfo;
}


export type Page_SendAccountInfo_Params = Page_SendAccountInfo_ParamsMojoType;
mojo.internal.Struct<Page_SendAccountInfo_ParamsMojoType>(
    Page_SendAccountInfo_ParamsSpec.$,
    'Page_SendAccountInfo_Params',
    [
      mojo.internal.StructField<Page_SendAccountInfo_ParamsMojoType, AccountInfo>(
        'accountInfo', 0,
        0,
        AccountInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



