// ui/webui/resources/cr_components/history/history.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_HISTORY_MOJOM_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_HISTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/cr_components/history/history.mojom-features.h"  // IWYU pragma: export
#include "ui/webui/resources/cr_components/history/history.mojom-shared.h"  // IWYU pragma: export
#include "ui/webui/resources/cr_components/history/history.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace history::mojom {

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "history.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetPageMinVersion = 0,
    kQueryHistoryMinVersion = 0,
    kQueryHistoryContinuationMinVersion = 0,
    kRemoveVisitsMinVersion = 0,
    kOpenClearBrowsingDataDialogMinVersion = 0,
    kRemoveBookmarkMinVersion = 0,
    kSetLastSelectedTabMinVersion = 0,
    kShowSidePanelUIMinVersion = 0,
    kRequestAccountInfoMinVersion = 0,
    kTurnOnHistorySyncMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueryHistory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueryHistoryContinuation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveVisits_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenClearBrowsingDataDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveBookmark_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetLastSelectedTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowSidePanelUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestAccountInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TurnOnHistorySync_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void SetPage(::mojo::PendingRemote<Page> page) = 0;

  using QueryHistoryCallback = base::OnceCallback<void(QueryResultPtr)>;
  using QueryHistoryMojoCallback = base::OnceCallback<void(QueryResultPtr)>;

  virtual void QueryHistory(const std::string& query, int32_t max_results, std::optional<double> begin_time, QueryHistoryCallback callback) = 0;

  using QueryHistoryContinuationCallback = base::OnceCallback<void(QueryResultPtr)>;
  using QueryHistoryContinuationMojoCallback = base::OnceCallback<void(QueryResultPtr)>;

  virtual void QueryHistoryContinuation(QueryHistoryContinuationCallback callback) = 0;

  using RemoveVisitsCallback = base::OnceCallback<void(bool)>;
  using RemoveVisitsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RemoveVisits(std::vector<RemovalItemPtr> items, RemoveVisitsCallback callback) = 0;

  virtual void OpenClearBrowsingDataDialog() = 0;

  virtual void RemoveBookmark(const std::string& url) = 0;

  virtual void SetLastSelectedTab(int32_t last_tab) = 0;

  virtual void ShowSidePanelUI() = 0;

  using RequestAccountInfoCallback = base::OnceCallback<void(AccountInfoPtr)>;
  using RequestAccountInfoMojoCallback = base::OnceCallback<void(AccountInfoPtr)>;

  virtual void RequestAccountInfo(RequestAccountInfoCallback callback) = 0;

  virtual void TurnOnHistorySync() = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "history.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnHistoryDeletedMinVersion = 0,
    kOnHasOtherFormsChangedMinVersion = 0,
    kSendAccountInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnHistoryDeleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnHasOtherFormsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendAccountInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void OnHistoryDeleted() = 0;

  virtual void OnHasOtherFormsChanged(bool has_other_forms) = 0;

  virtual void SendAccountInfo(AccountInfoPtr account_info) = 0;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetPage(::mojo::PendingRemote<Page> page) final;
  
  void QueryHistory(const std::string& query, int32_t max_results, std::optional<double> begin_time, QueryHistoryCallback callback) final;
  
  void QueryHistoryContinuation(QueryHistoryContinuationCallback callback) final;
  
  void RemoveVisits(std::vector<RemovalItemPtr> items, RemoveVisitsCallback callback) final;
  
  void OpenClearBrowsingDataDialog() final;
  
  void RemoveBookmark(const std::string& url) final;
  
  void SetLastSelectedTab(int32_t last_tab) final;
  
  void ShowSidePanelUI() final;
  
  void RequestAccountInfo(RequestAccountInfoCallback callback) final;
  
  void TurnOnHistorySync() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnHistoryDeleted() final;
  
  void OnHasOtherFormsChanged(bool has_other_forms) final;
  
  void SendAccountInfo(AccountInfoPtr account_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  QueryState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QueryState, T>::value>;
  using DataView = QueryStateDataView;
  using Data_ = internal::QueryState_Data;

  template <typename... Args>
  static QueryStatePtr New(Args&&... args) {
    return QueryStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QueryStatePtr From(const U& u) {
    return mojo::TypeConverter<QueryStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QueryState>::Convert(*this);
  }


  QueryState();

  QueryState(
      bool incremental,
      bool querying,
      const std::string& search_term,
      const std::optional<std::string>& after);


  ~QueryState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QueryStatePtr>
  QueryStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QueryState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, QueryState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, QueryState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QueryState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QueryState_UnserializedMessageContext<
            UserType, QueryState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<QueryState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return QueryState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QueryState_UnserializedMessageContext<
            UserType, QueryState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QueryState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool incremental;
  
  bool querying;
  
  std::string search_term;
  
  std::optional<std::string> after;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QueryState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QueryState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QueryState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QueryState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  HistoryQuery {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HistoryQuery, T>::value>;
  using DataView = HistoryQueryDataView;
  using Data_ = internal::HistoryQuery_Data;

  template <typename... Args>
  static HistoryQueryPtr New(Args&&... args) {
    return HistoryQueryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HistoryQueryPtr From(const U& u) {
    return mojo::TypeConverter<HistoryQueryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HistoryQuery>::Convert(*this);
  }


  HistoryQuery();

  HistoryQuery(
      const std::string& term,
      bool finished);


  ~HistoryQuery();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HistoryQueryPtr>
  HistoryQueryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HistoryQuery::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HistoryQuery::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HistoryQuery::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HistoryQuery::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HistoryQuery::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HistoryQuery::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HistoryQuery_UnserializedMessageContext<
            UserType, HistoryQuery::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HistoryQuery::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HistoryQuery::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HistoryQuery_UnserializedMessageContext<
            UserType, HistoryQuery::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HistoryQuery::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string term;
  
  bool finished;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HistoryQuery::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HistoryQuery::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HistoryQuery::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HistoryQuery::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DebugInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DebugInfo, T>::value>;
  using DataView = DebugInfoDataView;
  using Data_ = internal::DebugInfo_Data;

  template <typename... Args>
  static DebugInfoPtr New(Args&&... args) {
    return DebugInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DebugInfoPtr From(const U& u) {
    return mojo::TypeConverter<DebugInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DebugInfo>::Convert(*this);
  }


  DebugInfo();

  DebugInfo(
      bool is_url_in_local_database,
      uint32_t visit_count,
      uint32_t typed_count);


  ~DebugInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DebugInfoPtr>
  DebugInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DebugInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DebugInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DebugInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DebugInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DebugInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DebugInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DebugInfo_UnserializedMessageContext<
            UserType, DebugInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DebugInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DebugInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DebugInfo_UnserializedMessageContext<
            UserType, DebugInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DebugInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_url_in_local_database;
  
  uint32_t visit_count;
  
  uint32_t typed_count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DebugInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DebugInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DebugInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DebugInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}














class  HistoryEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HistoryEntry, T>::value>;
  using DataView = HistoryEntryDataView;
  using Data_ = internal::HistoryEntry_Data;

  template <typename... Args>
  static HistoryEntryPtr New(Args&&... args) {
    return HistoryEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HistoryEntryPtr From(const U& u) {
    return mojo::TypeConverter<HistoryEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HistoryEntry>::Convert(*this);
  }


  HistoryEntry();

  HistoryEntry(
      const std::string& url,
      const std::string& title,
      const std::string& domain,
      const std::string& fallback_favicon_text,
      double time,
      std::vector<double> all_timestamps,
      const std::string& date_short,
      const std::string& device_name,
      const std::string& device_type,
      const std::string& date_time_of_day,
      const std::string& date_relative_day,
      bool selected,
      const std::string& readableTimestamp,
      const std::string& snippet,
      bool starred,
      FilteringBehavior host_filtering_behavior,
      bool blocked_visit,
      bool is_url_in_remote_user_data,
      bool is_actor_visit,
      const std::string& remote_icon_url_for_uma,
      DebugInfoPtr debug);

HistoryEntry(const HistoryEntry&) = delete;
HistoryEntry& operator=(const HistoryEntry&) = delete;

  ~HistoryEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HistoryEntryPtr>
  HistoryEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HistoryEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HistoryEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HistoryEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HistoryEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HistoryEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HistoryEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HistoryEntry_UnserializedMessageContext<
            UserType, HistoryEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HistoryEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HistoryEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HistoryEntry_UnserializedMessageContext<
            UserType, HistoryEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HistoryEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string url;
  
  std::string title;
  
  std::string domain;
  
  std::string fallback_favicon_text;
  
  double time;
  
  std::vector<double> all_timestamps;
  
  std::string date_short;
  
  std::string device_name;
  
  std::string device_type;
  
  std::string date_time_of_day;
  
  std::string date_relative_day;
  
  bool selected;
  
  std::string readableTimestamp;
  
  std::string snippet;
  
  bool starred;
  
  FilteringBehavior host_filtering_behavior;
  
  bool blocked_visit;
  
  bool is_url_in_remote_user_data;
  
  bool is_actor_visit;
  
  std::string remote_icon_url_for_uma;
  
  DebugInfoPtr debug;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HistoryEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HistoryEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HistoryEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HistoryEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  QueryResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QueryResult, T>::value>;
  using DataView = QueryResultDataView;
  using Data_ = internal::QueryResult_Data;

  template <typename... Args>
  static QueryResultPtr New(Args&&... args) {
    return QueryResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QueryResultPtr From(const U& u) {
    return mojo::TypeConverter<QueryResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QueryResult>::Convert(*this);
  }


  QueryResult();

  QueryResult(
      HistoryQueryPtr info,
      std::vector<HistoryEntryPtr> value);

QueryResult(const QueryResult&) = delete;
QueryResult& operator=(const QueryResult&) = delete;

  ~QueryResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QueryResultPtr>
  QueryResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QueryResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, QueryResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, QueryResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QueryResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QueryResult_UnserializedMessageContext<
            UserType, QueryResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<QueryResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return QueryResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QueryResult_UnserializedMessageContext<
            UserType, QueryResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QueryResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  HistoryQueryPtr info;
  
  std::vector<HistoryEntryPtr> value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QueryResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QueryResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QueryResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QueryResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  RemovalItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RemovalItem, T>::value>;
  using DataView = RemovalItemDataView;
  using Data_ = internal::RemovalItem_Data;

  template <typename... Args>
  static RemovalItemPtr New(Args&&... args) {
    return RemovalItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RemovalItemPtr From(const U& u) {
    return mojo::TypeConverter<RemovalItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RemovalItem>::Convert(*this);
  }


  RemovalItem();

  RemovalItem(
      const std::string& url,
      std::vector<double> timestamps);


  ~RemovalItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RemovalItemPtr>
  RemovalItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RemovalItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RemovalItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RemovalItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RemovalItem::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RemovalItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RemovalItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RemovalItem_UnserializedMessageContext<
            UserType, RemovalItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RemovalItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RemovalItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RemovalItem_UnserializedMessageContext<
            UserType, RemovalItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RemovalItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string url;
  
  std::vector<double> timestamps;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RemovalItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RemovalItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RemovalItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RemovalItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AccountInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AccountInfo, T>::value>;
  using DataView = AccountInfoDataView;
  using Data_ = internal::AccountInfo_Data;

  template <typename... Args>
  static AccountInfoPtr New(Args&&... args) {
    return AccountInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AccountInfoPtr From(const U& u) {
    return mojo::TypeConverter<AccountInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AccountInfo>::Convert(*this);
  }


  AccountInfo();

  AccountInfo(
      const ::GURL& account_image_src,
      const std::string& name,
      const std::string& email);


  ~AccountInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AccountInfoPtr>
  AccountInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AccountInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AccountInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AccountInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AccountInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AccountInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AccountInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AccountInfo_UnserializedMessageContext<
            UserType, AccountInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AccountInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AccountInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AccountInfo_UnserializedMessageContext<
            UserType, AccountInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AccountInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL account_image_src;
  
  std::string name;
  
  std::string email;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AccountInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AccountInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AccountInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AccountInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
QueryStatePtr QueryState::Clone() const {
  return New(
      mojo::Clone(incremental),
      mojo::Clone(querying),
      mojo::Clone(search_term),
      mojo::Clone(after)
  );
}

template <typename T, QueryState::EnableIfSame<T>*>
bool QueryState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->incremental, other_struct.incremental))
    return false;
  if (!mojo::Equals(this->querying, other_struct.querying))
    return false;
  if (!mojo::Equals(this->search_term, other_struct.search_term))
    return false;
  if (!mojo::Equals(this->after, other_struct.after))
    return false;
  return true;
}

template <typename T, QueryState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.incremental < rhs.incremental)
    return true;
  if (rhs.incremental < lhs.incremental)
    return false;
  if (lhs.querying < rhs.querying)
    return true;
  if (rhs.querying < lhs.querying)
    return false;
  if (lhs.search_term < rhs.search_term)
    return true;
  if (rhs.search_term < lhs.search_term)
    return false;
  if (lhs.after < rhs.after)
    return true;
  if (rhs.after < lhs.after)
    return false;
  return false;
}
template <typename StructPtrType>
HistoryQueryPtr HistoryQuery::Clone() const {
  return New(
      mojo::Clone(term),
      mojo::Clone(finished)
  );
}

template <typename T, HistoryQuery::EnableIfSame<T>*>
bool HistoryQuery::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->term, other_struct.term))
    return false;
  if (!mojo::Equals(this->finished, other_struct.finished))
    return false;
  return true;
}

template <typename T, HistoryQuery::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.term < rhs.term)
    return true;
  if (rhs.term < lhs.term)
    return false;
  if (lhs.finished < rhs.finished)
    return true;
  if (rhs.finished < lhs.finished)
    return false;
  return false;
}
template <typename StructPtrType>
DebugInfoPtr DebugInfo::Clone() const {
  return New(
      mojo::Clone(is_url_in_local_database),
      mojo::Clone(visit_count),
      mojo::Clone(typed_count)
  );
}

template <typename T, DebugInfo::EnableIfSame<T>*>
bool DebugInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_url_in_local_database, other_struct.is_url_in_local_database))
    return false;
  if (!mojo::Equals(this->visit_count, other_struct.visit_count))
    return false;
  if (!mojo::Equals(this->typed_count, other_struct.typed_count))
    return false;
  return true;
}

template <typename T, DebugInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_url_in_local_database < rhs.is_url_in_local_database)
    return true;
  if (rhs.is_url_in_local_database < lhs.is_url_in_local_database)
    return false;
  if (lhs.visit_count < rhs.visit_count)
    return true;
  if (rhs.visit_count < lhs.visit_count)
    return false;
  if (lhs.typed_count < rhs.typed_count)
    return true;
  if (rhs.typed_count < lhs.typed_count)
    return false;
  return false;
}
template <typename StructPtrType>
HistoryEntryPtr HistoryEntry::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(title),
      mojo::Clone(domain),
      mojo::Clone(fallback_favicon_text),
      mojo::Clone(time),
      mojo::Clone(all_timestamps),
      mojo::Clone(date_short),
      mojo::Clone(device_name),
      mojo::Clone(device_type),
      mojo::Clone(date_time_of_day),
      mojo::Clone(date_relative_day),
      mojo::Clone(selected),
      mojo::Clone(readableTimestamp),
      mojo::Clone(snippet),
      mojo::Clone(starred),
      mojo::Clone(host_filtering_behavior),
      mojo::Clone(blocked_visit),
      mojo::Clone(is_url_in_remote_user_data),
      mojo::Clone(is_actor_visit),
      mojo::Clone(remote_icon_url_for_uma),
      mojo::Clone(debug)
  );
}

template <typename T, HistoryEntry::EnableIfSame<T>*>
bool HistoryEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->domain, other_struct.domain))
    return false;
  if (!mojo::Equals(this->fallback_favicon_text, other_struct.fallback_favicon_text))
    return false;
  if (!mojo::Equals(this->time, other_struct.time))
    return false;
  if (!mojo::Equals(this->all_timestamps, other_struct.all_timestamps))
    return false;
  if (!mojo::Equals(this->date_short, other_struct.date_short))
    return false;
  if (!mojo::Equals(this->device_name, other_struct.device_name))
    return false;
  if (!mojo::Equals(this->device_type, other_struct.device_type))
    return false;
  if (!mojo::Equals(this->date_time_of_day, other_struct.date_time_of_day))
    return false;
  if (!mojo::Equals(this->date_relative_day, other_struct.date_relative_day))
    return false;
  if (!mojo::Equals(this->selected, other_struct.selected))
    return false;
  if (!mojo::Equals(this->readableTimestamp, other_struct.readableTimestamp))
    return false;
  if (!mojo::Equals(this->snippet, other_struct.snippet))
    return false;
  if (!mojo::Equals(this->starred, other_struct.starred))
    return false;
  if (!mojo::Equals(this->host_filtering_behavior, other_struct.host_filtering_behavior))
    return false;
  if (!mojo::Equals(this->blocked_visit, other_struct.blocked_visit))
    return false;
  if (!mojo::Equals(this->is_url_in_remote_user_data, other_struct.is_url_in_remote_user_data))
    return false;
  if (!mojo::Equals(this->is_actor_visit, other_struct.is_actor_visit))
    return false;
  if (!mojo::Equals(this->remote_icon_url_for_uma, other_struct.remote_icon_url_for_uma))
    return false;
  if (!mojo::Equals(this->debug, other_struct.debug))
    return false;
  return true;
}

template <typename T, HistoryEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.domain < rhs.domain)
    return true;
  if (rhs.domain < lhs.domain)
    return false;
  if (lhs.fallback_favicon_text < rhs.fallback_favicon_text)
    return true;
  if (rhs.fallback_favicon_text < lhs.fallback_favicon_text)
    return false;
  if (lhs.time < rhs.time)
    return true;
  if (rhs.time < lhs.time)
    return false;
  if (lhs.all_timestamps < rhs.all_timestamps)
    return true;
  if (rhs.all_timestamps < lhs.all_timestamps)
    return false;
  if (lhs.date_short < rhs.date_short)
    return true;
  if (rhs.date_short < lhs.date_short)
    return false;
  if (lhs.device_name < rhs.device_name)
    return true;
  if (rhs.device_name < lhs.device_name)
    return false;
  if (lhs.device_type < rhs.device_type)
    return true;
  if (rhs.device_type < lhs.device_type)
    return false;
  if (lhs.date_time_of_day < rhs.date_time_of_day)
    return true;
  if (rhs.date_time_of_day < lhs.date_time_of_day)
    return false;
  if (lhs.date_relative_day < rhs.date_relative_day)
    return true;
  if (rhs.date_relative_day < lhs.date_relative_day)
    return false;
  if (lhs.selected < rhs.selected)
    return true;
  if (rhs.selected < lhs.selected)
    return false;
  if (lhs.readableTimestamp < rhs.readableTimestamp)
    return true;
  if (rhs.readableTimestamp < lhs.readableTimestamp)
    return false;
  if (lhs.snippet < rhs.snippet)
    return true;
  if (rhs.snippet < lhs.snippet)
    return false;
  if (lhs.starred < rhs.starred)
    return true;
  if (rhs.starred < lhs.starred)
    return false;
  if (lhs.host_filtering_behavior < rhs.host_filtering_behavior)
    return true;
  if (rhs.host_filtering_behavior < lhs.host_filtering_behavior)
    return false;
  if (lhs.blocked_visit < rhs.blocked_visit)
    return true;
  if (rhs.blocked_visit < lhs.blocked_visit)
    return false;
  if (lhs.is_url_in_remote_user_data < rhs.is_url_in_remote_user_data)
    return true;
  if (rhs.is_url_in_remote_user_data < lhs.is_url_in_remote_user_data)
    return false;
  if (lhs.is_actor_visit < rhs.is_actor_visit)
    return true;
  if (rhs.is_actor_visit < lhs.is_actor_visit)
    return false;
  if (lhs.remote_icon_url_for_uma < rhs.remote_icon_url_for_uma)
    return true;
  if (rhs.remote_icon_url_for_uma < lhs.remote_icon_url_for_uma)
    return false;
  if (lhs.debug < rhs.debug)
    return true;
  if (rhs.debug < lhs.debug)
    return false;
  return false;
}
template <typename StructPtrType>
QueryResultPtr QueryResult::Clone() const {
  return New(
      mojo::Clone(info),
      mojo::Clone(value)
  );
}

template <typename T, QueryResult::EnableIfSame<T>*>
bool QueryResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->info, other_struct.info))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, QueryResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.info < rhs.info)
    return true;
  if (rhs.info < lhs.info)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
RemovalItemPtr RemovalItem::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(timestamps)
  );
}

template <typename T, RemovalItem::EnableIfSame<T>*>
bool RemovalItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->timestamps, other_struct.timestamps))
    return false;
  return true;
}

template <typename T, RemovalItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.timestamps < rhs.timestamps)
    return true;
  if (rhs.timestamps < lhs.timestamps)
    return false;
  return false;
}
template <typename StructPtrType>
AccountInfoPtr AccountInfo::Clone() const {
  return New(
      mojo::Clone(account_image_src),
      mojo::Clone(name),
      mojo::Clone(email)
  );
}

template <typename T, AccountInfo::EnableIfSame<T>*>
bool AccountInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->account_image_src, other_struct.account_image_src))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->email, other_struct.email))
    return false;
  return true;
}

template <typename T, AccountInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.account_image_src < rhs.account_image_src)
    return true;
  if (rhs.account_image_src < lhs.account_image_src)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.email < rhs.email)
    return true;
  if (rhs.email < lhs.email)
    return false;
  return false;
}


}  // history::mojom

namespace mojo {


template <>
struct  StructTraits<::history::mojom::QueryState::DataView,
                                         ::history::mojom::QueryStatePtr> {
  static bool IsNull(const ::history::mojom::QueryStatePtr& input) { return !input; }
  static void SetToNull(::history::mojom::QueryStatePtr* output) { output->reset(); }

  static decltype(::history::mojom::QueryState::incremental) incremental(
      const ::history::mojom::QueryStatePtr& input) {
    return input->incremental;
  }

  static decltype(::history::mojom::QueryState::querying) querying(
      const ::history::mojom::QueryStatePtr& input) {
    return input->querying;
  }

  static const decltype(::history::mojom::QueryState::search_term)& search_term(
      const ::history::mojom::QueryStatePtr& input) {
    return input->search_term;
  }

  static const decltype(::history::mojom::QueryState::after)& after(
      const ::history::mojom::QueryStatePtr& input) {
    return input->after;
  }

  static bool Read(::history::mojom::QueryState::DataView input, ::history::mojom::QueryStatePtr* output);
};


template <>
struct  StructTraits<::history::mojom::HistoryQuery::DataView,
                                         ::history::mojom::HistoryQueryPtr> {
  static bool IsNull(const ::history::mojom::HistoryQueryPtr& input) { return !input; }
  static void SetToNull(::history::mojom::HistoryQueryPtr* output) { output->reset(); }

  static const decltype(::history::mojom::HistoryQuery::term)& term(
      const ::history::mojom::HistoryQueryPtr& input) {
    return input->term;
  }

  static decltype(::history::mojom::HistoryQuery::finished) finished(
      const ::history::mojom::HistoryQueryPtr& input) {
    return input->finished;
  }

  static bool Read(::history::mojom::HistoryQuery::DataView input, ::history::mojom::HistoryQueryPtr* output);
};


template <>
struct  StructTraits<::history::mojom::DebugInfo::DataView,
                                         ::history::mojom::DebugInfoPtr> {
  static bool IsNull(const ::history::mojom::DebugInfoPtr& input) { return !input; }
  static void SetToNull(::history::mojom::DebugInfoPtr* output) { output->reset(); }

  static decltype(::history::mojom::DebugInfo::is_url_in_local_database) is_url_in_local_database(
      const ::history::mojom::DebugInfoPtr& input) {
    return input->is_url_in_local_database;
  }

  static decltype(::history::mojom::DebugInfo::visit_count) visit_count(
      const ::history::mojom::DebugInfoPtr& input) {
    return input->visit_count;
  }

  static decltype(::history::mojom::DebugInfo::typed_count) typed_count(
      const ::history::mojom::DebugInfoPtr& input) {
    return input->typed_count;
  }

  static bool Read(::history::mojom::DebugInfo::DataView input, ::history::mojom::DebugInfoPtr* output);
};


template <>
struct  StructTraits<::history::mojom::HistoryEntry::DataView,
                                         ::history::mojom::HistoryEntryPtr> {
  static bool IsNull(const ::history::mojom::HistoryEntryPtr& input) { return !input; }
  static void SetToNull(::history::mojom::HistoryEntryPtr* output) { output->reset(); }

  static const decltype(::history::mojom::HistoryEntry::url)& url(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->url;
  }

  static const decltype(::history::mojom::HistoryEntry::title)& title(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->title;
  }

  static const decltype(::history::mojom::HistoryEntry::domain)& domain(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->domain;
  }

  static const decltype(::history::mojom::HistoryEntry::fallback_favicon_text)& fallback_favicon_text(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->fallback_favicon_text;
  }

  static decltype(::history::mojom::HistoryEntry::time) time(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->time;
  }

  static const decltype(::history::mojom::HistoryEntry::all_timestamps)& all_timestamps(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->all_timestamps;
  }

  static const decltype(::history::mojom::HistoryEntry::date_short)& date_short(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->date_short;
  }

  static const decltype(::history::mojom::HistoryEntry::device_name)& device_name(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->device_name;
  }

  static const decltype(::history::mojom::HistoryEntry::device_type)& device_type(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->device_type;
  }

  static const decltype(::history::mojom::HistoryEntry::date_time_of_day)& date_time_of_day(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->date_time_of_day;
  }

  static const decltype(::history::mojom::HistoryEntry::date_relative_day)& date_relative_day(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->date_relative_day;
  }

  static decltype(::history::mojom::HistoryEntry::selected) selected(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->selected;
  }

  static const decltype(::history::mojom::HistoryEntry::readableTimestamp)& readableTimestamp(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->readableTimestamp;
  }

  static const decltype(::history::mojom::HistoryEntry::snippet)& snippet(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->snippet;
  }

  static decltype(::history::mojom::HistoryEntry::starred) starred(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->starred;
  }

  static decltype(::history::mojom::HistoryEntry::host_filtering_behavior) host_filtering_behavior(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->host_filtering_behavior;
  }

  static decltype(::history::mojom::HistoryEntry::blocked_visit) blocked_visit(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->blocked_visit;
  }

  static decltype(::history::mojom::HistoryEntry::is_url_in_remote_user_data) is_url_in_remote_user_data(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->is_url_in_remote_user_data;
  }

  static decltype(::history::mojom::HistoryEntry::is_actor_visit) is_actor_visit(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->is_actor_visit;
  }

  static const decltype(::history::mojom::HistoryEntry::remote_icon_url_for_uma)& remote_icon_url_for_uma(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->remote_icon_url_for_uma;
  }

  static const decltype(::history::mojom::HistoryEntry::debug)& debug(
      const ::history::mojom::HistoryEntryPtr& input) {
    return input->debug;
  }

  static bool Read(::history::mojom::HistoryEntry::DataView input, ::history::mojom::HistoryEntryPtr* output);
};


template <>
struct  StructTraits<::history::mojom::QueryResult::DataView,
                                         ::history::mojom::QueryResultPtr> {
  static bool IsNull(const ::history::mojom::QueryResultPtr& input) { return !input; }
  static void SetToNull(::history::mojom::QueryResultPtr* output) { output->reset(); }

  static const decltype(::history::mojom::QueryResult::info)& info(
      const ::history::mojom::QueryResultPtr& input) {
    return input->info;
  }

  static const decltype(::history::mojom::QueryResult::value)& value(
      const ::history::mojom::QueryResultPtr& input) {
    return input->value;
  }

  static bool Read(::history::mojom::QueryResult::DataView input, ::history::mojom::QueryResultPtr* output);
};


template <>
struct  StructTraits<::history::mojom::RemovalItem::DataView,
                                         ::history::mojom::RemovalItemPtr> {
  static bool IsNull(const ::history::mojom::RemovalItemPtr& input) { return !input; }
  static void SetToNull(::history::mojom::RemovalItemPtr* output) { output->reset(); }

  static const decltype(::history::mojom::RemovalItem::url)& url(
      const ::history::mojom::RemovalItemPtr& input) {
    return input->url;
  }

  static const decltype(::history::mojom::RemovalItem::timestamps)& timestamps(
      const ::history::mojom::RemovalItemPtr& input) {
    return input->timestamps;
  }

  static bool Read(::history::mojom::RemovalItem::DataView input, ::history::mojom::RemovalItemPtr* output);
};


template <>
struct  StructTraits<::history::mojom::AccountInfo::DataView,
                                         ::history::mojom::AccountInfoPtr> {
  static bool IsNull(const ::history::mojom::AccountInfoPtr& input) { return !input; }
  static void SetToNull(::history::mojom::AccountInfoPtr* output) { output->reset(); }

  static const decltype(::history::mojom::AccountInfo::account_image_src)& account_image_src(
      const ::history::mojom::AccountInfoPtr& input) {
    return input->account_image_src;
  }

  static const decltype(::history::mojom::AccountInfo::name)& name(
      const ::history::mojom::AccountInfoPtr& input) {
    return input->name;
  }

  static const decltype(::history::mojom::AccountInfo::email)& email(
      const ::history::mojom::AccountInfoPtr& input) {
    return input->email;
  }

  static bool Read(::history::mojom::AccountInfo::DataView input, ::history::mojom::AccountInfoPtr* output);
};

}  // namespace mojo

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_HISTORY_MOJOM_H_