// ui/webui/resources/cr_components/app_management/app_management.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/webui/resources/cr_components/app_management/app_management.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/webui/resources/cr_components/app_management/app_management.mojom-params-data.h"
#include "ui/webui/resources/cr_components/app_management/app_management.mojom-shared-message-ids.h"

#include "ui/webui/resources/cr_components/app_management/app_management.mojom-import-headers.h"
#include "ui/webui/resources/cr_components/app_management/app_management.mojom-test-utils.h"


namespace app_management::mojom {
Permission::Permission()
    : permission_type(),
      value(),
      is_managed(),
      details() {}

Permission::Permission(
    ::apps::PermissionType permission_type_in,
    PermissionValuePtr value_in,
    bool is_managed_in,
    const std::optional<std::string>& details_in)
    : permission_type(std::move(permission_type_in)),
      value(std::move(value_in)),
      is_managed(std::move(is_managed_in)),
      details(std::move(details_in)) {}

Permission::~Permission() = default;

void Permission::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permission_type"), this->permission_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::apps::PermissionType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PermissionValuePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_managed"), this->is_managed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "details"), this->details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Permission::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RunOnOsLogin::RunOnOsLogin()
    : login_mode(),
      is_managed() {}

RunOnOsLogin::RunOnOsLogin(
    ::apps::RunOnOsLoginMode login_mode_in,
    bool is_managed_in)
    : login_mode(std::move(login_mode_in)),
      is_managed(std::move(is_managed_in)) {}

RunOnOsLogin::~RunOnOsLogin() = default;

void RunOnOsLogin::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "login_mode"), this->login_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::apps::RunOnOsLoginMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_managed"), this->is_managed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RunOnOsLogin::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Locale::Locale()
    : locale_tag(),
      display_name(),
      native_display_name() {}

Locale::Locale(
    const std::string& locale_tag_in,
    const std::string& display_name_in,
    const std::string& native_display_name_in)
    : locale_tag(std::move(locale_tag_in)),
      display_name(std::move(display_name_in)),
      native_display_name(std::move(native_display_name_in)) {}

Locale::~Locale() = default;
size_t Locale::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->locale_tag);
  seed = mojo::internal::Hash(seed, this->display_name);
  seed = mojo::internal::Hash(seed, this->native_display_name);
  return seed;
}

void Locale::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "locale_tag"), this->locale_tag,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "native_display_name"), this->native_display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Locale::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
App::App()
    : id(),
      type(),
      title(),
      description(),
      is_pinned(),
      is_policy_pinned(),
      version(),
      size(),
      permissions(),
      install_reason(),
      install_source(),
      hide_more_settings(),
      hide_pin_to_shelf(),
      is_preferred_app(),
      window_mode(),
      hide_window_mode(),
      resize_locked(),
      hide_resize_locked(),
      supported_links(),
      run_on_os_login(),
      file_handling_state(),
      app_size(),
      data_size(),
      publisher_id(),
      formatted_origin(),
      scope_extensions(),
      supported_locales(),
      selected_locale(),
      show_system_notifications_settings_link(),
      allow_uninstall(),
      disable_user_choice_navigation_capturing() {}

App::App(
    const std::string& id_in,
    ::apps::AppType type_in,
    const std::optional<std::string>& title_in,
    const std::optional<std::string>& description_in,
    std::optional<bool> is_pinned_in,
    std::optional<bool> is_policy_pinned_in,
    const std::optional<std::string>& version_in,
    const std::optional<std::string>& size_in,
    base::flat_map<::apps::PermissionType, ::apps::PermissionPtr> permissions_in,
    ::apps::InstallReason install_reason_in,
    ::apps::InstallSource install_source_in,
    bool hide_more_settings_in,
    bool hide_pin_to_shelf_in,
    bool is_preferred_app_in,
    ::apps::WindowMode window_mode_in,
    bool hide_window_mode_in,
    bool resize_locked_in,
    bool hide_resize_locked_in,
    std::vector<std::string> supported_links_in,
    std::optional<::apps::RunOnOsLoginPtr> run_on_os_login_in,
    FileHandlingStatePtr file_handling_state_in,
    const std::optional<std::string>& app_size_in,
    const std::optional<std::string>& data_size_in,
    const std::string& publisher_id_in,
    const std::optional<std::string>& formatted_origin_in,
    std::vector<std::string> scope_extensions_in,
    std::vector<LocalePtr> supported_locales_in,
    LocalePtr selected_locale_in,
    bool show_system_notifications_settings_link_in,
    bool allow_uninstall_in,
    bool disable_user_choice_navigation_capturing_in)
    : id(std::move(id_in)),
      type(std::move(type_in)),
      title(std::move(title_in)),
      description(std::move(description_in)),
      is_pinned(std::move(is_pinned_in)),
      is_policy_pinned(std::move(is_policy_pinned_in)),
      version(std::move(version_in)),
      size(std::move(size_in)),
      permissions(std::move(permissions_in)),
      install_reason(std::move(install_reason_in)),
      install_source(std::move(install_source_in)),
      hide_more_settings(std::move(hide_more_settings_in)),
      hide_pin_to_shelf(std::move(hide_pin_to_shelf_in)),
      is_preferred_app(std::move(is_preferred_app_in)),
      window_mode(std::move(window_mode_in)),
      hide_window_mode(std::move(hide_window_mode_in)),
      resize_locked(std::move(resize_locked_in)),
      hide_resize_locked(std::move(hide_resize_locked_in)),
      supported_links(std::move(supported_links_in)),
      run_on_os_login(std::move(run_on_os_login_in)),
      file_handling_state(std::move(file_handling_state_in)),
      app_size(std::move(app_size_in)),
      data_size(std::move(data_size_in)),
      publisher_id(std::move(publisher_id_in)),
      formatted_origin(std::move(formatted_origin_in)),
      scope_extensions(std::move(scope_extensions_in)),
      supported_locales(std::move(supported_locales_in)),
      selected_locale(std::move(selected_locale_in)),
      show_system_notifications_settings_link(std::move(show_system_notifications_settings_link_in)),
      allow_uninstall(std::move(allow_uninstall_in)),
      disable_user_choice_navigation_capturing(std::move(disable_user_choice_navigation_capturing_in)) {}

App::~App() = default;

void App::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::apps::AppType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_pinned"), this->is_pinned,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_policy_pinned"), this->is_policy_pinned,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permissions"), this->permissions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<::apps::PermissionType, ::apps::PermissionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "install_reason"), this->install_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::apps::InstallReason>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "install_source"), this->install_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::apps::InstallSource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hide_more_settings"), this->hide_more_settings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hide_pin_to_shelf"), this->hide_pin_to_shelf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_preferred_app"), this->is_preferred_app,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_mode"), this->window_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::apps::WindowMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hide_window_mode"), this->hide_window_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resize_locked"), this->resize_locked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hide_resize_locked"), this->hide_resize_locked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_links"), this->supported_links,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "run_on_os_login"), this->run_on_os_login,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::apps::RunOnOsLoginPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_handling_state"), this->file_handling_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FileHandlingStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_size"), this->app_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_size"), this->data_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "publisher_id"), this->publisher_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "formatted_origin"), this->formatted_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope_extensions"), this->scope_extensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_locales"), this->supported_locales,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<LocalePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_locale"), this->selected_locale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LocalePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_system_notifications_settings_link"), this->show_system_notifications_settings_link,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_uninstall"), this->allow_uninstall,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_user_choice_navigation_capturing"), this->disable_user_choice_navigation_capturing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool App::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ExtensionAppPermissionMessage::ExtensionAppPermissionMessage()
    : message(),
      submessages() {}

ExtensionAppPermissionMessage::ExtensionAppPermissionMessage(
    const std::string& message_in,
    std::vector<std::string> submessages_in)
    : message(std::move(message_in)),
      submessages(std::move(submessages_in)) {}

ExtensionAppPermissionMessage::~ExtensionAppPermissionMessage() = default;

void ExtensionAppPermissionMessage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "submessages"), this->submessages,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExtensionAppPermissionMessage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileHandlingState::FileHandlingState()
    : enabled(),
      is_managed(),
      user_visible_types(),
      user_visible_types_label(),
      learn_more_url() {}

FileHandlingState::FileHandlingState(
    bool enabled_in,
    bool is_managed_in,
    const std::string& user_visible_types_in,
    const std::string& user_visible_types_label_in,
    const std::optional<::GURL>& learn_more_url_in)
    : enabled(std::move(enabled_in)),
      is_managed(std::move(is_managed_in)),
      user_visible_types(std::move(user_visible_types_in)),
      user_visible_types_label(std::move(user_visible_types_label_in)),
      learn_more_url(std::move(learn_more_url_in)) {}

FileHandlingState::~FileHandlingState() = default;

void FileHandlingState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enabled"), this->enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_managed"), this->is_managed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_visible_types"), this->user_visible_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_visible_types_label"), this->user_visible_types_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "learn_more_url"), this->learn_more_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileHandlingState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PermissionValuePtr
PermissionValue::NewBoolValue(
    bool value) {
  return PermissionValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBoolValue)>,
      std::move(value));
}

PermissionValuePtr
PermissionValue::NewTristateValue(
    TriState value) {
  return PermissionValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTristateValue)>,
      std::move(value));
}

PermissionValue::PermissionValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kBoolValue)>,
    bool value)
    : tag_(Tag::kBoolValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBoolValue)>,
            std::move(value)) {}

PermissionValue::PermissionValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kTristateValue)>,
    TriState value)
    : tag_(Tag::kTristateValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTristateValue)>,
            std::move(value)) {}
PermissionValue::~PermissionValue() {
  DestroyActive();
}

void PermissionValue::set_bool_value(bool bool_value) {
  if (tag_ != Tag::kBoolValue) {
    DestroyActive();
    tag_ = Tag::kBoolValue;
  }
  data_.bool_value = bool_value;
}

void PermissionValue::set_tristate_value(TriState tristate_value) {
  if (tag_ != Tag::kTristateValue) {
    DestroyActive();
    tag_ = Tag::kTristateValue;
  }
  data_.tristate_value = tristate_value;
}


PermissionValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBoolValue)>,
    bool value)
    : bool_value(std::move(value)) {}

PermissionValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTristateValue)>,
    TriState value)
    : tristate_value(std::move(value)) {}

void PermissionValue::DestroyActive() {
  switch (tag_) {

    case Tag::kBoolValue:
      std::destroy_at(&data_.bool_value);
      break;
    case Tag::kTristateValue:
      std::destroy_at(&data_.tristate_value);
      break;
  }
}
size_t PermissionValue::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kBoolValue:
      return mojo::internal::Hash(seed, data_.bool_value);
    case Tag::kTristateValue:
      return mojo::internal::Hash(seed, data_.tristate_value);
    default:
      NOTREACHED();
  }
}

bool PermissionValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive app_management::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply app_management::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc44aea8c;  // IPCStableHash for app_management::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::app_management::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::app_management::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::app_management::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetApps: {
      return &PageHandler::GetApps_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetApp: {
      return &PageHandler::GetApp_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetSubAppToParentMap: {
      return &PageHandler::GetSubAppToParentMap_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetExtensionAppPermissionMessages: {
      return &PageHandler::GetExtensionAppPermissionMessages_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetPinned: {
      return &PageHandler::SetPinned_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetPermission: {
      return &PageHandler::SetPermission_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetResizeLocked: {
      return &PageHandler::SetResizeLocked_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUninstall: {
      return &PageHandler::Uninstall_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenNativeSettings: {
      return &PageHandler::OpenNativeSettings_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetPreferredApp: {
      return &PageHandler::SetPreferredApp_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetOverlappingPreferredApps: {
      return &PageHandler::GetOverlappingPreferredApps_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUpdateAppSize: {
      return &PageHandler::UpdateAppSize_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetWindowMode: {
      return &PageHandler::SetWindowMode_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetRunOnOsLoginMode: {
      return &PageHandler::SetRunOnOsLoginMode_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetFileHandlingEnabled: {
      return &PageHandler::SetFileHandlingEnabled_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowDefaultAppAssociationsUi: {
      return &PageHandler::ShowDefaultAppAssociationsUi_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenStorePage: {
      return &PageHandler::OpenStorePage_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetAppLocale: {
      return &PageHandler::SetAppLocale_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenSystemNotificationSettings: {
      return &PageHandler::OpenSystemNotificationSettings_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetApps:
            return "Receive app_management::mojom::PageHandler::GetApps";
      case messages::PageHandler::kGetApp:
            return "Receive app_management::mojom::PageHandler::GetApp";
      case messages::PageHandler::kGetSubAppToParentMap:
            return "Receive app_management::mojom::PageHandler::GetSubAppToParentMap";
      case messages::PageHandler::kGetExtensionAppPermissionMessages:
            return "Receive app_management::mojom::PageHandler::GetExtensionAppPermissionMessages";
      case messages::PageHandler::kSetPinned:
            return "Receive app_management::mojom::PageHandler::SetPinned";
      case messages::PageHandler::kSetPermission:
            return "Receive app_management::mojom::PageHandler::SetPermission";
      case messages::PageHandler::kSetResizeLocked:
            return "Receive app_management::mojom::PageHandler::SetResizeLocked";
      case messages::PageHandler::kUninstall:
            return "Receive app_management::mojom::PageHandler::Uninstall";
      case messages::PageHandler::kOpenNativeSettings:
            return "Receive app_management::mojom::PageHandler::OpenNativeSettings";
      case messages::PageHandler::kSetPreferredApp:
            return "Receive app_management::mojom::PageHandler::SetPreferredApp";
      case messages::PageHandler::kGetOverlappingPreferredApps:
            return "Receive app_management::mojom::PageHandler::GetOverlappingPreferredApps";
      case messages::PageHandler::kUpdateAppSize:
            return "Receive app_management::mojom::PageHandler::UpdateAppSize";
      case messages::PageHandler::kSetWindowMode:
            return "Receive app_management::mojom::PageHandler::SetWindowMode";
      case messages::PageHandler::kSetRunOnOsLoginMode:
            return "Receive app_management::mojom::PageHandler::SetRunOnOsLoginMode";
      case messages::PageHandler::kSetFileHandlingEnabled:
            return "Receive app_management::mojom::PageHandler::SetFileHandlingEnabled";
      case messages::PageHandler::kShowDefaultAppAssociationsUi:
            return "Receive app_management::mojom::PageHandler::ShowDefaultAppAssociationsUi";
      case messages::PageHandler::kOpenStorePage:
            return "Receive app_management::mojom::PageHandler::OpenStorePage";
      case messages::PageHandler::kSetAppLocale:
            return "Receive app_management::mojom::PageHandler::SetAppLocale";
      case messages::PageHandler::kOpenSystemNotificationSettings:
            return "Receive app_management::mojom::PageHandler::OpenSystemNotificationSettings";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetApps:
            return "Receive reply app_management::mojom::PageHandler::GetApps";
      case messages::PageHandler::kGetApp:
            return "Receive reply app_management::mojom::PageHandler::GetApp";
      case messages::PageHandler::kGetSubAppToParentMap:
            return "Receive reply app_management::mojom::PageHandler::GetSubAppToParentMap";
      case messages::PageHandler::kGetExtensionAppPermissionMessages:
            return "Receive reply app_management::mojom::PageHandler::GetExtensionAppPermissionMessages";
      case messages::PageHandler::kSetPinned:
            return "Receive reply app_management::mojom::PageHandler::SetPinned";
      case messages::PageHandler::kSetPermission:
            return "Receive reply app_management::mojom::PageHandler::SetPermission";
      case messages::PageHandler::kSetResizeLocked:
            return "Receive reply app_management::mojom::PageHandler::SetResizeLocked";
      case messages::PageHandler::kUninstall:
            return "Receive reply app_management::mojom::PageHandler::Uninstall";
      case messages::PageHandler::kOpenNativeSettings:
            return "Receive reply app_management::mojom::PageHandler::OpenNativeSettings";
      case messages::PageHandler::kSetPreferredApp:
            return "Receive reply app_management::mojom::PageHandler::SetPreferredApp";
      case messages::PageHandler::kGetOverlappingPreferredApps:
            return "Receive reply app_management::mojom::PageHandler::GetOverlappingPreferredApps";
      case messages::PageHandler::kUpdateAppSize:
            return "Receive reply app_management::mojom::PageHandler::UpdateAppSize";
      case messages::PageHandler::kSetWindowMode:
            return "Receive reply app_management::mojom::PageHandler::SetWindowMode";
      case messages::PageHandler::kSetRunOnOsLoginMode:
            return "Receive reply app_management::mojom::PageHandler::SetRunOnOsLoginMode";
      case messages::PageHandler::kSetFileHandlingEnabled:
            return "Receive reply app_management::mojom::PageHandler::SetFileHandlingEnabled";
      case messages::PageHandler::kShowDefaultAppAssociationsUi:
            return "Receive reply app_management::mojom::PageHandler::ShowDefaultAppAssociationsUi";
      case messages::PageHandler::kOpenStorePage:
            return "Receive reply app_management::mojom::PageHandler::OpenStorePage";
      case messages::PageHandler::kSetAppLocale:
            return "Receive reply app_management::mojom::PageHandler::SetAppLocale";
      case messages::PageHandler::kOpenSystemNotificationSettings:
            return "Receive reply app_management::mojom::PageHandler::OpenSystemNotificationSettings";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetApps_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x24d39263;  // IPCStableHash for app_management::mojom::PageHandler::GetApps
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x75ef15f0;  // IPCStableHash for app_management::mojom::PageHandler::GetApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetSubAppToParentMap_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2978dd7f;  // IPCStableHash for app_management::mojom::PageHandler::GetSubAppToParentMap
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetExtensionAppPermissionMessages_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x122cea71;  // IPCStableHash for app_management::mojom::PageHandler::GetExtensionAppPermissionMessages
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetPinned_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x044353eb;  // IPCStableHash for app_management::mojom::PageHandler::SetPinned
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetPermission_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac030c21;  // IPCStableHash for app_management::mojom::PageHandler::SetPermission
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetResizeLocked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd940d2e5;  // IPCStableHash for app_management::mojom::PageHandler::SetResizeLocked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Uninstall_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbbd3ce0e;  // IPCStableHash for app_management::mojom::PageHandler::Uninstall
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenNativeSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa1083347;  // IPCStableHash for app_management::mojom::PageHandler::OpenNativeSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetPreferredApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9b695c75;  // IPCStableHash for app_management::mojom::PageHandler::SetPreferredApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetOverlappingPreferredApps_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3bc19ec4;  // IPCStableHash for app_management::mojom::PageHandler::GetOverlappingPreferredApps
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UpdateAppSize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2b14f07b;  // IPCStableHash for app_management::mojom::PageHandler::UpdateAppSize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetWindowMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3c3119f9;  // IPCStableHash for app_management::mojom::PageHandler::SetWindowMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetRunOnOsLoginMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9fad40c5;  // IPCStableHash for app_management::mojom::PageHandler::SetRunOnOsLoginMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetFileHandlingEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x03a66e96;  // IPCStableHash for app_management::mojom::PageHandler::SetFileHandlingEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowDefaultAppAssociationsUi_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0f9ac533;  // IPCStableHash for app_management::mojom::PageHandler::ShowDefaultAppAssociationsUi
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenStorePage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9565ef14;  // IPCStableHash for app_management::mojom::PageHandler::OpenStorePage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetAppLocale_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc567932b;  // IPCStableHash for app_management::mojom::PageHandler::SetAppLocale
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenSystemNotificationSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf3d30ec7;  // IPCStableHash for app_management::mojom::PageHandler::OpenSystemNotificationSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetApps_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetApps_ForwardToCallback(
      PageHandler::GetAppsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetApps_ForwardToCallback(const PageHandler_GetApps_ForwardToCallback&) = delete;
  PageHandler_GetApps_ForwardToCallback& operator=(const PageHandler_GetApps_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetAppsCallback callback_;
};

class PageHandler_GetApp_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetApp_ForwardToCallback(
      PageHandler::GetAppCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetApp_ForwardToCallback(const PageHandler_GetApp_ForwardToCallback&) = delete;
  PageHandler_GetApp_ForwardToCallback& operator=(const PageHandler_GetApp_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetAppCallback callback_;
};

class PageHandler_GetSubAppToParentMap_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetSubAppToParentMap_ForwardToCallback(
      PageHandler::GetSubAppToParentMapCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetSubAppToParentMap_ForwardToCallback(const PageHandler_GetSubAppToParentMap_ForwardToCallback&) = delete;
  PageHandler_GetSubAppToParentMap_ForwardToCallback& operator=(const PageHandler_GetSubAppToParentMap_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetSubAppToParentMapCallback callback_;
};

class PageHandler_GetExtensionAppPermissionMessages_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetExtensionAppPermissionMessages_ForwardToCallback(
      PageHandler::GetExtensionAppPermissionMessagesCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetExtensionAppPermissionMessages_ForwardToCallback(const PageHandler_GetExtensionAppPermissionMessages_ForwardToCallback&) = delete;
  PageHandler_GetExtensionAppPermissionMessages_ForwardToCallback& operator=(const PageHandler_GetExtensionAppPermissionMessages_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetExtensionAppPermissionMessagesCallback callback_;
};

class PageHandler_GetOverlappingPreferredApps_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetOverlappingPreferredApps_ForwardToCallback(
      PageHandler::GetOverlappingPreferredAppsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetOverlappingPreferredApps_ForwardToCallback(const PageHandler_GetOverlappingPreferredApps_ForwardToCallback&) = delete;
  PageHandler_GetOverlappingPreferredApps_ForwardToCallback& operator=(const PageHandler_GetOverlappingPreferredApps_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetOverlappingPreferredAppsCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetApps(
    GetAppsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send app_management::mojom::PageHandler::GetApps");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetApps), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_GetApps_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetApps");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetApps_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetApp(
    const std::string& in_app_id, GetAppCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::GetApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_GetApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.GetApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetApp");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetApp_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetSubAppToParentMap(
    GetSubAppToParentMapCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send app_management::mojom::PageHandler::GetSubAppToParentMap");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetSubAppToParentMap), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_GetSubAppToParentMap_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetSubAppToParentMap");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetSubAppToParentMap_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetExtensionAppPermissionMessages(
    const std::string& in_app_id, GetExtensionAppPermissionMessagesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::GetExtensionAppPermissionMessages", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetExtensionAppPermissionMessages), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_GetExtensionAppPermissionMessages_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.GetExtensionAppPermissionMessages request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetExtensionAppPermissionMessages");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetExtensionAppPermissionMessages_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SetPinned(
    const std::string& in_app_id, bool in_pinned) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::SetPinned", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pinned"), in_pinned,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetPinned), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_SetPinned_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.SetPinned request");

  params->pinned = in_pinned;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetPinned");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetPermission(
    const std::string& in_app_id, ::apps::PermissionPtr in_permission) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::SetPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permission"), in_permission,
                        "<value of type ::apps::PermissionPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_SetPermission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.SetPermission request");
  mojo::internal::MessageFragment<
      typename decltype(params->permission)::BaseType> permission_fragment(
          params.message());
  
  mojo::internal::Serialize<::app_management::mojom::PermissionDataView>(
    in_permission,
    permission_fragment);

  params->permission.Set(
      permission_fragment.is_null() ? nullptr : permission_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->permission.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null permission in PageHandler.SetPermission request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetPermission");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetResizeLocked(
    const std::string& in_app_id, bool in_locked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::SetResizeLocked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("locked"), in_locked,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetResizeLocked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_SetResizeLocked_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.SetResizeLocked request");

  params->locked = in_locked;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetResizeLocked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Uninstall(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::Uninstall", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUninstall), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_Uninstall_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.Uninstall request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Uninstall");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenNativeSettings(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::OpenNativeSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenNativeSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_OpenNativeSettings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.OpenNativeSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenNativeSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetPreferredApp(
    const std::string& in_app_id, bool in_is_preferred_app) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::SetPreferredApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_preferred_app"), in_is_preferred_app,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetPreferredApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_SetPreferredApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.SetPreferredApp request");

  params->is_preferred_app = in_is_preferred_app;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetPreferredApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::GetOverlappingPreferredApps(
    const std::string& in_app_id, GetOverlappingPreferredAppsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::GetOverlappingPreferredApps", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetOverlappingPreferredApps), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_GetOverlappingPreferredApps_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.GetOverlappingPreferredApps request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetOverlappingPreferredApps");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetOverlappingPreferredApps_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::UpdateAppSize(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::UpdateAppSize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUpdateAppSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_UpdateAppSize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.UpdateAppSize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UpdateAppSize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetWindowMode(
    const std::string& in_app_id, ::apps::WindowMode in_window_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::SetWindowMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_mode"), in_window_mode,
                        "<value of type ::apps::WindowMode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetWindowMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_SetWindowMode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.SetWindowMode request");

  
  mojo::internal::Serialize<::app_management::mojom::WindowMode>(
    in_window_mode,
    &params->window_mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetWindowMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetRunOnOsLoginMode(
    const std::string& in_app_id, ::apps::RunOnOsLoginMode in_run_on_os_login_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::SetRunOnOsLoginMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("run_on_os_login_mode"), in_run_on_os_login_mode,
                        "<value of type ::apps::RunOnOsLoginMode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetRunOnOsLoginMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_SetRunOnOsLoginMode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.SetRunOnOsLoginMode request");

  
  mojo::internal::Serialize<::app_management::mojom::RunOnOsLoginMode>(
    in_run_on_os_login_mode,
    &params->run_on_os_login_mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetRunOnOsLoginMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetFileHandlingEnabled(
    const std::string& in_app_id, bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::SetFileHandlingEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetFileHandlingEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_SetFileHandlingEnabled_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.SetFileHandlingEnabled request");

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetFileHandlingEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ShowDefaultAppAssociationsUi(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send app_management::mojom::PageHandler::ShowDefaultAppAssociationsUi");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowDefaultAppAssociationsUi), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_ShowDefaultAppAssociationsUi_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowDefaultAppAssociationsUi");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenStorePage(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::OpenStorePage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenStorePage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_OpenStorePage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.OpenStorePage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenStorePage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetAppLocale(
    const std::string& in_app_id, const std::string& in_locale_tag) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::SetAppLocale", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("locale_tag"), in_locale_tag,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetAppLocale), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_SetAppLocale_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.SetAppLocale request");
  mojo::internal::MessageFragment<
      typename decltype(params->locale_tag)::BaseType> locale_tag_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_locale_tag,
    locale_tag_fragment);

  params->locale_tag.Set(
      locale_tag_fragment.is_null() ? nullptr : locale_tag_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->locale_tag.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null locale_tag in PageHandler.SetAppLocale request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetAppLocale");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenSystemNotificationSettings(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::PageHandler::OpenSystemNotificationSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenSystemNotificationSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_OpenSystemNotificationSettings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in PageHandler.OpenSystemNotificationSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenSystemNotificationSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_GetApps_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetAppsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetApps_ProxyToResponder> proxy(
        new PageHandler_GetApps_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetApps_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetApps_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetApps_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetAppsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<AppPtr> in_apps);
};

bool PageHandler_GetApps_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetApps_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetApps_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  std::vector<AppPtr> p_apps{};
  PageHandler_GetApps_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadApps(&p_apps))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_apps));
  }
  return true;
}

void PageHandler_GetApps_ProxyToResponder::Run(
    std::vector<AppPtr> in_apps) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply app_management::mojom::PageHandler::GetApps", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("apps"), in_apps,
                        "<value of type std::vector<AppPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetApps), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_GetApps_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->apps)::BaseType>
      apps_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& apps_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::app_management::mojom::AppDataView>>(
    in_apps,
    apps_fragment,
    &apps_validate_params);

  params->apps.Set(
      apps_fragment.is_null() ? nullptr : apps_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->apps.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null apps in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetApps");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetApp_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetAppCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetApp_ProxyToResponder> proxy(
        new PageHandler_GetApp_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetApp_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetApp_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetApp_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetAppCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      AppPtr in_app);
};

bool PageHandler_GetApp_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetApp_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetApp_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  AppPtr p_app{};
  PageHandler_GetApp_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadApp(&p_app))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_app));
  }
  return true;
}

void PageHandler_GetApp_ProxyToResponder::Run(
    AppPtr in_app) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply app_management::mojom::PageHandler::GetApp", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app"), in_app,
                        "<value of type AppPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_GetApp_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app)::BaseType> app_fragment(
          params.message());
  
  mojo::internal::Serialize<::app_management::mojom::AppDataView>(
    in_app,
    app_fragment);

  params->app.Set(
      app_fragment.is_null() ? nullptr : app_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetApp");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetSubAppToParentMap_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetSubAppToParentMapCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetSubAppToParentMap_ProxyToResponder> proxy(
        new PageHandler_GetSubAppToParentMap_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetSubAppToParentMap_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetSubAppToParentMap_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetSubAppToParentMap_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetSubAppToParentMapCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::flat_map<std::string, std::string>& in_sub_app_to_parent_map);
};

bool PageHandler_GetSubAppToParentMap_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetSubAppToParentMap_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetSubAppToParentMap_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.2
  bool success = true;
  base::flat_map<std::string, std::string> p_sub_app_to_parent_map{};
  PageHandler_GetSubAppToParentMap_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSubAppToParentMap(&p_sub_app_to_parent_map))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_sub_app_to_parent_map));
  }
  return true;
}

void PageHandler_GetSubAppToParentMap_ProxyToResponder::Run(
    const base::flat_map<std::string, std::string>& in_sub_app_to_parent_map) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply app_management::mojom::PageHandler::GetSubAppToParentMap", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sub_app_to_parent_map"), in_sub_app_to_parent_map,
                        "<value of type const base::flat_map<std::string, std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetSubAppToParentMap), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_GetSubAppToParentMap_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sub_app_to_parent_map)::BaseType>
      sub_app_to_parent_map_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& sub_app_to_parent_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
    in_sub_app_to_parent_map,
    sub_app_to_parent_map_fragment,
    &sub_app_to_parent_map_validate_params);

  params->sub_app_to_parent_map.Set(
      sub_app_to_parent_map_fragment.is_null() ? nullptr : sub_app_to_parent_map_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sub_app_to_parent_map.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sub_app_to_parent_map in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetSubAppToParentMap");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetExtensionAppPermissionMessages_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetExtensionAppPermissionMessagesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetExtensionAppPermissionMessages_ProxyToResponder> proxy(
        new PageHandler_GetExtensionAppPermissionMessages_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetExtensionAppPermissionMessages_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetExtensionAppPermissionMessages_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetExtensionAppPermissionMessages_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetExtensionAppPermissionMessagesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ExtensionAppPermissionMessagePtr> in_messages);
};

bool PageHandler_GetExtensionAppPermissionMessages_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetExtensionAppPermissionMessages_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetExtensionAppPermissionMessages_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.3
  bool success = true;
  std::vector<ExtensionAppPermissionMessagePtr> p_messages{};
  PageHandler_GetExtensionAppPermissionMessages_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMessages(&p_messages))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_messages));
  }
  return true;
}

void PageHandler_GetExtensionAppPermissionMessages_ProxyToResponder::Run(
    std::vector<ExtensionAppPermissionMessagePtr> in_messages) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply app_management::mojom::PageHandler::GetExtensionAppPermissionMessages", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("messages"), in_messages,
                        "<value of type std::vector<ExtensionAppPermissionMessagePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetExtensionAppPermissionMessages), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_GetExtensionAppPermissionMessages_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->messages)::BaseType>
      messages_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& messages_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::app_management::mojom::ExtensionAppPermissionMessageDataView>>(
    in_messages,
    messages_fragment,
    &messages_validate_params);

  params->messages.Set(
      messages_fragment.is_null() ? nullptr : messages_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->messages.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null messages in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetExtensionAppPermissionMessages");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetOverlappingPreferredApps_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetOverlappingPreferredAppsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetOverlappingPreferredApps_ProxyToResponder> proxy(
        new PageHandler_GetOverlappingPreferredApps_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetOverlappingPreferredApps_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetOverlappingPreferredApps_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetOverlappingPreferredApps_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetOverlappingPreferredAppsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_app_ids);
};

bool PageHandler_GetOverlappingPreferredApps_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetOverlappingPreferredApps_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetOverlappingPreferredApps_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.10
  bool success = true;
  std::vector<std::string> p_app_ids{};
  PageHandler_GetOverlappingPreferredApps_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAppIds(&p_app_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_app_ids));
  }
  return true;
}

void PageHandler_GetOverlappingPreferredApps_ProxyToResponder::Run(
    const std::vector<std::string>& in_app_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply app_management::mojom::PageHandler::GetOverlappingPreferredApps", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_ids"), in_app_ids,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetOverlappingPreferredApps), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::PageHandler_GetOverlappingPreferredApps_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_ids)::BaseType>
      app_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& app_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_app_ids,
    app_ids_fragment,
    &app_ids_validate_params);

  params->app_ids.Set(
      app_ids_fragment.is_null() ? nullptr : app_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_ids in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetOverlappingPreferredApps");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetApps: {
      break;
    }
    case messages::PageHandler::kGetApp: {
      break;
    }
    case messages::PageHandler::kGetSubAppToParentMap: {
      break;
    }
    case messages::PageHandler::kGetExtensionAppPermissionMessages: {
      break;
    }
    case messages::PageHandler::kSetPinned: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetPinned_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetPinned_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      std::string p_app_id{};
      bool p_pinned{};
      PageHandler_SetPinned_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success)
        p_pinned = input_data_view.pinned();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPinned(        
        std::move(p_app_id), 
        std::move(p_pinned));
      return true;
    }
    case messages::PageHandler::kSetPermission: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetPermission_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetPermission_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      std::string p_app_id{};
      ::apps::PermissionPtr p_permission{};
      PageHandler_SetPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadPermission(&p_permission))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPermission(        
        std::move(p_app_id), 
        std::move(p_permission));
      return true;
    }
    case messages::PageHandler::kSetResizeLocked: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetResizeLocked_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetResizeLocked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      std::string p_app_id{};
      bool p_locked{};
      PageHandler_SetResizeLocked_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success)
        p_locked = input_data_view.locked();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetResizeLocked(        
        std::move(p_app_id), 
        std::move(p_locked));
      return true;
    }
    case messages::PageHandler::kUninstall: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Uninstall_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Uninstall_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      std::string p_app_id{};
      PageHandler_Uninstall_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Uninstall(        
        std::move(p_app_id));
      return true;
    }
    case messages::PageHandler::kOpenNativeSettings: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenNativeSettings_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenNativeSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      std::string p_app_id{};
      PageHandler_OpenNativeSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenNativeSettings(        
        std::move(p_app_id));
      return true;
    }
    case messages::PageHandler::kSetPreferredApp: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetPreferredApp_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetPreferredApp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      std::string p_app_id{};
      bool p_is_preferred_app{};
      PageHandler_SetPreferredApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success)
        p_is_preferred_app = input_data_view.is_preferred_app();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPreferredApp(        
        std::move(p_app_id), 
        std::move(p_is_preferred_app));
      return true;
    }
    case messages::PageHandler::kGetOverlappingPreferredApps: {
      break;
    }
    case messages::PageHandler::kUpdateAppSize: {
      DCHECK(message->is_serialized());
      internal::PageHandler_UpdateAppSize_Params_Data* params =
          reinterpret_cast<internal::PageHandler_UpdateAppSize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.11
      bool success = true;
      std::string p_app_id{};
      PageHandler_UpdateAppSize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateAppSize(        
        std::move(p_app_id));
      return true;
    }
    case messages::PageHandler::kSetWindowMode: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetWindowMode_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetWindowMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.12
      bool success = true;
      std::string p_app_id{};
      ::apps::WindowMode p_window_mode{};
      PageHandler_SetWindowMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadWindowMode(&p_window_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWindowMode(        
        std::move(p_app_id), 
        std::move(p_window_mode));
      return true;
    }
    case messages::PageHandler::kSetRunOnOsLoginMode: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetRunOnOsLoginMode_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetRunOnOsLoginMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.13
      bool success = true;
      std::string p_app_id{};
      ::apps::RunOnOsLoginMode p_run_on_os_login_mode{};
      PageHandler_SetRunOnOsLoginMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadRunOnOsLoginMode(&p_run_on_os_login_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRunOnOsLoginMode(        
        std::move(p_app_id), 
        std::move(p_run_on_os_login_mode));
      return true;
    }
    case messages::PageHandler::kSetFileHandlingEnabled: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetFileHandlingEnabled_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetFileHandlingEnabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.14
      bool success = true;
      std::string p_app_id{};
      bool p_enabled{};
      PageHandler_SetFileHandlingEnabled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFileHandlingEnabled(        
        std::move(p_app_id), 
        std::move(p_enabled));
      return true;
    }
    case messages::PageHandler::kShowDefaultAppAssociationsUi: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowDefaultAppAssociationsUi_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowDefaultAppAssociationsUi_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.15
      bool success = true;
      PageHandler_ShowDefaultAppAssociationsUi_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowDefaultAppAssociationsUi(        );
      return true;
    }
    case messages::PageHandler::kOpenStorePage: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenStorePage_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenStorePage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.16
      bool success = true;
      std::string p_app_id{};
      PageHandler_OpenStorePage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenStorePage(        
        std::move(p_app_id));
      return true;
    }
    case messages::PageHandler::kSetAppLocale: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetAppLocale_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetAppLocale_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.17
      bool success = true;
      std::string p_app_id{};
      std::string p_locale_tag{};
      PageHandler_SetAppLocale_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadLocaleTag(&p_locale_tag))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAppLocale(        
        std::move(p_app_id), 
        std::move(p_locale_tag));
      return true;
    }
    case messages::PageHandler::kOpenSystemNotificationSettings: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenSystemNotificationSettings_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenSystemNotificationSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.18
      bool success = true;
      std::string p_app_id{};
      PageHandler_OpenSystemNotificationSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenSystemNotificationSettings(        
        std::move(p_app_id));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetApps: {
      internal::PageHandler_GetApps_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetApps_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_GetApps_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_GetApps_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetApps(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetApp: {
      internal::PageHandler_GetApp_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetApp_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      std::string p_app_id{};
      PageHandler_GetApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_GetApp_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetApp(        
        std::move(p_app_id), std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetSubAppToParentMap: {
      internal::PageHandler_GetSubAppToParentMap_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetSubAppToParentMap_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      PageHandler_GetSubAppToParentMap_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          PageHandler_GetSubAppToParentMap_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSubAppToParentMap(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetExtensionAppPermissionMessages: {
      internal::PageHandler_GetExtensionAppPermissionMessages_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetExtensionAppPermissionMessages_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      std::string p_app_id{};
      PageHandler_GetExtensionAppPermissionMessages_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          PageHandler_GetExtensionAppPermissionMessages_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetExtensionAppPermissionMessages(        
        std::move(p_app_id), std::move(callback));
      return true;
    }
    case messages::PageHandler::kSetPinned: {
      break;
    }
    case messages::PageHandler::kSetPermission: {
      break;
    }
    case messages::PageHandler::kSetResizeLocked: {
      break;
    }
    case messages::PageHandler::kUninstall: {
      break;
    }
    case messages::PageHandler::kOpenNativeSettings: {
      break;
    }
    case messages::PageHandler::kSetPreferredApp: {
      break;
    }
    case messages::PageHandler::kGetOverlappingPreferredApps: {
      internal::PageHandler_GetOverlappingPreferredApps_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetOverlappingPreferredApps_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.10
      bool success = true;
      std::string p_app_id{};
      PageHandler_GetOverlappingPreferredApps_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 10, false);
        return false;
      }
      auto callback =
          PageHandler_GetOverlappingPreferredApps_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetOverlappingPreferredApps(        
        std::move(p_app_id), std::move(callback));
      return true;
    }
    case messages::PageHandler::kUpdateAppSize: {
      break;
    }
    case messages::PageHandler::kSetWindowMode: {
      break;
    }
    case messages::PageHandler::kSetRunOnOsLoginMode: {
      break;
    }
    case messages::PageHandler::kSetFileHandlingEnabled: {
      break;
    }
    case messages::PageHandler::kShowDefaultAppAssociationsUi: {
      break;
    }
    case messages::PageHandler::kOpenStorePage: {
      break;
    }
    case messages::PageHandler::kSetAppLocale: {
      break;
    }
    case messages::PageHandler::kOpenSystemNotificationSettings: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_GetApps_Params_Data::Validate,
     &internal::PageHandler_GetApps_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetApp_Params_Data::Validate,
     &internal::PageHandler_GetApp_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetSubAppToParentMap_Params_Data::Validate,
     &internal::PageHandler_GetSubAppToParentMap_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetExtensionAppPermissionMessages_Params_Data::Validate,
     &internal::PageHandler_GetExtensionAppPermissionMessages_ResponseParams_Data::Validate},
    { &internal::PageHandler_SetPinned_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetPermission_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetResizeLocked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Uninstall_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenNativeSettings_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetPreferredApp_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_GetOverlappingPreferredApps_Params_Data::Validate,
     &internal::PageHandler_GetOverlappingPreferredApps_ResponseParams_Data::Validate},
    { &internal::PageHandler_UpdateAppSize_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetWindowMode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetRunOnOsLoginMode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetFileHandlingEnabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ShowDefaultAppAssociationsUi_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenStorePage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetAppLocale_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenSystemNotificationSettings_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::app_management::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::app_management::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kOnAppAdded: {
      return &Page::OnAppAdded_Sym::IPCStableHash;
    }
    case messages::Page::kOnAppChanged: {
      return &Page::OnAppChanged_Sym::IPCStableHash;
    }
    case messages::Page::kOnAppRemoved: {
      return &Page::OnAppRemoved_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnAppAdded:
            return "Receive app_management::mojom::Page::OnAppAdded";
      case messages::Page::kOnAppChanged:
            return "Receive app_management::mojom::Page::OnAppChanged";
      case messages::Page::kOnAppRemoved:
            return "Receive app_management::mojom::Page::OnAppRemoved";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnAppAdded:
            return "Receive reply app_management::mojom::Page::OnAppAdded";
      case messages::Page::kOnAppChanged:
            return "Receive reply app_management::mojom::Page::OnAppChanged";
      case messages::Page::kOnAppRemoved:
            return "Receive reply app_management::mojom::Page::OnAppRemoved";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::OnAppAdded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1c0ab1f1;  // IPCStableHash for app_management::mojom::Page::OnAppAdded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnAppChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1e1da7e1;  // IPCStableHash for app_management::mojom::Page::OnAppChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnAppRemoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbc3d35c5;  // IPCStableHash for app_management::mojom::Page::OnAppRemoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::OnAppAdded(
    AppPtr in_app) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::Page::OnAppAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app"), in_app,
                        "<value of type AppPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnAppAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::Page_OnAppAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app)::BaseType> app_fragment(
          params.message());
  
  mojo::internal::Serialize<::app_management::mojom::AppDataView>(
    in_app,
    app_fragment);

  params->app.Set(
      app_fragment.is_null() ? nullptr : app_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app in Page.OnAppAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnAppAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnAppChanged(
    AppPtr in_update) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::Page::OnAppChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update"), in_update,
                        "<value of type AppPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnAppChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::Page_OnAppChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->update)::BaseType> update_fragment(
          params.message());
  
  mojo::internal::Serialize<::app_management::mojom::AppDataView>(
    in_update,
    update_fragment);

  params->update.Set(
      update_fragment.is_null() ? nullptr : update_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->update.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null update in Page.OnAppChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnAppChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnAppRemoved(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send app_management::mojom::Page::OnAppRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnAppRemoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::app_management::mojom::internal::Page_OnAppRemoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in Page.OnAppRemoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnAppRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnAppAdded: {
      DCHECK(message->is_serialized());
      internal::Page_OnAppAdded_Params_Data* params =
          reinterpret_cast<internal::Page_OnAppAdded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      AppPtr p_app{};
      Page_OnAppAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadApp(&p_app))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAppAdded(        
        std::move(p_app));
      return true;
    }
    case messages::Page::kOnAppChanged: {
      DCHECK(message->is_serialized());
      internal::Page_OnAppChanged_Params_Data* params =
          reinterpret_cast<internal::Page_OnAppChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      AppPtr p_update{};
      Page_OnAppChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdate(&p_update))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAppChanged(        
        std::move(p_update));
      return true;
    }
    case messages::Page::kOnAppRemoved: {
      DCHECK(message->is_serialized());
      internal::Page_OnAppRemoved_Params_Data* params =
          reinterpret_cast<internal::Page_OnAppRemoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      std::string p_app_id{};
      Page_OnAppRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAppRemoved(        
        std::move(p_app_id));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnAppAdded: {
      break;
    }
    case messages::Page::kOnAppChanged: {
      break;
    }
    case messages::Page::kOnAppRemoved: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_OnAppAdded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnAppChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnAppRemoved_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::app_management::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // app_management::mojom


namespace mojo {


// static
bool StructTraits<::app_management::mojom::Permission::DataView, ::app_management::mojom::PermissionPtr>::Read(
    ::app_management::mojom::Permission::DataView input,
    ::app_management::mojom::PermissionPtr* output) {
  bool success = true;
  ::app_management::mojom::PermissionPtr result(::app_management::mojom::Permission::New());
  
      if (success && !input.ReadPermissionType(&result->permission_type))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success)
        result->is_managed = input.is_managed();
      if (success && !input.ReadDetails(&result->details))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::app_management::mojom::RunOnOsLogin::DataView, ::app_management::mojom::RunOnOsLoginPtr>::Read(
    ::app_management::mojom::RunOnOsLogin::DataView input,
    ::app_management::mojom::RunOnOsLoginPtr* output) {
  bool success = true;
  ::app_management::mojom::RunOnOsLoginPtr result(::app_management::mojom::RunOnOsLogin::New());
  
      if (success && !input.ReadLoginMode(&result->login_mode))
        success = false;
      if (success)
        result->is_managed = input.is_managed();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::app_management::mojom::Locale::DataView, ::app_management::mojom::LocalePtr>::Read(
    ::app_management::mojom::Locale::DataView input,
    ::app_management::mojom::LocalePtr* output) {
  bool success = true;
  ::app_management::mojom::LocalePtr result(::app_management::mojom::Locale::New());
  
      if (success && !input.ReadLocaleTag(&result->locale_tag))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadNativeDisplayName(&result->native_display_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::app_management::mojom::App::DataView, ::app_management::mojom::AppPtr>::Read(
    ::app_management::mojom::App::DataView input,
    ::app_management::mojom::AppPtr* output) {
  bool success = true;
  ::app_management::mojom::AppPtr result(::app_management::mojom::App::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success) {
        result->is_pinned = input.is_pinned();
      }
      if (success) {
        result->is_policy_pinned = input.is_policy_pinned();
      }
      if (success && !input.ReadVersion(&result->version))
        success = false;
      if (success && !input.ReadSize(&result->size))
        success = false;
      if (success && !input.ReadPermissions(&result->permissions))
        success = false;
      if (success && !input.ReadInstallReason(&result->install_reason))
        success = false;
      if (success && !input.ReadInstallSource(&result->install_source))
        success = false;
      if (success)
        result->hide_more_settings = input.hide_more_settings();
      if (success)
        result->hide_pin_to_shelf = input.hide_pin_to_shelf();
      if (success)
        result->is_preferred_app = input.is_preferred_app();
      if (success && !input.ReadWindowMode(&result->window_mode))
        success = false;
      if (success)
        result->hide_window_mode = input.hide_window_mode();
      if (success)
        result->resize_locked = input.resize_locked();
      if (success)
        result->hide_resize_locked = input.hide_resize_locked();
      if (success && !input.ReadSupportedLinks(&result->supported_links))
        success = false;
      if (success && !input.ReadRunOnOsLogin(&result->run_on_os_login))
        success = false;
      if (success && !input.ReadFileHandlingState(&result->file_handling_state))
        success = false;
      if (success && !input.ReadAppSize(&result->app_size))
        success = false;
      if (success && !input.ReadDataSize(&result->data_size))
        success = false;
      if (success && !input.ReadPublisherId(&result->publisher_id))
        success = false;
      if (success && !input.ReadFormattedOrigin(&result->formatted_origin))
        success = false;
      if (success && !input.ReadScopeExtensions(&result->scope_extensions))
        success = false;
      if (success && !input.ReadSupportedLocales(&result->supported_locales))
        success = false;
      if (success && !input.ReadSelectedLocale(&result->selected_locale))
        success = false;
      if (success)
        result->show_system_notifications_settings_link = input.show_system_notifications_settings_link();
      if (success)
        result->allow_uninstall = input.allow_uninstall();
      if (success)
        result->disable_user_choice_navigation_capturing = input.disable_user_choice_navigation_capturing();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::app_management::mojom::ExtensionAppPermissionMessage::DataView, ::app_management::mojom::ExtensionAppPermissionMessagePtr>::Read(
    ::app_management::mojom::ExtensionAppPermissionMessage::DataView input,
    ::app_management::mojom::ExtensionAppPermissionMessagePtr* output) {
  bool success = true;
  ::app_management::mojom::ExtensionAppPermissionMessagePtr result(::app_management::mojom::ExtensionAppPermissionMessage::New());
  
      if (success && !input.ReadMessage(&result->message))
        success = false;
      if (success && !input.ReadSubmessages(&result->submessages))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::app_management::mojom::FileHandlingState::DataView, ::app_management::mojom::FileHandlingStatePtr>::Read(
    ::app_management::mojom::FileHandlingState::DataView input,
    ::app_management::mojom::FileHandlingStatePtr* output) {
  bool success = true;
  ::app_management::mojom::FileHandlingStatePtr result(::app_management::mojom::FileHandlingState::New());
  
      if (success)
        result->enabled = input.enabled();
      if (success)
        result->is_managed = input.is_managed();
      if (success && !input.ReadUserVisibleTypes(&result->user_visible_types))
        success = false;
      if (success && !input.ReadUserVisibleTypesLabel(&result->user_visible_types_label))
        success = false;
      if (success && !input.ReadLearnMoreUrl(&result->learn_more_url))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::app_management::mojom::PermissionValue::DataView, ::app_management::mojom::PermissionValuePtr>::Read(
    ::app_management::mojom::PermissionValue::DataView input,
    ::app_management::mojom::PermissionValuePtr* output) {
  using UnionType = ::app_management::mojom::PermissionValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kBoolValue: {
      *output = UnionType::NewBoolValue(input.bool_value());
      break;
    }
    case Tag::kTristateValue: {
      ::app_management::mojom::TriState result_tristate_value;
      if (!input.ReadTristateValue(&result_tristate_value))
        return false;

      *output = UnionType::NewTristateValue(result_tristate_value);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace app_management::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::GetApps(GetAppsCallback callback) {
  GetForwardingInterface()->GetApps(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetApp(const std::string& app_id, GetAppCallback callback) {
  GetForwardingInterface()->GetApp(
    std::move(app_id)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::GetSubAppToParentMap(GetSubAppToParentMapCallback callback) {
  GetForwardingInterface()->GetSubAppToParentMap(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetExtensionAppPermissionMessages(const std::string& app_id, GetExtensionAppPermissionMessagesCallback callback) {
  GetForwardingInterface()->GetExtensionAppPermissionMessages(
    std::move(app_id)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::SetPinned(const std::string& app_id, bool pinned) {
  GetForwardingInterface()->SetPinned(
    std::move(app_id)
    , 
    std::move(pinned)
    );
}
void PageHandlerInterceptorForTesting::SetPermission(const std::string& app_id, ::apps::PermissionPtr permission) {
  GetForwardingInterface()->SetPermission(
    std::move(app_id)
    , 
    std::move(permission)
    );
}
void PageHandlerInterceptorForTesting::SetResizeLocked(const std::string& app_id, bool locked) {
  GetForwardingInterface()->SetResizeLocked(
    std::move(app_id)
    , 
    std::move(locked)
    );
}
void PageHandlerInterceptorForTesting::Uninstall(const std::string& app_id) {
  GetForwardingInterface()->Uninstall(
    std::move(app_id)
    );
}
void PageHandlerInterceptorForTesting::OpenNativeSettings(const std::string& app_id) {
  GetForwardingInterface()->OpenNativeSettings(
    std::move(app_id)
    );
}
void PageHandlerInterceptorForTesting::SetPreferredApp(const std::string& app_id, bool is_preferred_app) {
  GetForwardingInterface()->SetPreferredApp(
    std::move(app_id)
    , 
    std::move(is_preferred_app)
    );
}
void PageHandlerInterceptorForTesting::GetOverlappingPreferredApps(const std::string& app_id, GetOverlappingPreferredAppsCallback callback) {
  GetForwardingInterface()->GetOverlappingPreferredApps(
    std::move(app_id)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::UpdateAppSize(const std::string& app_id) {
  GetForwardingInterface()->UpdateAppSize(
    std::move(app_id)
    );
}
void PageHandlerInterceptorForTesting::SetWindowMode(const std::string& app_id, ::apps::WindowMode window_mode) {
  GetForwardingInterface()->SetWindowMode(
    std::move(app_id)
    , 
    std::move(window_mode)
    );
}
void PageHandlerInterceptorForTesting::SetRunOnOsLoginMode(const std::string& app_id, ::apps::RunOnOsLoginMode run_on_os_login_mode) {
  GetForwardingInterface()->SetRunOnOsLoginMode(
    std::move(app_id)
    , 
    std::move(run_on_os_login_mode)
    );
}
void PageHandlerInterceptorForTesting::SetFileHandlingEnabled(const std::string& app_id, bool enabled) {
  GetForwardingInterface()->SetFileHandlingEnabled(
    std::move(app_id)
    , 
    std::move(enabled)
    );
}
void PageHandlerInterceptorForTesting::ShowDefaultAppAssociationsUi() {
  GetForwardingInterface()->ShowDefaultAppAssociationsUi();
}
void PageHandlerInterceptorForTesting::OpenStorePage(const std::string& app_id) {
  GetForwardingInterface()->OpenStorePage(
    std::move(app_id)
    );
}
void PageHandlerInterceptorForTesting::SetAppLocale(const std::string& app_id, const std::string& locale_tag) {
  GetForwardingInterface()->SetAppLocale(
    std::move(app_id)
    , 
    std::move(locale_tag)
    );
}
void PageHandlerInterceptorForTesting::OpenSystemNotificationSettings(const std::string& app_id) {
  GetForwardingInterface()->OpenSystemNotificationSettings(
    std::move(app_id)
    );
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetApps(
    std::vector<AppPtr>* out_apps) {
  base::RunLoop loop;
  proxy_->GetApps(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<AppPtr>* out_apps
,
             std::vector<AppPtr> apps) {*out_apps = std::move(apps);
            loop->Quit();
          },
          &loop,
          out_apps));
  loop.Run();
}

std::vector<AppPtr> PageHandlerAsyncWaiter::GetApps(
    ) {
  std::vector<AppPtr> async_wait_result;
  GetApps(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetApp(
    const std::string& app_id, AppPtr* out_app) {
  base::RunLoop loop;
  proxy_->GetApp(
      std::move(app_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             AppPtr* out_app
,
             AppPtr app) {*out_app = std::move(app);
            loop->Quit();
          },
          &loop,
          out_app));
  loop.Run();
}

AppPtr PageHandlerAsyncWaiter::GetApp(
    const std::string& app_id) {
  AppPtr async_wait_result;
  GetApp(std::move(app_id),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetSubAppToParentMap(
    base::flat_map<std::string, std::string>* out_sub_app_to_parent_map) {
  base::RunLoop loop;
  proxy_->GetSubAppToParentMap(
      base::BindOnce(
          [](base::RunLoop* loop,
             base::flat_map<std::string, std::string>* out_sub_app_to_parent_map
,
             const base::flat_map<std::string, std::string>& sub_app_to_parent_map) {*out_sub_app_to_parent_map = std::move(sub_app_to_parent_map);
            loop->Quit();
          },
          &loop,
          out_sub_app_to_parent_map));
  loop.Run();
}

base::flat_map<std::string, std::string> PageHandlerAsyncWaiter::GetSubAppToParentMap(
    ) {
  base::flat_map<std::string, std::string> async_wait_result;
  GetSubAppToParentMap(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetExtensionAppPermissionMessages(
    const std::string& app_id, std::vector<ExtensionAppPermissionMessagePtr>* out_messages) {
  base::RunLoop loop;
  proxy_->GetExtensionAppPermissionMessages(
      std::move(app_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ExtensionAppPermissionMessagePtr>* out_messages
,
             std::vector<ExtensionAppPermissionMessagePtr> messages) {*out_messages = std::move(messages);
            loop->Quit();
          },
          &loop,
          out_messages));
  loop.Run();
}

std::vector<ExtensionAppPermissionMessagePtr> PageHandlerAsyncWaiter::GetExtensionAppPermissionMessages(
    const std::string& app_id) {
  std::vector<ExtensionAppPermissionMessagePtr> async_wait_result;
  GetExtensionAppPermissionMessages(std::move(app_id),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetOverlappingPreferredApps(
    const std::string& app_id, std::vector<std::string>* out_app_ids) {
  base::RunLoop loop;
  proxy_->GetOverlappingPreferredApps(
      std::move(app_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_app_ids
,
             const std::vector<std::string>& app_ids) {*out_app_ids = std::move(app_ids);
            loop->Quit();
          },
          &loop,
          out_app_ids));
  loop.Run();
}

std::vector<std::string> PageHandlerAsyncWaiter::GetOverlappingPreferredApps(
    const std::string& app_id) {
  std::vector<std::string> async_wait_result;
  GetOverlappingPreferredApps(std::move(app_id),&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::OnAppAdded(AppPtr app) {
  GetForwardingInterface()->OnAppAdded(
    std::move(app)
    );
}
void PageInterceptorForTesting::OnAppChanged(AppPtr update) {
  GetForwardingInterface()->OnAppChanged(
    std::move(update)
    );
}
void PageInterceptorForTesting::OnAppRemoved(const std::string& app_id) {
  GetForwardingInterface()->OnAppRemoved(
    std::move(app_id)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // app_management::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif