// ui/gl/mojom/gl_implementation.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/gl/mojom/gl_implementation.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gl.mojom');


  var GLImplementation = {};
  GLImplementation.kGLImplementationNone = 0;
  GLImplementation.kGLImplementationEGLGLES2 = 1;
  GLImplementation.kGLImplementationMockGL = 2;
  GLImplementation.kGLImplementationStubGL = 3;
  GLImplementation.kGLImplementationDisabled = 4;
  GLImplementation.kGLImplementationEGLANGLE = 5;
  GLImplementation.MIN_VALUE = 0;
  GLImplementation.MAX_VALUE = 5;

  GLImplementation.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  GLImplementation.toKnownEnumValue = function(value) {
    return value;
  };

  GLImplementation.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ANGLEImplementation = {};
  ANGLEImplementation.kNone = 0;
  ANGLEImplementation.kD3D9 = 1;
  ANGLEImplementation.kD3D11 = 2;
  ANGLEImplementation.kOpenGL = 3;
  ANGLEImplementation.kOpenGLES = 4;
  ANGLEImplementation.kNull = 5;
  ANGLEImplementation.kVulkan = 6;
  ANGLEImplementation.kSwiftShader = 7;
  ANGLEImplementation.kMetal = 8;
  ANGLEImplementation.kD3D11Warp = 9;
  ANGLEImplementation.kDefault = 10;
  ANGLEImplementation.MIN_VALUE = 0;
  ANGLEImplementation.MAX_VALUE = 10;

  ANGLEImplementation.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
      return true;
    }
    return false;
  };

  ANGLEImplementation.toKnownEnumValue = function(value) {
    return value;
  };

  ANGLEImplementation.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function GLImplementationParts(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GLImplementationParts.prototype.initDefaults_ = function() {
    this.gl = 0;
    this.angle = 0;
  };
  GLImplementationParts.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GLImplementationParts.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GLImplementationParts.gl
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, GLImplementation);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GLImplementationParts.angle
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ANGLEImplementation);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GLImplementationParts.encodedSize = codec.kStructHeaderSize + 8;

  GLImplementationParts.decode = function(decoder) {
    var packed;
    var val = new GLImplementationParts();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.gl =
        decoder.decodeStruct(new codec.Enum(GLImplementation));
    val.angle =
        decoder.decodeStruct(new codec.Enum(ANGLEImplementation));
    return val;
  };

  GLImplementationParts.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GLImplementationParts.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.gl);
    encoder.encodeStruct(codec.Int32, val.angle);
  };
  exports.GLImplementation = GLImplementation;
  exports.ANGLEImplementation = ANGLEImplementation;
  exports.GLImplementationParts = GLImplementationParts;
})();