// ui/gfx/mojom/delegated_ink_metadata.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_DELEGATED_INK_METADATA_MOJOM_BLINK_H_
#define UI_GFX_MOJOM_DELEGATED_INK_METADATA_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/delegated_ink_metadata.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/delegated_ink_metadata.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/delegated_ink_metadata.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "skia/public/mojom/skcolor.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "ui/gfx/mojom/delegated_ink_metadata_mojom_traits.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gfx::mojom::blink {








class  DelegatedInkMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DelegatedInkMetadata, T>::value>;
  using DataView = DelegatedInkMetadataDataView;
  using Data_ = internal::DelegatedInkMetadata_Data;

  template <typename... Args>
  static DelegatedInkMetadataPtr New(Args&&... args) {
    return DelegatedInkMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DelegatedInkMetadataPtr From(const U& u) {
    return mojo::TypeConverter<DelegatedInkMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DelegatedInkMetadata>::Convert(*this);
  }


  DelegatedInkMetadata();

  DelegatedInkMetadata(
      const ::gfx::PointF& point,
      double diameter,
      ::SkColor color,
      ::base::TimeTicks timestamp,
      const ::gfx::RectF& presentation_area,
      ::base::TimeTicks frame_time,
      bool is_hovering);


  ~DelegatedInkMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DelegatedInkMetadataPtr>
  DelegatedInkMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DelegatedInkMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DelegatedInkMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DelegatedInkMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DelegatedInkMetadata::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DelegatedInkMetadata::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DelegatedInkMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DelegatedInkMetadata_UnserializedMessageContext<
            UserType, DelegatedInkMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DelegatedInkMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DelegatedInkMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DelegatedInkMetadata_UnserializedMessageContext<
            UserType, DelegatedInkMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DelegatedInkMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::PointF point;
  
  double diameter;
  
  ::SkColor color;
  
  ::base::TimeTicks timestamp;
  
  ::gfx::RectF presentation_area;
  
  ::base::TimeTicks frame_time;
  
  bool is_hovering;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DelegatedInkMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DelegatedInkMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DelegatedInkMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DelegatedInkMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DelegatedInkMetadataPtr DelegatedInkMetadata::Clone() const {
  return New(
      mojo::Clone(point),
      mojo::Clone(diameter),
      mojo::Clone(color),
      mojo::Clone(timestamp),
      mojo::Clone(presentation_area),
      mojo::Clone(frame_time),
      mojo::Clone(is_hovering)
  );
}

template <typename T, DelegatedInkMetadata::EnableIfSame<T>*>
bool DelegatedInkMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->point, other_struct.point))
    return false;
  if (!mojo::Equals(this->diameter, other_struct.diameter))
    return false;
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->presentation_area, other_struct.presentation_area))
    return false;
  if (!mojo::Equals(this->frame_time, other_struct.frame_time))
    return false;
  if (!mojo::Equals(this->is_hovering, other_struct.is_hovering))
    return false;
  return true;
}

template <typename T, DelegatedInkMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.point < rhs.point)
    return true;
  if (rhs.point < lhs.point)
    return false;
  if (lhs.diameter < rhs.diameter)
    return true;
  if (rhs.diameter < lhs.diameter)
    return false;
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.presentation_area < rhs.presentation_area)
    return true;
  if (rhs.presentation_area < lhs.presentation_area)
    return false;
  if (lhs.frame_time < rhs.frame_time)
    return true;
  if (rhs.frame_time < lhs.frame_time)
    return false;
  if (lhs.is_hovering < rhs.is_hovering)
    return true;
  if (rhs.is_hovering < lhs.is_hovering)
    return false;
  return false;
}


}  // gfx::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::blink::DelegatedInkMetadata::DataView,
                                         ::gfx::mojom::blink::DelegatedInkMetadataPtr> {
  static bool IsNull(const ::gfx::mojom::blink::DelegatedInkMetadataPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::DelegatedInkMetadataPtr* output) { output->reset(); }

  static const decltype(::gfx::mojom::blink::DelegatedInkMetadata::point)& point(
      const ::gfx::mojom::blink::DelegatedInkMetadataPtr& input) {
    return input->point;
  }

  static decltype(::gfx::mojom::blink::DelegatedInkMetadata::diameter) diameter(
      const ::gfx::mojom::blink::DelegatedInkMetadataPtr& input) {
    return input->diameter;
  }

  static const decltype(::gfx::mojom::blink::DelegatedInkMetadata::color)& color(
      const ::gfx::mojom::blink::DelegatedInkMetadataPtr& input) {
    return input->color;
  }

  static const decltype(::gfx::mojom::blink::DelegatedInkMetadata::timestamp)& timestamp(
      const ::gfx::mojom::blink::DelegatedInkMetadataPtr& input) {
    return input->timestamp;
  }

  static const decltype(::gfx::mojom::blink::DelegatedInkMetadata::presentation_area)& presentation_area(
      const ::gfx::mojom::blink::DelegatedInkMetadataPtr& input) {
    return input->presentation_area;
  }

  static const decltype(::gfx::mojom::blink::DelegatedInkMetadata::frame_time)& frame_time(
      const ::gfx::mojom::blink::DelegatedInkMetadataPtr& input) {
    return input->frame_time;
  }

  static decltype(::gfx::mojom::blink::DelegatedInkMetadata::is_hovering) is_hovering(
      const ::gfx::mojom::blink::DelegatedInkMetadataPtr& input) {
    return input->is_hovering;
  }

  static bool Read(::gfx::mojom::blink::DelegatedInkMetadata::DataView input, ::gfx::mojom::blink::DelegatedInkMetadataPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_DELEGATED_INK_METADATA_MOJOM_BLINK_H_