// ui/display/mojom/display_color_management.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_COLOR_MANAGEMENT_MOJOM_SEND_VALIDATION_H_
#define UI_DISPLAY_MOJOM_DISPLAY_COLOR_MANAGEMENT_MOJOM_SEND_VALIDATION_H_

#include "ui/display/mojom/display_color_management.mojom-shared-internal.h"
#include "skia/public/mojom/skcolorspace.mojom-shared.h"
#include "ui/display/mojom/gamma_ramp_rgb_entry.mojom-shared.h"

#include "ui/display/mojom/display_color_management.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::display::mojom::GammaCurveDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::GammaCurveDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::GammaCurve_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::lut(input)) in_lut = Traits::lut(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lut)::BaseType>
          lut_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& lut_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::display::mojom::GammaRampRGBEntryDataView>, send_validation>(
        in_lut,
        lut_fragment,
        &lut_validate_params);

      fragment->lut.Set(
          lut_fragment.is_null() ? nullptr : lut_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->lut.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lut in GammaCurve struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::display::mojom::ColorCalibrationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::ColorCalibrationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::ColorCalibration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::srgb_to_linear(input)) in_srgb_to_linear = Traits::srgb_to_linear(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->srgb_to_linear)::BaseType> srgb_to_linear_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::display::mojom::GammaCurveDataView, send_validation>(
        in_srgb_to_linear,
        srgb_to_linear_fragment);

      fragment->srgb_to_linear.Set(
          srgb_to_linear_fragment.is_null() ? nullptr : srgb_to_linear_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->srgb_to_linear.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null srgb_to_linear in ColorCalibration struct");

      decltype(Traits::srgb_to_device_matrix(input)) in_srgb_to_device_matrix = Traits::srgb_to_device_matrix(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->srgb_to_device_matrix)::BaseType> srgb_to_device_matrix_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkcmsMatrix3x3DataView, send_validation>(
        in_srgb_to_device_matrix,
        srgb_to_device_matrix_fragment);

      fragment->srgb_to_device_matrix.Set(
          srgb_to_device_matrix_fragment.is_null() ? nullptr : srgb_to_device_matrix_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->srgb_to_device_matrix.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null srgb_to_device_matrix in ColorCalibration struct");

      decltype(Traits::linear_to_device(input)) in_linear_to_device = Traits::linear_to_device(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->linear_to_device)::BaseType> linear_to_device_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::display::mojom::GammaCurveDataView, send_validation>(
        in_linear_to_device,
        linear_to_device_fragment);

      fragment->linear_to_device.Set(
          linear_to_device_fragment.is_null() ? nullptr : linear_to_device_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->linear_to_device.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null linear_to_device in ColorCalibration struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::display::mojom::ColorTemperatureAdjustmentDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::ColorTemperatureAdjustmentDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::ColorTemperatureAdjustment_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::srgb_matrix(input)) in_srgb_matrix = Traits::srgb_matrix(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->srgb_matrix)::BaseType> srgb_matrix_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkcmsMatrix3x3DataView, send_validation>(
        in_srgb_matrix,
        srgb_matrix_fragment);

      fragment->srgb_matrix.Set(
          srgb_matrix_fragment.is_null() ? nullptr : srgb_matrix_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->srgb_matrix.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null srgb_matrix in ColorTemperatureAdjustment struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::display::mojom::GammaAdjustmentDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::GammaAdjustmentDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::GammaAdjustment_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::curve(input)) in_curve = Traits::curve(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->curve)::BaseType> curve_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::display::mojom::GammaCurveDataView, send_validation>(
        in_curve,
        curve_fragment);

      fragment->curve.Set(
          curve_fragment.is_null() ? nullptr : curve_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->curve.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null curve in GammaAdjustment struct");
  }
};

}  // namespace mojo::internal

#endif  // UI_DISPLAY_MOJOM_DISPLAY_COLOR_MANAGEMENT_MOJOM_SEND_VALIDATION_H_