// ui/color/scheme_variant.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/color/scheme_variant.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/color/scheme_variant.mojom-params-data.h"
namespace color {
namespace mojom {

NOINLINE static const char* SchemeVariantToStringHelper(SchemeVariant value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SchemeVariant::kTonalSpot:
      return "kTonalSpot";
    case SchemeVariant::kNeutral:
      return "kNeutral";
    case SchemeVariant::kVibrant:
      return "kVibrant";
    case SchemeVariant::kExpressive:
      return "kExpressive";
    default:
      return nullptr;
  }
}

std::string SchemeVariantToString(SchemeVariant value) {
  const char *str = SchemeVariantToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SchemeVariant value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SchemeVariant value) {
  return os << SchemeVariantToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace color

namespace perfetto {

// static
void TraceFormatTraits<::color::mojom::SchemeVariant>::WriteIntoTrace(
   perfetto::TracedValue context, ::color::mojom::SchemeVariant value) {
  return std::move(context).WriteString(::color::mojom::SchemeVariantToString(value));
}

} // namespace perfetto