// ui/base/mojom/attributed_string.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/base/mojom/attributed_string.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ui.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var range$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/range/mojom/range.mojom', '../../gfx/range/mojom/range.mojom.js');
  }



  function FontAttribute(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FontAttribute.prototype.initDefaults_ = function() {
    this.fontName = null;
    this.fontPointSize = 0;
    this.effectiveRange = null;
  };
  FontAttribute.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FontAttribute.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FontAttribute.fontName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate FontAttribute.effectiveRange
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, range$.Range, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FontAttribute.encodedSize = codec.kStructHeaderSize + 24;

  FontAttribute.decode = function(decoder) {
    var packed;
    var val = new FontAttribute();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.fontName =
        decoder.decodeStructPointer(string16$.String16);
    val.fontPointSize =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.effectiveRange =
        decoder.decodeStructPointer(range$.Range);
    return val;
  };

  FontAttribute.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FontAttribute.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.fontName);
    encoder.encodeStruct(codec.Float, val.fontPointSize);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(range$.Range, val.effectiveRange);
  };
  function AttributedString(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AttributedString.prototype.initDefaults_ = function() {
    this.string = null;
    this.attributes = null;
  };
  AttributedString.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AttributedString.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AttributedString.string
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AttributedString.attributes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(FontAttribute), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AttributedString.encodedSize = codec.kStructHeaderSize + 16;

  AttributedString.decode = function(decoder) {
    var packed;
    var val = new AttributedString();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.string =
        decoder.decodeStructPointer(string16$.String16);
    val.attributes =
        decoder.decodeArrayPointer(new codec.PointerTo(FontAttribute));
    return val;
  };

  AttributedString.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AttributedString.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.string);
    encoder.encodeArrayPointer(new codec.PointerTo(FontAttribute), val.attributes);
  };
  exports.FontAttribute = FontAttribute;
  exports.AttributedString = AttributedString;
})();