// ui/base/ime/mojom/text_input_state.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_SEND_VALIDATION_H_
#define UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_SEND_VALIDATION_H_

#include "ui/base/ime/mojom/text_input_state.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "ui/base/ime/mojom/ime_types.mojom-shared.h"
#include "ui/base/ime/mojom/virtual_keyboard_types.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/range/mojom/range.mojom-shared.h"

#include "ui/base/ime/mojom/text_input_state.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::ImeTextSpanInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::ImeTextSpanInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::ImeTextSpanInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::span(input)) in_span = Traits::span(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->span)::BaseType> span_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ui::mojom::ImeTextSpanDataView, send_validation>(
        in_span,
        span_fragment);

      fragment->span.Set(
          span_fragment.is_null() ? nullptr : span_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->span.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null span in ImeTextSpanInfo struct");

      decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounds)::BaseType> bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_bounds,
        bounds_fragment);

      fragment->bounds.Set(
          bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in ImeTextSpanInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::TextInputStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::TextInputStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::TextInputState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->node_id = Traits::node_id(input);

      
      mojo::internal::Serialize<::ui::mojom::TextInputType>(
        Traits::type(input),
        &fragment->type);

      
      mojo::internal::Serialize<::ui::mojom::TextInputMode>(
        Traits::mode(input),
        &fragment->mode);

      
      mojo::internal::Serialize<::ui::mojom::TextInputAction>(
        Traits::action(input),
        &fragment->action);

      fragment->flags = Traits::flags(input);

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      decltype(Traits::selection(input)) in_selection = Traits::selection(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->selection)::BaseType> selection_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RangeDataView, send_validation>(
        in_selection,
        selection_fragment);

      fragment->selection.Set(
          selection_fragment.is_null() ? nullptr : selection_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->selection.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null selection in TextInputState struct");

      decltype(Traits::composition(input)) in_composition = Traits::composition(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->composition)::BaseType> composition_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RangeDataView, send_validation>(
        in_composition,
        composition_fragment);

      fragment->composition.Set(
          composition_fragment.is_null() ? nullptr : composition_fragment.data());

      fragment->can_compose_inline = Traits::can_compose_inline(input);

      fragment->show_ime_if_needed = Traits::show_ime_if_needed(input);

      fragment->always_hide_ime = Traits::always_hide_ime(input);

      fragment->reply_to_request = Traits::reply_to_request(input);

      decltype(Traits::edit_context_control_bounds(input)) in_edit_context_control_bounds = Traits::edit_context_control_bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->edit_context_control_bounds)::BaseType> edit_context_control_bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_edit_context_control_bounds,
        edit_context_control_bounds_fragment);

      fragment->edit_context_control_bounds.Set(
          edit_context_control_bounds_fragment.is_null() ? nullptr : edit_context_control_bounds_fragment.data());

      decltype(Traits::edit_context_selection_bounds(input)) in_edit_context_selection_bounds = Traits::edit_context_selection_bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->edit_context_selection_bounds)::BaseType> edit_context_selection_bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_edit_context_selection_bounds,
        edit_context_selection_bounds_fragment);

      fragment->edit_context_selection_bounds.Set(
          edit_context_selection_bounds_fragment.is_null() ? nullptr : edit_context_selection_bounds_fragment.data());

      
      mojo::internal::Serialize<::ui::mojom::VirtualKeyboardPolicy>(
        Traits::vk_policy(input),
        &fragment->vk_policy);

      
      mojo::internal::Serialize<::ui::mojom::VirtualKeyboardVisibilityRequest>(
        Traits::last_vk_visibility_request(input),
        &fragment->last_vk_visibility_request);

      decltype(Traits::ime_text_spans_info(input)) in_ime_text_spans_info = Traits::ime_text_spans_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ime_text_spans_info)::BaseType>
          ime_text_spans_info_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_info_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::ui::mojom::ImeTextSpanInfoDataView>, send_validation>(
        in_ime_text_spans_info,
        ime_text_spans_info_fragment,
        &ime_text_spans_info_validate_params);

      fragment->ime_text_spans_info.Set(
          ime_text_spans_info_fragment.is_null() ? nullptr : ime_text_spans_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->ime_text_spans_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ime_text_spans_info in TextInputState struct");
  }
};

}  // namespace mojo::internal

#endif  // UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_SEND_VALIDATION_H_