// ui/base/cursor/mojom/cursor.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/base/cursor/mojom/cursor.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ui.mojom');
  var bitmap$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/bitmap.mojom', '../../../../skia/public/mojom/bitmap.mojom.js');
  }
  var cursor_type$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/base/cursor/mojom/cursor_type.mojom', 'cursor_type.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../gfx/geometry/mojom/geometry.mojom.js');
  }



  function Cursor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Cursor.prototype.initDefaults_ = function() {
    this.type = 0;
    this.imageScaleFactor = 0;
    this.hotspot = null;
    this.bitmap = null;
  };
  Cursor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Cursor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Cursor.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, cursor_type$.CursorType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Cursor.hotspot
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Cursor.bitmap
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, bitmap$.BitmapN32, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Cursor.encodedSize = codec.kStructHeaderSize + 24;

  Cursor.decode = function(decoder) {
    var packed;
    var val = new Cursor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(cursor_type$.CursorType));
    val.imageScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.hotspot =
        decoder.decodeStructPointer(geometry$.Point);
    val.bitmap =
        decoder.decodeStructPointer(bitmap$.BitmapN32);
    return val;
  };

  Cursor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Cursor.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Float, val.imageScaleFactor);
    encoder.encodeStructPointer(geometry$.Point, val.hotspot);
    encoder.encodeStructPointer(bitmap$.BitmapN32, val.bitmap);
  };
  exports.Cursor = Cursor;
})();