// ui/accessibility/mojom/ax_tree_id.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/accessibility/mojom/ax_tree_id.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/mojom/ax_tree_id.mojom-params-data.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared-message-ids.h"

#include "ui/accessibility/mojom/ax_tree_id.mojom-blink-import-headers.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace ax::mojom::blink {
AXTreeIDPtr
AXTreeID::NewUnknown(
    uint8_t value) {
  return AXTreeIDPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUnknown)>,
      std::move(value));
}

AXTreeIDPtr
AXTreeID::NewToken(
    const ::base::UnguessableToken& value) {
  return AXTreeIDPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kToken)>,
      std::move(value));
}

AXTreeID::AXTreeID(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnknown)>,
    uint8_t value)
    : tag_(Tag::kUnknown),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUnknown)>,
            std::move(value)) {}

AXTreeID::AXTreeID(
    std::in_place_index_t<static_cast<size_t>(Tag::kToken)>,
    const ::base::UnguessableToken& value)
    : tag_(Tag::kToken),
      data_(std::in_place_index<static_cast<size_t>(Tag::kToken)>,
            std::move(value)) {}
AXTreeID::~AXTreeID() {
  DestroyActive();
}

void AXTreeID::set_unknown(uint8_t unknown) {
  if (tag_ != Tag::kUnknown) {
    DestroyActive();
    tag_ = Tag::kUnknown;
  }
  data_.unknown = unknown;
}

void AXTreeID::set_token(const ::base::UnguessableToken& token) {
  if (tag_ == Tag::kToken) {
    data_.token = std::move(token);
  } else {
    DestroyActive();
    tag_ = Tag::kToken;
    new (&data_.token) ::base::UnguessableToken(
        std::move(token));
  }
}


AXTreeID::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnknown)>,
    uint8_t value)
    : unknown(std::move(value)) {}

AXTreeID::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kToken)>,
    const ::base::UnguessableToken& value)
    : token(std::move(value)) {}

void AXTreeID::DestroyActive() {
  switch (tag_) {

    case Tag::kUnknown:
      std::destroy_at(&data_.unknown);
      break;
    case Tag::kToken:
      std::destroy_at(&data_.token);
      break;
  }
}

bool AXTreeID::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // ax::mojom::blink


namespace mojo {

// static
bool UnionTraits<::ax::mojom::blink::AXTreeID::DataView, ::ax::mojom::blink::AXTreeIDPtr>::Read(
    ::ax::mojom::blink::AXTreeID::DataView input,
    ::ax::mojom::blink::AXTreeIDPtr* output) {
  using UnionType = ::ax::mojom::blink::AXTreeID;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kUnknown: {
      *output = UnionType::NewUnknown(input.unknown());
      break;
    }
    case Tag::kToken: {
      ::base::UnguessableToken result_token{};
      if (!input.ReadToken(&result_token))
        return false;

      *output = UnionType::NewToken(
          std::move(result_token));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ax::mojom::blink {




}  // ax::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif