// ui/accessibility/mojom/ax_location_and_scroll_updates.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/accessibility/mojom/ax_location_and_scroll_updates.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ax.mojom');
  var ax_relative_bounds$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_relative_bounds.mojom', 'ax_relative_bounds.mojom.js');
  }
  var ax_tree_id$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_tree_id.mojom', 'ax_tree_id.mojom.js');
  }



  function AXLocationChange(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AXLocationChange.prototype.initDefaults_ = function() {
    this.id = 0;
    this.newLocation = null;
  };
  AXLocationChange.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AXLocationChange.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AXLocationChange.newLocation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ax_relative_bounds$.AXRelativeBounds, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AXLocationChange.encodedSize = codec.kStructHeaderSize + 16;

  AXLocationChange.decode = function(decoder) {
    var packed;
    var val = new AXLocationChange();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.newLocation =
        decoder.decodeStructPointer(ax_relative_bounds$.AXRelativeBounds);
    return val;
  };

  AXLocationChange.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AXLocationChange.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.id);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ax_relative_bounds$.AXRelativeBounds, val.newLocation);
  };
  function AXScrollChange(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AXScrollChange.prototype.initDefaults_ = function() {
    this.id = 0;
    this.scrollX = 0;
    this.scrollY = 0;
  };
  AXScrollChange.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AXScrollChange.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  AXScrollChange.encodedSize = codec.kStructHeaderSize + 16;

  AXScrollChange.decode = function(decoder) {
    var packed;
    var val = new AXScrollChange();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int32);
    val.scrollX =
        decoder.decodeStruct(codec.Int32);
    val.scrollY =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AXScrollChange.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AXScrollChange.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.id);
    encoder.encodeStruct(codec.Int32, val.scrollX);
    encoder.encodeStruct(codec.Int32, val.scrollY);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AXLocationAndScrollUpdates(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AXLocationAndScrollUpdates.prototype.initDefaults_ = function() {
    this.locationChanges = null;
    this.scrollChanges = null;
  };
  AXLocationAndScrollUpdates.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AXLocationAndScrollUpdates.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXLocationAndScrollUpdates.locationChanges
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(AXLocationChange), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXLocationAndScrollUpdates.scrollChanges
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(AXScrollChange), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AXLocationAndScrollUpdates.encodedSize = codec.kStructHeaderSize + 16;

  AXLocationAndScrollUpdates.decode = function(decoder) {
    var packed;
    var val = new AXLocationAndScrollUpdates();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.locationChanges =
        decoder.decodeArrayPointer(new codec.PointerTo(AXLocationChange));
    val.scrollChanges =
        decoder.decodeArrayPointer(new codec.PointerTo(AXScrollChange));
    return val;
  };

  AXLocationAndScrollUpdates.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AXLocationAndScrollUpdates.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(AXLocationChange), val.locationChanges);
    encoder.encodeArrayPointer(new codec.PointerTo(AXScrollChange), val.scrollChanges);
  };
  exports.AXLocationChange = AXLocationChange;
  exports.AXScrollChange = AXScrollChange;
  exports.AXLocationAndScrollUpdates = AXLocationAndScrollUpdates;
})();