// ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-params-data.h"
#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-shared-message-ids.h"

#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-blink-import-headers.h"
#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace ax::mojom::blink {
AXLocationChange::AXLocationChange()
    : id(),
      new_location() {}

AXLocationChange::AXLocationChange(
    int32_t id_in,
    ::ui::AXRelativeBounds new_location_in)
    : id(std::move(id_in)),
      new_location(std::move(new_location_in)) {}

AXLocationChange::~AXLocationChange() = default;

void AXLocationChange::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_location"), this->new_location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::AXRelativeBounds>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AXLocationChange::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AXScrollChange::AXScrollChange()
    : id(),
      scroll_x(),
      scroll_y() {}

AXScrollChange::AXScrollChange(
    int32_t id_in,
    int32_t scroll_x_in,
    int32_t scroll_y_in)
    : id(std::move(id_in)),
      scroll_x(std::move(scroll_x_in)),
      scroll_y(std::move(scroll_y_in)) {}

AXScrollChange::~AXScrollChange() = default;
size_t AXScrollChange::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->id);
  seed = mojo::internal::WTFHash(seed, this->scroll_x);
  seed = mojo::internal::WTFHash(seed, this->scroll_y);
  return seed;
}

void AXScrollChange::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_x"), this->scroll_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_y"), this->scroll_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AXScrollChange::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AXLocationAndScrollUpdates::AXLocationAndScrollUpdates()
    : location_changes(),
      scroll_changes() {}

AXLocationAndScrollUpdates::AXLocationAndScrollUpdates(
    ::blink::Vector<AXLocationChangePtr> location_changes_in,
    ::blink::Vector<AXScrollChangePtr> scroll_changes_in)
    : location_changes(std::move(location_changes_in)),
      scroll_changes(std::move(scroll_changes_in)) {}

AXLocationAndScrollUpdates::~AXLocationAndScrollUpdates() = default;

void AXLocationAndScrollUpdates::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location_changes"), this->location_changes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<AXLocationChangePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_changes"), this->scroll_changes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<AXScrollChangePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AXLocationAndScrollUpdates::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // ax::mojom::blink


namespace mojo {


// static
bool StructTraits<::ax::mojom::blink::AXLocationChange::DataView, ::ax::mojom::blink::AXLocationChangePtr>::Read(
    ::ax::mojom::blink::AXLocationChange::DataView input,
    ::ax::mojom::blink::AXLocationChangePtr* output) {
  bool success = true;
  ::ax::mojom::blink::AXLocationChangePtr result(::ax::mojom::blink::AXLocationChange::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadNewLocation(&result->new_location))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ax::mojom::blink::AXScrollChange::DataView, ::ax::mojom::blink::AXScrollChangePtr>::Read(
    ::ax::mojom::blink::AXScrollChange::DataView input,
    ::ax::mojom::blink::AXScrollChangePtr* output) {
  bool success = true;
  ::ax::mojom::blink::AXScrollChangePtr result(::ax::mojom::blink::AXScrollChange::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->scroll_x = input.scroll_x();
      if (success)
        result->scroll_y = input.scroll_y();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ax::mojom::blink::AXLocationAndScrollUpdates::DataView, ::ax::mojom::blink::AXLocationAndScrollUpdatesPtr>::Read(
    ::ax::mojom::blink::AXLocationAndScrollUpdates::DataView input,
    ::ax::mojom::blink::AXLocationAndScrollUpdatesPtr* output) {
  bool success = true;
  ::ax::mojom::blink::AXLocationAndScrollUpdatesPtr result(::ax::mojom::blink::AXLocationAndScrollUpdates::New());
  
      if (success && !input.ReadLocationChanges(&result->location_changes))
        success = false;
      if (success && !input.ReadScrollChanges(&result->scroll_changes))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ax::mojom::blink {




}  // ax::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif