// ui/accessibility/mojom/ax_event.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_EVENT_MOJOM_DATA_VIEW_H_
#define UI_ACCESSIBILITY_MOJOM_AX_EVENT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/accessibility/mojom/ax_event.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_event_intent.mojom-shared.h"


namespace ax::mojom {
class AXEventDataView;



}  // ax::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXEventDataView> {
  using Data = ::ax::mojom::internal::AXEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax::mojom {


class AXEventDataView {
 public:
  AXEventDataView() = default;

  AXEventDataView(
      internal::AXEvent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadEventType(UserType* output) const {
    auto data_value = data_->event_type;
    return mojo::internal::Deserialize<::ax::mojom::Event>(
        data_value, output);
  }
  ::ax::mojom::Event event_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::Event>(data_->event_type));
  }
  int32_t id() const {
    return data_->id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEventFrom(UserType* output) const {
    auto data_value = data_->event_from;
    return mojo::internal::Deserialize<::ax::mojom::EventFrom>(
        data_value, output);
  }
  ::ax::mojom::EventFrom event_from() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::EventFrom>(data_->event_from));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEventFromAction(UserType* output) const {
    auto data_value = data_->event_from_action;
    return mojo::internal::Deserialize<::ax::mojom::Action>(
        data_value, output);
  }
  ::ax::mojom::Action event_from_action() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::Action>(data_->event_from_action));
  }
  inline void GetEventIntentsDataView(
      mojo::ArrayDataView<::ax::mojom::EventIntentDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventIntents(UserType* output) {
    
    auto* pointer = data_->event_intents.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::EventIntentDataView>>(
        pointer, output, message_);
  }
  int32_t action_request_id() const {
    return data_->action_request_id;
  }
 private:
  internal::AXEvent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ax::mojom

#endif  // UI_ACCESSIBILITY_MOJOM_AX_EVENT_MOJOM_DATA_VIEW_H_