import*as e from"../../core/common/common.js";import*as t from"../../core/host/host.js";import*as r from"../../core/i18n/i18n.js";import*as o from"../../core/platform/platform.js";import*as i from"../../core/sdk/sdk.js";import*as s from"../../ui/legacy/legacy.js";import*as a from"../../ui/legacy/theme_support/theme_support.js";import{Directives as n,render as l,html as c}from"../../ui/lit/lit.js";import*as h from"../../ui/visual_logging/visual_logging.js";var d=`:host{overflow:hidden;--override-color-perf-monitor-cpu:var(--sys-color-yellow-bright);--override-color-perf-monitor-cpu-task-duration:var(--sys-color-neutral-bright);--override-color-perf-monitor-cpu-script-duration:var(--sys-color-yellow-bright);--override-color-perf-monitor-cpu-layout-duration:var(--sys-color-purple);--override-color-perf-monitor-cpu-recalc-style-duration:var(--sys-color-purple-bright);--override-color-perf-monitor-jsheap:var(--sys-color-purple-bright);--override-color-perf-monitor-jsheap-total-size:var(--ref-palette-purple70);--override-color-perf-monitor-jsheap-used-size:var(--sys-color-purple-bright);--override-color-perf-monitor-dom-nodes:var(--sys-color-green);--override-color-perf-monitor-js-event-listeners:var(--ref-palette-green80);--override-color-perf-monitor-documents:var(--sys-color-blue);--override-color-perf-monitor-document-frames:var(--sys-color-cyan-bright);--override-color-perf-monitor-layout-count:var(--sys-color-pink-bright);--override-color-perf-monitor-recalc-style-count:var(--sys-color-pink)}:host-context(.theme-with-dark-background){--override-color-perf-monitor-jsheap-total-size:var(--ref-palette-purple50);--override-color-perf-monitor-js-event-listeners:var(--ref-palette-green50)}.suspended{opacity:40%;pointer-events:none}.perfmon-chart-suspend-overlay{display:flex;font-size:26px;align-items:center;justify-content:center}.perfmon-control-pane{display:flex;flex:initial;flex-direction:column;padding:6px 0;overflow:hidden auto}.perfmon-chart-container{display:flex;flex:1 1;border-left:1px solid var(--sys-color-divider);overflow-y:auto}.perfmon-chart-container canvas{width:100%}.perfmon-indicator{padding:3px 9px;margin:-1px 0;display:flex;flex-shrink:0;width:210px}.perfmon-indicator span{flex:0 0 135px}.perfmon-indicator-value{flex:0 0 55px;text-align:right;overflow:visible;align-self:center;margin-left:auto}.perfmon-indicator:not(.active) .perfmon-indicator-value{opacity:0%}\n/*# sourceURL=${import.meta.resolve("./performanceMonitor.css")} */`;const m={graphsDisplayingARealtimeViewOf:"Graphs displaying a real-time view of performance metrics",paused:"Paused",cpuUsage:"CPU usage",jsHeapSize:"JS heap size",domNodes:"DOM Nodes",jsEventListeners:"JS event listeners",documents:"Documents",documentFrames:"Document Frames",layoutsSec:"Layouts / sec",styleRecalcsSec:"Style recalcs / sec"},p=r.i18n.registerUIStrings("panels/performance_monitor/PerformanceMonitor.ts",m),u=r.i18n.getLocalizedString.bind(void 0,p),{widgetConfig:g}=s.Widget,{classMap:f,ref:v}=n,C=(e,t,r)=>{l(c`
    <devtools-widget .widgetConfig=${g(x,{onMetricChanged:e.onMetricChanged,chartsInfo:e.chartsInfo,metrics:e.metrics})} class=${f({suspended:e.suspended})}></devtools-widget>
    <div class="perfmon-chart-container ${f({suspended:e.suspended})}">
      <canvas tabindex="-1" aria-label=${u(m.graphsDisplayingARealtimeViewOf)}
          .width=${Math.round(e.width*window.devicePixelRatio)} .height=${e.height}
          style="height:${e.height/window.devicePixelRatio}px" ${v(e=>{if(e){const r=e;t.graphRenderingContext=r.getContext("2d"),t.width=r.offsetWidth}})}>
      </canvas>
    </div>
    ${e.suspended?c`
      <div class="perfmon-chart-suspend-overlay fill">
        <div>${u(m.paused)}</div>
      </div>`:""}`,r)};class w extends s.Widget.HBox{view;chartInfos=[];activeCharts=new Set;metricsBuffer;pixelsPerMs;pollIntervalMs;scaleHeight;graphHeight;gridColor;animationId;width;height;model;pollTimer;metrics;suspended=!1;graphRenderingContext=null;constructor(e=500,t=C){super({jslog:`${h.panel("performance.monitor").track({resize:!0})}`,useShadowDom:!0}),this.view=t,this.registerRequiredCSS(d),this.metricsBuffer=[],this.pixelsPerMs=.01,this.pollIntervalMs=e,this.scaleHeight=16,this.graphHeight=90,this.gridColor=a.ThemeSupport.instance().getComputedValue("--divider-line"),i.TargetManager.TargetManager.instance().observeModels(i.PerformanceMetricsModel.PerformanceMetricsModel,this)}onMetricStateChanged(e,t){t?this.activeCharts.add(e):this.activeCharts.delete(e),this.recalcChartHeight()}wasShown(){if(!this.model)return;this.chartInfos=this.createChartInfos();a.ThemeSupport.instance().addEventListener(a.ThemeChangeEvent.eventName,()=>{this.chartInfos=this.createChartInfos(),this.requestUpdate()}),i.TargetManager.TargetManager.instance().addEventListener("SuspendStateChanged",this.suspendStateChanged,this),this.model.enable(),this.suspendStateChanged(),this.requestUpdate()}willHide(){this.model&&(i.TargetManager.TargetManager.instance().removeEventListener("SuspendStateChanged",this.suspendStateChanged,this),this.stopPolling(),this.model.disable())}performUpdate(){const e={onMetricChanged:this.onMetricStateChanged.bind(this),chartsInfo:this.chartInfos,metrics:this.metrics,width:this.width,height:this.height,suspended:this.suspended},t={graphRenderingContext:null,width:0};this.view(e,t,this.contentElement),this.graphRenderingContext=t.graphRenderingContext,this.width=t.width,this.draw()}modelAdded(e){e.target()===i.TargetManager.TargetManager.instance().primaryPageTarget()&&(this.model=e,this.isShowing()&&this.wasShown())}modelRemoved(e){this.model===e&&(this.isShowing()&&this.willHide(),this.model=null)}suspendStateChanged(){const e=i.TargetManager.TargetManager.instance().allTargetsSuspended();e?this.stopPolling():this.startPolling(),this.suspended=e,this.requestUpdate()}startPolling(){this.pollTimer=window.setInterval(()=>this.poll(),this.pollIntervalMs),this.onResize();const e=()=>{this.draw(),this.animationId=this.contentElement.window().requestAnimationFrame(()=>{e()})};e()}stopPolling(){window.clearInterval(this.pollTimer),this.contentElement.window().cancelAnimationFrame(this.animationId),this.metricsBuffer=[]}async poll(){if(!this.model)return;const e=await this.model.requestMetrics(),t=e.timestamp,r=e.metrics;this.metricsBuffer.push({timestamp:t,metrics:r});const o=this.width/this.pixelsPerMs,i=Math.ceil(o/this.pollIntervalMs*2);this.metricsBuffer.length>2*i&&this.metricsBuffer.splice(0,this.metricsBuffer.length-i),this.metrics=r,this.requestUpdate()}draw(){if(!this.graphRenderingContext)return;const e=this.graphRenderingContext;e.save(),e.scale(window.devicePixelRatio,window.devicePixelRatio),e.clearRect(0,0,this.width,this.height),e.save(),e.translate(0,this.scaleHeight);for(const t of this.chartInfos)this.activeCharts.has(t.metrics[0].name)&&(this.drawChart(e,t,this.graphHeight),e.translate(0,this.graphHeight));e.restore(),this.drawHorizontalGrid(e),e.restore()}drawHorizontalGrid(e){const r=a.ThemeSupport.instance().getComputedValue("--color-background-inverted-opacity-2");e.font="10px "+t.Platform.fontFamily(),e.fillStyle=a.ThemeSupport.instance().getComputedValue("--color-background-inverted-opacity-50");const o=Date.now()/1e3;for(let t=Math.ceil(o);;--t){const i=this.width-(1e3*(o-t)-this.pollIntervalMs)*this.pixelsPerMs;if(i<-50)break;e.beginPath(),e.moveTo(i,0),e.lineTo(i,this.height),t>=0&&t%10==0&&e.fillText(new Date(1e3*t).toLocaleTimeString(),i+4,12),e.strokeStyle=t%10?r:this.gridColor,e.stroke()}}drawChart(r,o,i){r.save(),r.rect(0,0,this.width,i),r.clip();const s=1.05*this.calcMax(o),n=o.stacked?new Map:null,l=[];for(let e=o.metrics.length-1;e>=0;--e){const t=o.metrics[e];l.push({path:this.buildMetricPath(o,t,i-8,s,e?n:null),color:t.color})}const c=e.Color.parse(a.ThemeSupport.instance().getComputedValue("--sys-color-cdt-base-container"))?.asLegacyColor();if(c)for(const t of l.reverse()){const o=t.color;r.save();const i=e.Color.parse(o);i&&(r.fillStyle=c.blendWith(i.setAlpha(.2).asLegacyColor()).asString()||"",r.fill(t.path),r.strokeStyle=o,r.lineWidth=.5,r.stroke(t.path),r.restore())}r.fillStyle=a.ThemeSupport.instance().getComputedValue("--color-background-inverted-opacity-50"),r.font=`10px  ${t.Platform.fontFamily()}`,r.fillText(o.title,8,10),this.drawVerticalGrid(r,i-8,s,o),r.restore()}calcMax(e){if(e.max)return e.max;const t=this.width,r=performance.now()-this.pollIntervalMs-t/this.pixelsPerMs;let o=-1/0;for(const t of e.metrics)for(let e=this.metricsBuffer.length-1;e>=0;--e){const i=this.metricsBuffer[e],s=i.metrics.get(t.name);if(void 0!==s&&(o=Math.max(o,s)),i.timestamp<r)break}if(!this.metricsBuffer.length)return 10;const i=Math.pow(10,Math.floor(Math.log10(o)));o=Math.ceil(o/i/2)*i*2;return e.currentMax=.2*o+.8*(e.currentMax||o),e.currentMax}drawVerticalGrid(e,t,r,o){let i=Math.pow(10,Math.floor(Math.log10(r)));const s=Math.floor(r/i);1!==s&&s%2==1&&(i*=2);let n=Math.floor(r/i)*i;const l=r,c=t-18;e.fillStyle=a.ThemeSupport.instance().getComputedValue("--color-background-inverted-opacity-50"),e.strokeStyle=this.gridColor,e.beginPath();for(let t=0;t<2;++t){const t=h(n),r=b(n,o);e.moveTo(0,t),e.lineTo(4,t),e.moveTo(e.measureText(r).width+12,t),e.lineTo(this.width,t),e.fillText(r,8,h(n)+3),n/=2}function h(e){return Math.round(t-c*e/l)+.5}e.stroke(),e.beginPath(),e.moveTo(0,t+.5),e.lineTo(this.width,t+.5),e.strokeStyle=a.ThemeSupport.instance().getComputedValue("--color-background-inverted-opacity-2"),e.stroke()}buildMetricPath(e,t,r,i,s){const a=new Path2D,n=r-18;if(n<1)return a;const l=i,c=t.name,h=this.pixelsPerMs,d=performance.now()-this.pollIntervalMs-this.width/h,m=e.smooth;let p=0,u=0,g=0;this.metricsBuffer.length&&(p=(this.metricsBuffer[0].timestamp-d)*h,a.moveTo(p,f(0)),a.lineTo(this.width+5,f(0)),u=f(this.metricsBuffer[this.metricsBuffer.length-1].metrics.get(c)||0),g=this.width+5,a.lineTo(g,u));for(let e=this.metricsBuffer.length-1;e>=0;--e){const t=this.metricsBuffer[e],r=t.timestamp;let i=t.metrics.get(c)||0;s&&(i+=s.get(r)||0,i=o.NumberUtilities.clamp(i,0,1),s.set(r,i));const n=f(i);if(p=(r-d)*h,m){const e=(g+p)/2;a.bezierCurveTo(e,u,e,n,p,n)}else a.lineTo(p,u),a.lineTo(p,n);if(g=p,u=n,r<d)break}return a;function f(e){return Math.round(r-n*e/l)+.5}}onResize(){super.onResize(),this.recalcChartHeight()}recalcChartHeight(){let e=this.scaleHeight;for(const t of this.chartInfos)this.activeCharts.has(t.metrics[0].name)&&(e+=this.graphHeight);this.height=Math.ceil(e*window.devicePixelRatio),this.requestUpdate()}createChartInfos(){const e=a.ThemeSupport.instance(),t=this.contentElement,r={color:void 0,format:void 0,currentMax:void 0,max:void 0,smooth:void 0,stacked:void 0};return[{...r,title:u(m.cpuUsage),metrics:[{name:"TaskDuration",color:e.getComputedValue("--override-color-perf-monitor-cpu-task-duration",t)},{name:"ScriptDuration",color:e.getComputedValue("--override-color-perf-monitor-cpu-script-duration",t)},{name:"LayoutDuration",color:e.getComputedValue("--override-color-perf-monitor-cpu-layout-duration",t)},{name:"RecalcStyleDuration",color:e.getComputedValue("--override-color-perf-monitor-cpu-recalc-style-duration",t)}],format:"Percent",smooth:!0,stacked:!0,color:e.getComputedValue("--override-color-perf-monitor-cpu",t),max:1,currentMax:void 0},{...r,title:u(m.jsHeapSize),metrics:[{name:"JSHeapTotalSize",color:e.getComputedValue("--override-color-perf-monitor-jsheap-total-size",t)},{name:"JSHeapUsedSize",color:e.getComputedValue("--override-color-perf-monitor-jsheap-used-size",t)}],format:"Bytes",color:e.getComputedValue("--override-color-perf-monitor-jsheap",t)},{...r,title:u(m.domNodes),metrics:[{name:"Nodes",color:e.getComputedValue("--override-color-perf-monitor-dom-nodes",t)}]},{...r,title:u(m.jsEventListeners),metrics:[{name:"JSEventListeners",color:e.getComputedValue("--override-color-perf-monitor-js-event-listeners",t)}]},{...r,title:u(m.documents),metrics:[{name:"Documents",color:e.getComputedValue("--override-color-perf-monitor-documents",t)}]},{...r,title:u(m.documentFrames),metrics:[{name:"Frames",color:e.getComputedValue("--override-color-perf-monitor-document-frames",t)}]},{...r,title:u(m.layoutsSec),metrics:[{name:"LayoutCount",color:e.getComputedValue("--override-color-perf-monitor-layout-count",t)}]},{...r,title:u(m.styleRecalcsSec),metrics:[{name:"RecalcStyleCount",color:e.getComputedValue("--override-color-perf-monitor-recalc-style-count",t)}]}]}}const y=(e,t,r)=>{l(e.chartsInfo.map(t=>{const r=t.metrics[0].name;return function(e,t,r,i){const s=e.color||e.metrics[0].color,a=e.metrics[0].name;return c`
      <div class="perfmon-indicator ${t?"active":""}" jslog=${h.toggle().track({click:!0,keydown:"Enter"}).context(o.StringUtilities.toKebabCase(a))}>
        <devtools-checkbox .checked=${t}
            @change=${i} .jslogContext=${a}>${e.title}</devtools-checkbox>
        <div class="perfmon-indicator-value" style="color:${s}">${b(r,e)}</div>
      </div>
    `}(t,e.enabledCharts.has(r),e.metricValues.get(r)||0,t=>e.onCheckboxChange(r,t))}),r)};class x extends s.Widget.VBox{#e;#t;#r=null;#o=[];#i=new Map;#s;constructor(t,r=y){super(t,{useShadowDom:!1,classes:["perfmon-control-pane"]}),this.#s=r,this.#e=e.Settings.Settings.instance().createSetting("perfmon-active-indicators2",["TaskDuration","JSHeapTotalSize","Nodes"]),this.#t=new Set(this.#e.get())}set chartsInfo(e){this.#o=e,this.requestUpdate()}set onMetricChanged(e){this.#r=e;for(const t of this.#t)e(t,!0)}performUpdate(){const e={chartsInfo:this.#o,enabledCharts:this.#t,metricValues:this.#i,onCheckboxChange:this.#a.bind(this)};this.#s(e,{},this.element)}#a(e,t){this.#n(e,t.target.checked),this.requestUpdate()}#n(e,t){t?this.#t.add(e):this.#t.delete(e),this.#e.set(Array.from(this.#t)),this.#r&&this.#r(e,t)}set metrics(e){if(e){for(const[t,r]of e.entries())this.#i.set(t,r);this.requestUpdate()}}}let S,M;function b(e,t){switch(S||(S=new Intl.NumberFormat("en-US",{maximumFractionDigits:1}),M=new Intl.NumberFormat("en-US",{maximumFractionDigits:1,style:"percent"})),t.format){case"Percent":return M.format(e);case"Bytes":return r.ByteUtilities.bytesToString(e);default:return S.format(e)}}const T=new Intl.NumberFormat("en-US",{maximumFractionDigits:1});var k=Object.freeze({__proto__:null,ControlPane:x,PerformanceMonitorImpl:w,format:T,formatNumber:b});export{k as PerformanceMonitor};
//# sourceMappingURL=performance_monitor.js.map
