// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/web_audio.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace WebAudio {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "WebAudio";
const char Metainfo::commandPrefix[] = "WebAudio.";
const char Metainfo::version[] = "1.3";


namespace ContextTypeEnum {
const char Realtime[] = "realtime";
const char Offline[] = "offline";
} // namespace ContextTypeEnum


namespace ContextStateEnum {
const char Suspended[] = "suspended";
const char Running[] = "running";
const char Closed[] = "closed";
const char Interrupted[] = "interrupted";
} // namespace ContextStateEnum



namespace ChannelCountModeEnum {
const char ClampedMax[] = "clamped-max";
const char Explicit[] = "explicit";
const char Max[] = "max";
} // namespace ChannelCountModeEnum


namespace ChannelInterpretationEnum {
const char Discrete[] = "discrete";
const char Speakers[] = "speakers";
} // namespace ChannelInterpretationEnum



namespace AutomationRateEnum {
const char ARate[] = "a-rate";
const char KRate[] = "k-rate";
} // namespace AutomationRateEnum


CRDTP_BEGIN_DESERIALIZER(ContextRealtimeData)
    CRDTP_DESERIALIZE_FIELD("callbackIntervalMean", m_callbackIntervalMean),
    CRDTP_DESERIALIZE_FIELD("callbackIntervalVariance", m_callbackIntervalVariance),
    CRDTP_DESERIALIZE_FIELD("currentTime", m_currentTime),
    CRDTP_DESERIALIZE_FIELD("renderCapacity", m_renderCapacity),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ContextRealtimeData)
    CRDTP_SERIALIZE_FIELD("currentTime", m_currentTime);
    CRDTP_SERIALIZE_FIELD("renderCapacity", m_renderCapacity);
    CRDTP_SERIALIZE_FIELD("callbackIntervalMean", m_callbackIntervalMean);
    CRDTP_SERIALIZE_FIELD("callbackIntervalVariance", m_callbackIntervalVariance);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(BaseAudioContext)
    CRDTP_DESERIALIZE_FIELD("callbackBufferSize", m_callbackBufferSize),
    CRDTP_DESERIALIZE_FIELD("contextId", m_contextId),
    CRDTP_DESERIALIZE_FIELD("contextState", m_contextState),
    CRDTP_DESERIALIZE_FIELD("contextType", m_contextType),
    CRDTP_DESERIALIZE_FIELD("maxOutputChannelCount", m_maxOutputChannelCount),
    CRDTP_DESERIALIZE_FIELD_OPT("realtimeData", m_realtimeData),
    CRDTP_DESERIALIZE_FIELD("sampleRate", m_sampleRate),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BaseAudioContext)
    CRDTP_SERIALIZE_FIELD("contextId", m_contextId);
    CRDTP_SERIALIZE_FIELD("contextType", m_contextType);
    CRDTP_SERIALIZE_FIELD("contextState", m_contextState);
    CRDTP_SERIALIZE_FIELD("realtimeData", m_realtimeData);
    CRDTP_SERIALIZE_FIELD("callbackBufferSize", m_callbackBufferSize);
    CRDTP_SERIALIZE_FIELD("maxOutputChannelCount", m_maxOutputChannelCount);
    CRDTP_SERIALIZE_FIELD("sampleRate", m_sampleRate);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AudioListener)
    CRDTP_DESERIALIZE_FIELD("contextId", m_contextId),
    CRDTP_DESERIALIZE_FIELD("listenerId", m_listenerId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AudioListener)
    CRDTP_SERIALIZE_FIELD("listenerId", m_listenerId);
    CRDTP_SERIALIZE_FIELD("contextId", m_contextId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AudioNode)
    CRDTP_DESERIALIZE_FIELD("channelCount", m_channelCount),
    CRDTP_DESERIALIZE_FIELD("channelCountMode", m_channelCountMode),
    CRDTP_DESERIALIZE_FIELD("channelInterpretation", m_channelInterpretation),
    CRDTP_DESERIALIZE_FIELD("contextId", m_contextId),
    CRDTP_DESERIALIZE_FIELD("nodeId", m_nodeId),
    CRDTP_DESERIALIZE_FIELD("nodeType", m_nodeType),
    CRDTP_DESERIALIZE_FIELD("numberOfInputs", m_numberOfInputs),
    CRDTP_DESERIALIZE_FIELD("numberOfOutputs", m_numberOfOutputs),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AudioNode)
    CRDTP_SERIALIZE_FIELD("nodeId", m_nodeId);
    CRDTP_SERIALIZE_FIELD("contextId", m_contextId);
    CRDTP_SERIALIZE_FIELD("nodeType", m_nodeType);
    CRDTP_SERIALIZE_FIELD("numberOfInputs", m_numberOfInputs);
    CRDTP_SERIALIZE_FIELD("numberOfOutputs", m_numberOfOutputs);
    CRDTP_SERIALIZE_FIELD("channelCount", m_channelCount);
    CRDTP_SERIALIZE_FIELD("channelCountMode", m_channelCountMode);
    CRDTP_SERIALIZE_FIELD("channelInterpretation", m_channelInterpretation);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AudioParam)
    CRDTP_DESERIALIZE_FIELD("contextId", m_contextId),
    CRDTP_DESERIALIZE_FIELD("defaultValue", m_defaultValue),
    CRDTP_DESERIALIZE_FIELD("maxValue", m_maxValue),
    CRDTP_DESERIALIZE_FIELD("minValue", m_minValue),
    CRDTP_DESERIALIZE_FIELD("nodeId", m_nodeId),
    CRDTP_DESERIALIZE_FIELD("paramId", m_paramId),
    CRDTP_DESERIALIZE_FIELD("paramType", m_paramType),
    CRDTP_DESERIALIZE_FIELD("rate", m_rate),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AudioParam)
    CRDTP_SERIALIZE_FIELD("paramId", m_paramId);
    CRDTP_SERIALIZE_FIELD("nodeId", m_nodeId);
    CRDTP_SERIALIZE_FIELD("contextId", m_contextId);
    CRDTP_SERIALIZE_FIELD("paramType", m_paramType);
    CRDTP_SERIALIZE_FIELD("rate", m_rate);
    CRDTP_SERIALIZE_FIELD("defaultValue", m_defaultValue);
    CRDTP_SERIALIZE_FIELD("minValue", m_minValue);
    CRDTP_SERIALIZE_FIELD("maxValue", m_maxValue);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::contextCreated(std::unique_ptr<protocol::WebAudio::BaseAudioContext> context)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("context"), context);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("WebAudio.contextCreated", serializer.Finish()));
}

void Frontend::contextWillBeDestroyed(const String& contextId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("contextId"), contextId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("WebAudio.contextWillBeDestroyed", serializer.Finish()));
}

void Frontend::contextChanged(std::unique_ptr<protocol::WebAudio::BaseAudioContext> context)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("context"), context);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("WebAudio.contextChanged", serializer.Finish()));
}

void Frontend::audioListenerCreated(std::unique_ptr<protocol::WebAudio::AudioListener> listener)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("listener"), listener);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("WebAudio.audioListenerCreated", serializer.Finish()));
}

void Frontend::audioListenerWillBeDestroyed(const String& contextId, const String& listenerId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("contextId"), contextId);
    serializer.AddField(crdtp::MakeSpan("listenerId"), listenerId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("WebAudio.audioListenerWillBeDestroyed", serializer.Finish()));
}

void Frontend::audioNodeCreated(std::unique_ptr<protocol::WebAudio::AudioNode> node)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("node"), node);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("WebAudio.audioNodeCreated", serializer.Finish()));
}

void Frontend::audioNodeWillBeDestroyed(const String& contextId, const String& nodeId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("contextId"), contextId);
    serializer.AddField(crdtp::MakeSpan("nodeId"), nodeId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("WebAudio.audioNodeWillBeDestroyed", serializer.Finish()));
}

void Frontend::audioParamCreated(std::unique_ptr<protocol::WebAudio::AudioParam> param)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("param"), param);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("WebAudio.audioParamCreated", serializer.Finish()));
}

void Frontend::audioParamWillBeDestroyed(const String& contextId, const String& nodeId, const String& paramId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("contextId"), contextId);
    serializer.AddField(crdtp::MakeSpan("nodeId"), nodeId);
    serializer.AddField(crdtp::MakeSpan("paramId"), paramId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("WebAudio.audioParamWillBeDestroyed", serializer.Finish()));
}

void Frontend::nodesConnected(const String& contextId, const String& sourceId, const String& destinationId, std::optional<double> sourceOutputIndex, std::optional<double> destinationInputIndex)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("contextId"), contextId);
    serializer.AddField(crdtp::MakeSpan("sourceId"), sourceId);
    serializer.AddField(crdtp::MakeSpan("destinationId"), destinationId);
    serializer.AddField(crdtp::MakeSpan("sourceOutputIndex"), sourceOutputIndex);
    serializer.AddField(crdtp::MakeSpan("destinationInputIndex"), destinationInputIndex);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("WebAudio.nodesConnected", serializer.Finish()));
}

void Frontend::nodesDisconnected(const String& contextId, const String& sourceId, const String& destinationId, std::optional<double> sourceOutputIndex, std::optional<double> destinationInputIndex)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("contextId"), contextId);
    serializer.AddField(crdtp::MakeSpan("sourceId"), sourceId);
    serializer.AddField(crdtp::MakeSpan("destinationId"), destinationId);
    serializer.AddField(crdtp::MakeSpan("sourceOutputIndex"), sourceOutputIndex);
    serializer.AddField(crdtp::MakeSpan("destinationInputIndex"), destinationInputIndex);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("WebAudio.nodesDisconnected", serializer.Finish()));
}

void Frontend::nodeParamConnected(const String& contextId, const String& sourceId, const String& destinationId, std::optional<double> sourceOutputIndex)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("contextId"), contextId);
    serializer.AddField(crdtp::MakeSpan("sourceId"), sourceId);
    serializer.AddField(crdtp::MakeSpan("destinationId"), destinationId);
    serializer.AddField(crdtp::MakeSpan("sourceOutputIndex"), sourceOutputIndex);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("WebAudio.nodeParamConnected", serializer.Finish()));
}

void Frontend::nodeParamDisconnected(const String& contextId, const String& sourceId, const String& destinationId, std::optional<double> sourceOutputIndex)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("contextId"), contextId);
    serializer.AddField(crdtp::MakeSpan("sourceId"), sourceId);
    serializer.AddField(crdtp::MakeSpan("destinationId"), destinationId);
    serializer.AddField(crdtp::MakeSpan("sourceOutputIndex"), sourceOutputIndex);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("WebAudio.nodeParamDisconnected", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void enable(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
    void getRealtimeData(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("getRealtimeData"),
          &DomainDispatcherImpl::getRealtimeData
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("WebAudio.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("WebAudio.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getRealtimeDataParams : public crdtp::DeserializableProtocolObject<getRealtimeDataParams> {
    String contextId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getRealtimeDataParams)
    CRDTP_DESERIALIZE_FIELD("contextId", contextId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getRealtimeData(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getRealtimeDataParams params;
    if (!getRealtimeDataParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::WebAudio::ContextRealtimeData> out_realtimeData;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getRealtimeData(params.contextId, &out_realtimeData);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("WebAudio.getRealtimeData"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("realtimeData"), out_realtimeData);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("WebAudio"), SortedRedirects(), std::move(dispatcher));
}

} // WebAudio
} // namespace blink
} // namespace protocol
