// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/preload.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace Preload {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Preload";
const char Metainfo::commandPrefix[] = "Preload.";
const char Metainfo::version[] = "1.3";


CRDTP_BEGIN_DESERIALIZER(RuleSet)
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", m_backendNodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("errorMessage", m_errorMessage),
    CRDTP_DESERIALIZE_FIELD_OPT("errorType", m_errorType),
    CRDTP_DESERIALIZE_FIELD("id", m_id),
    CRDTP_DESERIALIZE_FIELD("loaderId", m_loaderId),
    CRDTP_DESERIALIZE_FIELD_OPT("requestId", m_requestId),
    CRDTP_DESERIALIZE_FIELD("sourceText", m_sourceText),
    CRDTP_DESERIALIZE_FIELD_OPT("tag", m_tag),
    CRDTP_DESERIALIZE_FIELD_OPT("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(RuleSet)
    CRDTP_SERIALIZE_FIELD("id", m_id);
    CRDTP_SERIALIZE_FIELD("loaderId", m_loaderId);
    CRDTP_SERIALIZE_FIELD("sourceText", m_sourceText);
    CRDTP_SERIALIZE_FIELD("backendNodeId", m_backendNodeId);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("requestId", m_requestId);
    CRDTP_SERIALIZE_FIELD("errorType", m_errorType);
    CRDTP_SERIALIZE_FIELD("errorMessage", m_errorMessage);
    CRDTP_SERIALIZE_FIELD("tag", m_tag);
CRDTP_END_SERIALIZER();


namespace RuleSetErrorTypeEnum {
const char SourceIsNotJsonObject[] = "SourceIsNotJsonObject";
const char InvalidRulesSkipped[] = "InvalidRulesSkipped";
const char InvalidRulesetLevelTag[] = "InvalidRulesetLevelTag";
} // namespace RuleSetErrorTypeEnum


namespace SpeculationActionEnum {
const char Prefetch[] = "Prefetch";
const char Prerender[] = "Prerender";
} // namespace SpeculationActionEnum


namespace SpeculationTargetHintEnum {
const char Blank[] = "Blank";
const char Self[] = "Self";
} // namespace SpeculationTargetHintEnum


CRDTP_BEGIN_DESERIALIZER(PreloadingAttemptKey)
    CRDTP_DESERIALIZE_FIELD("action", m_action),
    CRDTP_DESERIALIZE_FIELD("loaderId", m_loaderId),
    CRDTP_DESERIALIZE_FIELD_OPT("targetHint", m_targetHint),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PreloadingAttemptKey)
    CRDTP_SERIALIZE_FIELD("loaderId", m_loaderId);
    CRDTP_SERIALIZE_FIELD("action", m_action);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("targetHint", m_targetHint);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(PreloadingAttemptSource)
    CRDTP_DESERIALIZE_FIELD("key", m_key),
    CRDTP_DESERIALIZE_FIELD("nodeIds", m_nodeIds),
    CRDTP_DESERIALIZE_FIELD("ruleSetIds", m_ruleSetIds),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PreloadingAttemptSource)
    CRDTP_SERIALIZE_FIELD("key", m_key);
    CRDTP_SERIALIZE_FIELD("ruleSetIds", m_ruleSetIds);
    CRDTP_SERIALIZE_FIELD("nodeIds", m_nodeIds);
CRDTP_END_SERIALIZER();



namespace PrerenderFinalStatusEnum {
const char Activated[] = "Activated";
const char Destroyed[] = "Destroyed";
const char LowEndDevice[] = "LowEndDevice";
const char InvalidSchemeRedirect[] = "InvalidSchemeRedirect";
const char InvalidSchemeNavigation[] = "InvalidSchemeNavigation";
const char NavigationRequestBlockedByCsp[] = "NavigationRequestBlockedByCsp";
const char MojoBinderPolicy[] = "MojoBinderPolicy";
const char RendererProcessCrashed[] = "RendererProcessCrashed";
const char RendererProcessKilled[] = "RendererProcessKilled";
const char Download[] = "Download";
const char TriggerDestroyed[] = "TriggerDestroyed";
const char NavigationNotCommitted[] = "NavigationNotCommitted";
const char NavigationBadHttpStatus[] = "NavigationBadHttpStatus";
const char ClientCertRequested[] = "ClientCertRequested";
const char NavigationRequestNetworkError[] = "NavigationRequestNetworkError";
const char CancelAllHostsForTesting[] = "CancelAllHostsForTesting";
const char DidFailLoad[] = "DidFailLoad";
const char Stop[] = "Stop";
const char SslCertificateError[] = "SslCertificateError";
const char LoginAuthRequested[] = "LoginAuthRequested";
const char UaChangeRequiresReload[] = "UaChangeRequiresReload";
const char BlockedByClient[] = "BlockedByClient";
const char AudioOutputDeviceRequested[] = "AudioOutputDeviceRequested";
const char MixedContent[] = "MixedContent";
const char TriggerBackgrounded[] = "TriggerBackgrounded";
const char MemoryLimitExceeded[] = "MemoryLimitExceeded";
const char DataSaverEnabled[] = "DataSaverEnabled";
const char TriggerUrlHasEffectiveUrl[] = "TriggerUrlHasEffectiveUrl";
const char ActivatedBeforeStarted[] = "ActivatedBeforeStarted";
const char InactivePageRestriction[] = "InactivePageRestriction";
const char StartFailed[] = "StartFailed";
const char TimeoutBackgrounded[] = "TimeoutBackgrounded";
const char CrossSiteRedirectInInitialNavigation[] = "CrossSiteRedirectInInitialNavigation";
const char CrossSiteNavigationInInitialNavigation[] = "CrossSiteNavigationInInitialNavigation";
const char SameSiteCrossOriginRedirectNotOptInInInitialNavigation[] = "SameSiteCrossOriginRedirectNotOptInInInitialNavigation";
const char SameSiteCrossOriginNavigationNotOptInInInitialNavigation[] = "SameSiteCrossOriginNavigationNotOptInInInitialNavigation";
const char ActivationNavigationParameterMismatch[] = "ActivationNavigationParameterMismatch";
const char ActivatedInBackground[] = "ActivatedInBackground";
const char EmbedderHostDisallowed[] = "EmbedderHostDisallowed";
const char ActivationNavigationDestroyedBeforeSuccess[] = "ActivationNavigationDestroyedBeforeSuccess";
const char TabClosedByUserGesture[] = "TabClosedByUserGesture";
const char TabClosedWithoutUserGesture[] = "TabClosedWithoutUserGesture";
const char PrimaryMainFrameRendererProcessCrashed[] = "PrimaryMainFrameRendererProcessCrashed";
const char PrimaryMainFrameRendererProcessKilled[] = "PrimaryMainFrameRendererProcessKilled";
const char ActivationFramePolicyNotCompatible[] = "ActivationFramePolicyNotCompatible";
const char PreloadingDisabled[] = "PreloadingDisabled";
const char BatterySaverEnabled[] = "BatterySaverEnabled";
const char ActivatedDuringMainFrameNavigation[] = "ActivatedDuringMainFrameNavigation";
const char PreloadingUnsupportedByWebContents[] = "PreloadingUnsupportedByWebContents";
const char CrossSiteRedirectInMainFrameNavigation[] = "CrossSiteRedirectInMainFrameNavigation";
const char CrossSiteNavigationInMainFrameNavigation[] = "CrossSiteNavigationInMainFrameNavigation";
const char SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation[] = "SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation";
const char SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation[] = "SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation";
const char MemoryPressureOnTrigger[] = "MemoryPressureOnTrigger";
const char MemoryPressureAfterTriggered[] = "MemoryPressureAfterTriggered";
const char PrerenderingDisabledByDevTools[] = "PrerenderingDisabledByDevTools";
const char SpeculationRuleRemoved[] = "SpeculationRuleRemoved";
const char ActivatedWithAuxiliaryBrowsingContexts[] = "ActivatedWithAuxiliaryBrowsingContexts";
const char MaxNumOfRunningEagerPrerendersExceeded[] = "MaxNumOfRunningEagerPrerendersExceeded";
const char MaxNumOfRunningNonEagerPrerendersExceeded[] = "MaxNumOfRunningNonEagerPrerendersExceeded";
const char MaxNumOfRunningEmbedderPrerendersExceeded[] = "MaxNumOfRunningEmbedderPrerendersExceeded";
const char PrerenderingUrlHasEffectiveUrl[] = "PrerenderingUrlHasEffectiveUrl";
const char RedirectedPrerenderingUrlHasEffectiveUrl[] = "RedirectedPrerenderingUrlHasEffectiveUrl";
const char ActivationUrlHasEffectiveUrl[] = "ActivationUrlHasEffectiveUrl";
const char JavaScriptInterfaceAdded[] = "JavaScriptInterfaceAdded";
const char JavaScriptInterfaceRemoved[] = "JavaScriptInterfaceRemoved";
const char AllPrerenderingCanceled[] = "AllPrerenderingCanceled";
const char WindowClosed[] = "WindowClosed";
const char SlowNetwork[] = "SlowNetwork";
const char OtherPrerenderedPageActivated[] = "OtherPrerenderedPageActivated";
const char V8OptimizerDisabled[] = "V8OptimizerDisabled";
const char PrerenderFailedDuringPrefetch[] = "PrerenderFailedDuringPrefetch";
const char BrowsingDataRemoved[] = "BrowsingDataRemoved";
const char PrerenderHostReused[] = "PrerenderHostReused";
} // namespace PrerenderFinalStatusEnum


namespace PreloadingStatusEnum {
const char Pending[] = "Pending";
const char Running[] = "Running";
const char Ready[] = "Ready";
const char Success[] = "Success";
const char Failure[] = "Failure";
const char NotSupported[] = "NotSupported";
} // namespace PreloadingStatusEnum


namespace PrefetchStatusEnum {
const char PrefetchAllowed[] = "PrefetchAllowed";
const char PrefetchFailedIneligibleRedirect[] = "PrefetchFailedIneligibleRedirect";
const char PrefetchFailedInvalidRedirect[] = "PrefetchFailedInvalidRedirect";
const char PrefetchFailedMIMENotSupported[] = "PrefetchFailedMIMENotSupported";
const char PrefetchFailedNetError[] = "PrefetchFailedNetError";
const char PrefetchFailedNon2XX[] = "PrefetchFailedNon2XX";
const char PrefetchEvictedAfterBrowsingDataRemoved[] = "PrefetchEvictedAfterBrowsingDataRemoved";
const char PrefetchEvictedAfterCandidateRemoved[] = "PrefetchEvictedAfterCandidateRemoved";
const char PrefetchEvictedForNewerPrefetch[] = "PrefetchEvictedForNewerPrefetch";
const char PrefetchHeldback[] = "PrefetchHeldback";
const char PrefetchIneligibleRetryAfter[] = "PrefetchIneligibleRetryAfter";
const char PrefetchIsPrivacyDecoy[] = "PrefetchIsPrivacyDecoy";
const char PrefetchIsStale[] = "PrefetchIsStale";
const char PrefetchNotEligibleBrowserContextOffTheRecord[] = "PrefetchNotEligibleBrowserContextOffTheRecord";
const char PrefetchNotEligibleDataSaverEnabled[] = "PrefetchNotEligibleDataSaverEnabled";
const char PrefetchNotEligibleExistingProxy[] = "PrefetchNotEligibleExistingProxy";
const char PrefetchNotEligibleHostIsNonUnique[] = "PrefetchNotEligibleHostIsNonUnique";
const char PrefetchNotEligibleNonDefaultStoragePartition[] = "PrefetchNotEligibleNonDefaultStoragePartition";
const char PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy[] = "PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy";
const char PrefetchNotEligibleSchemeIsNotHttps[] = "PrefetchNotEligibleSchemeIsNotHttps";
const char PrefetchNotEligibleUserHasCookies[] = "PrefetchNotEligibleUserHasCookies";
const char PrefetchNotEligibleUserHasServiceWorker[] = "PrefetchNotEligibleUserHasServiceWorker";
const char PrefetchNotEligibleUserHasServiceWorkerNoFetchHandler[] = "PrefetchNotEligibleUserHasServiceWorkerNoFetchHandler";
const char PrefetchNotEligibleRedirectFromServiceWorker[] = "PrefetchNotEligibleRedirectFromServiceWorker";
const char PrefetchNotEligibleRedirectToServiceWorker[] = "PrefetchNotEligibleRedirectToServiceWorker";
const char PrefetchNotEligibleBatterySaverEnabled[] = "PrefetchNotEligibleBatterySaverEnabled";
const char PrefetchNotEligiblePreloadingDisabled[] = "PrefetchNotEligiblePreloadingDisabled";
const char PrefetchNotFinishedInTime[] = "PrefetchNotFinishedInTime";
const char PrefetchNotStarted[] = "PrefetchNotStarted";
const char PrefetchNotUsedCookiesChanged[] = "PrefetchNotUsedCookiesChanged";
const char PrefetchProxyNotAvailable[] = "PrefetchProxyNotAvailable";
const char PrefetchResponseUsed[] = "PrefetchResponseUsed";
const char PrefetchSuccessfulButNotUsed[] = "PrefetchSuccessfulButNotUsed";
const char PrefetchNotUsedProbeFailed[] = "PrefetchNotUsedProbeFailed";
} // namespace PrefetchStatusEnum


CRDTP_BEGIN_DESERIALIZER(PrerenderMismatchedHeaders)
    CRDTP_DESERIALIZE_FIELD_OPT("activationValue", m_activationValue),
    CRDTP_DESERIALIZE_FIELD("headerName", m_headerName),
    CRDTP_DESERIALIZE_FIELD_OPT("initialValue", m_initialValue),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PrerenderMismatchedHeaders)
    CRDTP_SERIALIZE_FIELD("headerName", m_headerName);
    CRDTP_SERIALIZE_FIELD("initialValue", m_initialValue);
    CRDTP_SERIALIZE_FIELD("activationValue", m_activationValue);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::ruleSetUpdated(std::unique_ptr<protocol::Preload::RuleSet> ruleSet)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("ruleSet"), ruleSet);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Preload.ruleSetUpdated", serializer.Finish()));
}

void Frontend::ruleSetRemoved(const String& id)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("id"), id);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Preload.ruleSetRemoved", serializer.Finish()));
}

void Frontend::preloadEnabledStateUpdated(bool disabledByPreference, bool disabledByDataSaver, bool disabledByBatterySaver, bool disabledByHoldbackPrefetchSpeculationRules, bool disabledByHoldbackPrerenderSpeculationRules)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("disabledByPreference"), disabledByPreference);
    serializer.AddField(crdtp::MakeSpan("disabledByDataSaver"), disabledByDataSaver);
    serializer.AddField(crdtp::MakeSpan("disabledByBatterySaver"), disabledByBatterySaver);
    serializer.AddField(crdtp::MakeSpan("disabledByHoldbackPrefetchSpeculationRules"), disabledByHoldbackPrefetchSpeculationRules);
    serializer.AddField(crdtp::MakeSpan("disabledByHoldbackPrerenderSpeculationRules"), disabledByHoldbackPrerenderSpeculationRules);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Preload.preloadEnabledStateUpdated", serializer.Finish()));
}

void Frontend::prefetchStatusUpdated(std::unique_ptr<protocol::Preload::PreloadingAttemptKey> key, const String& pipelineId, const String& initiatingFrameId, const String& prefetchUrl, const String& status, const String& prefetchStatus, const String& requestId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("key"), key);
    serializer.AddField(crdtp::MakeSpan("pipelineId"), pipelineId);
    serializer.AddField(crdtp::MakeSpan("initiatingFrameId"), initiatingFrameId);
    serializer.AddField(crdtp::MakeSpan("prefetchUrl"), prefetchUrl);
    serializer.AddField(crdtp::MakeSpan("status"), status);
    serializer.AddField(crdtp::MakeSpan("prefetchStatus"), prefetchStatus);
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Preload.prefetchStatusUpdated", serializer.Finish()));
}

void Frontend::prerenderStatusUpdated(std::unique_ptr<protocol::Preload::PreloadingAttemptKey> key, const String& pipelineId, const String& status, std::optional<String> prerenderStatus, std::optional<String> disallowedMojoInterface, std::unique_ptr<protocol::Array<protocol::Preload::PrerenderMismatchedHeaders>> mismatchedHeaders)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("key"), key);
    serializer.AddField(crdtp::MakeSpan("pipelineId"), pipelineId);
    serializer.AddField(crdtp::MakeSpan("status"), status);
    serializer.AddField(crdtp::MakeSpan("prerenderStatus"), prerenderStatus);
    serializer.AddField(crdtp::MakeSpan("disallowedMojoInterface"), disallowedMojoInterface);
    serializer.AddField(crdtp::MakeSpan("mismatchedHeaders"), mismatchedHeaders);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Preload.prerenderStatusUpdated", serializer.Finish()));
}

void Frontend::preloadingAttemptSourcesUpdated(const String& loaderId, std::unique_ptr<protocol::Array<protocol::Preload::PreloadingAttemptSource>> preloadingAttemptSources)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("loaderId"), loaderId);
    serializer.AddField(crdtp::MakeSpan("preloadingAttemptSources"), preloadingAttemptSources);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Preload.preloadingAttemptSourcesUpdated", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void enable(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Preload.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Preload.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Preload"), SortedRedirects(), std::move(dispatcher));
}

} // Preload
} // namespace blink
} // namespace protocol
