// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/page.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace Page {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Page";
const char Metainfo::commandPrefix[] = "Page.";
const char Metainfo::version[] = "1.3";


namespace AdFrameTypeEnum {
const char None[] = "none";
const char Child[] = "child";
const char Root[] = "root";
} // namespace AdFrameTypeEnum


namespace AdFrameExplanationEnum {
const char ParentIsAd[] = "ParentIsAd";
const char CreatedByAdScript[] = "CreatedByAdScript";
const char MatchedBlockingRule[] = "MatchedBlockingRule";
} // namespace AdFrameExplanationEnum


CRDTP_BEGIN_DESERIALIZER(AdFrameStatus)
    CRDTP_DESERIALIZE_FIELD("adFrameType", m_adFrameType),
    CRDTP_DESERIALIZE_FIELD_OPT("explanations", m_explanations),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AdFrameStatus)
    CRDTP_SERIALIZE_FIELD("adFrameType", m_adFrameType);
    CRDTP_SERIALIZE_FIELD("explanations", m_explanations);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AdScriptId)
    CRDTP_DESERIALIZE_FIELD("debuggerId", m_debuggerId),
    CRDTP_DESERIALIZE_FIELD("scriptId", m_scriptId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AdScriptId)
    CRDTP_SERIALIZE_FIELD("scriptId", m_scriptId);
    CRDTP_SERIALIZE_FIELD("debuggerId", m_debuggerId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AdScriptAncestry)
    CRDTP_DESERIALIZE_FIELD("ancestryChain", m_ancestryChain),
    CRDTP_DESERIALIZE_FIELD_OPT("rootScriptFilterlistRule", m_rootScriptFilterlistRule),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AdScriptAncestry)
    CRDTP_SERIALIZE_FIELD("ancestryChain", m_ancestryChain);
    CRDTP_SERIALIZE_FIELD("rootScriptFilterlistRule", m_rootScriptFilterlistRule);
CRDTP_END_SERIALIZER();


namespace SecureContextTypeEnum {
const char Secure[] = "Secure";
const char SecureLocalhost[] = "SecureLocalhost";
const char InsecureScheme[] = "InsecureScheme";
const char InsecureAncestor[] = "InsecureAncestor";
} // namespace SecureContextTypeEnum


namespace CrossOriginIsolatedContextTypeEnum {
const char Isolated[] = "Isolated";
const char NotIsolated[] = "NotIsolated";
const char NotIsolatedFeatureDisabled[] = "NotIsolatedFeatureDisabled";
} // namespace CrossOriginIsolatedContextTypeEnum


namespace GatedAPIFeaturesEnum {
const char SharedArrayBuffers[] = "SharedArrayBuffers";
const char SharedArrayBuffersTransferAllowed[] = "SharedArrayBuffersTransferAllowed";
const char PerformanceMeasureMemory[] = "PerformanceMeasureMemory";
const char PerformanceProfile[] = "PerformanceProfile";
} // namespace GatedAPIFeaturesEnum


namespace PermissionsPolicyFeatureEnum {
const char Accelerometer[] = "accelerometer";
const char AllScreensCapture[] = "all-screens-capture";
const char AmbientLightSensor[] = "ambient-light-sensor";
const char AriaNotify[] = "aria-notify";
const char AttributionReporting[] = "attribution-reporting";
const char Autoplay[] = "autoplay";
const char Bluetooth[] = "bluetooth";
const char BrowsingTopics[] = "browsing-topics";
const char Camera[] = "camera";
const char CapturedSurfaceControl[] = "captured-surface-control";
const char ChDpr[] = "ch-dpr";
const char ChDeviceMemory[] = "ch-device-memory";
const char ChDownlink[] = "ch-downlink";
const char ChEct[] = "ch-ect";
const char ChPrefersColorScheme[] = "ch-prefers-color-scheme";
const char ChPrefersReducedMotion[] = "ch-prefers-reduced-motion";
const char ChPrefersReducedTransparency[] = "ch-prefers-reduced-transparency";
const char ChRtt[] = "ch-rtt";
const char ChSaveData[] = "ch-save-data";
const char ChUa[] = "ch-ua";
const char ChUaArch[] = "ch-ua-arch";
const char ChUaBitness[] = "ch-ua-bitness";
const char ChUaHighEntropyValues[] = "ch-ua-high-entropy-values";
const char ChUaPlatform[] = "ch-ua-platform";
const char ChUaModel[] = "ch-ua-model";
const char ChUaMobile[] = "ch-ua-mobile";
const char ChUaFormFactors[] = "ch-ua-form-factors";
const char ChUaFullVersion[] = "ch-ua-full-version";
const char ChUaFullVersionList[] = "ch-ua-full-version-list";
const char ChUaPlatformVersion[] = "ch-ua-platform-version";
const char ChUaWow64[] = "ch-ua-wow64";
const char ChViewportHeight[] = "ch-viewport-height";
const char ChViewportWidth[] = "ch-viewport-width";
const char ChWidth[] = "ch-width";
const char ClipboardRead[] = "clipboard-read";
const char ClipboardWrite[] = "clipboard-write";
const char ComputePressure[] = "compute-pressure";
const char ControlledFrame[] = "controlled-frame";
const char CrossOriginIsolated[] = "cross-origin-isolated";
const char DeferredFetch[] = "deferred-fetch";
const char DeferredFetchMinimal[] = "deferred-fetch-minimal";
const char DeviceAttributes[] = "device-attributes";
const char DigitalCredentialsCreate[] = "digital-credentials-create";
const char DigitalCredentialsGet[] = "digital-credentials-get";
const char DirectSockets[] = "direct-sockets";
const char DirectSocketsMulticast[] = "direct-sockets-multicast";
const char DirectSocketsPrivate[] = "direct-sockets-private";
const char DisplayCapture[] = "display-capture";
const char DocumentDomain[] = "document-domain";
const char EncryptedMedia[] = "encrypted-media";
const char ExecutionWhileOutOfViewport[] = "execution-while-out-of-viewport";
const char ExecutionWhileNotRendered[] = "execution-while-not-rendered";
const char FencedUnpartitionedStorageRead[] = "fenced-unpartitioned-storage-read";
const char FocusWithoutUserActivation[] = "focus-without-user-activation";
const char Fullscreen[] = "fullscreen";
const char Frobulate[] = "frobulate";
const char Gamepad[] = "gamepad";
const char Geolocation[] = "geolocation";
const char Gyroscope[] = "gyroscope";
const char Hid[] = "hid";
const char IdentityCredentialsGet[] = "identity-credentials-get";
const char IdleDetection[] = "idle-detection";
const char InterestCohort[] = "interest-cohort";
const char JoinAdInterestGroup[] = "join-ad-interest-group";
const char KeyboardMap[] = "keyboard-map";
const char LanguageDetector[] = "language-detector";
const char LanguageModel[] = "language-model";
const char LocalFonts[] = "local-fonts";
const char LocalNetworkAccess[] = "local-network-access";
const char Magnetometer[] = "magnetometer";
const char MediaPlaybackWhileNotVisible[] = "media-playback-while-not-visible";
const char Microphone[] = "microphone";
const char Midi[] = "midi";
const char OnDeviceSpeechRecognition[] = "on-device-speech-recognition";
const char OtpCredentials[] = "otp-credentials";
const char Payment[] = "payment";
const char PictureInPicture[] = "picture-in-picture";
const char Popins[] = "popins";
const char PrivateAggregation[] = "private-aggregation";
const char PrivateStateTokenIssuance[] = "private-state-token-issuance";
const char PrivateStateTokenRedemption[] = "private-state-token-redemption";
const char PublickeyCredentialsCreate[] = "publickey-credentials-create";
const char PublickeyCredentialsGet[] = "publickey-credentials-get";
const char RecordAdAuctionEvents[] = "record-ad-auction-events";
const char Rewriter[] = "rewriter";
const char RunAdAuction[] = "run-ad-auction";
const char ScreenWakeLock[] = "screen-wake-lock";
const char Serial[] = "serial";
const char SharedAutofill[] = "shared-autofill";
const char SharedStorage[] = "shared-storage";
const char SharedStorageSelectUrl[] = "shared-storage-select-url";
const char SmartCard[] = "smart-card";
const char SpeakerSelection[] = "speaker-selection";
const char StorageAccess[] = "storage-access";
const char SubApps[] = "sub-apps";
const char Summarizer[] = "summarizer";
const char SyncXhr[] = "sync-xhr";
const char Translator[] = "translator";
const char Unload[] = "unload";
const char Usb[] = "usb";
const char UsbUnrestricted[] = "usb-unrestricted";
const char VerticalScroll[] = "vertical-scroll";
const char WebAppInstallation[] = "web-app-installation";
const char WebPrinting[] = "web-printing";
const char WebShare[] = "web-share";
const char WindowManagement[] = "window-management";
const char Writer[] = "writer";
const char XrSpatialTracking[] = "xr-spatial-tracking";
} // namespace PermissionsPolicyFeatureEnum


namespace PermissionsPolicyBlockReasonEnum {
const char Header[] = "Header";
const char IframeAttribute[] = "IframeAttribute";
const char InFencedFrameTree[] = "InFencedFrameTree";
const char InIsolatedApp[] = "InIsolatedApp";
} // namespace PermissionsPolicyBlockReasonEnum


CRDTP_BEGIN_DESERIALIZER(PermissionsPolicyBlockLocator)
    CRDTP_DESERIALIZE_FIELD("blockReason", m_blockReason),
    CRDTP_DESERIALIZE_FIELD("frameId", m_frameId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PermissionsPolicyBlockLocator)
    CRDTP_SERIALIZE_FIELD("frameId", m_frameId);
    CRDTP_SERIALIZE_FIELD("blockReason", m_blockReason);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(PermissionsPolicyFeatureState)
    CRDTP_DESERIALIZE_FIELD("allowed", m_allowed),
    CRDTP_DESERIALIZE_FIELD("feature", m_feature),
    CRDTP_DESERIALIZE_FIELD_OPT("locator", m_locator),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PermissionsPolicyFeatureState)
    CRDTP_SERIALIZE_FIELD("feature", m_feature);
    CRDTP_SERIALIZE_FIELD("allowed", m_allowed);
    CRDTP_SERIALIZE_FIELD("locator", m_locator);
CRDTP_END_SERIALIZER();


namespace OriginTrialTokenStatusEnum {
const char Success[] = "Success";
const char NotSupported[] = "NotSupported";
const char Insecure[] = "Insecure";
const char Expired[] = "Expired";
const char WrongOrigin[] = "WrongOrigin";
const char InvalidSignature[] = "InvalidSignature";
const char Malformed[] = "Malformed";
const char WrongVersion[] = "WrongVersion";
const char FeatureDisabled[] = "FeatureDisabled";
const char TokenDisabled[] = "TokenDisabled";
const char FeatureDisabledForUser[] = "FeatureDisabledForUser";
const char UnknownTrial[] = "UnknownTrial";
} // namespace OriginTrialTokenStatusEnum


namespace OriginTrialStatusEnum {
const char Enabled[] = "Enabled";
const char ValidTokenNotProvided[] = "ValidTokenNotProvided";
const char OSNotSupported[] = "OSNotSupported";
const char TrialNotAllowed[] = "TrialNotAllowed";
} // namespace OriginTrialStatusEnum


namespace OriginTrialUsageRestrictionEnum {
const char None[] = "None";
const char Subset[] = "Subset";
} // namespace OriginTrialUsageRestrictionEnum


CRDTP_BEGIN_DESERIALIZER(OriginTrialToken)
    CRDTP_DESERIALIZE_FIELD("expiryTime", m_expiryTime),
    CRDTP_DESERIALIZE_FIELD("isThirdParty", m_isThirdParty),
    CRDTP_DESERIALIZE_FIELD("matchSubDomains", m_matchSubDomains),
    CRDTP_DESERIALIZE_FIELD("origin", m_origin),
    CRDTP_DESERIALIZE_FIELD("trialName", m_trialName),
    CRDTP_DESERIALIZE_FIELD("usageRestriction", m_usageRestriction),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(OriginTrialToken)
    CRDTP_SERIALIZE_FIELD("origin", m_origin);
    CRDTP_SERIALIZE_FIELD("matchSubDomains", m_matchSubDomains);
    CRDTP_SERIALIZE_FIELD("trialName", m_trialName);
    CRDTP_SERIALIZE_FIELD("expiryTime", m_expiryTime);
    CRDTP_SERIALIZE_FIELD("isThirdParty", m_isThirdParty);
    CRDTP_SERIALIZE_FIELD("usageRestriction", m_usageRestriction);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(OriginTrialTokenWithStatus)
    CRDTP_DESERIALIZE_FIELD_OPT("parsedToken", m_parsedToken),
    CRDTP_DESERIALIZE_FIELD("rawTokenText", m_rawTokenText),
    CRDTP_DESERIALIZE_FIELD("status", m_status),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(OriginTrialTokenWithStatus)
    CRDTP_SERIALIZE_FIELD("rawTokenText", m_rawTokenText);
    CRDTP_SERIALIZE_FIELD("parsedToken", m_parsedToken);
    CRDTP_SERIALIZE_FIELD("status", m_status);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(OriginTrial)
    CRDTP_DESERIALIZE_FIELD("status", m_status),
    CRDTP_DESERIALIZE_FIELD("tokensWithStatus", m_tokensWithStatus),
    CRDTP_DESERIALIZE_FIELD("trialName", m_trialName),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(OriginTrial)
    CRDTP_SERIALIZE_FIELD("trialName", m_trialName);
    CRDTP_SERIALIZE_FIELD("status", m_status);
    CRDTP_SERIALIZE_FIELD("tokensWithStatus", m_tokensWithStatus);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SecurityOriginDetails)
    CRDTP_DESERIALIZE_FIELD("isLocalhost", m_isLocalhost),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SecurityOriginDetails)
    CRDTP_SERIALIZE_FIELD("isLocalhost", m_isLocalhost);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Frame)
    CRDTP_DESERIALIZE_FIELD_OPT("adFrameStatus", m_adFrameStatus),
    CRDTP_DESERIALIZE_FIELD("crossOriginIsolatedContextType", m_crossOriginIsolatedContextType),
    CRDTP_DESERIALIZE_FIELD("domainAndRegistry", m_domainAndRegistry),
    CRDTP_DESERIALIZE_FIELD("gatedAPIFeatures", m_gatedAPIFeatures),
    CRDTP_DESERIALIZE_FIELD("id", m_id),
    CRDTP_DESERIALIZE_FIELD("loaderId", m_loaderId),
    CRDTP_DESERIALIZE_FIELD("mimeType", m_mimeType),
    CRDTP_DESERIALIZE_FIELD_OPT("name", m_name),
    CRDTP_DESERIALIZE_FIELD_OPT("parentId", m_parentId),
    CRDTP_DESERIALIZE_FIELD("secureContextType", m_secureContextType),
    CRDTP_DESERIALIZE_FIELD("securityOrigin", m_securityOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("securityOriginDetails", m_securityOriginDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("unreachableUrl", m_unreachableUrl),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
    CRDTP_DESERIALIZE_FIELD_OPT("urlFragment", m_urlFragment),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Frame)
    CRDTP_SERIALIZE_FIELD("id", m_id);
    CRDTP_SERIALIZE_FIELD("parentId", m_parentId);
    CRDTP_SERIALIZE_FIELD("loaderId", m_loaderId);
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("urlFragment", m_urlFragment);
    CRDTP_SERIALIZE_FIELD("domainAndRegistry", m_domainAndRegistry);
    CRDTP_SERIALIZE_FIELD("securityOrigin", m_securityOrigin);
    CRDTP_SERIALIZE_FIELD("securityOriginDetails", m_securityOriginDetails);
    CRDTP_SERIALIZE_FIELD("mimeType", m_mimeType);
    CRDTP_SERIALIZE_FIELD("unreachableUrl", m_unreachableUrl);
    CRDTP_SERIALIZE_FIELD("adFrameStatus", m_adFrameStatus);
    CRDTP_SERIALIZE_FIELD("secureContextType", m_secureContextType);
    CRDTP_SERIALIZE_FIELD("crossOriginIsolatedContextType", m_crossOriginIsolatedContextType);
    CRDTP_SERIALIZE_FIELD("gatedAPIFeatures", m_gatedAPIFeatures);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(FrameResource)
    CRDTP_DESERIALIZE_FIELD_OPT("canceled", m_canceled),
    CRDTP_DESERIALIZE_FIELD_OPT("contentSize", m_contentSize),
    CRDTP_DESERIALIZE_FIELD_OPT("failed", m_failed),
    CRDTP_DESERIALIZE_FIELD_OPT("lastModified", m_lastModified),
    CRDTP_DESERIALIZE_FIELD("mimeType", m_mimeType),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FrameResource)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("mimeType", m_mimeType);
    CRDTP_SERIALIZE_FIELD("lastModified", m_lastModified);
    CRDTP_SERIALIZE_FIELD("contentSize", m_contentSize);
    CRDTP_SERIALIZE_FIELD("failed", m_failed);
    CRDTP_SERIALIZE_FIELD("canceled", m_canceled);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(FrameResourceTree)
    CRDTP_DESERIALIZE_FIELD_OPT("childFrames", m_childFrames),
    CRDTP_DESERIALIZE_FIELD("frame", m_frame),
    CRDTP_DESERIALIZE_FIELD("resources", m_resources),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FrameResourceTree)
    CRDTP_SERIALIZE_FIELD("frame", m_frame);
    CRDTP_SERIALIZE_FIELD("childFrames", m_childFrames);
    CRDTP_SERIALIZE_FIELD("resources", m_resources);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(FrameTree)
    CRDTP_DESERIALIZE_FIELD_OPT("childFrames", m_childFrames),
    CRDTP_DESERIALIZE_FIELD("frame", m_frame),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FrameTree)
    CRDTP_SERIALIZE_FIELD("frame", m_frame);
    CRDTP_SERIALIZE_FIELD("childFrames", m_childFrames);
CRDTP_END_SERIALIZER();



CRDTP_BEGIN_DESERIALIZER(LayoutViewport)
    CRDTP_DESERIALIZE_FIELD("clientHeight", m_clientHeight),
    CRDTP_DESERIALIZE_FIELD("clientWidth", m_clientWidth),
    CRDTP_DESERIALIZE_FIELD("pageX", m_pageX),
    CRDTP_DESERIALIZE_FIELD("pageY", m_pageY),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(LayoutViewport)
    CRDTP_SERIALIZE_FIELD("pageX", m_pageX);
    CRDTP_SERIALIZE_FIELD("pageY", m_pageY);
    CRDTP_SERIALIZE_FIELD("clientWidth", m_clientWidth);
    CRDTP_SERIALIZE_FIELD("clientHeight", m_clientHeight);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(VisualViewport)
    CRDTP_DESERIALIZE_FIELD("clientHeight", m_clientHeight),
    CRDTP_DESERIALIZE_FIELD("clientWidth", m_clientWidth),
    CRDTP_DESERIALIZE_FIELD("offsetX", m_offsetX),
    CRDTP_DESERIALIZE_FIELD("offsetY", m_offsetY),
    CRDTP_DESERIALIZE_FIELD("pageX", m_pageX),
    CRDTP_DESERIALIZE_FIELD("pageY", m_pageY),
    CRDTP_DESERIALIZE_FIELD("scale", m_scale),
    CRDTP_DESERIALIZE_FIELD_OPT("zoom", m_zoom),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(VisualViewport)
    CRDTP_SERIALIZE_FIELD("offsetX", m_offsetX);
    CRDTP_SERIALIZE_FIELD("offsetY", m_offsetY);
    CRDTP_SERIALIZE_FIELD("pageX", m_pageX);
    CRDTP_SERIALIZE_FIELD("pageY", m_pageY);
    CRDTP_SERIALIZE_FIELD("clientWidth", m_clientWidth);
    CRDTP_SERIALIZE_FIELD("clientHeight", m_clientHeight);
    CRDTP_SERIALIZE_FIELD("scale", m_scale);
    CRDTP_SERIALIZE_FIELD("zoom", m_zoom);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Viewport)
    CRDTP_DESERIALIZE_FIELD("height", m_height),
    CRDTP_DESERIALIZE_FIELD("scale", m_scale),
    CRDTP_DESERIALIZE_FIELD("width", m_width),
    CRDTP_DESERIALIZE_FIELD("x", m_x),
    CRDTP_DESERIALIZE_FIELD("y", m_y),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Viewport)
    CRDTP_SERIALIZE_FIELD("x", m_x);
    CRDTP_SERIALIZE_FIELD("y", m_y);
    CRDTP_SERIALIZE_FIELD("width", m_width);
    CRDTP_SERIALIZE_FIELD("height", m_height);
    CRDTP_SERIALIZE_FIELD("scale", m_scale);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(FontFamilies)
    CRDTP_DESERIALIZE_FIELD_OPT("cursive", m_cursive),
    CRDTP_DESERIALIZE_FIELD_OPT("fantasy", m_fantasy),
    CRDTP_DESERIALIZE_FIELD_OPT("fixed", m_fixed),
    CRDTP_DESERIALIZE_FIELD_OPT("math", m_math),
    CRDTP_DESERIALIZE_FIELD_OPT("sansSerif", m_sansSerif),
    CRDTP_DESERIALIZE_FIELD_OPT("serif", m_serif),
    CRDTP_DESERIALIZE_FIELD_OPT("standard", m_standard),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FontFamilies)
    CRDTP_SERIALIZE_FIELD("standard", m_standard);
    CRDTP_SERIALIZE_FIELD("fixed", m_fixed);
    CRDTP_SERIALIZE_FIELD("serif", m_serif);
    CRDTP_SERIALIZE_FIELD("sansSerif", m_sansSerif);
    CRDTP_SERIALIZE_FIELD("cursive", m_cursive);
    CRDTP_SERIALIZE_FIELD("fantasy", m_fantasy);
    CRDTP_SERIALIZE_FIELD("math", m_math);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ScriptFontFamilies)
    CRDTP_DESERIALIZE_FIELD("fontFamilies", m_fontFamilies),
    CRDTP_DESERIALIZE_FIELD("script", m_script),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ScriptFontFamilies)
    CRDTP_SERIALIZE_FIELD("script", m_script);
    CRDTP_SERIALIZE_FIELD("fontFamilies", m_fontFamilies);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(FontSizes)
    CRDTP_DESERIALIZE_FIELD_OPT("fixed", m_fixed),
    CRDTP_DESERIALIZE_FIELD_OPT("standard", m_standard),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FontSizes)
    CRDTP_SERIALIZE_FIELD("standard", m_standard);
    CRDTP_SERIALIZE_FIELD("fixed", m_fixed);
CRDTP_END_SERIALIZER();


namespace ClientNavigationReasonEnum {
const char AnchorClick[] = "anchorClick";
const char FormSubmissionGet[] = "formSubmissionGet";
const char FormSubmissionPost[] = "formSubmissionPost";
const char HttpHeaderRefresh[] = "httpHeaderRefresh";
const char InitialFrameNavigation[] = "initialFrameNavigation";
const char MetaTagRefresh[] = "metaTagRefresh";
const char Other[] = "other";
const char PageBlockInterstitial[] = "pageBlockInterstitial";
const char Reload[] = "reload";
const char ScriptInitiated[] = "scriptInitiated";
} // namespace ClientNavigationReasonEnum


namespace ClientNavigationDispositionEnum {
const char CurrentTab[] = "currentTab";
const char NewTab[] = "newTab";
const char NewWindow[] = "newWindow";
const char Download[] = "download";
} // namespace ClientNavigationDispositionEnum


CRDTP_BEGIN_DESERIALIZER(CompilationCacheParams)
    CRDTP_DESERIALIZE_FIELD_OPT("eager", m_eager),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CompilationCacheParams)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("eager", m_eager);
CRDTP_END_SERIALIZER();


namespace NavigationTypeEnum {
const char Navigation[] = "Navigation";
const char BackForwardCacheRestore[] = "BackForwardCacheRestore";
} // namespace NavigationTypeEnum


namespace BackForwardCacheNotRestoredReasonEnum {
const char NotPrimaryMainFrame[] = "NotPrimaryMainFrame";
const char BackForwardCacheDisabled[] = "BackForwardCacheDisabled";
const char RelatedActiveContentsExist[] = "RelatedActiveContentsExist";
const char HTTPStatusNotOK[] = "HTTPStatusNotOK";
const char SchemeNotHTTPOrHTTPS[] = "SchemeNotHTTPOrHTTPS";
const char Loading[] = "Loading";
const char WasGrantedMediaAccess[] = "WasGrantedMediaAccess";
const char DisableForRenderFrameHostCalled[] = "DisableForRenderFrameHostCalled";
const char DomainNotAllowed[] = "DomainNotAllowed";
const char HTTPMethodNotGET[] = "HTTPMethodNotGET";
const char SubframeIsNavigating[] = "SubframeIsNavigating";
const char Timeout[] = "Timeout";
const char CacheLimit[] = "CacheLimit";
const char JavaScriptExecution[] = "JavaScriptExecution";
const char RendererProcessKilled[] = "RendererProcessKilled";
const char RendererProcessCrashed[] = "RendererProcessCrashed";
const char SchedulerTrackedFeatureUsed[] = "SchedulerTrackedFeatureUsed";
const char ConflictingBrowsingInstance[] = "ConflictingBrowsingInstance";
const char CacheFlushed[] = "CacheFlushed";
const char ServiceWorkerVersionActivation[] = "ServiceWorkerVersionActivation";
const char SessionRestored[] = "SessionRestored";
const char ServiceWorkerPostMessage[] = "ServiceWorkerPostMessage";
const char EnteredBackForwardCacheBeforeServiceWorkerHostAdded[] = "EnteredBackForwardCacheBeforeServiceWorkerHostAdded";
const char RenderFrameHostReused_SameSite[] = "RenderFrameHostReused_SameSite";
const char RenderFrameHostReused_CrossSite[] = "RenderFrameHostReused_CrossSite";
const char ServiceWorkerClaim[] = "ServiceWorkerClaim";
const char IgnoreEventAndEvict[] = "IgnoreEventAndEvict";
const char HaveInnerContents[] = "HaveInnerContents";
const char TimeoutPuttingInCache[] = "TimeoutPuttingInCache";
const char BackForwardCacheDisabledByLowMemory[] = "BackForwardCacheDisabledByLowMemory";
const char BackForwardCacheDisabledByCommandLine[] = "BackForwardCacheDisabledByCommandLine";
const char NetworkRequestDatapipeDrainedAsBytesConsumer[] = "NetworkRequestDatapipeDrainedAsBytesConsumer";
const char NetworkRequestRedirected[] = "NetworkRequestRedirected";
const char NetworkRequestTimeout[] = "NetworkRequestTimeout";
const char NetworkExceedsBufferLimit[] = "NetworkExceedsBufferLimit";
const char NavigationCancelledWhileRestoring[] = "NavigationCancelledWhileRestoring";
const char NotMostRecentNavigationEntry[] = "NotMostRecentNavigationEntry";
const char BackForwardCacheDisabledForPrerender[] = "BackForwardCacheDisabledForPrerender";
const char UserAgentOverrideDiffers[] = "UserAgentOverrideDiffers";
const char ForegroundCacheLimit[] = "ForegroundCacheLimit";
const char BrowsingInstanceNotSwapped[] = "BrowsingInstanceNotSwapped";
const char BackForwardCacheDisabledForDelegate[] = "BackForwardCacheDisabledForDelegate";
const char UnloadHandlerExistsInMainFrame[] = "UnloadHandlerExistsInMainFrame";
const char UnloadHandlerExistsInSubFrame[] = "UnloadHandlerExistsInSubFrame";
const char ServiceWorkerUnregistration[] = "ServiceWorkerUnregistration";
const char CacheControlNoStore[] = "CacheControlNoStore";
const char CacheControlNoStoreCookieModified[] = "CacheControlNoStoreCookieModified";
const char CacheControlNoStoreHTTPOnlyCookieModified[] = "CacheControlNoStoreHTTPOnlyCookieModified";
const char NoResponseHead[] = "NoResponseHead";
const char Unknown[] = "Unknown";
const char ActivationNavigationsDisallowedForBug1234857[] = "ActivationNavigationsDisallowedForBug1234857";
const char ErrorDocument[] = "ErrorDocument";
const char FencedFramesEmbedder[] = "FencedFramesEmbedder";
const char CookieDisabled[] = "CookieDisabled";
const char HTTPAuthRequired[] = "HTTPAuthRequired";
const char CookieFlushed[] = "CookieFlushed";
const char BroadcastChannelOnMessage[] = "BroadcastChannelOnMessage";
const char WebViewSettingsChanged[] = "WebViewSettingsChanged";
const char WebViewJavaScriptObjectChanged[] = "WebViewJavaScriptObjectChanged";
const char WebViewMessageListenerInjected[] = "WebViewMessageListenerInjected";
const char WebViewSafeBrowsingAllowlistChanged[] = "WebViewSafeBrowsingAllowlistChanged";
const char WebViewDocumentStartJavascriptChanged[] = "WebViewDocumentStartJavascriptChanged";
const char WebSocket[] = "WebSocket";
const char WebTransport[] = "WebTransport";
const char WebRTC[] = "WebRTC";
const char MainResourceHasCacheControlNoStore[] = "MainResourceHasCacheControlNoStore";
const char MainResourceHasCacheControlNoCache[] = "MainResourceHasCacheControlNoCache";
const char SubresourceHasCacheControlNoStore[] = "SubresourceHasCacheControlNoStore";
const char SubresourceHasCacheControlNoCache[] = "SubresourceHasCacheControlNoCache";
const char ContainsPlugins[] = "ContainsPlugins";
const char DocumentLoaded[] = "DocumentLoaded";
const char OutstandingNetworkRequestOthers[] = "OutstandingNetworkRequestOthers";
const char RequestedMIDIPermission[] = "RequestedMIDIPermission";
const char RequestedAudioCapturePermission[] = "RequestedAudioCapturePermission";
const char RequestedVideoCapturePermission[] = "RequestedVideoCapturePermission";
const char RequestedBackForwardCacheBlockedSensors[] = "RequestedBackForwardCacheBlockedSensors";
const char RequestedBackgroundWorkPermission[] = "RequestedBackgroundWorkPermission";
const char BroadcastChannel[] = "BroadcastChannel";
const char WebXR[] = "WebXR";
const char SharedWorker[] = "SharedWorker";
const char SharedWorkerMessage[] = "SharedWorkerMessage";
const char SharedWorkerWithNoActiveClient[] = "SharedWorkerWithNoActiveClient";
const char WebLocks[] = "WebLocks";
const char WebHID[] = "WebHID";
const char WebBluetooth[] = "WebBluetooth";
const char WebShare[] = "WebShare";
const char RequestedStorageAccessGrant[] = "RequestedStorageAccessGrant";
const char WebNfc[] = "WebNfc";
const char OutstandingNetworkRequestFetch[] = "OutstandingNetworkRequestFetch";
const char OutstandingNetworkRequestXHR[] = "OutstandingNetworkRequestXHR";
const char AppBanner[] = "AppBanner";
const char Printing[] = "Printing";
const char WebDatabase[] = "WebDatabase";
const char PictureInPicture[] = "PictureInPicture";
const char SpeechRecognizer[] = "SpeechRecognizer";
const char IdleManager[] = "IdleManager";
const char PaymentManager[] = "PaymentManager";
const char SpeechSynthesis[] = "SpeechSynthesis";
const char KeyboardLock[] = "KeyboardLock";
const char WebOTPService[] = "WebOTPService";
const char OutstandingNetworkRequestDirectSocket[] = "OutstandingNetworkRequestDirectSocket";
const char InjectedJavascript[] = "InjectedJavascript";
const char InjectedStyleSheet[] = "InjectedStyleSheet";
const char KeepaliveRequest[] = "KeepaliveRequest";
const char IndexedDBEvent[] = "IndexedDBEvent";
const char Dummy[] = "Dummy";
const char JsNetworkRequestReceivedCacheControlNoStoreResource[] = "JsNetworkRequestReceivedCacheControlNoStoreResource";
const char WebRTCUsedWithCCNS[] = "WebRTCUsedWithCCNS";
const char WebTransportUsedWithCCNS[] = "WebTransportUsedWithCCNS";
const char WebSocketUsedWithCCNS[] = "WebSocketUsedWithCCNS";
const char SmartCard[] = "SmartCard";
const char LiveMediaStreamTrack[] = "LiveMediaStreamTrack";
const char UnloadHandler[] = "UnloadHandler";
const char ParserAborted[] = "ParserAborted";
const char ContentSecurityHandler[] = "ContentSecurityHandler";
const char ContentWebAuthenticationAPI[] = "ContentWebAuthenticationAPI";
const char ContentFileChooser[] = "ContentFileChooser";
const char ContentSerial[] = "ContentSerial";
const char ContentFileSystemAccess[] = "ContentFileSystemAccess";
const char ContentMediaDevicesDispatcherHost[] = "ContentMediaDevicesDispatcherHost";
const char ContentWebBluetooth[] = "ContentWebBluetooth";
const char ContentWebUSB[] = "ContentWebUSB";
const char ContentMediaSessionService[] = "ContentMediaSessionService";
const char ContentScreenReader[] = "ContentScreenReader";
const char ContentDiscarded[] = "ContentDiscarded";
const char EmbedderPopupBlockerTabHelper[] = "EmbedderPopupBlockerTabHelper";
const char EmbedderSafeBrowsingTriggeredPopupBlocker[] = "EmbedderSafeBrowsingTriggeredPopupBlocker";
const char EmbedderSafeBrowsingThreatDetails[] = "EmbedderSafeBrowsingThreatDetails";
const char EmbedderAppBannerManager[] = "EmbedderAppBannerManager";
const char EmbedderDomDistillerViewerSource[] = "EmbedderDomDistillerViewerSource";
const char EmbedderDomDistillerSelfDeletingRequestDelegate[] = "EmbedderDomDistillerSelfDeletingRequestDelegate";
const char EmbedderOomInterventionTabHelper[] = "EmbedderOomInterventionTabHelper";
const char EmbedderOfflinePage[] = "EmbedderOfflinePage";
const char EmbedderChromePasswordManagerClientBindCredentialManager[] = "EmbedderChromePasswordManagerClientBindCredentialManager";
const char EmbedderPermissionRequestManager[] = "EmbedderPermissionRequestManager";
const char EmbedderModalDialog[] = "EmbedderModalDialog";
const char EmbedderExtensions[] = "EmbedderExtensions";
const char EmbedderExtensionMessaging[] = "EmbedderExtensionMessaging";
const char EmbedderExtensionMessagingForOpenPort[] = "EmbedderExtensionMessagingForOpenPort";
const char EmbedderExtensionSentMessageToCachedFrame[] = "EmbedderExtensionSentMessageToCachedFrame";
const char RequestedByWebViewClient[] = "RequestedByWebViewClient";
const char PostMessageByWebViewClient[] = "PostMessageByWebViewClient";
const char CacheControlNoStoreDeviceBoundSessionTerminated[] = "CacheControlNoStoreDeviceBoundSessionTerminated";
const char CacheLimitPrunedOnModerateMemoryPressure[] = "CacheLimitPrunedOnModerateMemoryPressure";
const char CacheLimitPrunedOnCriticalMemoryPressure[] = "CacheLimitPrunedOnCriticalMemoryPressure";
} // namespace BackForwardCacheNotRestoredReasonEnum


namespace BackForwardCacheNotRestoredReasonTypeEnum {
const char SupportPending[] = "SupportPending";
const char PageSupportNeeded[] = "PageSupportNeeded";
const char Circumstantial[] = "Circumstantial";
} // namespace BackForwardCacheNotRestoredReasonTypeEnum


CRDTP_BEGIN_DESERIALIZER(BackForwardCacheBlockingDetails)
    CRDTP_DESERIALIZE_FIELD("columnNumber", m_columnNumber),
    CRDTP_DESERIALIZE_FIELD_OPT("function", m_function),
    CRDTP_DESERIALIZE_FIELD("lineNumber", m_lineNumber),
    CRDTP_DESERIALIZE_FIELD_OPT("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BackForwardCacheBlockingDetails)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("function", m_function);
    CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(BackForwardCacheNotRestoredExplanation)
    CRDTP_DESERIALIZE_FIELD_OPT("context", m_context),
    CRDTP_DESERIALIZE_FIELD_OPT("details", m_details),
    CRDTP_DESERIALIZE_FIELD("reason", m_reason),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BackForwardCacheNotRestoredExplanation)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("reason", m_reason);
    CRDTP_SERIALIZE_FIELD("context", m_context);
    CRDTP_SERIALIZE_FIELD("details", m_details);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(BackForwardCacheNotRestoredExplanationTree)
    CRDTP_DESERIALIZE_FIELD("children", m_children),
    CRDTP_DESERIALIZE_FIELD("explanations", m_explanations),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BackForwardCacheNotRestoredExplanationTree)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("explanations", m_explanations);
    CRDTP_SERIALIZE_FIELD("children", m_children);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


namespace CaptureScreenshot {
namespace FormatEnum {
const char* Jpeg = "jpeg";
const char* Png = "png";
const char* Webp = "webp";
} // namespace FormatEnum
} // namespace CaptureScreenshot

namespace CaptureSnapshot {
namespace FormatEnum {
const char* Mhtml = "mhtml";
} // namespace FormatEnum
} // namespace CaptureSnapshot

namespace PrintToPDF {
namespace TransferModeEnum {
const char* ReturnAsBase64 = "ReturnAsBase64";
const char* ReturnAsStream = "ReturnAsStream";
} // namespace TransferModeEnum
} // namespace PrintToPDF

namespace SetDownloadBehavior {
namespace BehaviorEnum {
const char* Deny = "deny";
const char* Allow = "allow";
const char* Default = "default";
} // namespace BehaviorEnum
} // namespace SetDownloadBehavior

namespace SetTouchEmulationEnabled {
namespace ConfigurationEnum {
const char* Mobile = "mobile";
const char* Desktop = "desktop";
} // namespace ConfigurationEnum
} // namespace SetTouchEmulationEnabled

namespace StartScreencast {
namespace FormatEnum {
const char* Jpeg = "jpeg";
const char* Png = "png";
} // namespace FormatEnum
} // namespace StartScreencast

namespace SetWebLifecycleState {
namespace StateEnum {
const char* Frozen = "frozen";
const char* Active = "active";
} // namespace StateEnum
} // namespace SetWebLifecycleState

namespace SetSPCTransactionMode {
namespace ModeEnum {
const char* None = "none";
const char* AutoAccept = "autoAccept";
const char* AutoChooseToAuthAnotherWay = "autoChooseToAuthAnotherWay";
const char* AutoReject = "autoReject";
const char* AutoOptOut = "autoOptOut";
} // namespace ModeEnum
} // namespace SetSPCTransactionMode

namespace SetRPHRegistrationMode {
namespace ModeEnum {
const char* None = "none";
const char* AutoAccept = "autoAccept";
const char* AutoReject = "autoReject";
} // namespace ModeEnum
} // namespace SetRPHRegistrationMode

namespace FileChooserOpened {
namespace ModeEnum {
const char* SelectSingle = "selectSingle";
const char* SelectMultiple = "selectMultiple";
} // namespace ModeEnum
} // namespace FileChooserOpened

namespace FrameDetached {
namespace ReasonEnum {
const char* Remove = "remove";
const char* Swap = "swap";
} // namespace ReasonEnum
} // namespace FrameDetached

namespace FrameStartedNavigating {
namespace NavigationTypeEnum {
const char* Reload = "reload";
const char* ReloadBypassingCache = "reloadBypassingCache";
const char* Restore = "restore";
const char* RestoreWithPost = "restoreWithPost";
const char* HistorySameDocument = "historySameDocument";
const char* HistoryDifferentDocument = "historyDifferentDocument";
const char* SameDocument = "sameDocument";
const char* DifferentDocument = "differentDocument";
} // namespace NavigationTypeEnum
} // namespace FrameStartedNavigating

namespace DownloadProgress {
namespace StateEnum {
const char* InProgress = "inProgress";
const char* Completed = "completed";
const char* Canceled = "canceled";
} // namespace StateEnum
} // namespace DownloadProgress

namespace NavigatedWithinDocument {
namespace NavigationTypeEnum {
const char* Fragment = "fragment";
const char* HistoryApi = "historyApi";
const char* Other = "other";
} // namespace NavigationTypeEnum
} // namespace NavigatedWithinDocument

// ------------- Frontend notifications.

void Frontend::domContentEventFired(double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.domContentEventFired", serializer.Finish()));
}

void Frontend::fileChooserOpened(const String& frameId, const String& mode, std::optional<int> backendNodeId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("mode"), mode);
    serializer.AddField(crdtp::MakeSpan("backendNodeId"), backendNodeId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.fileChooserOpened", serializer.Finish()));
}

void Frontend::frameAttached(const String& frameId, const String& parentFrameId, std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> stack)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("parentFrameId"), parentFrameId);
    serializer.AddField(crdtp::MakeSpan("stack"), stack);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.frameAttached", serializer.Finish()));
}

void Frontend::frameClearedScheduledNavigation(const String& frameId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.frameClearedScheduledNavigation", serializer.Finish()));
}

void Frontend::frameDetached(const String& frameId, const String& reason)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("reason"), reason);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.frameDetached", serializer.Finish()));
}

void Frontend::frameSubtreeWillBeDetached(const String& frameId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.frameSubtreeWillBeDetached", serializer.Finish()));
}

void Frontend::frameNavigated(std::unique_ptr<protocol::Page::Frame> frame, const String& type)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frame"), frame);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.frameNavigated", serializer.Finish()));
}

void Frontend::documentOpened(std::unique_ptr<protocol::Page::Frame> frame)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frame"), frame);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.documentOpened", serializer.Finish()));
}

void Frontend::frameResized()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.frameResized"));
}

void Frontend::frameStartedNavigating(const String& frameId, const String& url, const String& loaderId, const String& navigationType)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("loaderId"), loaderId);
    serializer.AddField(crdtp::MakeSpan("navigationType"), navigationType);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.frameStartedNavigating", serializer.Finish()));
}

void Frontend::frameRequestedNavigation(const String& frameId, const String& reason, const String& url, const String& disposition)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("reason"), reason);
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("disposition"), disposition);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.frameRequestedNavigation", serializer.Finish()));
}

void Frontend::frameScheduledNavigation(const String& frameId, double delay, const String& reason, const String& url)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("delay"), delay);
    serializer.AddField(crdtp::MakeSpan("reason"), reason);
    serializer.AddField(crdtp::MakeSpan("url"), url);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.frameScheduledNavigation", serializer.Finish()));
}

void Frontend::downloadWillBegin(const String& frameId, const String& guid, const String& url, const String& suggestedFilename)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("guid"), guid);
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("suggestedFilename"), suggestedFilename);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.downloadWillBegin", serializer.Finish()));
}

void Frontend::downloadProgress(const String& guid, double totalBytes, double receivedBytes, const String& state)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("guid"), guid);
    serializer.AddField(crdtp::MakeSpan("totalBytes"), totalBytes);
    serializer.AddField(crdtp::MakeSpan("receivedBytes"), receivedBytes);
    serializer.AddField(crdtp::MakeSpan("state"), state);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.downloadProgress", serializer.Finish()));
}

void Frontend::lifecycleEvent(const String& frameId, const String& loaderId, const String& name, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("loaderId"), loaderId);
    serializer.AddField(crdtp::MakeSpan("name"), name);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.lifecycleEvent", serializer.Finish()));
}

void Frontend::backForwardCacheNotUsed(const String& loaderId, const String& frameId, std::unique_ptr<protocol::Array<protocol::Page::BackForwardCacheNotRestoredExplanation>> notRestoredExplanations, std::unique_ptr<protocol::Page::BackForwardCacheNotRestoredExplanationTree> notRestoredExplanationsTree)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("loaderId"), loaderId);
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("notRestoredExplanations"), notRestoredExplanations);
    serializer.AddField(crdtp::MakeSpan("notRestoredExplanationsTree"), notRestoredExplanationsTree);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.backForwardCacheNotUsed", serializer.Finish()));
}

void Frontend::loadEventFired(double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.loadEventFired", serializer.Finish()));
}

void Frontend::navigatedWithinDocument(const String& frameId, const String& url, const String& navigationType)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("navigationType"), navigationType);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.navigatedWithinDocument", serializer.Finish()));
}

void Frontend::windowOpen(const String& url, const String& windowName, std::unique_ptr<protocol::Array<String>> windowFeatures, bool userGesture)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("windowName"), windowName);
    serializer.AddField(crdtp::MakeSpan("windowFeatures"), windowFeatures);
    serializer.AddField(crdtp::MakeSpan("userGesture"), userGesture);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.windowOpen", serializer.Finish()));
}

void Frontend::compilationCacheProduced(const String& url, const Binary& data)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("data"), data);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Page.compilationCacheProduced", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void addScriptToEvaluateOnLoad(const crdtp::Dispatchable& dispatchable);
    void addScriptToEvaluateOnNewDocument(const crdtp::Dispatchable& dispatchable);
    void createIsolatedWorld(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void getAdScriptAncestry(const crdtp::Dispatchable& dispatchable);
    void getFrameTree(const crdtp::Dispatchable& dispatchable);
    void getLayoutMetrics(const crdtp::Dispatchable& dispatchable);
    void getResourceContent(const crdtp::Dispatchable& dispatchable);
    void getResourceTree(const crdtp::Dispatchable& dispatchable);
    void reload(const crdtp::Dispatchable& dispatchable);
    void removeScriptToEvaluateOnLoad(const crdtp::Dispatchable& dispatchable);
    void removeScriptToEvaluateOnNewDocument(const crdtp::Dispatchable& dispatchable);
    void searchInResource(const crdtp::Dispatchable& dispatchable);
    void setAdBlockingEnabled(const crdtp::Dispatchable& dispatchable);
    void setBypassCSP(const crdtp::Dispatchable& dispatchable);
    void getPermissionsPolicyState(const crdtp::Dispatchable& dispatchable);
    void getOriginTrials(const crdtp::Dispatchable& dispatchable);
    void setFontFamilies(const crdtp::Dispatchable& dispatchable);
    void setFontSizes(const crdtp::Dispatchable& dispatchable);
    void setDocumentContent(const crdtp::Dispatchable& dispatchable);
    void setLifecycleEventsEnabled(const crdtp::Dispatchable& dispatchable);
    void startScreencast(const crdtp::Dispatchable& dispatchable);
    void stopLoading(const crdtp::Dispatchable& dispatchable);
    void stopScreencast(const crdtp::Dispatchable& dispatchable);
    void produceCompilationCache(const crdtp::Dispatchable& dispatchable);
    void addCompilationCache(const crdtp::Dispatchable& dispatchable);
    void clearCompilationCache(const crdtp::Dispatchable& dispatchable);
    void generateTestReport(const crdtp::Dispatchable& dispatchable);
    void waitForDebugger(const crdtp::Dispatchable& dispatchable);
    void setInterceptFileChooserDialog(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("addCompilationCache"),
          &DomainDispatcherImpl::addCompilationCache
    },
    {
          crdtp::SpanFrom("addScriptToEvaluateOnLoad"),
          &DomainDispatcherImpl::addScriptToEvaluateOnLoad
    },
    {
          crdtp::SpanFrom("addScriptToEvaluateOnNewDocument"),
          &DomainDispatcherImpl::addScriptToEvaluateOnNewDocument
    },
    {
          crdtp::SpanFrom("clearCompilationCache"),
          &DomainDispatcherImpl::clearCompilationCache
    },
    {
          crdtp::SpanFrom("createIsolatedWorld"),
          &DomainDispatcherImpl::createIsolatedWorld
    },
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("generateTestReport"),
          &DomainDispatcherImpl::generateTestReport
    },
    {
          crdtp::SpanFrom("getAdScriptAncestry"),
          &DomainDispatcherImpl::getAdScriptAncestry
    },
    {
          crdtp::SpanFrom("getFrameTree"),
          &DomainDispatcherImpl::getFrameTree
    },
    {
          crdtp::SpanFrom("getLayoutMetrics"),
          &DomainDispatcherImpl::getLayoutMetrics
    },
    {
          crdtp::SpanFrom("getOriginTrials"),
          &DomainDispatcherImpl::getOriginTrials
    },
    {
          crdtp::SpanFrom("getPermissionsPolicyState"),
          &DomainDispatcherImpl::getPermissionsPolicyState
    },
    {
          crdtp::SpanFrom("getResourceContent"),
          &DomainDispatcherImpl::getResourceContent
    },
    {
          crdtp::SpanFrom("getResourceTree"),
          &DomainDispatcherImpl::getResourceTree
    },
    {
          crdtp::SpanFrom("produceCompilationCache"),
          &DomainDispatcherImpl::produceCompilationCache
    },
    {
          crdtp::SpanFrom("reload"),
          &DomainDispatcherImpl::reload
    },
    {
          crdtp::SpanFrom("removeScriptToEvaluateOnLoad"),
          &DomainDispatcherImpl::removeScriptToEvaluateOnLoad
    },
    {
          crdtp::SpanFrom("removeScriptToEvaluateOnNewDocument"),
          &DomainDispatcherImpl::removeScriptToEvaluateOnNewDocument
    },
    {
          crdtp::SpanFrom("searchInResource"),
          &DomainDispatcherImpl::searchInResource
    },
    {
          crdtp::SpanFrom("setAdBlockingEnabled"),
          &DomainDispatcherImpl::setAdBlockingEnabled
    },
    {
          crdtp::SpanFrom("setBypassCSP"),
          &DomainDispatcherImpl::setBypassCSP
    },
    {
          crdtp::SpanFrom("setDocumentContent"),
          &DomainDispatcherImpl::setDocumentContent
    },
    {
          crdtp::SpanFrom("setFontFamilies"),
          &DomainDispatcherImpl::setFontFamilies
    },
    {
          crdtp::SpanFrom("setFontSizes"),
          &DomainDispatcherImpl::setFontSizes
    },
    {
          crdtp::SpanFrom("setInterceptFileChooserDialog"),
          &DomainDispatcherImpl::setInterceptFileChooserDialog
    },
    {
          crdtp::SpanFrom("setLifecycleEventsEnabled"),
          &DomainDispatcherImpl::setLifecycleEventsEnabled
    },
    {
          crdtp::SpanFrom("startScreencast"),
          &DomainDispatcherImpl::startScreencast
    },
    {
          crdtp::SpanFrom("stopLoading"),
          &DomainDispatcherImpl::stopLoading
    },
    {
          crdtp::SpanFrom("stopScreencast"),
          &DomainDispatcherImpl::stopScreencast
    },
    {
          crdtp::SpanFrom("waitForDebugger"),
          &DomainDispatcherImpl::waitForDebugger
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct addScriptToEvaluateOnLoadParams : public crdtp::DeserializableProtocolObject<addScriptToEvaluateOnLoadParams> {
    String scriptSource;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(addScriptToEvaluateOnLoadParams)
    CRDTP_DESERIALIZE_FIELD("scriptSource", scriptSource),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::addScriptToEvaluateOnLoad(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    addScriptToEvaluateOnLoadParams params;
    if (!addScriptToEvaluateOnLoadParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_identifier;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->addScriptToEvaluateOnLoad(params.scriptSource, &out_identifier);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.addScriptToEvaluateOnLoad"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("identifier"), out_identifier);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct addScriptToEvaluateOnNewDocumentParams : public crdtp::DeserializableProtocolObject<addScriptToEvaluateOnNewDocumentParams> {
    String source;
    std::optional<String> worldName;
    std::optional<bool> includeCommandLineAPI;
    std::optional<bool> runImmediately;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(addScriptToEvaluateOnNewDocumentParams)
    CRDTP_DESERIALIZE_FIELD_OPT("includeCommandLineAPI", includeCommandLineAPI),
    CRDTP_DESERIALIZE_FIELD_OPT("runImmediately", runImmediately),
    CRDTP_DESERIALIZE_FIELD("source", source),
    CRDTP_DESERIALIZE_FIELD_OPT("worldName", worldName),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::addScriptToEvaluateOnNewDocument(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    addScriptToEvaluateOnNewDocumentParams params;
    if (!addScriptToEvaluateOnNewDocumentParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_identifier;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->addScriptToEvaluateOnNewDocument(params.source, std::move(params.worldName), std::move(params.includeCommandLineAPI), std::move(params.runImmediately), &out_identifier);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.addScriptToEvaluateOnNewDocument"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("identifier"), out_identifier);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

class CreateIsolatedWorldCallbackImpl : public Backend::CreateIsolatedWorldCallback, public DomainDispatcher::Callback {
public:
    CreateIsolatedWorldCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.createIsolatedWorld"), message) { }

    void sendSuccess(int executionContextId) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("executionContextId"), executionContextId);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct createIsolatedWorldParams : public crdtp::DeserializableProtocolObject<createIsolatedWorldParams> {
    String frameId;
    std::optional<String> worldName;
    std::optional<bool> grantUniveralAccess;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(createIsolatedWorldParams)
    CRDTP_DESERIALIZE_FIELD("frameId", frameId),
    CRDTP_DESERIALIZE_FIELD_OPT("grantUniveralAccess", grantUniveralAccess),
    CRDTP_DESERIALIZE_FIELD_OPT("worldName", worldName),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::createIsolatedWorld(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    createIsolatedWorldParams params;
    if (!createIsolatedWorldParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->createIsolatedWorld(params.frameId, std::move(params.worldName), std::move(params.grantUniveralAccess), std::make_unique<CreateIsolatedWorldCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct enableParams : public crdtp::DeserializableProtocolObject<enableParams> {
    std::optional<bool> enableFileChooserOpenedEvent;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(enableParams)
    CRDTP_DESERIALIZE_FIELD_OPT("enableFileChooserOpenedEvent", enableFileChooserOpenedEvent),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    enableParams params;
    if (!enableParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable(std::move(params.enableFileChooserOpenedEvent));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getAdScriptAncestryParams : public crdtp::DeserializableProtocolObject<getAdScriptAncestryParams> {
    String frameId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getAdScriptAncestryParams)
    CRDTP_DESERIALIZE_FIELD("frameId", frameId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getAdScriptAncestry(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getAdScriptAncestryParams params;
    if (!getAdScriptAncestryParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Page::AdScriptAncestry> out_adScriptAncestry;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getAdScriptAncestry(params.frameId, &out_adScriptAncestry);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.getAdScriptAncestry"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("adScriptAncestry"), out_adScriptAncestry);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getFrameTree(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::Page::FrameTree> out_frameTree;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getFrameTree(&out_frameTree);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.getFrameTree"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("frameTree"), out_frameTree);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getLayoutMetrics(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::Page::LayoutViewport> out_layoutViewport;
    std::unique_ptr<protocol::Page::VisualViewport> out_visualViewport;
    std::unique_ptr<protocol::DOM::Rect> out_contentSize;
    std::unique_ptr<protocol::Page::LayoutViewport> out_cssLayoutViewport;
    std::unique_ptr<protocol::Page::VisualViewport> out_cssVisualViewport;
    std::unique_ptr<protocol::DOM::Rect> out_cssContentSize;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getLayoutMetrics(&out_layoutViewport, &out_visualViewport, &out_contentSize, &out_cssLayoutViewport, &out_cssVisualViewport, &out_cssContentSize);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.getLayoutMetrics"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("layoutViewport"), out_layoutViewport);
          serializer.AddField(crdtp::MakeSpan("visualViewport"), out_visualViewport);
          serializer.AddField(crdtp::MakeSpan("contentSize"), out_contentSize);
          serializer.AddField(crdtp::MakeSpan("cssLayoutViewport"), out_cssLayoutViewport);
          serializer.AddField(crdtp::MakeSpan("cssVisualViewport"), out_cssVisualViewport);
          serializer.AddField(crdtp::MakeSpan("cssContentSize"), out_cssContentSize);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

class GetResourceContentCallbackImpl : public Backend::GetResourceContentCallback, public DomainDispatcher::Callback {
public:
    GetResourceContentCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.getResourceContent"), message) { }

    void sendSuccess(const String& content, bool base64Encoded) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("content"), content);
        serializer.AddField(crdtp::MakeSpan("base64Encoded"), base64Encoded);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct getResourceContentParams : public crdtp::DeserializableProtocolObject<getResourceContentParams> {
    String frameId;
    String url;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getResourceContentParams)
    CRDTP_DESERIALIZE_FIELD("frameId", frameId),
    CRDTP_DESERIALIZE_FIELD("url", url),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getResourceContent(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getResourceContentParams params;
    if (!getResourceContentParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->getResourceContent(params.frameId, params.url, std::make_unique<GetResourceContentCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {


}  // namespace

void DomainDispatcherImpl::getResourceTree(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::Page::FrameResourceTree> out_frameTree;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getResourceTree(&out_frameTree);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.getResourceTree"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("frameTree"), out_frameTree);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct reloadParams : public crdtp::DeserializableProtocolObject<reloadParams> {
    std::optional<bool> ignoreCache;
    std::optional<String> scriptToEvaluateOnLoad;
    std::optional<String> loaderId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(reloadParams)
    CRDTP_DESERIALIZE_FIELD_OPT("ignoreCache", ignoreCache),
    CRDTP_DESERIALIZE_FIELD_OPT("loaderId", loaderId),
    CRDTP_DESERIALIZE_FIELD_OPT("scriptToEvaluateOnLoad", scriptToEvaluateOnLoad),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::reload(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    reloadParams params;
    if (!reloadParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->reload(std::move(params.ignoreCache), std::move(params.scriptToEvaluateOnLoad), std::move(params.loaderId));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.reload"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct removeScriptToEvaluateOnLoadParams : public crdtp::DeserializableProtocolObject<removeScriptToEvaluateOnLoadParams> {
    String identifier;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(removeScriptToEvaluateOnLoadParams)
    CRDTP_DESERIALIZE_FIELD("identifier", identifier),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::removeScriptToEvaluateOnLoad(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    removeScriptToEvaluateOnLoadParams params;
    if (!removeScriptToEvaluateOnLoadParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->removeScriptToEvaluateOnLoad(params.identifier);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.removeScriptToEvaluateOnLoad"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct removeScriptToEvaluateOnNewDocumentParams : public crdtp::DeserializableProtocolObject<removeScriptToEvaluateOnNewDocumentParams> {
    String identifier;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(removeScriptToEvaluateOnNewDocumentParams)
    CRDTP_DESERIALIZE_FIELD("identifier", identifier),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::removeScriptToEvaluateOnNewDocument(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    removeScriptToEvaluateOnNewDocumentParams params;
    if (!removeScriptToEvaluateOnNewDocumentParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->removeScriptToEvaluateOnNewDocument(params.identifier);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.removeScriptToEvaluateOnNewDocument"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class SearchInResourceCallbackImpl : public Backend::SearchInResourceCallback, public DomainDispatcher::Callback {
public:
    SearchInResourceCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Page.searchInResource"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Array<v8_inspector::protocol::Debugger::API::SearchMatch>> result) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("result"), result);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct searchInResourceParams : public crdtp::DeserializableProtocolObject<searchInResourceParams> {
    String frameId;
    String url;
    String query;
    std::optional<bool> caseSensitive;
    std::optional<bool> isRegex;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(searchInResourceParams)
    CRDTP_DESERIALIZE_FIELD_OPT("caseSensitive", caseSensitive),
    CRDTP_DESERIALIZE_FIELD("frameId", frameId),
    CRDTP_DESERIALIZE_FIELD_OPT("isRegex", isRegex),
    CRDTP_DESERIALIZE_FIELD("query", query),
    CRDTP_DESERIALIZE_FIELD("url", url),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::searchInResource(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    searchInResourceParams params;
    if (!searchInResourceParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->searchInResource(params.frameId, params.url, params.query, std::move(params.caseSensitive), std::move(params.isRegex), std::make_unique<SearchInResourceCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct setAdBlockingEnabledParams : public crdtp::DeserializableProtocolObject<setAdBlockingEnabledParams> {
    bool enabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setAdBlockingEnabledParams)
    CRDTP_DESERIALIZE_FIELD("enabled", enabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setAdBlockingEnabled(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setAdBlockingEnabledParams params;
    if (!setAdBlockingEnabledParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setAdBlockingEnabled(params.enabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.setAdBlockingEnabled"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setBypassCSPParams : public crdtp::DeserializableProtocolObject<setBypassCSPParams> {
    bool enabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setBypassCSPParams)
    CRDTP_DESERIALIZE_FIELD("enabled", enabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setBypassCSP(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setBypassCSPParams params;
    if (!setBypassCSPParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setBypassCSP(params.enabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.setBypassCSP"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getPermissionsPolicyStateParams : public crdtp::DeserializableProtocolObject<getPermissionsPolicyStateParams> {
    String frameId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getPermissionsPolicyStateParams)
    CRDTP_DESERIALIZE_FIELD("frameId", frameId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getPermissionsPolicyState(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getPermissionsPolicyStateParams params;
    if (!getPermissionsPolicyStateParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Page::PermissionsPolicyFeatureState>> out_states;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getPermissionsPolicyState(params.frameId, &out_states);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.getPermissionsPolicyState"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("states"), out_states);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getOriginTrialsParams : public crdtp::DeserializableProtocolObject<getOriginTrialsParams> {
    String frameId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getOriginTrialsParams)
    CRDTP_DESERIALIZE_FIELD("frameId", frameId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getOriginTrials(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getOriginTrialsParams params;
    if (!getOriginTrialsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Page::OriginTrial>> out_originTrials;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getOriginTrials(params.frameId, &out_originTrials);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.getOriginTrials"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("originTrials"), out_originTrials);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setFontFamiliesParams : public crdtp::DeserializableProtocolObject<setFontFamiliesParams> {
    std::unique_ptr<protocol::Page::FontFamilies> fontFamilies;
    std::unique_ptr<protocol::Array<protocol::Page::ScriptFontFamilies>> forScripts;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setFontFamiliesParams)
    CRDTP_DESERIALIZE_FIELD("fontFamilies", fontFamilies),
    CRDTP_DESERIALIZE_FIELD_OPT("forScripts", forScripts),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setFontFamilies(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setFontFamiliesParams params;
    if (!setFontFamiliesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setFontFamilies(std::move(params.fontFamilies), std::move(params.forScripts));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.setFontFamilies"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setFontSizesParams : public crdtp::DeserializableProtocolObject<setFontSizesParams> {
    std::unique_ptr<protocol::Page::FontSizes> fontSizes;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setFontSizesParams)
    CRDTP_DESERIALIZE_FIELD("fontSizes", fontSizes),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setFontSizes(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setFontSizesParams params;
    if (!setFontSizesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setFontSizes(std::move(params.fontSizes));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.setFontSizes"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setDocumentContentParams : public crdtp::DeserializableProtocolObject<setDocumentContentParams> {
    String frameId;
    String html;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setDocumentContentParams)
    CRDTP_DESERIALIZE_FIELD("frameId", frameId),
    CRDTP_DESERIALIZE_FIELD("html", html),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setDocumentContent(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setDocumentContentParams params;
    if (!setDocumentContentParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setDocumentContent(params.frameId, params.html);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.setDocumentContent"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setLifecycleEventsEnabledParams : public crdtp::DeserializableProtocolObject<setLifecycleEventsEnabledParams> {
    bool enabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setLifecycleEventsEnabledParams)
    CRDTP_DESERIALIZE_FIELD("enabled", enabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setLifecycleEventsEnabled(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setLifecycleEventsEnabledParams params;
    if (!setLifecycleEventsEnabledParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setLifecycleEventsEnabled(params.enabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.setLifecycleEventsEnabled"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct startScreencastParams : public crdtp::DeserializableProtocolObject<startScreencastParams> {
    std::optional<String> format;
    std::optional<int> quality;
    std::optional<int> maxWidth;
    std::optional<int> maxHeight;
    std::optional<int> everyNthFrame;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(startScreencastParams)
    CRDTP_DESERIALIZE_FIELD_OPT("everyNthFrame", everyNthFrame),
    CRDTP_DESERIALIZE_FIELD_OPT("format", format),
    CRDTP_DESERIALIZE_FIELD_OPT("maxHeight", maxHeight),
    CRDTP_DESERIALIZE_FIELD_OPT("maxWidth", maxWidth),
    CRDTP_DESERIALIZE_FIELD_OPT("quality", quality),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::startScreencast(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    startScreencastParams params;
    if (!startScreencastParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->startScreencast(std::move(params.format), std::move(params.quality), std::move(params.maxWidth), std::move(params.maxHeight), std::move(params.everyNthFrame));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.startScreencast"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::stopLoading(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->stopLoading();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.stopLoading"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::stopScreencast(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->stopScreencast();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.stopScreencast"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct produceCompilationCacheParams : public crdtp::DeserializableProtocolObject<produceCompilationCacheParams> {
    std::unique_ptr<protocol::Array<protocol::Page::CompilationCacheParams>> scripts;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(produceCompilationCacheParams)
    CRDTP_DESERIALIZE_FIELD("scripts", scripts),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::produceCompilationCache(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    produceCompilationCacheParams params;
    if (!produceCompilationCacheParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->produceCompilationCache(std::move(params.scripts));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.produceCompilationCache"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct addCompilationCacheParams : public crdtp::DeserializableProtocolObject<addCompilationCacheParams> {
    String url;
    Binary data;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(addCompilationCacheParams)
    CRDTP_DESERIALIZE_FIELD("data", data),
    CRDTP_DESERIALIZE_FIELD("url", url),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::addCompilationCache(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    addCompilationCacheParams params;
    if (!addCompilationCacheParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->addCompilationCache(params.url, params.data);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.addCompilationCache"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::clearCompilationCache(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->clearCompilationCache();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.clearCompilationCache"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct generateTestReportParams : public crdtp::DeserializableProtocolObject<generateTestReportParams> {
    String message;
    std::optional<String> group;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(generateTestReportParams)
    CRDTP_DESERIALIZE_FIELD_OPT("group", group),
    CRDTP_DESERIALIZE_FIELD("message", message),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::generateTestReport(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    generateTestReportParams params;
    if (!generateTestReportParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->generateTestReport(params.message, std::move(params.group));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.generateTestReport"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::waitForDebugger(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->waitForDebugger();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.waitForDebugger"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setInterceptFileChooserDialogParams : public crdtp::DeserializableProtocolObject<setInterceptFileChooserDialogParams> {
    bool enabled;
    std::optional<bool> cancel;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setInterceptFileChooserDialogParams)
    CRDTP_DESERIALIZE_FIELD_OPT("cancel", cancel),
    CRDTP_DESERIALIZE_FIELD("enabled", enabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setInterceptFileChooserDialog(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setInterceptFileChooserDialogParams params;
    if (!setInterceptFileChooserDialogParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setInterceptFileChooserDialog(params.enabled, std::move(params.cancel));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Page.setInterceptFileChooserDialog"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
          { crdtp::SpanFrom("Page.clearDeviceMetricsOverride"), crdtp::SpanFrom("Emulation.clearDeviceMetricsOverride") },
          { crdtp::SpanFrom("Page.clearDeviceOrientationOverride"), crdtp::SpanFrom("DeviceOrientation.clearDeviceOrientationOverride") },
          { crdtp::SpanFrom("Page.clearGeolocationOverride"), crdtp::SpanFrom("Emulation.clearGeolocationOverride") },
          { crdtp::SpanFrom("Page.deleteCookie"), crdtp::SpanFrom("Network.deleteCookie") },
          { crdtp::SpanFrom("Page.setDeviceMetricsOverride"), crdtp::SpanFrom("Emulation.setDeviceMetricsOverride") },
          { crdtp::SpanFrom("Page.setDeviceOrientationOverride"), crdtp::SpanFrom("DeviceOrientation.setDeviceOrientationOverride") },
          { crdtp::SpanFrom("Page.setGeolocationOverride"), crdtp::SpanFrom("Emulation.setGeolocationOverride") },
          { crdtp::SpanFrom("Page.setTouchEmulationEnabled"), crdtp::SpanFrom("Emulation.setTouchEmulationEnabled") },
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Page"), SortedRedirects(), std::move(dispatcher));
}

} // Page
} // namespace blink
} // namespace protocol
