// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Overlay_h
#define blink_protocol_Overlay_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/dom.h"
#include "third_party/blink/renderer/core/inspector/protocol/page.h"
#include "third_party/blink/renderer/core/inspector/protocol/runtime.h"

namespace blink {
namespace protocol {
namespace Overlay {
class SourceOrderConfig;
class GridHighlightConfig;
class FlexContainerHighlightConfig;
class FlexItemHighlightConfig;
class LineStyle;
class BoxStyle;
using ContrastAlgorithm = String;
class HighlightConfig;
using ColorFormat = String;
class GridNodeHighlightConfig;
class FlexNodeHighlightConfig;
class ScrollSnapContainerHighlightConfig;
class ScrollSnapHighlightConfig;
class HingeConfig;
class WindowControlsOverlayConfig;
class ContainerQueryHighlightConfig;
class ContainerQueryContainerHighlightConfig;
class IsolatedElementHighlightConfig;
class IsolationModeHighlightConfig;
using InspectMode = String;

// ------------- Forward and enum declarations.

namespace ContrastAlgorithmEnum {
CORE_EXPORT extern const char Aa[];
CORE_EXPORT extern const char Aaa[];
CORE_EXPORT extern const char Apca[];
} // namespace ContrastAlgorithmEnum

namespace ColorFormatEnum {
CORE_EXPORT extern const char Rgb[];
CORE_EXPORT extern const char Hsl[];
CORE_EXPORT extern const char Hwb[];
CORE_EXPORT extern const char Hex[];
} // namespace ColorFormatEnum

namespace InspectModeEnum {
CORE_EXPORT extern const char SearchForNode[];
CORE_EXPORT extern const char SearchForUAShadowDOM[];
CORE_EXPORT extern const char CaptureAreaScreenshot[];
CORE_EXPORT extern const char None[];
} // namespace InspectModeEnum

// ------------- Type and builder declarations.

class CORE_EXPORT SourceOrderConfig : public ::crdtp::ProtocolObject<SourceOrderConfig> {
public:
    ~SourceOrderConfig() override { }

    protocol::DOM::RGBA* getParentOutlineColor() { return m_parentOutlineColor.get(); }
    void setParentOutlineColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_parentOutlineColor = std::move(value); }

    protocol::DOM::RGBA* getChildOutlineColor() { return m_childOutlineColor.get(); }
    void setChildOutlineColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_childOutlineColor = std::move(value); }

    template<int STATE>
    class SourceOrderConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ParentOutlineColorSet = 1 << 1,
            ChildOutlineColorSet = 1 << 2,
            AllFieldsSet = (ParentOutlineColorSet | ChildOutlineColorSet | 0)};


        SourceOrderConfigBuilder<STATE | ParentOutlineColorSet>& setParentOutlineColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            static_assert(!(STATE & ParentOutlineColorSet), "property parentOutlineColor should not be set yet");
            m_result->setParentOutlineColor(std::move(value));
            return castState<ParentOutlineColorSet>();
        }

        SourceOrderConfigBuilder<STATE | ChildOutlineColorSet>& setChildOutlineColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            static_assert(!(STATE & ChildOutlineColorSet), "property childOutlineColor should not be set yet");
            m_result->setChildOutlineColor(std::move(value));
            return castState<ChildOutlineColorSet>();
        }

        std::unique_ptr<SourceOrderConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SourceOrderConfig;
        SourceOrderConfigBuilder() : m_result(new SourceOrderConfig()) { }

        template<int STEP> SourceOrderConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SourceOrderConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::SourceOrderConfig> m_result;
    };

    static SourceOrderConfigBuilder<0> create()
    {
        return SourceOrderConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SourceOrderConfig()
    {
    }

    std::unique_ptr<protocol::DOM::RGBA> m_parentOutlineColor;
    std::unique_ptr<protocol::DOM::RGBA> m_childOutlineColor;
};


class CORE_EXPORT GridHighlightConfig : public ::crdtp::ProtocolObject<GridHighlightConfig> {
public:
    ~GridHighlightConfig() override { }

    bool hasShowGridExtensionLines() { return !!m_showGridExtensionLines; }
    bool getShowGridExtensionLines(bool defaultValue) const {
       return m_showGridExtensionLines.value_or(defaultValue);
    }
    const std::optional<bool>& getShowGridExtensionLines() const {
       return m_showGridExtensionLines;
    }
    void setShowGridExtensionLines(bool value) { m_showGridExtensionLines = value; }

    bool hasShowPositiveLineNumbers() { return !!m_showPositiveLineNumbers; }
    bool getShowPositiveLineNumbers(bool defaultValue) const {
       return m_showPositiveLineNumbers.value_or(defaultValue);
    }
    const std::optional<bool>& getShowPositiveLineNumbers() const {
       return m_showPositiveLineNumbers;
    }
    void setShowPositiveLineNumbers(bool value) { m_showPositiveLineNumbers = value; }

    bool hasShowNegativeLineNumbers() { return !!m_showNegativeLineNumbers; }
    bool getShowNegativeLineNumbers(bool defaultValue) const {
       return m_showNegativeLineNumbers.value_or(defaultValue);
    }
    const std::optional<bool>& getShowNegativeLineNumbers() const {
       return m_showNegativeLineNumbers;
    }
    void setShowNegativeLineNumbers(bool value) { m_showNegativeLineNumbers = value; }

    bool hasShowAreaNames() { return !!m_showAreaNames; }
    bool getShowAreaNames(bool defaultValue) const {
       return m_showAreaNames.value_or(defaultValue);
    }
    const std::optional<bool>& getShowAreaNames() const {
       return m_showAreaNames;
    }
    void setShowAreaNames(bool value) { m_showAreaNames = value; }

    bool hasShowLineNames() { return !!m_showLineNames; }
    bool getShowLineNames(bool defaultValue) const {
       return m_showLineNames.value_or(defaultValue);
    }
    const std::optional<bool>& getShowLineNames() const {
       return m_showLineNames;
    }
    void setShowLineNames(bool value) { m_showLineNames = value; }

    bool hasShowTrackSizes() { return !!m_showTrackSizes; }
    bool getShowTrackSizes(bool defaultValue) const {
       return m_showTrackSizes.value_or(defaultValue);
    }
    const std::optional<bool>& getShowTrackSizes() const {
       return m_showTrackSizes;
    }
    void setShowTrackSizes(bool value) { m_showTrackSizes = value; }

    bool hasGridBorderColor() { return !!m_gridBorderColor; }
    protocol::DOM::RGBA* getGridBorderColor(protocol::DOM::RGBA* defaultValue) {
       return m_gridBorderColor ? m_gridBorderColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getGridBorderColor() const {
       return m_gridBorderColor;
    }
    void setGridBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_gridBorderColor = std::move(value); }

    bool hasCellBorderColor() { return !!m_cellBorderColor; }
    protocol::DOM::RGBA* getCellBorderColor(protocol::DOM::RGBA* defaultValue) {
       return m_cellBorderColor ? m_cellBorderColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getCellBorderColor() const {
       return m_cellBorderColor;
    }
    void setCellBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_cellBorderColor = std::move(value); }

    bool hasRowLineColor() { return !!m_rowLineColor; }
    protocol::DOM::RGBA* getRowLineColor(protocol::DOM::RGBA* defaultValue) {
       return m_rowLineColor ? m_rowLineColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getRowLineColor() const {
       return m_rowLineColor;
    }
    void setRowLineColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_rowLineColor = std::move(value); }

    bool hasColumnLineColor() { return !!m_columnLineColor; }
    protocol::DOM::RGBA* getColumnLineColor(protocol::DOM::RGBA* defaultValue) {
       return m_columnLineColor ? m_columnLineColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getColumnLineColor() const {
       return m_columnLineColor;
    }
    void setColumnLineColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_columnLineColor = std::move(value); }

    bool hasGridBorderDash() { return !!m_gridBorderDash; }
    bool getGridBorderDash(bool defaultValue) const {
       return m_gridBorderDash.value_or(defaultValue);
    }
    const std::optional<bool>& getGridBorderDash() const {
       return m_gridBorderDash;
    }
    void setGridBorderDash(bool value) { m_gridBorderDash = value; }

    bool hasCellBorderDash() { return !!m_cellBorderDash; }
    bool getCellBorderDash(bool defaultValue) const {
       return m_cellBorderDash.value_or(defaultValue);
    }
    const std::optional<bool>& getCellBorderDash() const {
       return m_cellBorderDash;
    }
    void setCellBorderDash(bool value) { m_cellBorderDash = value; }

    bool hasRowLineDash() { return !!m_rowLineDash; }
    bool getRowLineDash(bool defaultValue) const {
       return m_rowLineDash.value_or(defaultValue);
    }
    const std::optional<bool>& getRowLineDash() const {
       return m_rowLineDash;
    }
    void setRowLineDash(bool value) { m_rowLineDash = value; }

    bool hasColumnLineDash() { return !!m_columnLineDash; }
    bool getColumnLineDash(bool defaultValue) const {
       return m_columnLineDash.value_or(defaultValue);
    }
    const std::optional<bool>& getColumnLineDash() const {
       return m_columnLineDash;
    }
    void setColumnLineDash(bool value) { m_columnLineDash = value; }

    bool hasRowGapColor() { return !!m_rowGapColor; }
    protocol::DOM::RGBA* getRowGapColor(protocol::DOM::RGBA* defaultValue) {
       return m_rowGapColor ? m_rowGapColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getRowGapColor() const {
       return m_rowGapColor;
    }
    void setRowGapColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_rowGapColor = std::move(value); }

    bool hasRowHatchColor() { return !!m_rowHatchColor; }
    protocol::DOM::RGBA* getRowHatchColor(protocol::DOM::RGBA* defaultValue) {
       return m_rowHatchColor ? m_rowHatchColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getRowHatchColor() const {
       return m_rowHatchColor;
    }
    void setRowHatchColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_rowHatchColor = std::move(value); }

    bool hasColumnGapColor() { return !!m_columnGapColor; }
    protocol::DOM::RGBA* getColumnGapColor(protocol::DOM::RGBA* defaultValue) {
       return m_columnGapColor ? m_columnGapColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getColumnGapColor() const {
       return m_columnGapColor;
    }
    void setColumnGapColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_columnGapColor = std::move(value); }

    bool hasColumnHatchColor() { return !!m_columnHatchColor; }
    protocol::DOM::RGBA* getColumnHatchColor(protocol::DOM::RGBA* defaultValue) {
       return m_columnHatchColor ? m_columnHatchColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getColumnHatchColor() const {
       return m_columnHatchColor;
    }
    void setColumnHatchColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_columnHatchColor = std::move(value); }

    bool hasAreaBorderColor() { return !!m_areaBorderColor; }
    protocol::DOM::RGBA* getAreaBorderColor(protocol::DOM::RGBA* defaultValue) {
       return m_areaBorderColor ? m_areaBorderColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getAreaBorderColor() const {
       return m_areaBorderColor;
    }
    void setAreaBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_areaBorderColor = std::move(value); }

    bool hasGridBackgroundColor() { return !!m_gridBackgroundColor; }
    protocol::DOM::RGBA* getGridBackgroundColor(protocol::DOM::RGBA* defaultValue) {
       return m_gridBackgroundColor ? m_gridBackgroundColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getGridBackgroundColor() const {
       return m_gridBackgroundColor;
    }
    void setGridBackgroundColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_gridBackgroundColor = std::move(value); }

    template<int STATE>
    class GridHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        GridHighlightConfigBuilder<STATE>& setShowGridExtensionLines(bool value)
        {
            m_result->setShowGridExtensionLines(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setShowPositiveLineNumbers(bool value)
        {
            m_result->setShowPositiveLineNumbers(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setShowNegativeLineNumbers(bool value)
        {
            m_result->setShowNegativeLineNumbers(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setShowAreaNames(bool value)
        {
            m_result->setShowAreaNames(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setShowLineNames(bool value)
        {
            m_result->setShowLineNames(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setShowTrackSizes(bool value)
        {
            m_result->setShowTrackSizes(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setGridBorderColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setGridBorderColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setCellBorderColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setCellBorderColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setRowLineColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setRowLineColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setColumnLineColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setColumnLineColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setGridBorderDash(bool value)
        {
            m_result->setGridBorderDash(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setCellBorderDash(bool value)
        {
            m_result->setCellBorderDash(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setRowLineDash(bool value)
        {
            m_result->setRowLineDash(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setColumnLineDash(bool value)
        {
            m_result->setColumnLineDash(value);
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setRowGapColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setRowGapColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setRowHatchColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setRowHatchColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setColumnGapColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setColumnGapColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setColumnHatchColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setColumnHatchColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setAreaBorderColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setAreaBorderColor(std::move(value));
            return *this;
        }

        GridHighlightConfigBuilder<STATE>& setGridBackgroundColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setGridBackgroundColor(std::move(value));
            return *this;
        }

        std::unique_ptr<GridHighlightConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class GridHighlightConfig;
        GridHighlightConfigBuilder() : m_result(new GridHighlightConfig()) { }

        template<int STEP> GridHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<GridHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::GridHighlightConfig> m_result;
    };

    static GridHighlightConfigBuilder<0> create()
    {
        return GridHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    GridHighlightConfig()
    {
    }

    std::optional<bool> m_showGridExtensionLines;
    std::optional<bool> m_showPositiveLineNumbers;
    std::optional<bool> m_showNegativeLineNumbers;
    std::optional<bool> m_showAreaNames;
    std::optional<bool> m_showLineNames;
    std::optional<bool> m_showTrackSizes;
    std::unique_ptr<protocol::DOM::RGBA> m_gridBorderColor;
    std::unique_ptr<protocol::DOM::RGBA> m_cellBorderColor;
    std::unique_ptr<protocol::DOM::RGBA> m_rowLineColor;
    std::unique_ptr<protocol::DOM::RGBA> m_columnLineColor;
    std::optional<bool> m_gridBorderDash;
    std::optional<bool> m_cellBorderDash;
    std::optional<bool> m_rowLineDash;
    std::optional<bool> m_columnLineDash;
    std::unique_ptr<protocol::DOM::RGBA> m_rowGapColor;
    std::unique_ptr<protocol::DOM::RGBA> m_rowHatchColor;
    std::unique_ptr<protocol::DOM::RGBA> m_columnGapColor;
    std::unique_ptr<protocol::DOM::RGBA> m_columnHatchColor;
    std::unique_ptr<protocol::DOM::RGBA> m_areaBorderColor;
    std::unique_ptr<protocol::DOM::RGBA> m_gridBackgroundColor;
};


class CORE_EXPORT FlexContainerHighlightConfig : public ::crdtp::ProtocolObject<FlexContainerHighlightConfig> {
public:
    ~FlexContainerHighlightConfig() override { }

    bool hasContainerBorder() { return !!m_containerBorder; }
    protocol::Overlay::LineStyle* getContainerBorder(protocol::Overlay::LineStyle* defaultValue) {
       return m_containerBorder ? m_containerBorder.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& getContainerBorder() const {
       return m_containerBorder;
    }
    void setContainerBorder(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_containerBorder = std::move(value); }

    bool hasLineSeparator() { return !!m_lineSeparator; }
    protocol::Overlay::LineStyle* getLineSeparator(protocol::Overlay::LineStyle* defaultValue) {
       return m_lineSeparator ? m_lineSeparator.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& getLineSeparator() const {
       return m_lineSeparator;
    }
    void setLineSeparator(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_lineSeparator = std::move(value); }

    bool hasItemSeparator() { return !!m_itemSeparator; }
    protocol::Overlay::LineStyle* getItemSeparator(protocol::Overlay::LineStyle* defaultValue) {
       return m_itemSeparator ? m_itemSeparator.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& getItemSeparator() const {
       return m_itemSeparator;
    }
    void setItemSeparator(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_itemSeparator = std::move(value); }

    bool hasMainDistributedSpace() { return !!m_mainDistributedSpace; }
    protocol::Overlay::BoxStyle* getMainDistributedSpace(protocol::Overlay::BoxStyle* defaultValue) {
       return m_mainDistributedSpace ? m_mainDistributedSpace.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::BoxStyle>& getMainDistributedSpace() const {
       return m_mainDistributedSpace;
    }
    void setMainDistributedSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value) { m_mainDistributedSpace = std::move(value); }

    bool hasCrossDistributedSpace() { return !!m_crossDistributedSpace; }
    protocol::Overlay::BoxStyle* getCrossDistributedSpace(protocol::Overlay::BoxStyle* defaultValue) {
       return m_crossDistributedSpace ? m_crossDistributedSpace.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::BoxStyle>& getCrossDistributedSpace() const {
       return m_crossDistributedSpace;
    }
    void setCrossDistributedSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value) { m_crossDistributedSpace = std::move(value); }

    bool hasRowGapSpace() { return !!m_rowGapSpace; }
    protocol::Overlay::BoxStyle* getRowGapSpace(protocol::Overlay::BoxStyle* defaultValue) {
       return m_rowGapSpace ? m_rowGapSpace.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::BoxStyle>& getRowGapSpace() const {
       return m_rowGapSpace;
    }
    void setRowGapSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value) { m_rowGapSpace = std::move(value); }

    bool hasColumnGapSpace() { return !!m_columnGapSpace; }
    protocol::Overlay::BoxStyle* getColumnGapSpace(protocol::Overlay::BoxStyle* defaultValue) {
       return m_columnGapSpace ? m_columnGapSpace.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::BoxStyle>& getColumnGapSpace() const {
       return m_columnGapSpace;
    }
    void setColumnGapSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value) { m_columnGapSpace = std::move(value); }

    bool hasCrossAlignment() { return !!m_crossAlignment; }
    protocol::Overlay::LineStyle* getCrossAlignment(protocol::Overlay::LineStyle* defaultValue) {
       return m_crossAlignment ? m_crossAlignment.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& getCrossAlignment() const {
       return m_crossAlignment;
    }
    void setCrossAlignment(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_crossAlignment = std::move(value); }

    template<int STATE>
    class FlexContainerHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        FlexContainerHighlightConfigBuilder<STATE>& setContainerBorder(std::unique_ptr<protocol::Overlay::LineStyle> value)
        {
            m_result->setContainerBorder(std::move(value));
            return *this;
        }

        FlexContainerHighlightConfigBuilder<STATE>& setLineSeparator(std::unique_ptr<protocol::Overlay::LineStyle> value)
        {
            m_result->setLineSeparator(std::move(value));
            return *this;
        }

        FlexContainerHighlightConfigBuilder<STATE>& setItemSeparator(std::unique_ptr<protocol::Overlay::LineStyle> value)
        {
            m_result->setItemSeparator(std::move(value));
            return *this;
        }

        FlexContainerHighlightConfigBuilder<STATE>& setMainDistributedSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value)
        {
            m_result->setMainDistributedSpace(std::move(value));
            return *this;
        }

        FlexContainerHighlightConfigBuilder<STATE>& setCrossDistributedSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value)
        {
            m_result->setCrossDistributedSpace(std::move(value));
            return *this;
        }

        FlexContainerHighlightConfigBuilder<STATE>& setRowGapSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value)
        {
            m_result->setRowGapSpace(std::move(value));
            return *this;
        }

        FlexContainerHighlightConfigBuilder<STATE>& setColumnGapSpace(std::unique_ptr<protocol::Overlay::BoxStyle> value)
        {
            m_result->setColumnGapSpace(std::move(value));
            return *this;
        }

        FlexContainerHighlightConfigBuilder<STATE>& setCrossAlignment(std::unique_ptr<protocol::Overlay::LineStyle> value)
        {
            m_result->setCrossAlignment(std::move(value));
            return *this;
        }

        std::unique_ptr<FlexContainerHighlightConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FlexContainerHighlightConfig;
        FlexContainerHighlightConfigBuilder() : m_result(new FlexContainerHighlightConfig()) { }

        template<int STEP> FlexContainerHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FlexContainerHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig> m_result;
    };

    static FlexContainerHighlightConfigBuilder<0> create()
    {
        return FlexContainerHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FlexContainerHighlightConfig()
    {
    }

    std::unique_ptr<protocol::Overlay::LineStyle> m_containerBorder;
    std::unique_ptr<protocol::Overlay::LineStyle> m_lineSeparator;
    std::unique_ptr<protocol::Overlay::LineStyle> m_itemSeparator;
    std::unique_ptr<protocol::Overlay::BoxStyle> m_mainDistributedSpace;
    std::unique_ptr<protocol::Overlay::BoxStyle> m_crossDistributedSpace;
    std::unique_ptr<protocol::Overlay::BoxStyle> m_rowGapSpace;
    std::unique_ptr<protocol::Overlay::BoxStyle> m_columnGapSpace;
    std::unique_ptr<protocol::Overlay::LineStyle> m_crossAlignment;
};


class CORE_EXPORT FlexItemHighlightConfig : public ::crdtp::ProtocolObject<FlexItemHighlightConfig> {
public:
    ~FlexItemHighlightConfig() override { }

    bool hasBaseSizeBox() { return !!m_baseSizeBox; }
    protocol::Overlay::BoxStyle* getBaseSizeBox(protocol::Overlay::BoxStyle* defaultValue) {
       return m_baseSizeBox ? m_baseSizeBox.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::BoxStyle>& getBaseSizeBox() const {
       return m_baseSizeBox;
    }
    void setBaseSizeBox(std::unique_ptr<protocol::Overlay::BoxStyle> value) { m_baseSizeBox = std::move(value); }

    bool hasBaseSizeBorder() { return !!m_baseSizeBorder; }
    protocol::Overlay::LineStyle* getBaseSizeBorder(protocol::Overlay::LineStyle* defaultValue) {
       return m_baseSizeBorder ? m_baseSizeBorder.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& getBaseSizeBorder() const {
       return m_baseSizeBorder;
    }
    void setBaseSizeBorder(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_baseSizeBorder = std::move(value); }

    bool hasFlexibilityArrow() { return !!m_flexibilityArrow; }
    protocol::Overlay::LineStyle* getFlexibilityArrow(protocol::Overlay::LineStyle* defaultValue) {
       return m_flexibilityArrow ? m_flexibilityArrow.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& getFlexibilityArrow() const {
       return m_flexibilityArrow;
    }
    void setFlexibilityArrow(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_flexibilityArrow = std::move(value); }

    template<int STATE>
    class FlexItemHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        FlexItemHighlightConfigBuilder<STATE>& setBaseSizeBox(std::unique_ptr<protocol::Overlay::BoxStyle> value)
        {
            m_result->setBaseSizeBox(std::move(value));
            return *this;
        }

        FlexItemHighlightConfigBuilder<STATE>& setBaseSizeBorder(std::unique_ptr<protocol::Overlay::LineStyle> value)
        {
            m_result->setBaseSizeBorder(std::move(value));
            return *this;
        }

        FlexItemHighlightConfigBuilder<STATE>& setFlexibilityArrow(std::unique_ptr<protocol::Overlay::LineStyle> value)
        {
            m_result->setFlexibilityArrow(std::move(value));
            return *this;
        }

        std::unique_ptr<FlexItemHighlightConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FlexItemHighlightConfig;
        FlexItemHighlightConfigBuilder() : m_result(new FlexItemHighlightConfig()) { }

        template<int STEP> FlexItemHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FlexItemHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::FlexItemHighlightConfig> m_result;
    };

    static FlexItemHighlightConfigBuilder<0> create()
    {
        return FlexItemHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FlexItemHighlightConfig()
    {
    }

    std::unique_ptr<protocol::Overlay::BoxStyle> m_baseSizeBox;
    std::unique_ptr<protocol::Overlay::LineStyle> m_baseSizeBorder;
    std::unique_ptr<protocol::Overlay::LineStyle> m_flexibilityArrow;
};


class CORE_EXPORT LineStyle : public ::crdtp::ProtocolObject<LineStyle> {
public:
    ~LineStyle() override { }

    bool hasColor() { return !!m_color; }
    protocol::DOM::RGBA* getColor(protocol::DOM::RGBA* defaultValue) {
       return m_color ? m_color.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getColor() const {
       return m_color;
    }
    void setColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_color = std::move(value); }

    struct CORE_EXPORT PatternEnum {
        static const char* Dashed;
        static const char* Dotted;
    }; // PatternEnum

    bool hasPattern() { return !!m_pattern; }
    String getPattern(const String& defaultValue) const {
       return m_pattern.value_or(defaultValue);
    }
    const std::optional<String>& getPattern() const {
       return m_pattern;
    }
    void setPattern(const String& value) { m_pattern = value; }

    template<int STATE>
    class LineStyleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        LineStyleBuilder<STATE>& setColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setColor(std::move(value));
            return *this;
        }

        LineStyleBuilder<STATE>& setPattern(const String& value)
        {
            m_result->setPattern(value);
            return *this;
        }

        std::unique_ptr<LineStyle> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LineStyle;
        LineStyleBuilder() : m_result(new LineStyle()) { }

        template<int STEP> LineStyleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LineStyleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::LineStyle> m_result;
    };

    static LineStyleBuilder<0> create()
    {
        return LineStyleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LineStyle()
    {
    }

    std::unique_ptr<protocol::DOM::RGBA> m_color;
    std::optional<String> m_pattern;
};


class CORE_EXPORT BoxStyle : public ::crdtp::ProtocolObject<BoxStyle> {
public:
    ~BoxStyle() override { }

    bool hasFillColor() { return !!m_fillColor; }
    protocol::DOM::RGBA* getFillColor(protocol::DOM::RGBA* defaultValue) {
       return m_fillColor ? m_fillColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getFillColor() const {
       return m_fillColor;
    }
    void setFillColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_fillColor = std::move(value); }

    bool hasHatchColor() { return !!m_hatchColor; }
    protocol::DOM::RGBA* getHatchColor(protocol::DOM::RGBA* defaultValue) {
       return m_hatchColor ? m_hatchColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getHatchColor() const {
       return m_hatchColor;
    }
    void setHatchColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_hatchColor = std::move(value); }

    template<int STATE>
    class BoxStyleBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        BoxStyleBuilder<STATE>& setFillColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setFillColor(std::move(value));
            return *this;
        }

        BoxStyleBuilder<STATE>& setHatchColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setHatchColor(std::move(value));
            return *this;
        }

        std::unique_ptr<BoxStyle> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BoxStyle;
        BoxStyleBuilder() : m_result(new BoxStyle()) { }

        template<int STEP> BoxStyleBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BoxStyleBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::BoxStyle> m_result;
    };

    static BoxStyleBuilder<0> create()
    {
        return BoxStyleBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BoxStyle()
    {
    }

    std::unique_ptr<protocol::DOM::RGBA> m_fillColor;
    std::unique_ptr<protocol::DOM::RGBA> m_hatchColor;
};


class CORE_EXPORT HighlightConfig : public ::crdtp::ProtocolObject<HighlightConfig> {
public:
    ~HighlightConfig() override { }

    bool hasShowInfo() { return !!m_showInfo; }
    bool getShowInfo(bool defaultValue) const {
       return m_showInfo.value_or(defaultValue);
    }
    const std::optional<bool>& getShowInfo() const {
       return m_showInfo;
    }
    void setShowInfo(bool value) { m_showInfo = value; }

    bool hasShowStyles() { return !!m_showStyles; }
    bool getShowStyles(bool defaultValue) const {
       return m_showStyles.value_or(defaultValue);
    }
    const std::optional<bool>& getShowStyles() const {
       return m_showStyles;
    }
    void setShowStyles(bool value) { m_showStyles = value; }

    bool hasShowRulers() { return !!m_showRulers; }
    bool getShowRulers(bool defaultValue) const {
       return m_showRulers.value_or(defaultValue);
    }
    const std::optional<bool>& getShowRulers() const {
       return m_showRulers;
    }
    void setShowRulers(bool value) { m_showRulers = value; }

    bool hasShowAccessibilityInfo() { return !!m_showAccessibilityInfo; }
    bool getShowAccessibilityInfo(bool defaultValue) const {
       return m_showAccessibilityInfo.value_or(defaultValue);
    }
    const std::optional<bool>& getShowAccessibilityInfo() const {
       return m_showAccessibilityInfo;
    }
    void setShowAccessibilityInfo(bool value) { m_showAccessibilityInfo = value; }

    bool hasShowExtensionLines() { return !!m_showExtensionLines; }
    bool getShowExtensionLines(bool defaultValue) const {
       return m_showExtensionLines.value_or(defaultValue);
    }
    const std::optional<bool>& getShowExtensionLines() const {
       return m_showExtensionLines;
    }
    void setShowExtensionLines(bool value) { m_showExtensionLines = value; }

    bool hasContentColor() { return !!m_contentColor; }
    protocol::DOM::RGBA* getContentColor(protocol::DOM::RGBA* defaultValue) {
       return m_contentColor ? m_contentColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getContentColor() const {
       return m_contentColor;
    }
    void setContentColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_contentColor = std::move(value); }

    bool hasPaddingColor() { return !!m_paddingColor; }
    protocol::DOM::RGBA* getPaddingColor(protocol::DOM::RGBA* defaultValue) {
       return m_paddingColor ? m_paddingColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getPaddingColor() const {
       return m_paddingColor;
    }
    void setPaddingColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_paddingColor = std::move(value); }

    bool hasBorderColor() { return !!m_borderColor; }
    protocol::DOM::RGBA* getBorderColor(protocol::DOM::RGBA* defaultValue) {
       return m_borderColor ? m_borderColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getBorderColor() const {
       return m_borderColor;
    }
    void setBorderColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_borderColor = std::move(value); }

    bool hasMarginColor() { return !!m_marginColor; }
    protocol::DOM::RGBA* getMarginColor(protocol::DOM::RGBA* defaultValue) {
       return m_marginColor ? m_marginColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getMarginColor() const {
       return m_marginColor;
    }
    void setMarginColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_marginColor = std::move(value); }

    bool hasEventTargetColor() { return !!m_eventTargetColor; }
    protocol::DOM::RGBA* getEventTargetColor(protocol::DOM::RGBA* defaultValue) {
       return m_eventTargetColor ? m_eventTargetColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getEventTargetColor() const {
       return m_eventTargetColor;
    }
    void setEventTargetColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_eventTargetColor = std::move(value); }

    bool hasShapeColor() { return !!m_shapeColor; }
    protocol::DOM::RGBA* getShapeColor(protocol::DOM::RGBA* defaultValue) {
       return m_shapeColor ? m_shapeColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getShapeColor() const {
       return m_shapeColor;
    }
    void setShapeColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_shapeColor = std::move(value); }

    bool hasShapeMarginColor() { return !!m_shapeMarginColor; }
    protocol::DOM::RGBA* getShapeMarginColor(protocol::DOM::RGBA* defaultValue) {
       return m_shapeMarginColor ? m_shapeMarginColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getShapeMarginColor() const {
       return m_shapeMarginColor;
    }
    void setShapeMarginColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_shapeMarginColor = std::move(value); }

    bool hasCssGridColor() { return !!m_cssGridColor; }
    protocol::DOM::RGBA* getCssGridColor(protocol::DOM::RGBA* defaultValue) {
       return m_cssGridColor ? m_cssGridColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getCssGridColor() const {
       return m_cssGridColor;
    }
    void setCssGridColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_cssGridColor = std::move(value); }

    bool hasColorFormat() { return !!m_colorFormat; }
    String getColorFormat(const String& defaultValue) const {
       return m_colorFormat.value_or(defaultValue);
    }
    const std::optional<String>& getColorFormat() const {
       return m_colorFormat;
    }
    void setColorFormat(const String& value) { m_colorFormat = value; }

    bool hasGridHighlightConfig() { return !!m_gridHighlightConfig; }
    protocol::Overlay::GridHighlightConfig* getGridHighlightConfig(protocol::Overlay::GridHighlightConfig* defaultValue) {
       return m_gridHighlightConfig ? m_gridHighlightConfig.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::GridHighlightConfig>& getGridHighlightConfig() const {
       return m_gridHighlightConfig;
    }
    void setGridHighlightConfig(std::unique_ptr<protocol::Overlay::GridHighlightConfig> value) { m_gridHighlightConfig = std::move(value); }

    bool hasFlexContainerHighlightConfig() { return !!m_flexContainerHighlightConfig; }
    protocol::Overlay::FlexContainerHighlightConfig* getFlexContainerHighlightConfig(protocol::Overlay::FlexContainerHighlightConfig* defaultValue) {
       return m_flexContainerHighlightConfig ? m_flexContainerHighlightConfig.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig>& getFlexContainerHighlightConfig() const {
       return m_flexContainerHighlightConfig;
    }
    void setFlexContainerHighlightConfig(std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig> value) { m_flexContainerHighlightConfig = std::move(value); }

    bool hasFlexItemHighlightConfig() { return !!m_flexItemHighlightConfig; }
    protocol::Overlay::FlexItemHighlightConfig* getFlexItemHighlightConfig(protocol::Overlay::FlexItemHighlightConfig* defaultValue) {
       return m_flexItemHighlightConfig ? m_flexItemHighlightConfig.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::FlexItemHighlightConfig>& getFlexItemHighlightConfig() const {
       return m_flexItemHighlightConfig;
    }
    void setFlexItemHighlightConfig(std::unique_ptr<protocol::Overlay::FlexItemHighlightConfig> value) { m_flexItemHighlightConfig = std::move(value); }

    bool hasContrastAlgorithm() { return !!m_contrastAlgorithm; }
    String getContrastAlgorithm(const String& defaultValue) const {
       return m_contrastAlgorithm.value_or(defaultValue);
    }
    const std::optional<String>& getContrastAlgorithm() const {
       return m_contrastAlgorithm;
    }
    void setContrastAlgorithm(const String& value) { m_contrastAlgorithm = value; }

    bool hasContainerQueryContainerHighlightConfig() { return !!m_containerQueryContainerHighlightConfig; }
    protocol::Overlay::ContainerQueryContainerHighlightConfig* getContainerQueryContainerHighlightConfig(protocol::Overlay::ContainerQueryContainerHighlightConfig* defaultValue) {
       return m_containerQueryContainerHighlightConfig ? m_containerQueryContainerHighlightConfig.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig>& getContainerQueryContainerHighlightConfig() const {
       return m_containerQueryContainerHighlightConfig;
    }
    void setContainerQueryContainerHighlightConfig(std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig> value) { m_containerQueryContainerHighlightConfig = std::move(value); }

    template<int STATE>
    class HighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        HighlightConfigBuilder<STATE>& setShowInfo(bool value)
        {
            m_result->setShowInfo(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& setShowStyles(bool value)
        {
            m_result->setShowStyles(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& setShowRulers(bool value)
        {
            m_result->setShowRulers(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& setShowAccessibilityInfo(bool value)
        {
            m_result->setShowAccessibilityInfo(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& setShowExtensionLines(bool value)
        {
            m_result->setShowExtensionLines(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& setContentColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setContentColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setPaddingColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setPaddingColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setBorderColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setBorderColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setMarginColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setMarginColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setEventTargetColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setEventTargetColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setShapeColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setShapeColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setShapeMarginColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setShapeMarginColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setCssGridColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setCssGridColor(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setColorFormat(const String& value)
        {
            m_result->setColorFormat(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& setGridHighlightConfig(std::unique_ptr<protocol::Overlay::GridHighlightConfig> value)
        {
            m_result->setGridHighlightConfig(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setFlexContainerHighlightConfig(std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig> value)
        {
            m_result->setFlexContainerHighlightConfig(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setFlexItemHighlightConfig(std::unique_ptr<protocol::Overlay::FlexItemHighlightConfig> value)
        {
            m_result->setFlexItemHighlightConfig(std::move(value));
            return *this;
        }

        HighlightConfigBuilder<STATE>& setContrastAlgorithm(const String& value)
        {
            m_result->setContrastAlgorithm(value);
            return *this;
        }

        HighlightConfigBuilder<STATE>& setContainerQueryContainerHighlightConfig(std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig> value)
        {
            m_result->setContainerQueryContainerHighlightConfig(std::move(value));
            return *this;
        }

        std::unique_ptr<HighlightConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class HighlightConfig;
        HighlightConfigBuilder() : m_result(new HighlightConfig()) { }

        template<int STEP> HighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<HighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::HighlightConfig> m_result;
    };

    static HighlightConfigBuilder<0> create()
    {
        return HighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    HighlightConfig()
    {
    }

    std::optional<bool> m_showInfo;
    std::optional<bool> m_showStyles;
    std::optional<bool> m_showRulers;
    std::optional<bool> m_showAccessibilityInfo;
    std::optional<bool> m_showExtensionLines;
    std::unique_ptr<protocol::DOM::RGBA> m_contentColor;
    std::unique_ptr<protocol::DOM::RGBA> m_paddingColor;
    std::unique_ptr<protocol::DOM::RGBA> m_borderColor;
    std::unique_ptr<protocol::DOM::RGBA> m_marginColor;
    std::unique_ptr<protocol::DOM::RGBA> m_eventTargetColor;
    std::unique_ptr<protocol::DOM::RGBA> m_shapeColor;
    std::unique_ptr<protocol::DOM::RGBA> m_shapeMarginColor;
    std::unique_ptr<protocol::DOM::RGBA> m_cssGridColor;
    std::optional<String> m_colorFormat;
    std::unique_ptr<protocol::Overlay::GridHighlightConfig> m_gridHighlightConfig;
    std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig> m_flexContainerHighlightConfig;
    std::unique_ptr<protocol::Overlay::FlexItemHighlightConfig> m_flexItemHighlightConfig;
    std::optional<String> m_contrastAlgorithm;
    std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig> m_containerQueryContainerHighlightConfig;
};


class CORE_EXPORT GridNodeHighlightConfig : public ::crdtp::ProtocolObject<GridNodeHighlightConfig> {
public:
    ~GridNodeHighlightConfig() override { }

    protocol::Overlay::GridHighlightConfig* getGridHighlightConfig() { return m_gridHighlightConfig.get(); }
    void setGridHighlightConfig(std::unique_ptr<protocol::Overlay::GridHighlightConfig> value) { m_gridHighlightConfig = std::move(value); }

    int getNodeId() { return m_nodeId; }
    void setNodeId(int value) { m_nodeId = value; }

    template<int STATE>
    class GridNodeHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            GridHighlightConfigSet = 1 << 1,
            NodeIdSet = 1 << 2,
            AllFieldsSet = (GridHighlightConfigSet | NodeIdSet | 0)};


        GridNodeHighlightConfigBuilder<STATE | GridHighlightConfigSet>& setGridHighlightConfig(std::unique_ptr<protocol::Overlay::GridHighlightConfig> value)
        {
            static_assert(!(STATE & GridHighlightConfigSet), "property gridHighlightConfig should not be set yet");
            m_result->setGridHighlightConfig(std::move(value));
            return castState<GridHighlightConfigSet>();
        }

        GridNodeHighlightConfigBuilder<STATE | NodeIdSet>& setNodeId(int value)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId should not be set yet");
            m_result->setNodeId(value);
            return castState<NodeIdSet>();
        }

        std::unique_ptr<GridNodeHighlightConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class GridNodeHighlightConfig;
        GridNodeHighlightConfigBuilder() : m_result(new GridNodeHighlightConfig()) { }

        template<int STEP> GridNodeHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<GridNodeHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::GridNodeHighlightConfig> m_result;
    };

    static GridNodeHighlightConfigBuilder<0> create()
    {
        return GridNodeHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    GridNodeHighlightConfig()
    {
          m_nodeId = 0;
    }

    std::unique_ptr<protocol::Overlay::GridHighlightConfig> m_gridHighlightConfig;
    int m_nodeId;
};


class CORE_EXPORT FlexNodeHighlightConfig : public ::crdtp::ProtocolObject<FlexNodeHighlightConfig> {
public:
    ~FlexNodeHighlightConfig() override { }

    protocol::Overlay::FlexContainerHighlightConfig* getFlexContainerHighlightConfig() { return m_flexContainerHighlightConfig.get(); }
    void setFlexContainerHighlightConfig(std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig> value) { m_flexContainerHighlightConfig = std::move(value); }

    int getNodeId() { return m_nodeId; }
    void setNodeId(int value) { m_nodeId = value; }

    template<int STATE>
    class FlexNodeHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FlexContainerHighlightConfigSet = 1 << 1,
            NodeIdSet = 1 << 2,
            AllFieldsSet = (FlexContainerHighlightConfigSet | NodeIdSet | 0)};


        FlexNodeHighlightConfigBuilder<STATE | FlexContainerHighlightConfigSet>& setFlexContainerHighlightConfig(std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig> value)
        {
            static_assert(!(STATE & FlexContainerHighlightConfigSet), "property flexContainerHighlightConfig should not be set yet");
            m_result->setFlexContainerHighlightConfig(std::move(value));
            return castState<FlexContainerHighlightConfigSet>();
        }

        FlexNodeHighlightConfigBuilder<STATE | NodeIdSet>& setNodeId(int value)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId should not be set yet");
            m_result->setNodeId(value);
            return castState<NodeIdSet>();
        }

        std::unique_ptr<FlexNodeHighlightConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FlexNodeHighlightConfig;
        FlexNodeHighlightConfigBuilder() : m_result(new FlexNodeHighlightConfig()) { }

        template<int STEP> FlexNodeHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FlexNodeHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::FlexNodeHighlightConfig> m_result;
    };

    static FlexNodeHighlightConfigBuilder<0> create()
    {
        return FlexNodeHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FlexNodeHighlightConfig()
    {
          m_nodeId = 0;
    }

    std::unique_ptr<protocol::Overlay::FlexContainerHighlightConfig> m_flexContainerHighlightConfig;
    int m_nodeId;
};


class CORE_EXPORT ScrollSnapContainerHighlightConfig : public ::crdtp::ProtocolObject<ScrollSnapContainerHighlightConfig> {
public:
    ~ScrollSnapContainerHighlightConfig() override { }

    bool hasSnapportBorder() { return !!m_snapportBorder; }
    protocol::Overlay::LineStyle* getSnapportBorder(protocol::Overlay::LineStyle* defaultValue) {
       return m_snapportBorder ? m_snapportBorder.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& getSnapportBorder() const {
       return m_snapportBorder;
    }
    void setSnapportBorder(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_snapportBorder = std::move(value); }

    bool hasSnapAreaBorder() { return !!m_snapAreaBorder; }
    protocol::Overlay::LineStyle* getSnapAreaBorder(protocol::Overlay::LineStyle* defaultValue) {
       return m_snapAreaBorder ? m_snapAreaBorder.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& getSnapAreaBorder() const {
       return m_snapAreaBorder;
    }
    void setSnapAreaBorder(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_snapAreaBorder = std::move(value); }

    bool hasScrollMarginColor() { return !!m_scrollMarginColor; }
    protocol::DOM::RGBA* getScrollMarginColor(protocol::DOM::RGBA* defaultValue) {
       return m_scrollMarginColor ? m_scrollMarginColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getScrollMarginColor() const {
       return m_scrollMarginColor;
    }
    void setScrollMarginColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_scrollMarginColor = std::move(value); }

    bool hasScrollPaddingColor() { return !!m_scrollPaddingColor; }
    protocol::DOM::RGBA* getScrollPaddingColor(protocol::DOM::RGBA* defaultValue) {
       return m_scrollPaddingColor ? m_scrollPaddingColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getScrollPaddingColor() const {
       return m_scrollPaddingColor;
    }
    void setScrollPaddingColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_scrollPaddingColor = std::move(value); }

    template<int STATE>
    class ScrollSnapContainerHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        ScrollSnapContainerHighlightConfigBuilder<STATE>& setSnapportBorder(std::unique_ptr<protocol::Overlay::LineStyle> value)
        {
            m_result->setSnapportBorder(std::move(value));
            return *this;
        }

        ScrollSnapContainerHighlightConfigBuilder<STATE>& setSnapAreaBorder(std::unique_ptr<protocol::Overlay::LineStyle> value)
        {
            m_result->setSnapAreaBorder(std::move(value));
            return *this;
        }

        ScrollSnapContainerHighlightConfigBuilder<STATE>& setScrollMarginColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setScrollMarginColor(std::move(value));
            return *this;
        }

        ScrollSnapContainerHighlightConfigBuilder<STATE>& setScrollPaddingColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setScrollPaddingColor(std::move(value));
            return *this;
        }

        std::unique_ptr<ScrollSnapContainerHighlightConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScrollSnapContainerHighlightConfig;
        ScrollSnapContainerHighlightConfigBuilder() : m_result(new ScrollSnapContainerHighlightConfig()) { }

        template<int STEP> ScrollSnapContainerHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScrollSnapContainerHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::ScrollSnapContainerHighlightConfig> m_result;
    };

    static ScrollSnapContainerHighlightConfigBuilder<0> create()
    {
        return ScrollSnapContainerHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScrollSnapContainerHighlightConfig()
    {
    }

    std::unique_ptr<protocol::Overlay::LineStyle> m_snapportBorder;
    std::unique_ptr<protocol::Overlay::LineStyle> m_snapAreaBorder;
    std::unique_ptr<protocol::DOM::RGBA> m_scrollMarginColor;
    std::unique_ptr<protocol::DOM::RGBA> m_scrollPaddingColor;
};


class CORE_EXPORT ScrollSnapHighlightConfig : public ::crdtp::ProtocolObject<ScrollSnapHighlightConfig> {
public:
    ~ScrollSnapHighlightConfig() override { }

    protocol::Overlay::ScrollSnapContainerHighlightConfig* getScrollSnapContainerHighlightConfig() { return m_scrollSnapContainerHighlightConfig.get(); }
    void setScrollSnapContainerHighlightConfig(std::unique_ptr<protocol::Overlay::ScrollSnapContainerHighlightConfig> value) { m_scrollSnapContainerHighlightConfig = std::move(value); }

    int getNodeId() { return m_nodeId; }
    void setNodeId(int value) { m_nodeId = value; }

    template<int STATE>
    class ScrollSnapHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ScrollSnapContainerHighlightConfigSet = 1 << 1,
            NodeIdSet = 1 << 2,
            AllFieldsSet = (ScrollSnapContainerHighlightConfigSet | NodeIdSet | 0)};


        ScrollSnapHighlightConfigBuilder<STATE | ScrollSnapContainerHighlightConfigSet>& setScrollSnapContainerHighlightConfig(std::unique_ptr<protocol::Overlay::ScrollSnapContainerHighlightConfig> value)
        {
            static_assert(!(STATE & ScrollSnapContainerHighlightConfigSet), "property scrollSnapContainerHighlightConfig should not be set yet");
            m_result->setScrollSnapContainerHighlightConfig(std::move(value));
            return castState<ScrollSnapContainerHighlightConfigSet>();
        }

        ScrollSnapHighlightConfigBuilder<STATE | NodeIdSet>& setNodeId(int value)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId should not be set yet");
            m_result->setNodeId(value);
            return castState<NodeIdSet>();
        }

        std::unique_ptr<ScrollSnapHighlightConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScrollSnapHighlightConfig;
        ScrollSnapHighlightConfigBuilder() : m_result(new ScrollSnapHighlightConfig()) { }

        template<int STEP> ScrollSnapHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScrollSnapHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::ScrollSnapHighlightConfig> m_result;
    };

    static ScrollSnapHighlightConfigBuilder<0> create()
    {
        return ScrollSnapHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScrollSnapHighlightConfig()
    {
          m_nodeId = 0;
    }

    std::unique_ptr<protocol::Overlay::ScrollSnapContainerHighlightConfig> m_scrollSnapContainerHighlightConfig;
    int m_nodeId;
};


class CORE_EXPORT HingeConfig : public ::crdtp::ProtocolObject<HingeConfig> {
public:
    ~HingeConfig() override { }

    protocol::DOM::Rect* getRect() { return m_rect.get(); }
    void setRect(std::unique_ptr<protocol::DOM::Rect> value) { m_rect = std::move(value); }

    bool hasContentColor() { return !!m_contentColor; }
    protocol::DOM::RGBA* getContentColor(protocol::DOM::RGBA* defaultValue) {
       return m_contentColor ? m_contentColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getContentColor() const {
       return m_contentColor;
    }
    void setContentColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_contentColor = std::move(value); }

    bool hasOutlineColor() { return !!m_outlineColor; }
    protocol::DOM::RGBA* getOutlineColor(protocol::DOM::RGBA* defaultValue) {
       return m_outlineColor ? m_outlineColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getOutlineColor() const {
       return m_outlineColor;
    }
    void setOutlineColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_outlineColor = std::move(value); }

    template<int STATE>
    class HingeConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RectSet = 1 << 1,
            AllFieldsSet = (RectSet | 0)};


        HingeConfigBuilder<STATE | RectSet>& setRect(std::unique_ptr<protocol::DOM::Rect> value)
        {
            static_assert(!(STATE & RectSet), "property rect should not be set yet");
            m_result->setRect(std::move(value));
            return castState<RectSet>();
        }

        HingeConfigBuilder<STATE>& setContentColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setContentColor(std::move(value));
            return *this;
        }

        HingeConfigBuilder<STATE>& setOutlineColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setOutlineColor(std::move(value));
            return *this;
        }

        std::unique_ptr<HingeConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class HingeConfig;
        HingeConfigBuilder() : m_result(new HingeConfig()) { }

        template<int STEP> HingeConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<HingeConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::HingeConfig> m_result;
    };

    static HingeConfigBuilder<0> create()
    {
        return HingeConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    HingeConfig()
    {
    }

    std::unique_ptr<protocol::DOM::Rect> m_rect;
    std::unique_ptr<protocol::DOM::RGBA> m_contentColor;
    std::unique_ptr<protocol::DOM::RGBA> m_outlineColor;
};


class CORE_EXPORT WindowControlsOverlayConfig : public ::crdtp::ProtocolObject<WindowControlsOverlayConfig> {
public:
    ~WindowControlsOverlayConfig() override { }

    bool getShowCSS() { return m_showCSS; }
    void setShowCSS(bool value) { m_showCSS = value; }

    String getSelectedPlatform() { return m_selectedPlatform; }
    void setSelectedPlatform(const String& value) { m_selectedPlatform = value; }

    String getThemeColor() { return m_themeColor; }
    void setThemeColor(const String& value) { m_themeColor = value; }

    template<int STATE>
    class WindowControlsOverlayConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ShowCSSSet = 1 << 1,
            SelectedPlatformSet = 1 << 2,
            ThemeColorSet = 1 << 3,
            AllFieldsSet = (ShowCSSSet | SelectedPlatformSet | ThemeColorSet | 0)};


        WindowControlsOverlayConfigBuilder<STATE | ShowCSSSet>& setShowCSS(bool value)
        {
            static_assert(!(STATE & ShowCSSSet), "property showCSS should not be set yet");
            m_result->setShowCSS(value);
            return castState<ShowCSSSet>();
        }

        WindowControlsOverlayConfigBuilder<STATE | SelectedPlatformSet>& setSelectedPlatform(const String& value)
        {
            static_assert(!(STATE & SelectedPlatformSet), "property selectedPlatform should not be set yet");
            m_result->setSelectedPlatform(value);
            return castState<SelectedPlatformSet>();
        }

        WindowControlsOverlayConfigBuilder<STATE | ThemeColorSet>& setThemeColor(const String& value)
        {
            static_assert(!(STATE & ThemeColorSet), "property themeColor should not be set yet");
            m_result->setThemeColor(value);
            return castState<ThemeColorSet>();
        }

        std::unique_ptr<WindowControlsOverlayConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class WindowControlsOverlayConfig;
        WindowControlsOverlayConfigBuilder() : m_result(new WindowControlsOverlayConfig()) { }

        template<int STEP> WindowControlsOverlayConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<WindowControlsOverlayConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::WindowControlsOverlayConfig> m_result;
    };

    static WindowControlsOverlayConfigBuilder<0> create()
    {
        return WindowControlsOverlayConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    WindowControlsOverlayConfig()
    {
          m_showCSS = false;
    }

    bool m_showCSS;
    String m_selectedPlatform;
    String m_themeColor;
};


class CORE_EXPORT ContainerQueryHighlightConfig : public ::crdtp::ProtocolObject<ContainerQueryHighlightConfig> {
public:
    ~ContainerQueryHighlightConfig() override { }

    protocol::Overlay::ContainerQueryContainerHighlightConfig* getContainerQueryContainerHighlightConfig() { return m_containerQueryContainerHighlightConfig.get(); }
    void setContainerQueryContainerHighlightConfig(std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig> value) { m_containerQueryContainerHighlightConfig = std::move(value); }

    int getNodeId() { return m_nodeId; }
    void setNodeId(int value) { m_nodeId = value; }

    template<int STATE>
    class ContainerQueryHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ContainerQueryContainerHighlightConfigSet = 1 << 1,
            NodeIdSet = 1 << 2,
            AllFieldsSet = (ContainerQueryContainerHighlightConfigSet | NodeIdSet | 0)};


        ContainerQueryHighlightConfigBuilder<STATE | ContainerQueryContainerHighlightConfigSet>& setContainerQueryContainerHighlightConfig(std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig> value)
        {
            static_assert(!(STATE & ContainerQueryContainerHighlightConfigSet), "property containerQueryContainerHighlightConfig should not be set yet");
            m_result->setContainerQueryContainerHighlightConfig(std::move(value));
            return castState<ContainerQueryContainerHighlightConfigSet>();
        }

        ContainerQueryHighlightConfigBuilder<STATE | NodeIdSet>& setNodeId(int value)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId should not be set yet");
            m_result->setNodeId(value);
            return castState<NodeIdSet>();
        }

        std::unique_ptr<ContainerQueryHighlightConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ContainerQueryHighlightConfig;
        ContainerQueryHighlightConfigBuilder() : m_result(new ContainerQueryHighlightConfig()) { }

        template<int STEP> ContainerQueryHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ContainerQueryHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::ContainerQueryHighlightConfig> m_result;
    };

    static ContainerQueryHighlightConfigBuilder<0> create()
    {
        return ContainerQueryHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ContainerQueryHighlightConfig()
    {
          m_nodeId = 0;
    }

    std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig> m_containerQueryContainerHighlightConfig;
    int m_nodeId;
};


class CORE_EXPORT ContainerQueryContainerHighlightConfig : public ::crdtp::ProtocolObject<ContainerQueryContainerHighlightConfig> {
public:
    ~ContainerQueryContainerHighlightConfig() override { }

    bool hasContainerBorder() { return !!m_containerBorder; }
    protocol::Overlay::LineStyle* getContainerBorder(protocol::Overlay::LineStyle* defaultValue) {
       return m_containerBorder ? m_containerBorder.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& getContainerBorder() const {
       return m_containerBorder;
    }
    void setContainerBorder(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_containerBorder = std::move(value); }

    bool hasDescendantBorder() { return !!m_descendantBorder; }
    protocol::Overlay::LineStyle* getDescendantBorder(protocol::Overlay::LineStyle* defaultValue) {
       return m_descendantBorder ? m_descendantBorder.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Overlay::LineStyle>& getDescendantBorder() const {
       return m_descendantBorder;
    }
    void setDescendantBorder(std::unique_ptr<protocol::Overlay::LineStyle> value) { m_descendantBorder = std::move(value); }

    template<int STATE>
    class ContainerQueryContainerHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        ContainerQueryContainerHighlightConfigBuilder<STATE>& setContainerBorder(std::unique_ptr<protocol::Overlay::LineStyle> value)
        {
            m_result->setContainerBorder(std::move(value));
            return *this;
        }

        ContainerQueryContainerHighlightConfigBuilder<STATE>& setDescendantBorder(std::unique_ptr<protocol::Overlay::LineStyle> value)
        {
            m_result->setDescendantBorder(std::move(value));
            return *this;
        }

        std::unique_ptr<ContainerQueryContainerHighlightConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ContainerQueryContainerHighlightConfig;
        ContainerQueryContainerHighlightConfigBuilder() : m_result(new ContainerQueryContainerHighlightConfig()) { }

        template<int STEP> ContainerQueryContainerHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ContainerQueryContainerHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::ContainerQueryContainerHighlightConfig> m_result;
    };

    static ContainerQueryContainerHighlightConfigBuilder<0> create()
    {
        return ContainerQueryContainerHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ContainerQueryContainerHighlightConfig()
    {
    }

    std::unique_ptr<protocol::Overlay::LineStyle> m_containerBorder;
    std::unique_ptr<protocol::Overlay::LineStyle> m_descendantBorder;
};


class CORE_EXPORT IsolatedElementHighlightConfig : public ::crdtp::ProtocolObject<IsolatedElementHighlightConfig> {
public:
    ~IsolatedElementHighlightConfig() override { }

    protocol::Overlay::IsolationModeHighlightConfig* getIsolationModeHighlightConfig() { return m_isolationModeHighlightConfig.get(); }
    void setIsolationModeHighlightConfig(std::unique_ptr<protocol::Overlay::IsolationModeHighlightConfig> value) { m_isolationModeHighlightConfig = std::move(value); }

    int getNodeId() { return m_nodeId; }
    void setNodeId(int value) { m_nodeId = value; }

    template<int STATE>
    class IsolatedElementHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IsolationModeHighlightConfigSet = 1 << 1,
            NodeIdSet = 1 << 2,
            AllFieldsSet = (IsolationModeHighlightConfigSet | NodeIdSet | 0)};


        IsolatedElementHighlightConfigBuilder<STATE | IsolationModeHighlightConfigSet>& setIsolationModeHighlightConfig(std::unique_ptr<protocol::Overlay::IsolationModeHighlightConfig> value)
        {
            static_assert(!(STATE & IsolationModeHighlightConfigSet), "property isolationModeHighlightConfig should not be set yet");
            m_result->setIsolationModeHighlightConfig(std::move(value));
            return castState<IsolationModeHighlightConfigSet>();
        }

        IsolatedElementHighlightConfigBuilder<STATE | NodeIdSet>& setNodeId(int value)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId should not be set yet");
            m_result->setNodeId(value);
            return castState<NodeIdSet>();
        }

        std::unique_ptr<IsolatedElementHighlightConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class IsolatedElementHighlightConfig;
        IsolatedElementHighlightConfigBuilder() : m_result(new IsolatedElementHighlightConfig()) { }

        template<int STEP> IsolatedElementHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<IsolatedElementHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::IsolatedElementHighlightConfig> m_result;
    };

    static IsolatedElementHighlightConfigBuilder<0> create()
    {
        return IsolatedElementHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    IsolatedElementHighlightConfig()
    {
          m_nodeId = 0;
    }

    std::unique_ptr<protocol::Overlay::IsolationModeHighlightConfig> m_isolationModeHighlightConfig;
    int m_nodeId;
};


class CORE_EXPORT IsolationModeHighlightConfig : public ::crdtp::ProtocolObject<IsolationModeHighlightConfig> {
public:
    ~IsolationModeHighlightConfig() override { }

    bool hasResizerColor() { return !!m_resizerColor; }
    protocol::DOM::RGBA* getResizerColor(protocol::DOM::RGBA* defaultValue) {
       return m_resizerColor ? m_resizerColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getResizerColor() const {
       return m_resizerColor;
    }
    void setResizerColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_resizerColor = std::move(value); }

    bool hasResizerHandleColor() { return !!m_resizerHandleColor; }
    protocol::DOM::RGBA* getResizerHandleColor(protocol::DOM::RGBA* defaultValue) {
       return m_resizerHandleColor ? m_resizerHandleColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getResizerHandleColor() const {
       return m_resizerHandleColor;
    }
    void setResizerHandleColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_resizerHandleColor = std::move(value); }

    bool hasMaskColor() { return !!m_maskColor; }
    protocol::DOM::RGBA* getMaskColor(protocol::DOM::RGBA* defaultValue) {
       return m_maskColor ? m_maskColor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::RGBA>& getMaskColor() const {
       return m_maskColor;
    }
    void setMaskColor(std::unique_ptr<protocol::DOM::RGBA> value) { m_maskColor = std::move(value); }

    template<int STATE>
    class IsolationModeHighlightConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        IsolationModeHighlightConfigBuilder<STATE>& setResizerColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setResizerColor(std::move(value));
            return *this;
        }

        IsolationModeHighlightConfigBuilder<STATE>& setResizerHandleColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setResizerHandleColor(std::move(value));
            return *this;
        }

        IsolationModeHighlightConfigBuilder<STATE>& setMaskColor(std::unique_ptr<protocol::DOM::RGBA> value)
        {
            m_result->setMaskColor(std::move(value));
            return *this;
        }

        std::unique_ptr<IsolationModeHighlightConfig> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class IsolationModeHighlightConfig;
        IsolationModeHighlightConfigBuilder() : m_result(new IsolationModeHighlightConfig()) { }

        template<int STEP> IsolationModeHighlightConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<IsolationModeHighlightConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Overlay::IsolationModeHighlightConfig> m_result;
    };

    static IsolationModeHighlightConfigBuilder<0> create()
    {
        return IsolationModeHighlightConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    IsolationModeHighlightConfig()
    {
    }

    std::unique_ptr<protocol::DOM::RGBA> m_resizerColor;
    std::unique_ptr<protocol::DOM::RGBA> m_resizerHandleColor;
    std::unique_ptr<protocol::DOM::RGBA> m_maskColor;
};


// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse getHighlightObjectForTest(int in_nodeId, std::optional<bool> in_includeDistance, std::optional<bool> in_includeStyle, std::optional<String> in_colorFormat, std::optional<bool> in_showAccessibilityInfo, std::unique_ptr<protocol::DictionaryValue>* out_highlight) = 0;
    virtual DispatchResponse getGridHighlightObjectsForTest(std::unique_ptr<protocol::Array<int>> in_nodeIds, std::unique_ptr<protocol::DictionaryValue>* out_highlights) = 0;
    virtual DispatchResponse getSourceOrderHighlightObjectForTest(int in_nodeId, std::unique_ptr<protocol::DictionaryValue>* out_highlight) = 0;
    virtual DispatchResponse hideHighlight() = 0;
    virtual DispatchResponse highlightFrame(const String& in_frameId, std::unique_ptr<protocol::DOM::RGBA> in_contentColor, std::unique_ptr<protocol::DOM::RGBA> in_contentOutlineColor) = 0;
    virtual DispatchResponse highlightNode(std::unique_ptr<protocol::Overlay::HighlightConfig> in_highlightConfig, std::optional<int> in_nodeId, std::optional<int> in_backendNodeId, std::optional<String> in_objectId, std::optional<String> in_selector) = 0;
    virtual DispatchResponse highlightQuad(std::unique_ptr<protocol::Array<double>> in_quad, std::unique_ptr<protocol::DOM::RGBA> in_color, std::unique_ptr<protocol::DOM::RGBA> in_outlineColor) = 0;
    virtual DispatchResponse highlightRect(int in_x, int in_y, int in_width, int in_height, std::unique_ptr<protocol::DOM::RGBA> in_color, std::unique_ptr<protocol::DOM::RGBA> in_outlineColor) = 0;
    virtual DispatchResponse highlightSourceOrder(std::unique_ptr<protocol::Overlay::SourceOrderConfig> in_sourceOrderConfig, std::optional<int> in_nodeId, std::optional<int> in_backendNodeId, std::optional<String> in_objectId) = 0;
    virtual DispatchResponse setInspectMode(const String& in_mode, std::unique_ptr<protocol::Overlay::HighlightConfig> in_highlightConfig) = 0;
    virtual DispatchResponse setShowAdHighlights(bool in_show) = 0;
    virtual DispatchResponse setPausedInDebuggerMessage(std::optional<String> in_message) = 0;
    virtual DispatchResponse setShowDebugBorders(bool in_show) = 0;
    virtual DispatchResponse setShowFPSCounter(bool in_show) = 0;
    virtual DispatchResponse setShowGridOverlays(std::unique_ptr<protocol::Array<protocol::Overlay::GridNodeHighlightConfig>> in_gridNodeHighlightConfigs) = 0;
    virtual DispatchResponse setShowFlexOverlays(std::unique_ptr<protocol::Array<protocol::Overlay::FlexNodeHighlightConfig>> in_flexNodeHighlightConfigs) = 0;
    virtual DispatchResponse setShowScrollSnapOverlays(std::unique_ptr<protocol::Array<protocol::Overlay::ScrollSnapHighlightConfig>> in_scrollSnapHighlightConfigs) = 0;
    virtual DispatchResponse setShowContainerQueryOverlays(std::unique_ptr<protocol::Array<protocol::Overlay::ContainerQueryHighlightConfig>> in_containerQueryHighlightConfigs) = 0;
    virtual DispatchResponse setShowPaintRects(bool in_result) = 0;
    virtual DispatchResponse setShowLayoutShiftRegions(bool in_result) = 0;
    virtual DispatchResponse setShowScrollBottleneckRects(bool in_show) = 0;
    virtual DispatchResponse setShowHitTestBorders(bool in_show) = 0;
    virtual DispatchResponse setShowWebVitals(bool in_show) = 0;
    virtual DispatchResponse setShowViewportSizeOnResize(bool in_show) = 0;
    virtual DispatchResponse setShowHinge(std::unique_ptr<protocol::Overlay::HingeConfig> in_hingeConfig) = 0;
    virtual DispatchResponse setShowIsolatedElements(std::unique_ptr<protocol::Array<protocol::Overlay::IsolatedElementHighlightConfig>> in_isolatedElementHighlightConfigs) = 0;
    virtual DispatchResponse setShowWindowControlsOverlay(std::unique_ptr<protocol::Overlay::WindowControlsOverlayConfig> in_windowControlsOverlayConfig) = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void inspectNodeRequested(int backendNodeId);
    void nodeHighlightRequested(int nodeId);
    void screenshotRequested(std::unique_ptr<protocol::Page::Viewport> viewport);
    void inspectModeCanceled();

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Overlay
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Overlay_h)
