// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/overlay.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace Overlay {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Overlay";
const char Metainfo::commandPrefix[] = "Overlay.";
const char Metainfo::version[] = "1.3";

CRDTP_BEGIN_DESERIALIZER(SourceOrderConfig)
    CRDTP_DESERIALIZE_FIELD("childOutlineColor", m_childOutlineColor),
    CRDTP_DESERIALIZE_FIELD("parentOutlineColor", m_parentOutlineColor),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SourceOrderConfig)
    CRDTP_SERIALIZE_FIELD("parentOutlineColor", m_parentOutlineColor);
    CRDTP_SERIALIZE_FIELD("childOutlineColor", m_childOutlineColor);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(GridHighlightConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("areaBorderColor", m_areaBorderColor),
    CRDTP_DESERIALIZE_FIELD_OPT("cellBorderColor", m_cellBorderColor),
    CRDTP_DESERIALIZE_FIELD_OPT("cellBorderDash", m_cellBorderDash),
    CRDTP_DESERIALIZE_FIELD_OPT("columnGapColor", m_columnGapColor),
    CRDTP_DESERIALIZE_FIELD_OPT("columnHatchColor", m_columnHatchColor),
    CRDTP_DESERIALIZE_FIELD_OPT("columnLineColor", m_columnLineColor),
    CRDTP_DESERIALIZE_FIELD_OPT("columnLineDash", m_columnLineDash),
    CRDTP_DESERIALIZE_FIELD_OPT("gridBackgroundColor", m_gridBackgroundColor),
    CRDTP_DESERIALIZE_FIELD_OPT("gridBorderColor", m_gridBorderColor),
    CRDTP_DESERIALIZE_FIELD_OPT("gridBorderDash", m_gridBorderDash),
    CRDTP_DESERIALIZE_FIELD_OPT("rowGapColor", m_rowGapColor),
    CRDTP_DESERIALIZE_FIELD_OPT("rowHatchColor", m_rowHatchColor),
    CRDTP_DESERIALIZE_FIELD_OPT("rowLineColor", m_rowLineColor),
    CRDTP_DESERIALIZE_FIELD_OPT("rowLineDash", m_rowLineDash),
    CRDTP_DESERIALIZE_FIELD_OPT("showAreaNames", m_showAreaNames),
    CRDTP_DESERIALIZE_FIELD_OPT("showGridExtensionLines", m_showGridExtensionLines),
    CRDTP_DESERIALIZE_FIELD_OPT("showLineNames", m_showLineNames),
    CRDTP_DESERIALIZE_FIELD_OPT("showNegativeLineNumbers", m_showNegativeLineNumbers),
    CRDTP_DESERIALIZE_FIELD_OPT("showPositiveLineNumbers", m_showPositiveLineNumbers),
    CRDTP_DESERIALIZE_FIELD_OPT("showTrackSizes", m_showTrackSizes),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(GridHighlightConfig)
    CRDTP_SERIALIZE_FIELD("showGridExtensionLines", m_showGridExtensionLines);
    CRDTP_SERIALIZE_FIELD("showPositiveLineNumbers", m_showPositiveLineNumbers);
    CRDTP_SERIALIZE_FIELD("showNegativeLineNumbers", m_showNegativeLineNumbers);
    CRDTP_SERIALIZE_FIELD("showAreaNames", m_showAreaNames);
    CRDTP_SERIALIZE_FIELD("showLineNames", m_showLineNames);
    CRDTP_SERIALIZE_FIELD("showTrackSizes", m_showTrackSizes);
    CRDTP_SERIALIZE_FIELD("gridBorderColor", m_gridBorderColor);
    CRDTP_SERIALIZE_FIELD("cellBorderColor", m_cellBorderColor);
    CRDTP_SERIALIZE_FIELD("rowLineColor", m_rowLineColor);
    CRDTP_SERIALIZE_FIELD("columnLineColor", m_columnLineColor);
    CRDTP_SERIALIZE_FIELD("gridBorderDash", m_gridBorderDash);
    CRDTP_SERIALIZE_FIELD("cellBorderDash", m_cellBorderDash);
    CRDTP_SERIALIZE_FIELD("rowLineDash", m_rowLineDash);
    CRDTP_SERIALIZE_FIELD("columnLineDash", m_columnLineDash);
    CRDTP_SERIALIZE_FIELD("rowGapColor", m_rowGapColor);
    CRDTP_SERIALIZE_FIELD("rowHatchColor", m_rowHatchColor);
    CRDTP_SERIALIZE_FIELD("columnGapColor", m_columnGapColor);
    CRDTP_SERIALIZE_FIELD("columnHatchColor", m_columnHatchColor);
    CRDTP_SERIALIZE_FIELD("areaBorderColor", m_areaBorderColor);
    CRDTP_SERIALIZE_FIELD("gridBackgroundColor", m_gridBackgroundColor);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(FlexContainerHighlightConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("columnGapSpace", m_columnGapSpace),
    CRDTP_DESERIALIZE_FIELD_OPT("containerBorder", m_containerBorder),
    CRDTP_DESERIALIZE_FIELD_OPT("crossAlignment", m_crossAlignment),
    CRDTP_DESERIALIZE_FIELD_OPT("crossDistributedSpace", m_crossDistributedSpace),
    CRDTP_DESERIALIZE_FIELD_OPT("itemSeparator", m_itemSeparator),
    CRDTP_DESERIALIZE_FIELD_OPT("lineSeparator", m_lineSeparator),
    CRDTP_DESERIALIZE_FIELD_OPT("mainDistributedSpace", m_mainDistributedSpace),
    CRDTP_DESERIALIZE_FIELD_OPT("rowGapSpace", m_rowGapSpace),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FlexContainerHighlightConfig)
    CRDTP_SERIALIZE_FIELD("containerBorder", m_containerBorder);
    CRDTP_SERIALIZE_FIELD("lineSeparator", m_lineSeparator);
    CRDTP_SERIALIZE_FIELD("itemSeparator", m_itemSeparator);
    CRDTP_SERIALIZE_FIELD("mainDistributedSpace", m_mainDistributedSpace);
    CRDTP_SERIALIZE_FIELD("crossDistributedSpace", m_crossDistributedSpace);
    CRDTP_SERIALIZE_FIELD("rowGapSpace", m_rowGapSpace);
    CRDTP_SERIALIZE_FIELD("columnGapSpace", m_columnGapSpace);
    CRDTP_SERIALIZE_FIELD("crossAlignment", m_crossAlignment);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(FlexItemHighlightConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("baseSizeBorder", m_baseSizeBorder),
    CRDTP_DESERIALIZE_FIELD_OPT("baseSizeBox", m_baseSizeBox),
    CRDTP_DESERIALIZE_FIELD_OPT("flexibilityArrow", m_flexibilityArrow),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FlexItemHighlightConfig)
    CRDTP_SERIALIZE_FIELD("baseSizeBox", m_baseSizeBox);
    CRDTP_SERIALIZE_FIELD("baseSizeBorder", m_baseSizeBorder);
    CRDTP_SERIALIZE_FIELD("flexibilityArrow", m_flexibilityArrow);
CRDTP_END_SERIALIZER();



const char* LineStyle::PatternEnum::Dashed = "dashed";
const char* LineStyle::PatternEnum::Dotted = "dotted";
CRDTP_BEGIN_DESERIALIZER(LineStyle)
    CRDTP_DESERIALIZE_FIELD_OPT("color", m_color),
    CRDTP_DESERIALIZE_FIELD_OPT("pattern", m_pattern),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(LineStyle)
    CRDTP_SERIALIZE_FIELD("color", m_color);
    CRDTP_SERIALIZE_FIELD("pattern", m_pattern);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(BoxStyle)
    CRDTP_DESERIALIZE_FIELD_OPT("fillColor", m_fillColor),
    CRDTP_DESERIALIZE_FIELD_OPT("hatchColor", m_hatchColor),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BoxStyle)
    CRDTP_SERIALIZE_FIELD("fillColor", m_fillColor);
    CRDTP_SERIALIZE_FIELD("hatchColor", m_hatchColor);
CRDTP_END_SERIALIZER();


namespace ContrastAlgorithmEnum {
const char Aa[] = "aa";
const char Aaa[] = "aaa";
const char Apca[] = "apca";
} // namespace ContrastAlgorithmEnum


CRDTP_BEGIN_DESERIALIZER(HighlightConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("borderColor", m_borderColor),
    CRDTP_DESERIALIZE_FIELD_OPT("colorFormat", m_colorFormat),
    CRDTP_DESERIALIZE_FIELD_OPT("containerQueryContainerHighlightConfig", m_containerQueryContainerHighlightConfig),
    CRDTP_DESERIALIZE_FIELD_OPT("contentColor", m_contentColor),
    CRDTP_DESERIALIZE_FIELD_OPT("contrastAlgorithm", m_contrastAlgorithm),
    CRDTP_DESERIALIZE_FIELD_OPT("cssGridColor", m_cssGridColor),
    CRDTP_DESERIALIZE_FIELD_OPT("eventTargetColor", m_eventTargetColor),
    CRDTP_DESERIALIZE_FIELD_OPT("flexContainerHighlightConfig", m_flexContainerHighlightConfig),
    CRDTP_DESERIALIZE_FIELD_OPT("flexItemHighlightConfig", m_flexItemHighlightConfig),
    CRDTP_DESERIALIZE_FIELD_OPT("gridHighlightConfig", m_gridHighlightConfig),
    CRDTP_DESERIALIZE_FIELD_OPT("marginColor", m_marginColor),
    CRDTP_DESERIALIZE_FIELD_OPT("paddingColor", m_paddingColor),
    CRDTP_DESERIALIZE_FIELD_OPT("shapeColor", m_shapeColor),
    CRDTP_DESERIALIZE_FIELD_OPT("shapeMarginColor", m_shapeMarginColor),
    CRDTP_DESERIALIZE_FIELD_OPT("showAccessibilityInfo", m_showAccessibilityInfo),
    CRDTP_DESERIALIZE_FIELD_OPT("showExtensionLines", m_showExtensionLines),
    CRDTP_DESERIALIZE_FIELD_OPT("showInfo", m_showInfo),
    CRDTP_DESERIALIZE_FIELD_OPT("showRulers", m_showRulers),
    CRDTP_DESERIALIZE_FIELD_OPT("showStyles", m_showStyles),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(HighlightConfig)
    CRDTP_SERIALIZE_FIELD("showInfo", m_showInfo);
    CRDTP_SERIALIZE_FIELD("showStyles", m_showStyles);
    CRDTP_SERIALIZE_FIELD("showRulers", m_showRulers);
    CRDTP_SERIALIZE_FIELD("showAccessibilityInfo", m_showAccessibilityInfo);
    CRDTP_SERIALIZE_FIELD("showExtensionLines", m_showExtensionLines);
    CRDTP_SERIALIZE_FIELD("contentColor", m_contentColor);
    CRDTP_SERIALIZE_FIELD("paddingColor", m_paddingColor);
    CRDTP_SERIALIZE_FIELD("borderColor", m_borderColor);
    CRDTP_SERIALIZE_FIELD("marginColor", m_marginColor);
    CRDTP_SERIALIZE_FIELD("eventTargetColor", m_eventTargetColor);
    CRDTP_SERIALIZE_FIELD("shapeColor", m_shapeColor);
    CRDTP_SERIALIZE_FIELD("shapeMarginColor", m_shapeMarginColor);
    CRDTP_SERIALIZE_FIELD("cssGridColor", m_cssGridColor);
    CRDTP_SERIALIZE_FIELD("colorFormat", m_colorFormat);
    CRDTP_SERIALIZE_FIELD("gridHighlightConfig", m_gridHighlightConfig);
    CRDTP_SERIALIZE_FIELD("flexContainerHighlightConfig", m_flexContainerHighlightConfig);
    CRDTP_SERIALIZE_FIELD("flexItemHighlightConfig", m_flexItemHighlightConfig);
    CRDTP_SERIALIZE_FIELD("contrastAlgorithm", m_contrastAlgorithm);
    CRDTP_SERIALIZE_FIELD("containerQueryContainerHighlightConfig", m_containerQueryContainerHighlightConfig);
CRDTP_END_SERIALIZER();


namespace ColorFormatEnum {
const char Rgb[] = "rgb";
const char Hsl[] = "hsl";
const char Hwb[] = "hwb";
const char Hex[] = "hex";
} // namespace ColorFormatEnum


CRDTP_BEGIN_DESERIALIZER(GridNodeHighlightConfig)
    CRDTP_DESERIALIZE_FIELD("gridHighlightConfig", m_gridHighlightConfig),
    CRDTP_DESERIALIZE_FIELD("nodeId", m_nodeId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(GridNodeHighlightConfig)
    CRDTP_SERIALIZE_FIELD("gridHighlightConfig", m_gridHighlightConfig);
    CRDTP_SERIALIZE_FIELD("nodeId", m_nodeId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(FlexNodeHighlightConfig)
    CRDTP_DESERIALIZE_FIELD("flexContainerHighlightConfig", m_flexContainerHighlightConfig),
    CRDTP_DESERIALIZE_FIELD("nodeId", m_nodeId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FlexNodeHighlightConfig)
    CRDTP_SERIALIZE_FIELD("flexContainerHighlightConfig", m_flexContainerHighlightConfig);
    CRDTP_SERIALIZE_FIELD("nodeId", m_nodeId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ScrollSnapContainerHighlightConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("scrollMarginColor", m_scrollMarginColor),
    CRDTP_DESERIALIZE_FIELD_OPT("scrollPaddingColor", m_scrollPaddingColor),
    CRDTP_DESERIALIZE_FIELD_OPT("snapAreaBorder", m_snapAreaBorder),
    CRDTP_DESERIALIZE_FIELD_OPT("snapportBorder", m_snapportBorder),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ScrollSnapContainerHighlightConfig)
    CRDTP_SERIALIZE_FIELD("snapportBorder", m_snapportBorder);
    CRDTP_SERIALIZE_FIELD("snapAreaBorder", m_snapAreaBorder);
    CRDTP_SERIALIZE_FIELD("scrollMarginColor", m_scrollMarginColor);
    CRDTP_SERIALIZE_FIELD("scrollPaddingColor", m_scrollPaddingColor);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ScrollSnapHighlightConfig)
    CRDTP_DESERIALIZE_FIELD("nodeId", m_nodeId),
    CRDTP_DESERIALIZE_FIELD("scrollSnapContainerHighlightConfig", m_scrollSnapContainerHighlightConfig),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ScrollSnapHighlightConfig)
    CRDTP_SERIALIZE_FIELD("scrollSnapContainerHighlightConfig", m_scrollSnapContainerHighlightConfig);
    CRDTP_SERIALIZE_FIELD("nodeId", m_nodeId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(HingeConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("contentColor", m_contentColor),
    CRDTP_DESERIALIZE_FIELD_OPT("outlineColor", m_outlineColor),
    CRDTP_DESERIALIZE_FIELD("rect", m_rect),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(HingeConfig)
    CRDTP_SERIALIZE_FIELD("rect", m_rect);
    CRDTP_SERIALIZE_FIELD("contentColor", m_contentColor);
    CRDTP_SERIALIZE_FIELD("outlineColor", m_outlineColor);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(WindowControlsOverlayConfig)
    CRDTP_DESERIALIZE_FIELD("selectedPlatform", m_selectedPlatform),
    CRDTP_DESERIALIZE_FIELD("showCSS", m_showCSS),
    CRDTP_DESERIALIZE_FIELD("themeColor", m_themeColor),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(WindowControlsOverlayConfig)
    CRDTP_SERIALIZE_FIELD("showCSS", m_showCSS);
    CRDTP_SERIALIZE_FIELD("selectedPlatform", m_selectedPlatform);
    CRDTP_SERIALIZE_FIELD("themeColor", m_themeColor);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ContainerQueryHighlightConfig)
    CRDTP_DESERIALIZE_FIELD("containerQueryContainerHighlightConfig", m_containerQueryContainerHighlightConfig),
    CRDTP_DESERIALIZE_FIELD("nodeId", m_nodeId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ContainerQueryHighlightConfig)
    CRDTP_SERIALIZE_FIELD("containerQueryContainerHighlightConfig", m_containerQueryContainerHighlightConfig);
    CRDTP_SERIALIZE_FIELD("nodeId", m_nodeId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ContainerQueryContainerHighlightConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("containerBorder", m_containerBorder),
    CRDTP_DESERIALIZE_FIELD_OPT("descendantBorder", m_descendantBorder),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ContainerQueryContainerHighlightConfig)
    CRDTP_SERIALIZE_FIELD("containerBorder", m_containerBorder);
    CRDTP_SERIALIZE_FIELD("descendantBorder", m_descendantBorder);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(IsolatedElementHighlightConfig)
    CRDTP_DESERIALIZE_FIELD("isolationModeHighlightConfig", m_isolationModeHighlightConfig),
    CRDTP_DESERIALIZE_FIELD("nodeId", m_nodeId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(IsolatedElementHighlightConfig)
    CRDTP_SERIALIZE_FIELD("isolationModeHighlightConfig", m_isolationModeHighlightConfig);
    CRDTP_SERIALIZE_FIELD("nodeId", m_nodeId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(IsolationModeHighlightConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("maskColor", m_maskColor),
    CRDTP_DESERIALIZE_FIELD_OPT("resizerColor", m_resizerColor),
    CRDTP_DESERIALIZE_FIELD_OPT("resizerHandleColor", m_resizerHandleColor),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(IsolationModeHighlightConfig)
    CRDTP_SERIALIZE_FIELD("resizerColor", m_resizerColor);
    CRDTP_SERIALIZE_FIELD("resizerHandleColor", m_resizerHandleColor);
    CRDTP_SERIALIZE_FIELD("maskColor", m_maskColor);
CRDTP_END_SERIALIZER();


namespace InspectModeEnum {
const char SearchForNode[] = "searchForNode";
const char SearchForUAShadowDOM[] = "searchForUAShadowDOM";
const char CaptureAreaScreenshot[] = "captureAreaScreenshot";
const char None[] = "none";
} // namespace InspectModeEnum


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::inspectNodeRequested(int backendNodeId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("backendNodeId"), backendNodeId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Overlay.inspectNodeRequested", serializer.Finish()));
}

void Frontend::nodeHighlightRequested(int nodeId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("nodeId"), nodeId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Overlay.nodeHighlightRequested", serializer.Finish()));
}

void Frontend::screenshotRequested(std::unique_ptr<protocol::Page::Viewport> viewport)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("viewport"), viewport);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Overlay.screenshotRequested", serializer.Finish()));
}

void Frontend::inspectModeCanceled()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Overlay.inspectModeCanceled"));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void getHighlightObjectForTest(const crdtp::Dispatchable& dispatchable);
    void getGridHighlightObjectsForTest(const crdtp::Dispatchable& dispatchable);
    void getSourceOrderHighlightObjectForTest(const crdtp::Dispatchable& dispatchable);
    void hideHighlight(const crdtp::Dispatchable& dispatchable);
    void highlightFrame(const crdtp::Dispatchable& dispatchable);
    void highlightNode(const crdtp::Dispatchable& dispatchable);
    void highlightQuad(const crdtp::Dispatchable& dispatchable);
    void highlightRect(const crdtp::Dispatchable& dispatchable);
    void highlightSourceOrder(const crdtp::Dispatchable& dispatchable);
    void setInspectMode(const crdtp::Dispatchable& dispatchable);
    void setShowAdHighlights(const crdtp::Dispatchable& dispatchable);
    void setPausedInDebuggerMessage(const crdtp::Dispatchable& dispatchable);
    void setShowDebugBorders(const crdtp::Dispatchable& dispatchable);
    void setShowFPSCounter(const crdtp::Dispatchable& dispatchable);
    void setShowGridOverlays(const crdtp::Dispatchable& dispatchable);
    void setShowFlexOverlays(const crdtp::Dispatchable& dispatchable);
    void setShowScrollSnapOverlays(const crdtp::Dispatchable& dispatchable);
    void setShowContainerQueryOverlays(const crdtp::Dispatchable& dispatchable);
    void setShowPaintRects(const crdtp::Dispatchable& dispatchable);
    void setShowLayoutShiftRegions(const crdtp::Dispatchable& dispatchable);
    void setShowScrollBottleneckRects(const crdtp::Dispatchable& dispatchable);
    void setShowHitTestBorders(const crdtp::Dispatchable& dispatchable);
    void setShowWebVitals(const crdtp::Dispatchable& dispatchable);
    void setShowViewportSizeOnResize(const crdtp::Dispatchable& dispatchable);
    void setShowHinge(const crdtp::Dispatchable& dispatchable);
    void setShowIsolatedElements(const crdtp::Dispatchable& dispatchable);
    void setShowWindowControlsOverlay(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("getGridHighlightObjectsForTest"),
          &DomainDispatcherImpl::getGridHighlightObjectsForTest
    },
    {
          crdtp::SpanFrom("getHighlightObjectForTest"),
          &DomainDispatcherImpl::getHighlightObjectForTest
    },
    {
          crdtp::SpanFrom("getSourceOrderHighlightObjectForTest"),
          &DomainDispatcherImpl::getSourceOrderHighlightObjectForTest
    },
    {
          crdtp::SpanFrom("hideHighlight"),
          &DomainDispatcherImpl::hideHighlight
    },
    {
          crdtp::SpanFrom("highlightFrame"),
          &DomainDispatcherImpl::highlightFrame
    },
    {
          crdtp::SpanFrom("highlightNode"),
          &DomainDispatcherImpl::highlightNode
    },
    {
          crdtp::SpanFrom("highlightQuad"),
          &DomainDispatcherImpl::highlightQuad
    },
    {
          crdtp::SpanFrom("highlightRect"),
          &DomainDispatcherImpl::highlightRect
    },
    {
          crdtp::SpanFrom("highlightSourceOrder"),
          &DomainDispatcherImpl::highlightSourceOrder
    },
    {
          crdtp::SpanFrom("setInspectMode"),
          &DomainDispatcherImpl::setInspectMode
    },
    {
          crdtp::SpanFrom("setPausedInDebuggerMessage"),
          &DomainDispatcherImpl::setPausedInDebuggerMessage
    },
    {
          crdtp::SpanFrom("setShowAdHighlights"),
          &DomainDispatcherImpl::setShowAdHighlights
    },
    {
          crdtp::SpanFrom("setShowContainerQueryOverlays"),
          &DomainDispatcherImpl::setShowContainerQueryOverlays
    },
    {
          crdtp::SpanFrom("setShowDebugBorders"),
          &DomainDispatcherImpl::setShowDebugBorders
    },
    {
          crdtp::SpanFrom("setShowFPSCounter"),
          &DomainDispatcherImpl::setShowFPSCounter
    },
    {
          crdtp::SpanFrom("setShowFlexOverlays"),
          &DomainDispatcherImpl::setShowFlexOverlays
    },
    {
          crdtp::SpanFrom("setShowGridOverlays"),
          &DomainDispatcherImpl::setShowGridOverlays
    },
    {
          crdtp::SpanFrom("setShowHinge"),
          &DomainDispatcherImpl::setShowHinge
    },
    {
          crdtp::SpanFrom("setShowHitTestBorders"),
          &DomainDispatcherImpl::setShowHitTestBorders
    },
    {
          crdtp::SpanFrom("setShowIsolatedElements"),
          &DomainDispatcherImpl::setShowIsolatedElements
    },
    {
          crdtp::SpanFrom("setShowLayoutShiftRegions"),
          &DomainDispatcherImpl::setShowLayoutShiftRegions
    },
    {
          crdtp::SpanFrom("setShowPaintRects"),
          &DomainDispatcherImpl::setShowPaintRects
    },
    {
          crdtp::SpanFrom("setShowScrollBottleneckRects"),
          &DomainDispatcherImpl::setShowScrollBottleneckRects
    },
    {
          crdtp::SpanFrom("setShowScrollSnapOverlays"),
          &DomainDispatcherImpl::setShowScrollSnapOverlays
    },
    {
          crdtp::SpanFrom("setShowViewportSizeOnResize"),
          &DomainDispatcherImpl::setShowViewportSizeOnResize
    },
    {
          crdtp::SpanFrom("setShowWebVitals"),
          &DomainDispatcherImpl::setShowWebVitals
    },
    {
          crdtp::SpanFrom("setShowWindowControlsOverlay"),
          &DomainDispatcherImpl::setShowWindowControlsOverlay
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getHighlightObjectForTestParams : public crdtp::DeserializableProtocolObject<getHighlightObjectForTestParams> {
    int nodeId;
    std::optional<bool> includeDistance;
    std::optional<bool> includeStyle;
    std::optional<String> colorFormat;
    std::optional<bool> showAccessibilityInfo;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getHighlightObjectForTestParams)
    CRDTP_DESERIALIZE_FIELD_OPT("colorFormat", colorFormat),
    CRDTP_DESERIALIZE_FIELD_OPT("includeDistance", includeDistance),
    CRDTP_DESERIALIZE_FIELD_OPT("includeStyle", includeStyle),
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("showAccessibilityInfo", showAccessibilityInfo),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getHighlightObjectForTest(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getHighlightObjectForTestParams params;
    if (!getHighlightObjectForTestParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::DictionaryValue> out_highlight;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getHighlightObjectForTest(params.nodeId, std::move(params.includeDistance), std::move(params.includeStyle), std::move(params.colorFormat), std::move(params.showAccessibilityInfo), &out_highlight);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.getHighlightObjectForTest"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("highlight"), out_highlight);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getGridHighlightObjectsForTestParams : public crdtp::DeserializableProtocolObject<getGridHighlightObjectsForTestParams> {
    std::unique_ptr<protocol::Array<int>> nodeIds;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getGridHighlightObjectsForTestParams)
    CRDTP_DESERIALIZE_FIELD("nodeIds", nodeIds),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getGridHighlightObjectsForTest(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getGridHighlightObjectsForTestParams params;
    if (!getGridHighlightObjectsForTestParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::DictionaryValue> out_highlights;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getGridHighlightObjectsForTest(std::move(params.nodeIds), &out_highlights);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.getGridHighlightObjectsForTest"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("highlights"), out_highlights);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getSourceOrderHighlightObjectForTestParams : public crdtp::DeserializableProtocolObject<getSourceOrderHighlightObjectForTestParams> {
    int nodeId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getSourceOrderHighlightObjectForTestParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getSourceOrderHighlightObjectForTest(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getSourceOrderHighlightObjectForTestParams params;
    if (!getSourceOrderHighlightObjectForTestParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::DictionaryValue> out_highlight;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getSourceOrderHighlightObjectForTest(params.nodeId, &out_highlight);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.getSourceOrderHighlightObjectForTest"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("highlight"), out_highlight);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::hideHighlight(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->hideHighlight();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.hideHighlight"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct highlightFrameParams : public crdtp::DeserializableProtocolObject<highlightFrameParams> {
    String frameId;
    std::unique_ptr<protocol::DOM::RGBA> contentColor;
    std::unique_ptr<protocol::DOM::RGBA> contentOutlineColor;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(highlightFrameParams)
    CRDTP_DESERIALIZE_FIELD_OPT("contentColor", contentColor),
    CRDTP_DESERIALIZE_FIELD_OPT("contentOutlineColor", contentOutlineColor),
    CRDTP_DESERIALIZE_FIELD("frameId", frameId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::highlightFrame(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    highlightFrameParams params;
    if (!highlightFrameParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->highlightFrame(params.frameId, std::move(params.contentColor), std::move(params.contentOutlineColor));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.highlightFrame"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct highlightNodeParams : public crdtp::DeserializableProtocolObject<highlightNodeParams> {
    std::unique_ptr<protocol::Overlay::HighlightConfig> highlightConfig;
    std::optional<int> nodeId;
    std::optional<int> backendNodeId;
    std::optional<String> objectId;
    std::optional<String> selector;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(highlightNodeParams)
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", backendNodeId),
    CRDTP_DESERIALIZE_FIELD("highlightConfig", highlightConfig),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("objectId", objectId),
    CRDTP_DESERIALIZE_FIELD_OPT("selector", selector),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::highlightNode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    highlightNodeParams params;
    if (!highlightNodeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->highlightNode(std::move(params.highlightConfig), std::move(params.nodeId), std::move(params.backendNodeId), std::move(params.objectId), std::move(params.selector));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.highlightNode"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct highlightQuadParams : public crdtp::DeserializableProtocolObject<highlightQuadParams> {
    std::unique_ptr<protocol::Array<double>> quad;
    std::unique_ptr<protocol::DOM::RGBA> color;
    std::unique_ptr<protocol::DOM::RGBA> outlineColor;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(highlightQuadParams)
    CRDTP_DESERIALIZE_FIELD_OPT("color", color),
    CRDTP_DESERIALIZE_FIELD_OPT("outlineColor", outlineColor),
    CRDTP_DESERIALIZE_FIELD("quad", quad),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::highlightQuad(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    highlightQuadParams params;
    if (!highlightQuadParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->highlightQuad(std::move(params.quad), std::move(params.color), std::move(params.outlineColor));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.highlightQuad"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct highlightRectParams : public crdtp::DeserializableProtocolObject<highlightRectParams> {
    int x;
    int y;
    int width;
    int height;
    std::unique_ptr<protocol::DOM::RGBA> color;
    std::unique_ptr<protocol::DOM::RGBA> outlineColor;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(highlightRectParams)
    CRDTP_DESERIALIZE_FIELD_OPT("color", color),
    CRDTP_DESERIALIZE_FIELD("height", height),
    CRDTP_DESERIALIZE_FIELD_OPT("outlineColor", outlineColor),
    CRDTP_DESERIALIZE_FIELD("width", width),
    CRDTP_DESERIALIZE_FIELD("x", x),
    CRDTP_DESERIALIZE_FIELD("y", y),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::highlightRect(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    highlightRectParams params;
    if (!highlightRectParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->highlightRect(params.x, params.y, params.width, params.height, std::move(params.color), std::move(params.outlineColor));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.highlightRect"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct highlightSourceOrderParams : public crdtp::DeserializableProtocolObject<highlightSourceOrderParams> {
    std::unique_ptr<protocol::Overlay::SourceOrderConfig> sourceOrderConfig;
    std::optional<int> nodeId;
    std::optional<int> backendNodeId;
    std::optional<String> objectId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(highlightSourceOrderParams)
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", backendNodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD_OPT("objectId", objectId),
    CRDTP_DESERIALIZE_FIELD("sourceOrderConfig", sourceOrderConfig),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::highlightSourceOrder(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    highlightSourceOrderParams params;
    if (!highlightSourceOrderParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->highlightSourceOrder(std::move(params.sourceOrderConfig), std::move(params.nodeId), std::move(params.backendNodeId), std::move(params.objectId));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.highlightSourceOrder"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setInspectModeParams : public crdtp::DeserializableProtocolObject<setInspectModeParams> {
    String mode;
    std::unique_ptr<protocol::Overlay::HighlightConfig> highlightConfig;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setInspectModeParams)
    CRDTP_DESERIALIZE_FIELD_OPT("highlightConfig", highlightConfig),
    CRDTP_DESERIALIZE_FIELD("mode", mode),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setInspectMode(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setInspectModeParams params;
    if (!setInspectModeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setInspectMode(params.mode, std::move(params.highlightConfig));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setInspectMode"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowAdHighlightsParams : public crdtp::DeserializableProtocolObject<setShowAdHighlightsParams> {
    bool show;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowAdHighlightsParams)
    CRDTP_DESERIALIZE_FIELD("show", show),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowAdHighlights(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowAdHighlightsParams params;
    if (!setShowAdHighlightsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowAdHighlights(params.show);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowAdHighlights"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setPausedInDebuggerMessageParams : public crdtp::DeserializableProtocolObject<setPausedInDebuggerMessageParams> {
    std::optional<String> message;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setPausedInDebuggerMessageParams)
    CRDTP_DESERIALIZE_FIELD_OPT("message", message),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setPausedInDebuggerMessage(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setPausedInDebuggerMessageParams params;
    if (!setPausedInDebuggerMessageParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setPausedInDebuggerMessage(std::move(params.message));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setPausedInDebuggerMessage"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowDebugBordersParams : public crdtp::DeserializableProtocolObject<setShowDebugBordersParams> {
    bool show;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowDebugBordersParams)
    CRDTP_DESERIALIZE_FIELD("show", show),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowDebugBorders(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowDebugBordersParams params;
    if (!setShowDebugBordersParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowDebugBorders(params.show);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowDebugBorders"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowFPSCounterParams : public crdtp::DeserializableProtocolObject<setShowFPSCounterParams> {
    bool show;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowFPSCounterParams)
    CRDTP_DESERIALIZE_FIELD("show", show),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowFPSCounter(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowFPSCounterParams params;
    if (!setShowFPSCounterParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowFPSCounter(params.show);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowFPSCounter"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowGridOverlaysParams : public crdtp::DeserializableProtocolObject<setShowGridOverlaysParams> {
    std::unique_ptr<protocol::Array<protocol::Overlay::GridNodeHighlightConfig>> gridNodeHighlightConfigs;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowGridOverlaysParams)
    CRDTP_DESERIALIZE_FIELD("gridNodeHighlightConfigs", gridNodeHighlightConfigs),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowGridOverlays(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowGridOverlaysParams params;
    if (!setShowGridOverlaysParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowGridOverlays(std::move(params.gridNodeHighlightConfigs));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowGridOverlays"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowFlexOverlaysParams : public crdtp::DeserializableProtocolObject<setShowFlexOverlaysParams> {
    std::unique_ptr<protocol::Array<protocol::Overlay::FlexNodeHighlightConfig>> flexNodeHighlightConfigs;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowFlexOverlaysParams)
    CRDTP_DESERIALIZE_FIELD("flexNodeHighlightConfigs", flexNodeHighlightConfigs),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowFlexOverlays(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowFlexOverlaysParams params;
    if (!setShowFlexOverlaysParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowFlexOverlays(std::move(params.flexNodeHighlightConfigs));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowFlexOverlays"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowScrollSnapOverlaysParams : public crdtp::DeserializableProtocolObject<setShowScrollSnapOverlaysParams> {
    std::unique_ptr<protocol::Array<protocol::Overlay::ScrollSnapHighlightConfig>> scrollSnapHighlightConfigs;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowScrollSnapOverlaysParams)
    CRDTP_DESERIALIZE_FIELD("scrollSnapHighlightConfigs", scrollSnapHighlightConfigs),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowScrollSnapOverlays(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowScrollSnapOverlaysParams params;
    if (!setShowScrollSnapOverlaysParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowScrollSnapOverlays(std::move(params.scrollSnapHighlightConfigs));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowScrollSnapOverlays"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowContainerQueryOverlaysParams : public crdtp::DeserializableProtocolObject<setShowContainerQueryOverlaysParams> {
    std::unique_ptr<protocol::Array<protocol::Overlay::ContainerQueryHighlightConfig>> containerQueryHighlightConfigs;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowContainerQueryOverlaysParams)
    CRDTP_DESERIALIZE_FIELD("containerQueryHighlightConfigs", containerQueryHighlightConfigs),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowContainerQueryOverlays(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowContainerQueryOverlaysParams params;
    if (!setShowContainerQueryOverlaysParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowContainerQueryOverlays(std::move(params.containerQueryHighlightConfigs));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowContainerQueryOverlays"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowPaintRectsParams : public crdtp::DeserializableProtocolObject<setShowPaintRectsParams> {
    bool result;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowPaintRectsParams)
    CRDTP_DESERIALIZE_FIELD("result", result),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowPaintRects(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowPaintRectsParams params;
    if (!setShowPaintRectsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowPaintRects(params.result);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowPaintRects"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowLayoutShiftRegionsParams : public crdtp::DeserializableProtocolObject<setShowLayoutShiftRegionsParams> {
    bool result;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowLayoutShiftRegionsParams)
    CRDTP_DESERIALIZE_FIELD("result", result),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowLayoutShiftRegions(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowLayoutShiftRegionsParams params;
    if (!setShowLayoutShiftRegionsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowLayoutShiftRegions(params.result);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowLayoutShiftRegions"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowScrollBottleneckRectsParams : public crdtp::DeserializableProtocolObject<setShowScrollBottleneckRectsParams> {
    bool show;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowScrollBottleneckRectsParams)
    CRDTP_DESERIALIZE_FIELD("show", show),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowScrollBottleneckRects(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowScrollBottleneckRectsParams params;
    if (!setShowScrollBottleneckRectsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowScrollBottleneckRects(params.show);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowScrollBottleneckRects"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowHitTestBordersParams : public crdtp::DeserializableProtocolObject<setShowHitTestBordersParams> {
    bool show;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowHitTestBordersParams)
    CRDTP_DESERIALIZE_FIELD("show", show),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowHitTestBorders(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowHitTestBordersParams params;
    if (!setShowHitTestBordersParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowHitTestBorders(params.show);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowHitTestBorders"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowWebVitalsParams : public crdtp::DeserializableProtocolObject<setShowWebVitalsParams> {
    bool show;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowWebVitalsParams)
    CRDTP_DESERIALIZE_FIELD("show", show),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowWebVitals(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowWebVitalsParams params;
    if (!setShowWebVitalsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowWebVitals(params.show);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowWebVitals"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowViewportSizeOnResizeParams : public crdtp::DeserializableProtocolObject<setShowViewportSizeOnResizeParams> {
    bool show;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowViewportSizeOnResizeParams)
    CRDTP_DESERIALIZE_FIELD("show", show),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowViewportSizeOnResize(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowViewportSizeOnResizeParams params;
    if (!setShowViewportSizeOnResizeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowViewportSizeOnResize(params.show);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowViewportSizeOnResize"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowHingeParams : public crdtp::DeserializableProtocolObject<setShowHingeParams> {
    std::unique_ptr<protocol::Overlay::HingeConfig> hingeConfig;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowHingeParams)
    CRDTP_DESERIALIZE_FIELD_OPT("hingeConfig", hingeConfig),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowHinge(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowHingeParams params;
    if (!setShowHingeParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowHinge(std::move(params.hingeConfig));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowHinge"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowIsolatedElementsParams : public crdtp::DeserializableProtocolObject<setShowIsolatedElementsParams> {
    std::unique_ptr<protocol::Array<protocol::Overlay::IsolatedElementHighlightConfig>> isolatedElementHighlightConfigs;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowIsolatedElementsParams)
    CRDTP_DESERIALIZE_FIELD("isolatedElementHighlightConfigs", isolatedElementHighlightConfigs),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowIsolatedElements(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowIsolatedElementsParams params;
    if (!setShowIsolatedElementsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowIsolatedElements(std::move(params.isolatedElementHighlightConfigs));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowIsolatedElements"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setShowWindowControlsOverlayParams : public crdtp::DeserializableProtocolObject<setShowWindowControlsOverlayParams> {
    std::unique_ptr<protocol::Overlay::WindowControlsOverlayConfig> windowControlsOverlayConfig;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setShowWindowControlsOverlayParams)
    CRDTP_DESERIALIZE_FIELD_OPT("windowControlsOverlayConfig", windowControlsOverlayConfig),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setShowWindowControlsOverlay(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setShowWindowControlsOverlayParams params;
    if (!setShowWindowControlsOverlayParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setShowWindowControlsOverlay(std::move(params.windowControlsOverlayConfig));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Overlay.setShowWindowControlsOverlay"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Overlay"), SortedRedirects(), std::move(dispatcher));
}

} // Overlay
} // namespace blink
} // namespace protocol
