// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/indexed_db.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace IndexedDB {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "IndexedDB";
const char Metainfo::commandPrefix[] = "IndexedDB.";
const char Metainfo::version[] = "1.3";

CRDTP_BEGIN_DESERIALIZER(DatabaseWithObjectStores)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("objectStores", m_objectStores),
    CRDTP_DESERIALIZE_FIELD("version", m_version),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DatabaseWithObjectStores)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("version", m_version);
    CRDTP_SERIALIZE_FIELD("objectStores", m_objectStores);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ObjectStore)
    CRDTP_DESERIALIZE_FIELD("autoIncrement", m_autoIncrement),
    CRDTP_DESERIALIZE_FIELD("indexes", m_indexes),
    CRDTP_DESERIALIZE_FIELD("keyPath", m_keyPath),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ObjectStore)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("keyPath", m_keyPath);
    CRDTP_SERIALIZE_FIELD("autoIncrement", m_autoIncrement);
    CRDTP_SERIALIZE_FIELD("indexes", m_indexes);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ObjectStoreIndex)
    CRDTP_DESERIALIZE_FIELD("keyPath", m_keyPath),
    CRDTP_DESERIALIZE_FIELD("multiEntry", m_multiEntry),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("unique", m_unique),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ObjectStoreIndex)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("keyPath", m_keyPath);
    CRDTP_SERIALIZE_FIELD("unique", m_unique);
    CRDTP_SERIALIZE_FIELD("multiEntry", m_multiEntry);
CRDTP_END_SERIALIZER();



const char* Key::TypeEnum::Number = "number";
const char* Key::TypeEnum::String = "string";
const char* Key::TypeEnum::Date = "date";
const char* Key::TypeEnum::Array = "array";
CRDTP_BEGIN_DESERIALIZER(Key)
    CRDTP_DESERIALIZE_FIELD_OPT("array", m_array),
    CRDTP_DESERIALIZE_FIELD_OPT("date", m_date),
    CRDTP_DESERIALIZE_FIELD_OPT("number", m_number),
    CRDTP_DESERIALIZE_FIELD_OPT("string", m_string),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Key)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("number", m_number);
    CRDTP_SERIALIZE_FIELD("string", m_string);
    CRDTP_SERIALIZE_FIELD("date", m_date);
    CRDTP_SERIALIZE_FIELD("array", m_array);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(KeyRange)
    CRDTP_DESERIALIZE_FIELD_OPT("lower", m_lower),
    CRDTP_DESERIALIZE_FIELD("lowerOpen", m_lowerOpen),
    CRDTP_DESERIALIZE_FIELD_OPT("upper", m_upper),
    CRDTP_DESERIALIZE_FIELD("upperOpen", m_upperOpen),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(KeyRange)
    CRDTP_SERIALIZE_FIELD("lower", m_lower);
    CRDTP_SERIALIZE_FIELD("upper", m_upper);
    CRDTP_SERIALIZE_FIELD("lowerOpen", m_lowerOpen);
    CRDTP_SERIALIZE_FIELD("upperOpen", m_upperOpen);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(DataEntry)
    CRDTP_DESERIALIZE_FIELD("key", m_key),
    CRDTP_DESERIALIZE_FIELD("primaryKey", m_primaryKey),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DataEntry)
    CRDTP_SERIALIZE_FIELD("key", m_key);
    CRDTP_SERIALIZE_FIELD("primaryKey", m_primaryKey);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();



const char* KeyPath::TypeEnum::Null = "null";
const char* KeyPath::TypeEnum::String = "string";
const char* KeyPath::TypeEnum::Array = "array";
CRDTP_BEGIN_DESERIALIZER(KeyPath)
    CRDTP_DESERIALIZE_FIELD_OPT("array", m_array),
    CRDTP_DESERIALIZE_FIELD_OPT("string", m_string),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(KeyPath)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("string", m_string);
    CRDTP_SERIALIZE_FIELD("array", m_array);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void clearObjectStore(const crdtp::Dispatchable& dispatchable);
    void deleteDatabase(const crdtp::Dispatchable& dispatchable);
    void deleteObjectStoreEntries(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void requestData(const crdtp::Dispatchable& dispatchable);
    void getMetadata(const crdtp::Dispatchable& dispatchable);
    void requestDatabase(const crdtp::Dispatchable& dispatchable);
    void requestDatabaseNames(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("clearObjectStore"),
          &DomainDispatcherImpl::clearObjectStore
    },
    {
          crdtp::SpanFrom("deleteDatabase"),
          &DomainDispatcherImpl::deleteDatabase
    },
    {
          crdtp::SpanFrom("deleteObjectStoreEntries"),
          &DomainDispatcherImpl::deleteObjectStoreEntries
    },
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("getMetadata"),
          &DomainDispatcherImpl::getMetadata
    },
    {
          crdtp::SpanFrom("requestData"),
          &DomainDispatcherImpl::requestData
    },
    {
          crdtp::SpanFrom("requestDatabase"),
          &DomainDispatcherImpl::requestDatabase
    },
    {
          crdtp::SpanFrom("requestDatabaseNames"),
          &DomainDispatcherImpl::requestDatabaseNames
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


class ClearObjectStoreCallbackImpl : public Backend::ClearObjectStoreCallback, public DomainDispatcher::Callback {
public:
    ClearObjectStoreCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("IndexedDB.clearObjectStore"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct clearObjectStoreParams : public crdtp::DeserializableProtocolObject<clearObjectStoreParams> {
    std::optional<String> securityOrigin;
    std::optional<String> storageKey;
    std::unique_ptr<protocol::Storage::StorageBucket> storageBucket;
    String databaseName;
    String objectStoreName;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(clearObjectStoreParams)
    CRDTP_DESERIALIZE_FIELD("databaseName", databaseName),
    CRDTP_DESERIALIZE_FIELD("objectStoreName", objectStoreName),
    CRDTP_DESERIALIZE_FIELD_OPT("securityOrigin", securityOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("storageBucket", storageBucket),
    CRDTP_DESERIALIZE_FIELD_OPT("storageKey", storageKey),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::clearObjectStore(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    clearObjectStoreParams params;
    if (!clearObjectStoreParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->clearObjectStore(std::move(params.securityOrigin), std::move(params.storageKey), std::move(params.storageBucket), params.databaseName, params.objectStoreName, std::make_unique<ClearObjectStoreCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class DeleteDatabaseCallbackImpl : public Backend::DeleteDatabaseCallback, public DomainDispatcher::Callback {
public:
    DeleteDatabaseCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("IndexedDB.deleteDatabase"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct deleteDatabaseParams : public crdtp::DeserializableProtocolObject<deleteDatabaseParams> {
    std::optional<String> securityOrigin;
    std::optional<String> storageKey;
    std::unique_ptr<protocol::Storage::StorageBucket> storageBucket;
    String databaseName;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(deleteDatabaseParams)
    CRDTP_DESERIALIZE_FIELD("databaseName", databaseName),
    CRDTP_DESERIALIZE_FIELD_OPT("securityOrigin", securityOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("storageBucket", storageBucket),
    CRDTP_DESERIALIZE_FIELD_OPT("storageKey", storageKey),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::deleteDatabase(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    deleteDatabaseParams params;
    if (!deleteDatabaseParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->deleteDatabase(std::move(params.securityOrigin), std::move(params.storageKey), std::move(params.storageBucket), params.databaseName, std::make_unique<DeleteDatabaseCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class DeleteObjectStoreEntriesCallbackImpl : public Backend::DeleteObjectStoreEntriesCallback, public DomainDispatcher::Callback {
public:
    DeleteObjectStoreEntriesCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("IndexedDB.deleteObjectStoreEntries"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct deleteObjectStoreEntriesParams : public crdtp::DeserializableProtocolObject<deleteObjectStoreEntriesParams> {
    std::optional<String> securityOrigin;
    std::optional<String> storageKey;
    std::unique_ptr<protocol::Storage::StorageBucket> storageBucket;
    String databaseName;
    String objectStoreName;
    std::unique_ptr<protocol::IndexedDB::KeyRange> keyRange;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(deleteObjectStoreEntriesParams)
    CRDTP_DESERIALIZE_FIELD("databaseName", databaseName),
    CRDTP_DESERIALIZE_FIELD("keyRange", keyRange),
    CRDTP_DESERIALIZE_FIELD("objectStoreName", objectStoreName),
    CRDTP_DESERIALIZE_FIELD_OPT("securityOrigin", securityOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("storageBucket", storageBucket),
    CRDTP_DESERIALIZE_FIELD_OPT("storageKey", storageKey),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::deleteObjectStoreEntries(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    deleteObjectStoreEntriesParams params;
    if (!deleteObjectStoreEntriesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->deleteObjectStoreEntries(std::move(params.securityOrigin), std::move(params.storageKey), std::move(params.storageBucket), params.databaseName, params.objectStoreName, std::move(params.keyRange), std::make_unique<DeleteObjectStoreEntriesCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("IndexedDB.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("IndexedDB.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class RequestDataCallbackImpl : public Backend::RequestDataCallback, public DomainDispatcher::Callback {
public:
    RequestDataCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("IndexedDB.requestData"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Array<protocol::IndexedDB::DataEntry>> objectStoreDataEntries, bool hasMore) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("objectStoreDataEntries"), objectStoreDataEntries);
        serializer.AddField(crdtp::MakeSpan("hasMore"), hasMore);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct requestDataParams : public crdtp::DeserializableProtocolObject<requestDataParams> {
    std::optional<String> securityOrigin;
    std::optional<String> storageKey;
    std::unique_ptr<protocol::Storage::StorageBucket> storageBucket;
    String databaseName;
    String objectStoreName;
    std::optional<String> indexName;
    int skipCount;
    int pageSize;
    std::unique_ptr<protocol::IndexedDB::KeyRange> keyRange;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(requestDataParams)
    CRDTP_DESERIALIZE_FIELD("databaseName", databaseName),
    CRDTP_DESERIALIZE_FIELD_OPT("indexName", indexName),
    CRDTP_DESERIALIZE_FIELD_OPT("keyRange", keyRange),
    CRDTP_DESERIALIZE_FIELD("objectStoreName", objectStoreName),
    CRDTP_DESERIALIZE_FIELD("pageSize", pageSize),
    CRDTP_DESERIALIZE_FIELD_OPT("securityOrigin", securityOrigin),
    CRDTP_DESERIALIZE_FIELD("skipCount", skipCount),
    CRDTP_DESERIALIZE_FIELD_OPT("storageBucket", storageBucket),
    CRDTP_DESERIALIZE_FIELD_OPT("storageKey", storageKey),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::requestData(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    requestDataParams params;
    if (!requestDataParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->requestData(std::move(params.securityOrigin), std::move(params.storageKey), std::move(params.storageBucket), params.databaseName, params.objectStoreName, std::move(params.indexName), params.skipCount, params.pageSize, std::move(params.keyRange), std::make_unique<RequestDataCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class GetMetadataCallbackImpl : public Backend::GetMetadataCallback, public DomainDispatcher::Callback {
public:
    GetMetadataCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("IndexedDB.getMetadata"), message) { }

    void sendSuccess(double entriesCount, double keyGeneratorValue) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("entriesCount"), entriesCount);
        serializer.AddField(crdtp::MakeSpan("keyGeneratorValue"), keyGeneratorValue);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct getMetadataParams : public crdtp::DeserializableProtocolObject<getMetadataParams> {
    std::optional<String> securityOrigin;
    std::optional<String> storageKey;
    std::unique_ptr<protocol::Storage::StorageBucket> storageBucket;
    String databaseName;
    String objectStoreName;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getMetadataParams)
    CRDTP_DESERIALIZE_FIELD("databaseName", databaseName),
    CRDTP_DESERIALIZE_FIELD("objectStoreName", objectStoreName),
    CRDTP_DESERIALIZE_FIELD_OPT("securityOrigin", securityOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("storageBucket", storageBucket),
    CRDTP_DESERIALIZE_FIELD_OPT("storageKey", storageKey),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getMetadata(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getMetadataParams params;
    if (!getMetadataParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->getMetadata(std::move(params.securityOrigin), std::move(params.storageKey), std::move(params.storageBucket), params.databaseName, params.objectStoreName, std::make_unique<GetMetadataCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class RequestDatabaseCallbackImpl : public Backend::RequestDatabaseCallback, public DomainDispatcher::Callback {
public:
    RequestDatabaseCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("IndexedDB.requestDatabase"), message) { }

    void sendSuccess(std::unique_ptr<protocol::IndexedDB::DatabaseWithObjectStores> databaseWithObjectStores) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("databaseWithObjectStores"), databaseWithObjectStores);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct requestDatabaseParams : public crdtp::DeserializableProtocolObject<requestDatabaseParams> {
    std::optional<String> securityOrigin;
    std::optional<String> storageKey;
    std::unique_ptr<protocol::Storage::StorageBucket> storageBucket;
    String databaseName;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(requestDatabaseParams)
    CRDTP_DESERIALIZE_FIELD("databaseName", databaseName),
    CRDTP_DESERIALIZE_FIELD_OPT("securityOrigin", securityOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("storageBucket", storageBucket),
    CRDTP_DESERIALIZE_FIELD_OPT("storageKey", storageKey),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::requestDatabase(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    requestDatabaseParams params;
    if (!requestDatabaseParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->requestDatabase(std::move(params.securityOrigin), std::move(params.storageKey), std::move(params.storageBucket), params.databaseName, std::make_unique<RequestDatabaseCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class RequestDatabaseNamesCallbackImpl : public Backend::RequestDatabaseNamesCallback, public DomainDispatcher::Callback {
public:
    RequestDatabaseNamesCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("IndexedDB.requestDatabaseNames"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Array<String>> databaseNames) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("databaseNames"), databaseNames);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct requestDatabaseNamesParams : public crdtp::DeserializableProtocolObject<requestDatabaseNamesParams> {
    std::optional<String> securityOrigin;
    std::optional<String> storageKey;
    std::unique_ptr<protocol::Storage::StorageBucket> storageBucket;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(requestDatabaseNamesParams)
    CRDTP_DESERIALIZE_FIELD_OPT("securityOrigin", securityOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("storageBucket", storageBucket),
    CRDTP_DESERIALIZE_FIELD_OPT("storageKey", storageKey),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::requestDatabaseNames(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    requestDatabaseNamesParams params;
    if (!requestDatabaseNamesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->requestDatabaseNames(std::move(params.securityOrigin), std::move(params.storageKey), std::move(params.storageBucket), std::make_unique<RequestDatabaseNamesCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("IndexedDB"), SortedRedirects(), std::move(dispatcher));
}

} // IndexedDB
} // namespace blink
} // namespace protocol
