// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Emulation_h
#define blink_protocol_Emulation_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/dom.h"
#include "third_party/blink/renderer/core/inspector/protocol/page.h"
#include "third_party/blink/renderer/core/inspector/protocol/runtime.h"

namespace blink {
namespace protocol {
namespace Emulation {
class SafeAreaInsets;
class ScreenOrientation;
class DisplayFeature;
class DevicePosture;
class MediaFeature;
using VirtualTimePolicy = String;
class UserAgentBrandVersion;
class UserAgentMetadata;
using DisabledImageType = String;

// ------------- Forward and enum declarations.

namespace VirtualTimePolicyEnum {
CORE_EXPORT extern const char Advance[];
CORE_EXPORT extern const char Pause[];
CORE_EXPORT extern const char PauseIfNetworkFetchesPending[];
} // namespace VirtualTimePolicyEnum

namespace DisabledImageTypeEnum {
CORE_EXPORT extern const char Avif[];
CORE_EXPORT extern const char Webp[];
} // namespace DisabledImageTypeEnum

namespace SetEmitTouchEventsForMouse {
namespace ConfigurationEnum {
CORE_EXPORT extern const char* Mobile;
CORE_EXPORT extern const char* Desktop;
} // ConfigurationEnum
} // SetEmitTouchEventsForMouse

namespace SetEmulatedVisionDeficiency {
namespace TypeEnum {
CORE_EXPORT extern const char* None;
CORE_EXPORT extern const char* BlurredVision;
CORE_EXPORT extern const char* ReducedContrast;
CORE_EXPORT extern const char* Achromatopsia;
CORE_EXPORT extern const char* Deuteranopia;
CORE_EXPORT extern const char* Protanopia;
CORE_EXPORT extern const char* Tritanopia;
} // TypeEnum
} // SetEmulatedVisionDeficiency

// ------------- Type and builder declarations.

class CORE_EXPORT SafeAreaInsets : public ::crdtp::ProtocolObject<SafeAreaInsets> {
public:
    ~SafeAreaInsets() override { }

    bool hasTop() { return !!m_top; }
    int getTop(int defaultValue) const {
       return m_top.value_or(defaultValue);
    }
    const std::optional<int>& getTop() const {
       return m_top;
    }
    void setTop(int value) { m_top = value; }

    bool hasTopMax() { return !!m_topMax; }
    int getTopMax(int defaultValue) const {
       return m_topMax.value_or(defaultValue);
    }
    const std::optional<int>& getTopMax() const {
       return m_topMax;
    }
    void setTopMax(int value) { m_topMax = value; }

    bool hasLeft() { return !!m_left; }
    int getLeft(int defaultValue) const {
       return m_left.value_or(defaultValue);
    }
    const std::optional<int>& getLeft() const {
       return m_left;
    }
    void setLeft(int value) { m_left = value; }

    bool hasLeftMax() { return !!m_leftMax; }
    int getLeftMax(int defaultValue) const {
       return m_leftMax.value_or(defaultValue);
    }
    const std::optional<int>& getLeftMax() const {
       return m_leftMax;
    }
    void setLeftMax(int value) { m_leftMax = value; }

    bool hasBottom() { return !!m_bottom; }
    int getBottom(int defaultValue) const {
       return m_bottom.value_or(defaultValue);
    }
    const std::optional<int>& getBottom() const {
       return m_bottom;
    }
    void setBottom(int value) { m_bottom = value; }

    bool hasBottomMax() { return !!m_bottomMax; }
    int getBottomMax(int defaultValue) const {
       return m_bottomMax.value_or(defaultValue);
    }
    const std::optional<int>& getBottomMax() const {
       return m_bottomMax;
    }
    void setBottomMax(int value) { m_bottomMax = value; }

    bool hasRight() { return !!m_right; }
    int getRight(int defaultValue) const {
       return m_right.value_or(defaultValue);
    }
    const std::optional<int>& getRight() const {
       return m_right;
    }
    void setRight(int value) { m_right = value; }

    bool hasRightMax() { return !!m_rightMax; }
    int getRightMax(int defaultValue) const {
       return m_rightMax.value_or(defaultValue);
    }
    const std::optional<int>& getRightMax() const {
       return m_rightMax;
    }
    void setRightMax(int value) { m_rightMax = value; }

    template<int STATE>
    class SafeAreaInsetsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        SafeAreaInsetsBuilder<STATE>& setTop(int value)
        {
            m_result->setTop(value);
            return *this;
        }

        SafeAreaInsetsBuilder<STATE>& setTopMax(int value)
        {
            m_result->setTopMax(value);
            return *this;
        }

        SafeAreaInsetsBuilder<STATE>& setLeft(int value)
        {
            m_result->setLeft(value);
            return *this;
        }

        SafeAreaInsetsBuilder<STATE>& setLeftMax(int value)
        {
            m_result->setLeftMax(value);
            return *this;
        }

        SafeAreaInsetsBuilder<STATE>& setBottom(int value)
        {
            m_result->setBottom(value);
            return *this;
        }

        SafeAreaInsetsBuilder<STATE>& setBottomMax(int value)
        {
            m_result->setBottomMax(value);
            return *this;
        }

        SafeAreaInsetsBuilder<STATE>& setRight(int value)
        {
            m_result->setRight(value);
            return *this;
        }

        SafeAreaInsetsBuilder<STATE>& setRightMax(int value)
        {
            m_result->setRightMax(value);
            return *this;
        }

        std::unique_ptr<SafeAreaInsets> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SafeAreaInsets;
        SafeAreaInsetsBuilder() : m_result(new SafeAreaInsets()) { }

        template<int STEP> SafeAreaInsetsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SafeAreaInsetsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::SafeAreaInsets> m_result;
    };

    static SafeAreaInsetsBuilder<0> create()
    {
        return SafeAreaInsetsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SafeAreaInsets()
    {
    }

    std::optional<int> m_top;
    std::optional<int> m_topMax;
    std::optional<int> m_left;
    std::optional<int> m_leftMax;
    std::optional<int> m_bottom;
    std::optional<int> m_bottomMax;
    std::optional<int> m_right;
    std::optional<int> m_rightMax;
};


class CORE_EXPORT ScreenOrientation : public ::crdtp::ProtocolObject<ScreenOrientation> {
public:
    ~ScreenOrientation() override { }

    struct CORE_EXPORT TypeEnum {
        static const char* PortraitPrimary;
        static const char* PortraitSecondary;
        static const char* LandscapePrimary;
        static const char* LandscapeSecondary;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    int getAngle() { return m_angle; }
    void setAngle(int value) { m_angle = value; }

    template<int STATE>
    class ScreenOrientationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AngleSet = 1 << 2,
            AllFieldsSet = (TypeSet | AngleSet | 0)};


        ScreenOrientationBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        ScreenOrientationBuilder<STATE | AngleSet>& setAngle(int value)
        {
            static_assert(!(STATE & AngleSet), "property angle should not be set yet");
            m_result->setAngle(value);
            return castState<AngleSet>();
        }

        std::unique_ptr<ScreenOrientation> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScreenOrientation;
        ScreenOrientationBuilder() : m_result(new ScreenOrientation()) { }

        template<int STEP> ScreenOrientationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScreenOrientationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::ScreenOrientation> m_result;
    };

    static ScreenOrientationBuilder<0> create()
    {
        return ScreenOrientationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScreenOrientation()
    {
          m_angle = 0;
    }

    String m_type;
    int m_angle;
};


class CORE_EXPORT DisplayFeature : public ::crdtp::ProtocolObject<DisplayFeature> {
public:
    ~DisplayFeature() override { }

    struct CORE_EXPORT OrientationEnum {
        static const char* Vertical;
        static const char* Horizontal;
    }; // OrientationEnum

    String getOrientation() { return m_orientation; }
    void setOrientation(const String& value) { m_orientation = value; }

    int getOffset() { return m_offset; }
    void setOffset(int value) { m_offset = value; }

    int getMaskLength() { return m_maskLength; }
    void setMaskLength(int value) { m_maskLength = value; }

    template<int STATE>
    class DisplayFeatureBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OrientationSet = 1 << 1,
            OffsetSet = 1 << 2,
            MaskLengthSet = 1 << 3,
            AllFieldsSet = (OrientationSet | OffsetSet | MaskLengthSet | 0)};


        DisplayFeatureBuilder<STATE | OrientationSet>& setOrientation(const String& value)
        {
            static_assert(!(STATE & OrientationSet), "property orientation should not be set yet");
            m_result->setOrientation(value);
            return castState<OrientationSet>();
        }

        DisplayFeatureBuilder<STATE | OffsetSet>& setOffset(int value)
        {
            static_assert(!(STATE & OffsetSet), "property offset should not be set yet");
            m_result->setOffset(value);
            return castState<OffsetSet>();
        }

        DisplayFeatureBuilder<STATE | MaskLengthSet>& setMaskLength(int value)
        {
            static_assert(!(STATE & MaskLengthSet), "property maskLength should not be set yet");
            m_result->setMaskLength(value);
            return castState<MaskLengthSet>();
        }

        std::unique_ptr<DisplayFeature> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DisplayFeature;
        DisplayFeatureBuilder() : m_result(new DisplayFeature()) { }

        template<int STEP> DisplayFeatureBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DisplayFeatureBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::DisplayFeature> m_result;
    };

    static DisplayFeatureBuilder<0> create()
    {
        return DisplayFeatureBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DisplayFeature()
    {
          m_offset = 0;
          m_maskLength = 0;
    }

    String m_orientation;
    int m_offset;
    int m_maskLength;
};


class CORE_EXPORT DevicePosture : public ::crdtp::ProtocolObject<DevicePosture> {
public:
    ~DevicePosture() override { }

    struct CORE_EXPORT TypeEnum {
        static const char* Continuous;
        static const char* Folded;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    template<int STATE>
    class DevicePostureBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        DevicePostureBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        std::unique_ptr<DevicePosture> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DevicePosture;
        DevicePostureBuilder() : m_result(new DevicePosture()) { }

        template<int STEP> DevicePostureBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DevicePostureBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::DevicePosture> m_result;
    };

    static DevicePostureBuilder<0> create()
    {
        return DevicePostureBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DevicePosture()
    {
    }

    String m_type;
};


class CORE_EXPORT MediaFeature : public ::crdtp::ProtocolObject<MediaFeature> {
public:
    ~MediaFeature() override { }

    String getName() { return m_name; }
    void setName(const String& value) { m_name = value; }

    String getValue() { return m_value; }
    void setValue(const String& value) { m_value = value; }

    template<int STATE>
    class MediaFeatureBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        MediaFeatureBuilder<STATE | NameSet>& setName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(value);
            return castState<NameSet>();
        }

        MediaFeatureBuilder<STATE | ValueSet>& setValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->setValue(value);
            return castState<ValueSet>();
        }

        std::unique_ptr<MediaFeature> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class MediaFeature;
        MediaFeatureBuilder() : m_result(new MediaFeature()) { }

        template<int STEP> MediaFeatureBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<MediaFeatureBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::MediaFeature> m_result;
    };

    static MediaFeatureBuilder<0> create()
    {
        return MediaFeatureBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    MediaFeature()
    {
    }

    String m_name;
    String m_value;
};


class CORE_EXPORT UserAgentBrandVersion : public ::crdtp::ProtocolObject<UserAgentBrandVersion> {
public:
    ~UserAgentBrandVersion() override { }

    String getBrand() { return m_brand; }
    void setBrand(const String& value) { m_brand = value; }

    String getVersion() { return m_version; }
    void setVersion(const String& value) { m_version = value; }

    template<int STATE>
    class UserAgentBrandVersionBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            BrandSet = 1 << 1,
            VersionSet = 1 << 2,
            AllFieldsSet = (BrandSet | VersionSet | 0)};


        UserAgentBrandVersionBuilder<STATE | BrandSet>& setBrand(const String& value)
        {
            static_assert(!(STATE & BrandSet), "property brand should not be set yet");
            m_result->setBrand(value);
            return castState<BrandSet>();
        }

        UserAgentBrandVersionBuilder<STATE | VersionSet>& setVersion(const String& value)
        {
            static_assert(!(STATE & VersionSet), "property version should not be set yet");
            m_result->setVersion(value);
            return castState<VersionSet>();
        }

        std::unique_ptr<UserAgentBrandVersion> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UserAgentBrandVersion;
        UserAgentBrandVersionBuilder() : m_result(new UserAgentBrandVersion()) { }

        template<int STEP> UserAgentBrandVersionBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UserAgentBrandVersionBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::UserAgentBrandVersion> m_result;
    };

    static UserAgentBrandVersionBuilder<0> create()
    {
        return UserAgentBrandVersionBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UserAgentBrandVersion()
    {
    }

    String m_brand;
    String m_version;
};


class CORE_EXPORT UserAgentMetadata : public ::crdtp::ProtocolObject<UserAgentMetadata> {
public:
    ~UserAgentMetadata() override { }

    bool hasBrands() { return !!m_brands; }
    protocol::Array<protocol::Emulation::UserAgentBrandVersion>* getBrands(protocol::Array<protocol::Emulation::UserAgentBrandVersion>* defaultValue) {
       return m_brands ? m_brands.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>>& getBrands() const {
       return m_brands;
    }
    void setBrands(std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> value) { m_brands = std::move(value); }

    bool hasFullVersionList() { return !!m_fullVersionList; }
    protocol::Array<protocol::Emulation::UserAgentBrandVersion>* getFullVersionList(protocol::Array<protocol::Emulation::UserAgentBrandVersion>* defaultValue) {
       return m_fullVersionList ? m_fullVersionList.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>>& getFullVersionList() const {
       return m_fullVersionList;
    }
    void setFullVersionList(std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> value) { m_fullVersionList = std::move(value); }

    bool hasFullVersion() { return !!m_fullVersion; }
    String getFullVersion(const String& defaultValue) const {
       return m_fullVersion.value_or(defaultValue);
    }
    const std::optional<String>& getFullVersion() const {
       return m_fullVersion;
    }
    void setFullVersion(const String& value) { m_fullVersion = value; }

    String getPlatform() { return m_platform; }
    void setPlatform(const String& value) { m_platform = value; }

    String getPlatformVersion() { return m_platformVersion; }
    void setPlatformVersion(const String& value) { m_platformVersion = value; }

    String getArchitecture() { return m_architecture; }
    void setArchitecture(const String& value) { m_architecture = value; }

    String getModel() { return m_model; }
    void setModel(const String& value) { m_model = value; }

    bool getMobile() { return m_mobile; }
    void setMobile(bool value) { m_mobile = value; }

    bool hasBitness() { return !!m_bitness; }
    String getBitness(const String& defaultValue) const {
       return m_bitness.value_or(defaultValue);
    }
    const std::optional<String>& getBitness() const {
       return m_bitness;
    }
    void setBitness(const String& value) { m_bitness = value; }

    bool hasWow64() { return !!m_wow64; }
    bool getWow64(bool defaultValue) const {
       return m_wow64.value_or(defaultValue);
    }
    const std::optional<bool>& getWow64() const {
       return m_wow64;
    }
    void setWow64(bool value) { m_wow64 = value; }

    bool hasFormFactors() { return !!m_formFactors; }
    protocol::Array<String>* getFormFactors(protocol::Array<String>* defaultValue) {
       return m_formFactors ? m_formFactors.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& getFormFactors() const {
       return m_formFactors;
    }
    void setFormFactors(std::unique_ptr<protocol::Array<String>> value) { m_formFactors = std::move(value); }

    template<int STATE>
    class UserAgentMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            PlatformSet = 1 << 1,
            PlatformVersionSet = 1 << 2,
            ArchitectureSet = 1 << 3,
            ModelSet = 1 << 4,
            MobileSet = 1 << 5,
            AllFieldsSet = (PlatformSet | PlatformVersionSet | ArchitectureSet | ModelSet | MobileSet | 0)};


        UserAgentMetadataBuilder<STATE>& setBrands(std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> value)
        {
            m_result->setBrands(std::move(value));
            return *this;
        }

        UserAgentMetadataBuilder<STATE>& setFullVersionList(std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> value)
        {
            m_result->setFullVersionList(std::move(value));
            return *this;
        }

        UserAgentMetadataBuilder<STATE>& setFullVersion(const String& value)
        {
            m_result->setFullVersion(value);
            return *this;
        }

        UserAgentMetadataBuilder<STATE | PlatformSet>& setPlatform(const String& value)
        {
            static_assert(!(STATE & PlatformSet), "property platform should not be set yet");
            m_result->setPlatform(value);
            return castState<PlatformSet>();
        }

        UserAgentMetadataBuilder<STATE | PlatformVersionSet>& setPlatformVersion(const String& value)
        {
            static_assert(!(STATE & PlatformVersionSet), "property platformVersion should not be set yet");
            m_result->setPlatformVersion(value);
            return castState<PlatformVersionSet>();
        }

        UserAgentMetadataBuilder<STATE | ArchitectureSet>& setArchitecture(const String& value)
        {
            static_assert(!(STATE & ArchitectureSet), "property architecture should not be set yet");
            m_result->setArchitecture(value);
            return castState<ArchitectureSet>();
        }

        UserAgentMetadataBuilder<STATE | ModelSet>& setModel(const String& value)
        {
            static_assert(!(STATE & ModelSet), "property model should not be set yet");
            m_result->setModel(value);
            return castState<ModelSet>();
        }

        UserAgentMetadataBuilder<STATE | MobileSet>& setMobile(bool value)
        {
            static_assert(!(STATE & MobileSet), "property mobile should not be set yet");
            m_result->setMobile(value);
            return castState<MobileSet>();
        }

        UserAgentMetadataBuilder<STATE>& setBitness(const String& value)
        {
            m_result->setBitness(value);
            return *this;
        }

        UserAgentMetadataBuilder<STATE>& setWow64(bool value)
        {
            m_result->setWow64(value);
            return *this;
        }

        UserAgentMetadataBuilder<STATE>& setFormFactors(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->setFormFactors(std::move(value));
            return *this;
        }

        std::unique_ptr<UserAgentMetadata> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UserAgentMetadata;
        UserAgentMetadataBuilder() : m_result(new UserAgentMetadata()) { }

        template<int STEP> UserAgentMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UserAgentMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::UserAgentMetadata> m_result;
    };

    static UserAgentMetadataBuilder<0> create()
    {
        return UserAgentMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UserAgentMetadata()
    {
          m_mobile = false;
    }

    std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> m_brands;
    std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> m_fullVersionList;
    std::optional<String> m_fullVersion;
    String m_platform;
    String m_platformVersion;
    String m_architecture;
    String m_model;
    bool m_mobile;
    std::optional<String> m_bitness;
    std::optional<bool> m_wow64;
    std::unique_ptr<protocol::Array<String>> m_formFactors;
};


// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse clearDeviceMetricsOverride() = 0;
    virtual DispatchResponse resetPageScaleFactor() = 0;
    virtual DispatchResponse setFocusEmulationEnabled(bool in_enabled) = 0;
    virtual DispatchResponse setAutoDarkModeOverride(std::optional<bool> in_enabled) = 0;
    virtual DispatchResponse setCPUThrottlingRate(double in_rate) = 0;
    virtual DispatchResponse setDefaultBackgroundColorOverride(std::unique_ptr<protocol::DOM::RGBA> in_color) = 0;
    virtual DispatchResponse setSafeAreaInsetsOverride(std::unique_ptr<protocol::Emulation::SafeAreaInsets> in_insets) = 0;
    virtual DispatchResponse setDeviceMetricsOverride(int in_width, int in_height, double in_deviceScaleFactor, bool in_mobile, std::optional<double> in_scale, std::optional<int> in_screenWidth, std::optional<int> in_screenHeight, std::optional<int> in_positionX, std::optional<int> in_positionY, std::optional<bool> in_dontSetVisibleSize, std::unique_ptr<protocol::Emulation::ScreenOrientation> in_screenOrientation, std::unique_ptr<protocol::Page::Viewport> in_viewport, std::unique_ptr<protocol::Emulation::DisplayFeature> in_displayFeature, std::unique_ptr<protocol::Emulation::DevicePosture> in_devicePosture) = 0;
    virtual DispatchResponse setScrollbarsHidden(bool in_hidden) = 0;
    virtual DispatchResponse setDocumentCookieDisabled(bool in_disabled) = 0;
    virtual DispatchResponse setEmulatedMedia(std::optional<String> in_media, std::unique_ptr<protocol::Array<protocol::Emulation::MediaFeature>> in_features) = 0;
    virtual DispatchResponse setEmulatedVisionDeficiency(const String& in_type) = 0;
    virtual DispatchResponse setEmulatedOSTextScale(std::optional<double> in_scale) = 0;
    virtual DispatchResponse setNavigatorOverrides(const String& in_platform) = 0;
    virtual DispatchResponse setPageScaleFactor(double in_pageScaleFactor) = 0;
    virtual DispatchResponse setScriptExecutionDisabled(bool in_value) = 0;
    virtual DispatchResponse setTouchEmulationEnabled(bool in_enabled, std::optional<int> in_maxTouchPoints) = 0;
    virtual DispatchResponse setVirtualTimePolicy(const String& in_policy, std::optional<double> in_budget, std::optional<int> in_maxVirtualTimeTaskStarvationCount, std::optional<double> in_initialVirtualTime, double* out_virtualTimeTicksBase) = 0;
    virtual DispatchResponse setLocaleOverride(std::optional<String> in_locale) = 0;
    virtual DispatchResponse setTimezoneOverride(const String& in_timezoneId) = 0;
    virtual DispatchResponse setDisabledImageTypes(std::unique_ptr<protocol::Array<String>> in_imageTypes) = 0;
    virtual DispatchResponse setDataSaverOverride(std::optional<bool> in_dataSaverEnabled) = 0;
    virtual DispatchResponse setHardwareConcurrencyOverride(int in_hardwareConcurrency) = 0;
    virtual DispatchResponse setUserAgentOverride(const String& in_userAgent, std::optional<String> in_acceptLanguage, std::optional<String> in_platform, std::unique_ptr<protocol::Emulation::UserAgentMetadata> in_userAgentMetadata) = 0;
    virtual DispatchResponse setAutomationOverride(bool in_enabled) = 0;
    virtual DispatchResponse setSmallViewportHeightDifferenceOverride(int in_difference) = 0;

    virtual DispatchResponse disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void virtualTimeBudgetExpired();

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Emulation
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Emulation_h)
