// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/dom_storage.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace DOMStorage {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "DOMStorage";
const char Metainfo::commandPrefix[] = "DOMStorage.";
const char Metainfo::version[] = "1.3";


CRDTP_BEGIN_DESERIALIZER(StorageId)
    CRDTP_DESERIALIZE_FIELD("isLocalStorage", m_isLocalStorage),
    CRDTP_DESERIALIZE_FIELD_OPT("securityOrigin", m_securityOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("storageKey", m_storageKey),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(StorageId)
    CRDTP_SERIALIZE_FIELD("securityOrigin", m_securityOrigin);
    CRDTP_SERIALIZE_FIELD("storageKey", m_storageKey);
    CRDTP_SERIALIZE_FIELD("isLocalStorage", m_isLocalStorage);
CRDTP_END_SERIALIZER();



// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::domStorageItemAdded(std::unique_ptr<protocol::DOMStorage::StorageId> storageId, const String& key, const String& newValue)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("storageId"), storageId);
    serializer.AddField(crdtp::MakeSpan("key"), key);
    serializer.AddField(crdtp::MakeSpan("newValue"), newValue);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOMStorage.domStorageItemAdded", serializer.Finish()));
}

void Frontend::domStorageItemRemoved(std::unique_ptr<protocol::DOMStorage::StorageId> storageId, const String& key)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("storageId"), storageId);
    serializer.AddField(crdtp::MakeSpan("key"), key);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOMStorage.domStorageItemRemoved", serializer.Finish()));
}

void Frontend::domStorageItemUpdated(std::unique_ptr<protocol::DOMStorage::StorageId> storageId, const String& key, const String& oldValue, const String& newValue)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("storageId"), storageId);
    serializer.AddField(crdtp::MakeSpan("key"), key);
    serializer.AddField(crdtp::MakeSpan("oldValue"), oldValue);
    serializer.AddField(crdtp::MakeSpan("newValue"), newValue);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOMStorage.domStorageItemUpdated", serializer.Finish()));
}

void Frontend::domStorageItemsCleared(std::unique_ptr<protocol::DOMStorage::StorageId> storageId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("storageId"), storageId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("DOMStorage.domStorageItemsCleared", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void clear(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void getDOMStorageItems(const crdtp::Dispatchable& dispatchable);
    void removeDOMStorageItem(const crdtp::Dispatchable& dispatchable);
    void setDOMStorageItem(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("clear"),
          &DomainDispatcherImpl::clear
    },
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("getDOMStorageItems"),
          &DomainDispatcherImpl::getDOMStorageItems
    },
    {
          crdtp::SpanFrom("removeDOMStorageItem"),
          &DomainDispatcherImpl::removeDOMStorageItem
    },
    {
          crdtp::SpanFrom("setDOMStorageItem"),
          &DomainDispatcherImpl::setDOMStorageItem
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct clearParams : public crdtp::DeserializableProtocolObject<clearParams> {
    std::unique_ptr<protocol::DOMStorage::StorageId> storageId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(clearParams)
    CRDTP_DESERIALIZE_FIELD("storageId", storageId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::clear(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    clearParams params;
    if (!clearParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->clear(std::move(params.storageId));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMStorage.clear"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMStorage.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMStorage.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getDOMStorageItemsParams : public crdtp::DeserializableProtocolObject<getDOMStorageItemsParams> {
    std::unique_ptr<protocol::DOMStorage::StorageId> storageId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getDOMStorageItemsParams)
    CRDTP_DESERIALIZE_FIELD("storageId", storageId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getDOMStorageItems(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getDOMStorageItemsParams params;
    if (!getDOMStorageItemsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Array<String>>> out_entries;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getDOMStorageItems(std::move(params.storageId), &out_entries);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMStorage.getDOMStorageItems"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("entries"), out_entries);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct removeDOMStorageItemParams : public crdtp::DeserializableProtocolObject<removeDOMStorageItemParams> {
    std::unique_ptr<protocol::DOMStorage::StorageId> storageId;
    String key;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(removeDOMStorageItemParams)
    CRDTP_DESERIALIZE_FIELD("key", key),
    CRDTP_DESERIALIZE_FIELD("storageId", storageId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::removeDOMStorageItem(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    removeDOMStorageItemParams params;
    if (!removeDOMStorageItemParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->removeDOMStorageItem(std::move(params.storageId), params.key);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMStorage.removeDOMStorageItem"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setDOMStorageItemParams : public crdtp::DeserializableProtocolObject<setDOMStorageItemParams> {
    std::unique_ptr<protocol::DOMStorage::StorageId> storageId;
    String key;
    String value;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setDOMStorageItemParams)
    CRDTP_DESERIALIZE_FIELD("key", key),
    CRDTP_DESERIALIZE_FIELD("storageId", storageId),
    CRDTP_DESERIALIZE_FIELD("value", value),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setDOMStorageItem(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setDOMStorageItemParams params;
    if (!setDOMStorageItemParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setDOMStorageItem(std::move(params.storageId), params.key, params.value);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMStorage.setDOMStorageItem"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("DOMStorage"), SortedRedirects(), std::move(dispatcher));
}

} // DOMStorage
} // namespace blink
} // namespace protocol
