// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_DOM_h
#define blink_protocol_DOM_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/runtime.h"

namespace blink {
namespace protocol {
namespace DOM {
using NodeId = int;
using BackendNodeId = int;
class BackendNode;
using PseudoType = String;
using ShadowRootType = String;
using CompatibilityMode = String;
using PhysicalAxes = String;
using LogicalAxes = String;
using ScrollOrientation = String;
class Node;
class DetachedElementInfo;
class RGBA;
class BoxModel;
class ShapeOutsideInfo;
class Rect;
class CSSComputedStyleProperty;

// ------------- Forward and enum declarations.

namespace PseudoTypeEnum {
CORE_EXPORT extern const char FirstLine[];
CORE_EXPORT extern const char FirstLetter[];
CORE_EXPORT extern const char Checkmark[];
CORE_EXPORT extern const char Before[];
CORE_EXPORT extern const char After[];
CORE_EXPORT extern const char PickerIcon[];
CORE_EXPORT extern const char InterestHint[];
CORE_EXPORT extern const char Marker[];
CORE_EXPORT extern const char Backdrop[];
CORE_EXPORT extern const char Column[];
CORE_EXPORT extern const char Selection[];
CORE_EXPORT extern const char SearchText[];
CORE_EXPORT extern const char TargetText[];
CORE_EXPORT extern const char SpellingError[];
CORE_EXPORT extern const char GrammarError[];
CORE_EXPORT extern const char Highlight[];
CORE_EXPORT extern const char FirstLineInherited[];
CORE_EXPORT extern const char ScrollMarker[];
CORE_EXPORT extern const char ScrollMarkerGroup[];
CORE_EXPORT extern const char ScrollButton[];
CORE_EXPORT extern const char Scrollbar[];
CORE_EXPORT extern const char ScrollbarThumb[];
CORE_EXPORT extern const char ScrollbarButton[];
CORE_EXPORT extern const char ScrollbarTrack[];
CORE_EXPORT extern const char ScrollbarTrackPiece[];
CORE_EXPORT extern const char ScrollbarCorner[];
CORE_EXPORT extern const char Resizer[];
CORE_EXPORT extern const char InputListButton[];
CORE_EXPORT extern const char ViewTransition[];
CORE_EXPORT extern const char ViewTransitionGroup[];
CORE_EXPORT extern const char ViewTransitionImagePair[];
CORE_EXPORT extern const char ViewTransitionGroupChildren[];
CORE_EXPORT extern const char ViewTransitionOld[];
CORE_EXPORT extern const char ViewTransitionNew[];
CORE_EXPORT extern const char Placeholder[];
CORE_EXPORT extern const char FileSelectorButton[];
CORE_EXPORT extern const char DetailsContent[];
CORE_EXPORT extern const char Picker[];
CORE_EXPORT extern const char PermissionIcon[];
} // namespace PseudoTypeEnum

namespace ShadowRootTypeEnum {
CORE_EXPORT extern const char UserAgent[];
CORE_EXPORT extern const char Open[];
CORE_EXPORT extern const char Closed[];
} // namespace ShadowRootTypeEnum

namespace CompatibilityModeEnum {
CORE_EXPORT extern const char QuirksMode[];
CORE_EXPORT extern const char LimitedQuirksMode[];
CORE_EXPORT extern const char NoQuirksMode[];
} // namespace CompatibilityModeEnum

namespace PhysicalAxesEnum {
CORE_EXPORT extern const char Horizontal[];
CORE_EXPORT extern const char Vertical[];
CORE_EXPORT extern const char Both[];
} // namespace PhysicalAxesEnum

namespace LogicalAxesEnum {
CORE_EXPORT extern const char Inline[];
CORE_EXPORT extern const char Block[];
CORE_EXPORT extern const char Both[];
} // namespace LogicalAxesEnum

namespace ScrollOrientationEnum {
CORE_EXPORT extern const char Horizontal[];
CORE_EXPORT extern const char Vertical[];
} // namespace ScrollOrientationEnum

namespace Enable {
namespace IncludeWhitespaceEnum {
CORE_EXPORT extern const char* None;
CORE_EXPORT extern const char* All;
} // IncludeWhitespaceEnum
} // Enable

namespace GetElementByRelation {
namespace RelationEnum {
CORE_EXPORT extern const char* PopoverTarget;
CORE_EXPORT extern const char* InterestTarget;
CORE_EXPORT extern const char* CommandFor;
} // RelationEnum
} // GetElementByRelation

// ------------- Type and builder declarations.

class CORE_EXPORT BackendNode : public ::crdtp::ProtocolObject<BackendNode> {
public:
    ~BackendNode() override { }

    int getNodeType() { return m_nodeType; }
    void setNodeType(int value) { m_nodeType = value; }

    String getNodeName() { return m_nodeName; }
    void setNodeName(const String& value) { m_nodeName = value; }

    int getBackendNodeId() { return m_backendNodeId; }
    void setBackendNodeId(int value) { m_backendNodeId = value; }

    template<int STATE>
    class BackendNodeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NodeTypeSet = 1 << 1,
            NodeNameSet = 1 << 2,
            BackendNodeIdSet = 1 << 3,
            AllFieldsSet = (NodeTypeSet | NodeNameSet | BackendNodeIdSet | 0)};


        BackendNodeBuilder<STATE | NodeTypeSet>& setNodeType(int value)
        {
            static_assert(!(STATE & NodeTypeSet), "property nodeType should not be set yet");
            m_result->setNodeType(value);
            return castState<NodeTypeSet>();
        }

        BackendNodeBuilder<STATE | NodeNameSet>& setNodeName(const String& value)
        {
            static_assert(!(STATE & NodeNameSet), "property nodeName should not be set yet");
            m_result->setNodeName(value);
            return castState<NodeNameSet>();
        }

        BackendNodeBuilder<STATE | BackendNodeIdSet>& setBackendNodeId(int value)
        {
            static_assert(!(STATE & BackendNodeIdSet), "property backendNodeId should not be set yet");
            m_result->setBackendNodeId(value);
            return castState<BackendNodeIdSet>();
        }

        std::unique_ptr<BackendNode> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BackendNode;
        BackendNodeBuilder() : m_result(new BackendNode()) { }

        template<int STEP> BackendNodeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BackendNodeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOM::BackendNode> m_result;
    };

    static BackendNodeBuilder<0> create()
    {
        return BackendNodeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BackendNode()
    {
          m_nodeType = 0;
          m_backendNodeId = 0;
    }

    int m_nodeType;
    String m_nodeName;
    int m_backendNodeId;
};


class CORE_EXPORT Node : public ::crdtp::ProtocolObject<Node> {
public:
    ~Node() override { }

    int getNodeId() { return m_nodeId; }
    void setNodeId(int value) { m_nodeId = value; }

    bool hasParentId() { return !!m_parentId; }
    int getParentId(int defaultValue) const {
       return m_parentId.value_or(defaultValue);
    }
    const std::optional<int>& getParentId() const {
       return m_parentId;
    }
    void setParentId(int value) { m_parentId = value; }

    int getBackendNodeId() { return m_backendNodeId; }
    void setBackendNodeId(int value) { m_backendNodeId = value; }

    int getNodeType() { return m_nodeType; }
    void setNodeType(int value) { m_nodeType = value; }

    String getNodeName() { return m_nodeName; }
    void setNodeName(const String& value) { m_nodeName = value; }

    String getLocalName() { return m_localName; }
    void setLocalName(const String& value) { m_localName = value; }

    String getNodeValue() { return m_nodeValue; }
    void setNodeValue(const String& value) { m_nodeValue = value; }

    bool hasChildNodeCount() { return !!m_childNodeCount; }
    int getChildNodeCount(int defaultValue) const {
       return m_childNodeCount.value_or(defaultValue);
    }
    const std::optional<int>& getChildNodeCount() const {
       return m_childNodeCount;
    }
    void setChildNodeCount(int value) { m_childNodeCount = value; }

    bool hasChildren() { return !!m_children; }
    protocol::Array<protocol::DOM::Node>* getChildren(protocol::Array<protocol::DOM::Node>* defaultValue) {
       return m_children ? m_children.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::DOM::Node>>& getChildren() const {
       return m_children;
    }
    void setChildren(std::unique_ptr<protocol::Array<protocol::DOM::Node>> value) { m_children = std::move(value); }

    bool hasAttributes() { return !!m_attributes; }
    protocol::Array<String>* getAttributes(protocol::Array<String>* defaultValue) {
       return m_attributes ? m_attributes.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& getAttributes() const {
       return m_attributes;
    }
    void setAttributes(std::unique_ptr<protocol::Array<String>> value) { m_attributes = std::move(value); }

    bool hasDocumentURL() { return !!m_documentURL; }
    String getDocumentURL(const String& defaultValue) const {
       return m_documentURL.value_or(defaultValue);
    }
    const std::optional<String>& getDocumentURL() const {
       return m_documentURL;
    }
    void setDocumentURL(const String& value) { m_documentURL = value; }

    bool hasBaseURL() { return !!m_baseURL; }
    String getBaseURL(const String& defaultValue) const {
       return m_baseURL.value_or(defaultValue);
    }
    const std::optional<String>& getBaseURL() const {
       return m_baseURL;
    }
    void setBaseURL(const String& value) { m_baseURL = value; }

    bool hasPublicId() { return !!m_publicId; }
    String getPublicId(const String& defaultValue) const {
       return m_publicId.value_or(defaultValue);
    }
    const std::optional<String>& getPublicId() const {
       return m_publicId;
    }
    void setPublicId(const String& value) { m_publicId = value; }

    bool hasSystemId() { return !!m_systemId; }
    String getSystemId(const String& defaultValue) const {
       return m_systemId.value_or(defaultValue);
    }
    const std::optional<String>& getSystemId() const {
       return m_systemId;
    }
    void setSystemId(const String& value) { m_systemId = value; }

    bool hasInternalSubset() { return !!m_internalSubset; }
    String getInternalSubset(const String& defaultValue) const {
       return m_internalSubset.value_or(defaultValue);
    }
    const std::optional<String>& getInternalSubset() const {
       return m_internalSubset;
    }
    void setInternalSubset(const String& value) { m_internalSubset = value; }

    bool hasXmlVersion() { return !!m_xmlVersion; }
    String getXmlVersion(const String& defaultValue) const {
       return m_xmlVersion.value_or(defaultValue);
    }
    const std::optional<String>& getXmlVersion() const {
       return m_xmlVersion;
    }
    void setXmlVersion(const String& value) { m_xmlVersion = value; }

    bool hasName() { return !!m_name; }
    String getName(const String& defaultValue) const {
       return m_name.value_or(defaultValue);
    }
    const std::optional<String>& getName() const {
       return m_name;
    }
    void setName(const String& value) { m_name = value; }

    bool hasValue() { return !!m_value; }
    String getValue(const String& defaultValue) const {
       return m_value.value_or(defaultValue);
    }
    const std::optional<String>& getValue() const {
       return m_value;
    }
    void setValue(const String& value) { m_value = value; }

    bool hasPseudoType() { return !!m_pseudoType; }
    String getPseudoType(const String& defaultValue) const {
       return m_pseudoType.value_or(defaultValue);
    }
    const std::optional<String>& getPseudoType() const {
       return m_pseudoType;
    }
    void setPseudoType(const String& value) { m_pseudoType = value; }

    bool hasPseudoIdentifier() { return !!m_pseudoIdentifier; }
    String getPseudoIdentifier(const String& defaultValue) const {
       return m_pseudoIdentifier.value_or(defaultValue);
    }
    const std::optional<String>& getPseudoIdentifier() const {
       return m_pseudoIdentifier;
    }
    void setPseudoIdentifier(const String& value) { m_pseudoIdentifier = value; }

    bool hasShadowRootType() { return !!m_shadowRootType; }
    String getShadowRootType(const String& defaultValue) const {
       return m_shadowRootType.value_or(defaultValue);
    }
    const std::optional<String>& getShadowRootType() const {
       return m_shadowRootType;
    }
    void setShadowRootType(const String& value) { m_shadowRootType = value; }

    bool hasFrameId() { return !!m_frameId; }
    String getFrameId(const String& defaultValue) const {
       return m_frameId.value_or(defaultValue);
    }
    const std::optional<String>& getFrameId() const {
       return m_frameId;
    }
    void setFrameId(const String& value) { m_frameId = value; }

    bool hasContentDocument() { return !!m_contentDocument; }
    protocol::DOM::Node* getContentDocument(protocol::DOM::Node* defaultValue) {
       return m_contentDocument ? m_contentDocument.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::Node>& getContentDocument() const {
       return m_contentDocument;
    }
    void setContentDocument(std::unique_ptr<protocol::DOM::Node> value) { m_contentDocument = std::move(value); }

    bool hasShadowRoots() { return !!m_shadowRoots; }
    protocol::Array<protocol::DOM::Node>* getShadowRoots(protocol::Array<protocol::DOM::Node>* defaultValue) {
       return m_shadowRoots ? m_shadowRoots.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::DOM::Node>>& getShadowRoots() const {
       return m_shadowRoots;
    }
    void setShadowRoots(std::unique_ptr<protocol::Array<protocol::DOM::Node>> value) { m_shadowRoots = std::move(value); }

    bool hasTemplateContent() { return !!m_templateContent; }
    protocol::DOM::Node* getTemplateContent(protocol::DOM::Node* defaultValue) {
       return m_templateContent ? m_templateContent.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::Node>& getTemplateContent() const {
       return m_templateContent;
    }
    void setTemplateContent(std::unique_ptr<protocol::DOM::Node> value) { m_templateContent = std::move(value); }

    bool hasPseudoElements() { return !!m_pseudoElements; }
    protocol::Array<protocol::DOM::Node>* getPseudoElements(protocol::Array<protocol::DOM::Node>* defaultValue) {
       return m_pseudoElements ? m_pseudoElements.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::DOM::Node>>& getPseudoElements() const {
       return m_pseudoElements;
    }
    void setPseudoElements(std::unique_ptr<protocol::Array<protocol::DOM::Node>> value) { m_pseudoElements = std::move(value); }

    bool hasImportedDocument() { return !!m_importedDocument; }
    protocol::DOM::Node* getImportedDocument(protocol::DOM::Node* defaultValue) {
       return m_importedDocument ? m_importedDocument.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::Node>& getImportedDocument() const {
       return m_importedDocument;
    }
    void setImportedDocument(std::unique_ptr<protocol::DOM::Node> value) { m_importedDocument = std::move(value); }

    bool hasDistributedNodes() { return !!m_distributedNodes; }
    protocol::Array<protocol::DOM::BackendNode>* getDistributedNodes(protocol::Array<protocol::DOM::BackendNode>* defaultValue) {
       return m_distributedNodes ? m_distributedNodes.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::DOM::BackendNode>>& getDistributedNodes() const {
       return m_distributedNodes;
    }
    void setDistributedNodes(std::unique_ptr<protocol::Array<protocol::DOM::BackendNode>> value) { m_distributedNodes = std::move(value); }

    bool hasIsSVG() { return !!m_isSVG; }
    bool getIsSVG(bool defaultValue) const {
       return m_isSVG.value_or(defaultValue);
    }
    const std::optional<bool>& getIsSVG() const {
       return m_isSVG;
    }
    void setIsSVG(bool value) { m_isSVG = value; }

    bool hasCompatibilityMode() { return !!m_compatibilityMode; }
    String getCompatibilityMode(const String& defaultValue) const {
       return m_compatibilityMode.value_or(defaultValue);
    }
    const std::optional<String>& getCompatibilityMode() const {
       return m_compatibilityMode;
    }
    void setCompatibilityMode(const String& value) { m_compatibilityMode = value; }

    bool hasAssignedSlot() { return !!m_assignedSlot; }
    protocol::DOM::BackendNode* getAssignedSlot(protocol::DOM::BackendNode* defaultValue) {
       return m_assignedSlot ? m_assignedSlot.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::BackendNode>& getAssignedSlot() const {
       return m_assignedSlot;
    }
    void setAssignedSlot(std::unique_ptr<protocol::DOM::BackendNode> value) { m_assignedSlot = std::move(value); }

    bool hasIsScrollable() { return !!m_isScrollable; }
    bool getIsScrollable(bool defaultValue) const {
       return m_isScrollable.value_or(defaultValue);
    }
    const std::optional<bool>& getIsScrollable() const {
       return m_isScrollable;
    }
    void setIsScrollable(bool value) { m_isScrollable = value; }

    bool hasAffectedByStartingStyles() { return !!m_affectedByStartingStyles; }
    bool getAffectedByStartingStyles(bool defaultValue) const {
       return m_affectedByStartingStyles.value_or(defaultValue);
    }
    const std::optional<bool>& getAffectedByStartingStyles() const {
       return m_affectedByStartingStyles;
    }
    void setAffectedByStartingStyles(bool value) { m_affectedByStartingStyles = value; }

    template<int STATE>
    class NodeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NodeIdSet = 1 << 1,
            BackendNodeIdSet = 1 << 2,
            NodeTypeSet = 1 << 3,
            NodeNameSet = 1 << 4,
            LocalNameSet = 1 << 5,
            NodeValueSet = 1 << 6,
            AllFieldsSet = (NodeIdSet | BackendNodeIdSet | NodeTypeSet | NodeNameSet | LocalNameSet | NodeValueSet | 0)};


        NodeBuilder<STATE | NodeIdSet>& setNodeId(int value)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId should not be set yet");
            m_result->setNodeId(value);
            return castState<NodeIdSet>();
        }

        NodeBuilder<STATE>& setParentId(int value)
        {
            m_result->setParentId(value);
            return *this;
        }

        NodeBuilder<STATE | BackendNodeIdSet>& setBackendNodeId(int value)
        {
            static_assert(!(STATE & BackendNodeIdSet), "property backendNodeId should not be set yet");
            m_result->setBackendNodeId(value);
            return castState<BackendNodeIdSet>();
        }

        NodeBuilder<STATE | NodeTypeSet>& setNodeType(int value)
        {
            static_assert(!(STATE & NodeTypeSet), "property nodeType should not be set yet");
            m_result->setNodeType(value);
            return castState<NodeTypeSet>();
        }

        NodeBuilder<STATE | NodeNameSet>& setNodeName(const String& value)
        {
            static_assert(!(STATE & NodeNameSet), "property nodeName should not be set yet");
            m_result->setNodeName(value);
            return castState<NodeNameSet>();
        }

        NodeBuilder<STATE | LocalNameSet>& setLocalName(const String& value)
        {
            static_assert(!(STATE & LocalNameSet), "property localName should not be set yet");
            m_result->setLocalName(value);
            return castState<LocalNameSet>();
        }

        NodeBuilder<STATE | NodeValueSet>& setNodeValue(const String& value)
        {
            static_assert(!(STATE & NodeValueSet), "property nodeValue should not be set yet");
            m_result->setNodeValue(value);
            return castState<NodeValueSet>();
        }

        NodeBuilder<STATE>& setChildNodeCount(int value)
        {
            m_result->setChildNodeCount(value);
            return *this;
        }

        NodeBuilder<STATE>& setChildren(std::unique_ptr<protocol::Array<protocol::DOM::Node>> value)
        {
            m_result->setChildren(std::move(value));
            return *this;
        }

        NodeBuilder<STATE>& setAttributes(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->setAttributes(std::move(value));
            return *this;
        }

        NodeBuilder<STATE>& setDocumentURL(const String& value)
        {
            m_result->setDocumentURL(value);
            return *this;
        }

        NodeBuilder<STATE>& setBaseURL(const String& value)
        {
            m_result->setBaseURL(value);
            return *this;
        }

        NodeBuilder<STATE>& setPublicId(const String& value)
        {
            m_result->setPublicId(value);
            return *this;
        }

        NodeBuilder<STATE>& setSystemId(const String& value)
        {
            m_result->setSystemId(value);
            return *this;
        }

        NodeBuilder<STATE>& setInternalSubset(const String& value)
        {
            m_result->setInternalSubset(value);
            return *this;
        }

        NodeBuilder<STATE>& setXmlVersion(const String& value)
        {
            m_result->setXmlVersion(value);
            return *this;
        }

        NodeBuilder<STATE>& setName(const String& value)
        {
            m_result->setName(value);
            return *this;
        }

        NodeBuilder<STATE>& setValue(const String& value)
        {
            m_result->setValue(value);
            return *this;
        }

        NodeBuilder<STATE>& setPseudoType(const String& value)
        {
            m_result->setPseudoType(value);
            return *this;
        }

        NodeBuilder<STATE>& setPseudoIdentifier(const String& value)
        {
            m_result->setPseudoIdentifier(value);
            return *this;
        }

        NodeBuilder<STATE>& setShadowRootType(const String& value)
        {
            m_result->setShadowRootType(value);
            return *this;
        }

        NodeBuilder<STATE>& setFrameId(const String& value)
        {
            m_result->setFrameId(value);
            return *this;
        }

        NodeBuilder<STATE>& setContentDocument(std::unique_ptr<protocol::DOM::Node> value)
        {
            m_result->setContentDocument(std::move(value));
            return *this;
        }

        NodeBuilder<STATE>& setShadowRoots(std::unique_ptr<protocol::Array<protocol::DOM::Node>> value)
        {
            m_result->setShadowRoots(std::move(value));
            return *this;
        }

        NodeBuilder<STATE>& setTemplateContent(std::unique_ptr<protocol::DOM::Node> value)
        {
            m_result->setTemplateContent(std::move(value));
            return *this;
        }

        NodeBuilder<STATE>& setPseudoElements(std::unique_ptr<protocol::Array<protocol::DOM::Node>> value)
        {
            m_result->setPseudoElements(std::move(value));
            return *this;
        }

        NodeBuilder<STATE>& setImportedDocument(std::unique_ptr<protocol::DOM::Node> value)
        {
            m_result->setImportedDocument(std::move(value));
            return *this;
        }

        NodeBuilder<STATE>& setDistributedNodes(std::unique_ptr<protocol::Array<protocol::DOM::BackendNode>> value)
        {
            m_result->setDistributedNodes(std::move(value));
            return *this;
        }

        NodeBuilder<STATE>& setIsSVG(bool value)
        {
            m_result->setIsSVG(value);
            return *this;
        }

        NodeBuilder<STATE>& setCompatibilityMode(const String& value)
        {
            m_result->setCompatibilityMode(value);
            return *this;
        }

        NodeBuilder<STATE>& setAssignedSlot(std::unique_ptr<protocol::DOM::BackendNode> value)
        {
            m_result->setAssignedSlot(std::move(value));
            return *this;
        }

        NodeBuilder<STATE>& setIsScrollable(bool value)
        {
            m_result->setIsScrollable(value);
            return *this;
        }

        NodeBuilder<STATE>& setAffectedByStartingStyles(bool value)
        {
            m_result->setAffectedByStartingStyles(value);
            return *this;
        }

        std::unique_ptr<Node> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Node;
        NodeBuilder() : m_result(new Node()) { }

        template<int STEP> NodeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<NodeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOM::Node> m_result;
    };

    static NodeBuilder<0> create()
    {
        return NodeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Node()
    {
          m_nodeId = 0;
          m_backendNodeId = 0;
          m_nodeType = 0;
    }

    int m_nodeId;
    std::optional<int> m_parentId;
    int m_backendNodeId;
    int m_nodeType;
    String m_nodeName;
    String m_localName;
    String m_nodeValue;
    std::optional<int> m_childNodeCount;
    std::unique_ptr<protocol::Array<protocol::DOM::Node>> m_children;
    std::unique_ptr<protocol::Array<String>> m_attributes;
    std::optional<String> m_documentURL;
    std::optional<String> m_baseURL;
    std::optional<String> m_publicId;
    std::optional<String> m_systemId;
    std::optional<String> m_internalSubset;
    std::optional<String> m_xmlVersion;
    std::optional<String> m_name;
    std::optional<String> m_value;
    std::optional<String> m_pseudoType;
    std::optional<String> m_pseudoIdentifier;
    std::optional<String> m_shadowRootType;
    std::optional<String> m_frameId;
    std::unique_ptr<protocol::DOM::Node> m_contentDocument;
    std::unique_ptr<protocol::Array<protocol::DOM::Node>> m_shadowRoots;
    std::unique_ptr<protocol::DOM::Node> m_templateContent;
    std::unique_ptr<protocol::Array<protocol::DOM::Node>> m_pseudoElements;
    std::unique_ptr<protocol::DOM::Node> m_importedDocument;
    std::unique_ptr<protocol::Array<protocol::DOM::BackendNode>> m_distributedNodes;
    std::optional<bool> m_isSVG;
    std::optional<String> m_compatibilityMode;
    std::unique_ptr<protocol::DOM::BackendNode> m_assignedSlot;
    std::optional<bool> m_isScrollable;
    std::optional<bool> m_affectedByStartingStyles;
};


class CORE_EXPORT DetachedElementInfo : public ::crdtp::ProtocolObject<DetachedElementInfo> {
public:
    ~DetachedElementInfo() override { }

    protocol::DOM::Node* getTreeNode() { return m_treeNode.get(); }
    void setTreeNode(std::unique_ptr<protocol::DOM::Node> value) { m_treeNode = std::move(value); }

    protocol::Array<int>* getRetainedNodeIds() { return m_retainedNodeIds.get(); }
    void setRetainedNodeIds(std::unique_ptr<protocol::Array<int>> value) { m_retainedNodeIds = std::move(value); }

    template<int STATE>
    class DetachedElementInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TreeNodeSet = 1 << 1,
            RetainedNodeIdsSet = 1 << 2,
            AllFieldsSet = (TreeNodeSet | RetainedNodeIdsSet | 0)};


        DetachedElementInfoBuilder<STATE | TreeNodeSet>& setTreeNode(std::unique_ptr<protocol::DOM::Node> value)
        {
            static_assert(!(STATE & TreeNodeSet), "property treeNode should not be set yet");
            m_result->setTreeNode(std::move(value));
            return castState<TreeNodeSet>();
        }

        DetachedElementInfoBuilder<STATE | RetainedNodeIdsSet>& setRetainedNodeIds(std::unique_ptr<protocol::Array<int>> value)
        {
            static_assert(!(STATE & RetainedNodeIdsSet), "property retainedNodeIds should not be set yet");
            m_result->setRetainedNodeIds(std::move(value));
            return castState<RetainedNodeIdsSet>();
        }

        std::unique_ptr<DetachedElementInfo> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DetachedElementInfo;
        DetachedElementInfoBuilder() : m_result(new DetachedElementInfo()) { }

        template<int STEP> DetachedElementInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DetachedElementInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOM::DetachedElementInfo> m_result;
    };

    static DetachedElementInfoBuilder<0> create()
    {
        return DetachedElementInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DetachedElementInfo()
    {
    }

    std::unique_ptr<protocol::DOM::Node> m_treeNode;
    std::unique_ptr<protocol::Array<int>> m_retainedNodeIds;
};


class CORE_EXPORT RGBA : public ::crdtp::ProtocolObject<RGBA> {
public:
    ~RGBA() override { }

    int getR() { return m_r; }
    void setR(int value) { m_r = value; }

    int getG() { return m_g; }
    void setG(int value) { m_g = value; }

    int getB() { return m_b; }
    void setB(int value) { m_b = value; }

    bool hasA() { return !!m_a; }
    double getA(double defaultValue) const {
       return m_a.value_or(defaultValue);
    }
    const std::optional<double>& getA() const {
       return m_a;
    }
    void setA(double value) { m_a = value; }

    template<int STATE>
    class RGBABuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RSet = 1 << 1,
            GSet = 1 << 2,
            BSet = 1 << 3,
            AllFieldsSet = (RSet | GSet | BSet | 0)};


        RGBABuilder<STATE | RSet>& setR(int value)
        {
            static_assert(!(STATE & RSet), "property r should not be set yet");
            m_result->setR(value);
            return castState<RSet>();
        }

        RGBABuilder<STATE | GSet>& setG(int value)
        {
            static_assert(!(STATE & GSet), "property g should not be set yet");
            m_result->setG(value);
            return castState<GSet>();
        }

        RGBABuilder<STATE | BSet>& setB(int value)
        {
            static_assert(!(STATE & BSet), "property b should not be set yet");
            m_result->setB(value);
            return castState<BSet>();
        }

        RGBABuilder<STATE>& setA(double value)
        {
            m_result->setA(value);
            return *this;
        }

        std::unique_ptr<RGBA> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RGBA;
        RGBABuilder() : m_result(new RGBA()) { }

        template<int STEP> RGBABuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RGBABuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOM::RGBA> m_result;
    };

    static RGBABuilder<0> create()
    {
        return RGBABuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RGBA()
    {
          m_r = 0;
          m_g = 0;
          m_b = 0;
    }

    int m_r;
    int m_g;
    int m_b;
    std::optional<double> m_a;
};


class CORE_EXPORT BoxModel : public ::crdtp::ProtocolObject<BoxModel> {
public:
    ~BoxModel() override { }

    protocol::Array<double>* getContent() { return m_content.get(); }
    void setContent(std::unique_ptr<protocol::Array<double>> value) { m_content = std::move(value); }

    protocol::Array<double>* getPadding() { return m_padding.get(); }
    void setPadding(std::unique_ptr<protocol::Array<double>> value) { m_padding = std::move(value); }

    protocol::Array<double>* getBorder() { return m_border.get(); }
    void setBorder(std::unique_ptr<protocol::Array<double>> value) { m_border = std::move(value); }

    protocol::Array<double>* getMargin() { return m_margin.get(); }
    void setMargin(std::unique_ptr<protocol::Array<double>> value) { m_margin = std::move(value); }

    int getWidth() { return m_width; }
    void setWidth(int value) { m_width = value; }

    int getHeight() { return m_height; }
    void setHeight(int value) { m_height = value; }

    bool hasShapeOutside() { return !!m_shapeOutside; }
    protocol::DOM::ShapeOutsideInfo* getShapeOutside(protocol::DOM::ShapeOutsideInfo* defaultValue) {
       return m_shapeOutside ? m_shapeOutside.get() : defaultValue;
    }
    const std::unique_ptr<protocol::DOM::ShapeOutsideInfo>& getShapeOutside() const {
       return m_shapeOutside;
    }
    void setShapeOutside(std::unique_ptr<protocol::DOM::ShapeOutsideInfo> value) { m_shapeOutside = std::move(value); }

    template<int STATE>
    class BoxModelBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ContentSet = 1 << 1,
            PaddingSet = 1 << 2,
            BorderSet = 1 << 3,
            MarginSet = 1 << 4,
            WidthSet = 1 << 5,
            HeightSet = 1 << 6,
            AllFieldsSet = (ContentSet | PaddingSet | BorderSet | MarginSet | WidthSet | HeightSet | 0)};


        BoxModelBuilder<STATE | ContentSet>& setContent(std::unique_ptr<protocol::Array<double>> value)
        {
            static_assert(!(STATE & ContentSet), "property content should not be set yet");
            m_result->setContent(std::move(value));
            return castState<ContentSet>();
        }

        BoxModelBuilder<STATE | PaddingSet>& setPadding(std::unique_ptr<protocol::Array<double>> value)
        {
            static_assert(!(STATE & PaddingSet), "property padding should not be set yet");
            m_result->setPadding(std::move(value));
            return castState<PaddingSet>();
        }

        BoxModelBuilder<STATE | BorderSet>& setBorder(std::unique_ptr<protocol::Array<double>> value)
        {
            static_assert(!(STATE & BorderSet), "property border should not be set yet");
            m_result->setBorder(std::move(value));
            return castState<BorderSet>();
        }

        BoxModelBuilder<STATE | MarginSet>& setMargin(std::unique_ptr<protocol::Array<double>> value)
        {
            static_assert(!(STATE & MarginSet), "property margin should not be set yet");
            m_result->setMargin(std::move(value));
            return castState<MarginSet>();
        }

        BoxModelBuilder<STATE | WidthSet>& setWidth(int value)
        {
            static_assert(!(STATE & WidthSet), "property width should not be set yet");
            m_result->setWidth(value);
            return castState<WidthSet>();
        }

        BoxModelBuilder<STATE | HeightSet>& setHeight(int value)
        {
            static_assert(!(STATE & HeightSet), "property height should not be set yet");
            m_result->setHeight(value);
            return castState<HeightSet>();
        }

        BoxModelBuilder<STATE>& setShapeOutside(std::unique_ptr<protocol::DOM::ShapeOutsideInfo> value)
        {
            m_result->setShapeOutside(std::move(value));
            return *this;
        }

        std::unique_ptr<BoxModel> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BoxModel;
        BoxModelBuilder() : m_result(new BoxModel()) { }

        template<int STEP> BoxModelBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BoxModelBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOM::BoxModel> m_result;
    };

    static BoxModelBuilder<0> create()
    {
        return BoxModelBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BoxModel()
    {
          m_width = 0;
          m_height = 0;
    }

    std::unique_ptr<protocol::Array<double>> m_content;
    std::unique_ptr<protocol::Array<double>> m_padding;
    std::unique_ptr<protocol::Array<double>> m_border;
    std::unique_ptr<protocol::Array<double>> m_margin;
    int m_width;
    int m_height;
    std::unique_ptr<protocol::DOM::ShapeOutsideInfo> m_shapeOutside;
};


class CORE_EXPORT ShapeOutsideInfo : public ::crdtp::ProtocolObject<ShapeOutsideInfo> {
public:
    ~ShapeOutsideInfo() override { }

    protocol::Array<double>* getBounds() { return m_bounds.get(); }
    void setBounds(std::unique_ptr<protocol::Array<double>> value) { m_bounds = std::move(value); }

    protocol::Array<protocol::Value>* getShape() { return m_shape.get(); }
    void setShape(std::unique_ptr<protocol::Array<protocol::Value>> value) { m_shape = std::move(value); }

    protocol::Array<protocol::Value>* getMarginShape() { return m_marginShape.get(); }
    void setMarginShape(std::unique_ptr<protocol::Array<protocol::Value>> value) { m_marginShape = std::move(value); }

    template<int STATE>
    class ShapeOutsideInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            BoundsSet = 1 << 1,
            ShapeSet = 1 << 2,
            MarginShapeSet = 1 << 3,
            AllFieldsSet = (BoundsSet | ShapeSet | MarginShapeSet | 0)};


        ShapeOutsideInfoBuilder<STATE | BoundsSet>& setBounds(std::unique_ptr<protocol::Array<double>> value)
        {
            static_assert(!(STATE & BoundsSet), "property bounds should not be set yet");
            m_result->setBounds(std::move(value));
            return castState<BoundsSet>();
        }

        ShapeOutsideInfoBuilder<STATE | ShapeSet>& setShape(std::unique_ptr<protocol::Array<protocol::Value>> value)
        {
            static_assert(!(STATE & ShapeSet), "property shape should not be set yet");
            m_result->setShape(std::move(value));
            return castState<ShapeSet>();
        }

        ShapeOutsideInfoBuilder<STATE | MarginShapeSet>& setMarginShape(std::unique_ptr<protocol::Array<protocol::Value>> value)
        {
            static_assert(!(STATE & MarginShapeSet), "property marginShape should not be set yet");
            m_result->setMarginShape(std::move(value));
            return castState<MarginShapeSet>();
        }

        std::unique_ptr<ShapeOutsideInfo> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ShapeOutsideInfo;
        ShapeOutsideInfoBuilder() : m_result(new ShapeOutsideInfo()) { }

        template<int STEP> ShapeOutsideInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ShapeOutsideInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOM::ShapeOutsideInfo> m_result;
    };

    static ShapeOutsideInfoBuilder<0> create()
    {
        return ShapeOutsideInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ShapeOutsideInfo()
    {
    }

    std::unique_ptr<protocol::Array<double>> m_bounds;
    std::unique_ptr<protocol::Array<protocol::Value>> m_shape;
    std::unique_ptr<protocol::Array<protocol::Value>> m_marginShape;
};


class CORE_EXPORT Rect : public ::crdtp::ProtocolObject<Rect> {
public:
    ~Rect() override { }

    double getX() { return m_x; }
    void setX(double value) { m_x = value; }

    double getY() { return m_y; }
    void setY(double value) { m_y = value; }

    double getWidth() { return m_width; }
    void setWidth(double value) { m_width = value; }

    double getHeight() { return m_height; }
    void setHeight(double value) { m_height = value; }

    template<int STATE>
    class RectBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            XSet = 1 << 1,
            YSet = 1 << 2,
            WidthSet = 1 << 3,
            HeightSet = 1 << 4,
            AllFieldsSet = (XSet | YSet | WidthSet | HeightSet | 0)};


        RectBuilder<STATE | XSet>& setX(double value)
        {
            static_assert(!(STATE & XSet), "property x should not be set yet");
            m_result->setX(value);
            return castState<XSet>();
        }

        RectBuilder<STATE | YSet>& setY(double value)
        {
            static_assert(!(STATE & YSet), "property y should not be set yet");
            m_result->setY(value);
            return castState<YSet>();
        }

        RectBuilder<STATE | WidthSet>& setWidth(double value)
        {
            static_assert(!(STATE & WidthSet), "property width should not be set yet");
            m_result->setWidth(value);
            return castState<WidthSet>();
        }

        RectBuilder<STATE | HeightSet>& setHeight(double value)
        {
            static_assert(!(STATE & HeightSet), "property height should not be set yet");
            m_result->setHeight(value);
            return castState<HeightSet>();
        }

        std::unique_ptr<Rect> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Rect;
        RectBuilder() : m_result(new Rect()) { }

        template<int STEP> RectBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RectBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOM::Rect> m_result;
    };

    static RectBuilder<0> create()
    {
        return RectBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Rect()
    {
          m_x = 0;
          m_y = 0;
          m_width = 0;
          m_height = 0;
    }

    double m_x;
    double m_y;
    double m_width;
    double m_height;
};


class CORE_EXPORT CSSComputedStyleProperty : public ::crdtp::ProtocolObject<CSSComputedStyleProperty> {
public:
    ~CSSComputedStyleProperty() override { }

    String getName() { return m_name; }
    void setName(const String& value) { m_name = value; }

    String getValue() { return m_value; }
    void setValue(const String& value) { m_value = value; }

    template<int STATE>
    class CSSComputedStylePropertyBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        CSSComputedStylePropertyBuilder<STATE | NameSet>& setName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(value);
            return castState<NameSet>();
        }

        CSSComputedStylePropertyBuilder<STATE | ValueSet>& setValue(const String& value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->setValue(value);
            return castState<ValueSet>();
        }

        std::unique_ptr<CSSComputedStyleProperty> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CSSComputedStyleProperty;
        CSSComputedStylePropertyBuilder() : m_result(new CSSComputedStyleProperty()) { }

        template<int STEP> CSSComputedStylePropertyBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CSSComputedStylePropertyBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOM::CSSComputedStyleProperty> m_result;
    };

    static CSSComputedStylePropertyBuilder<0> create()
    {
        return CSSComputedStylePropertyBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CSSComputedStyleProperty()
    {
    }

    String m_name;
    String m_value;
};


// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse collectClassNamesFromSubtree(int in_nodeId, std::unique_ptr<protocol::Array<String>>* out_classNames) = 0;
    virtual DispatchResponse copyTo(int in_nodeId, int in_targetNodeId, std::optional<int> in_insertBeforeNodeId, int* out_nodeId) = 0;
    virtual DispatchResponse describeNode(std::optional<int> in_nodeId, std::optional<int> in_backendNodeId, std::optional<String> in_objectId, std::optional<int> in_depth, std::optional<bool> in_pierce, std::unique_ptr<protocol::DOM::Node>* out_node) = 0;
    virtual DispatchResponse scrollIntoViewIfNeeded(std::optional<int> in_nodeId, std::optional<int> in_backendNodeId, std::optional<String> in_objectId, std::unique_ptr<protocol::DOM::Rect> in_rect) = 0;
    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse discardSearchResults(const String& in_searchId) = 0;
    virtual DispatchResponse enable(std::optional<String> in_includeWhitespace) = 0;
    virtual DispatchResponse focus(std::optional<int> in_nodeId, std::optional<int> in_backendNodeId, std::optional<String> in_objectId) = 0;
    virtual DispatchResponse getAttributes(int in_nodeId, std::unique_ptr<protocol::Array<String>>* out_attributes) = 0;
    virtual DispatchResponse getBoxModel(std::optional<int> in_nodeId, std::optional<int> in_backendNodeId, std::optional<String> in_objectId, std::unique_ptr<protocol::DOM::BoxModel>* out_model) = 0;
    virtual DispatchResponse getContentQuads(std::optional<int> in_nodeId, std::optional<int> in_backendNodeId, std::optional<String> in_objectId, std::unique_ptr<protocol::Array<protocol::Array<double>>>* out_quads) = 0;
    virtual DispatchResponse getDocument(std::optional<int> in_depth, std::optional<bool> in_pierce, std::unique_ptr<protocol::DOM::Node>* out_root) = 0;
    virtual DispatchResponse getFlattenedDocument(std::optional<int> in_depth, std::optional<bool> in_pierce, std::unique_ptr<protocol::Array<protocol::DOM::Node>>* out_nodes) = 0;
    virtual DispatchResponse getNodesForSubtreeByStyle(int in_nodeId, std::unique_ptr<protocol::Array<protocol::DOM::CSSComputedStyleProperty>> in_computedStyles, std::optional<bool> in_pierce, std::unique_ptr<protocol::Array<int>>* out_nodeIds) = 0;
    virtual DispatchResponse getNodeForLocation(int in_x, int in_y, std::optional<bool> in_includeUserAgentShadowDOM, std::optional<bool> in_ignorePointerEventsNone, int* out_backendNodeId, String* out_frameId, std::optional<int>* out_nodeId) = 0;
    virtual DispatchResponse getOuterHTML(std::optional<int> in_nodeId, std::optional<int> in_backendNodeId, std::optional<String> in_objectId, std::optional<bool> in_includeShadowDOM, String* out_outerHTML) = 0;
    virtual DispatchResponse getRelayoutBoundary(int in_nodeId, int* out_nodeId) = 0;
    virtual DispatchResponse getSearchResults(const String& in_searchId, int in_fromIndex, int in_toIndex, std::unique_ptr<protocol::Array<int>>* out_nodeIds) = 0;
    virtual DispatchResponse markUndoableState() = 0;
    virtual DispatchResponse moveTo(int in_nodeId, int in_targetNodeId, std::optional<int> in_insertBeforeNodeId, int* out_nodeId) = 0;
    virtual DispatchResponse performSearch(const String& in_query, std::optional<bool> in_includeUserAgentShadowDOM, String* out_searchId, int* out_resultCount) = 0;
    virtual DispatchResponse pushNodeByPathToFrontend(const String& in_path, int* out_nodeId) = 0;
    virtual DispatchResponse pushNodesByBackendIdsToFrontend(std::unique_ptr<protocol::Array<int>> in_backendNodeIds, std::unique_ptr<protocol::Array<int>>* out_nodeIds) = 0;
    virtual DispatchResponse querySelector(int in_nodeId, const String& in_selector, int* out_nodeId) = 0;
    virtual DispatchResponse querySelectorAll(int in_nodeId, const String& in_selector, std::unique_ptr<protocol::Array<int>>* out_nodeIds) = 0;
    virtual DispatchResponse getTopLayerElements(std::unique_ptr<protocol::Array<int>>* out_nodeIds) = 0;
    virtual DispatchResponse getElementByRelation(int in_nodeId, const String& in_relation, int* out_nodeId) = 0;
    virtual DispatchResponse redo() = 0;
    virtual DispatchResponse removeAttribute(int in_nodeId, const String& in_name) = 0;
    virtual DispatchResponse removeNode(int in_nodeId) = 0;
    virtual DispatchResponse requestChildNodes(int in_nodeId, std::optional<int> in_depth, std::optional<bool> in_pierce) = 0;
    virtual DispatchResponse requestNode(const String& in_objectId, int* out_nodeId) = 0;
    virtual DispatchResponse resolveNode(std::optional<int> in_nodeId, std::optional<int> in_backendNodeId, std::optional<String> in_objectGroup, std::optional<int> in_executionContextId, std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject>* out_object) = 0;
    virtual DispatchResponse setAttributeValue(int in_nodeId, const String& in_name, const String& in_value) = 0;
    virtual DispatchResponse setAttributesAsText(int in_nodeId, const String& in_text, std::optional<String> in_name) = 0;
    virtual DispatchResponse setFileInputFiles(std::unique_ptr<protocol::Array<String>> in_files, std::optional<int> in_nodeId, std::optional<int> in_backendNodeId, std::optional<String> in_objectId) = 0;
    virtual DispatchResponse setNodeStackTracesEnabled(bool in_enable) = 0;
    virtual DispatchResponse getNodeStackTraces(int in_nodeId, std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace>* out_creation) = 0;
    virtual DispatchResponse getFileInfo(const String& in_objectId, String* out_path) = 0;
    virtual DispatchResponse getDetachedDomNodes(std::unique_ptr<protocol::Array<protocol::DOM::DetachedElementInfo>>* out_detachedNodes) = 0;
    virtual DispatchResponse setInspectedNode(int in_nodeId) = 0;
    virtual DispatchResponse setNodeName(int in_nodeId, const String& in_name, int* out_nodeId) = 0;
    virtual DispatchResponse setNodeValue(int in_nodeId, const String& in_value) = 0;
    virtual DispatchResponse setOuterHTML(int in_nodeId, const String& in_outerHTML) = 0;
    virtual DispatchResponse undo() = 0;
    virtual DispatchResponse getFrameOwner(const String& in_frameId, int* out_backendNodeId, std::optional<int>* out_nodeId) = 0;
    virtual DispatchResponse getContainerForNode(int in_nodeId, std::optional<String> in_containerName, std::optional<String> in_physicalAxes, std::optional<String> in_logicalAxes, std::optional<bool> in_queriesScrollState, std::optional<bool> in_queriesAnchored, std::optional<int>* out_nodeId) = 0;
    virtual DispatchResponse getQueryingDescendantsForContainer(int in_nodeId, std::unique_ptr<protocol::Array<int>>* out_nodeIds) = 0;
    virtual DispatchResponse getAnchorElement(int in_nodeId, std::optional<String> in_anchorSpecifier, int* out_nodeId) = 0;
    virtual DispatchResponse forceShowPopover(int in_nodeId, bool in_enable, std::unique_ptr<protocol::Array<int>>* out_nodeIds) = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void attributeModified(int nodeId, const String& name, const String& value);
    void attributeRemoved(int nodeId, const String& name);
    void characterDataModified(int nodeId, const String& characterData);
    void childNodeCountUpdated(int nodeId, int childNodeCount);
    void childNodeInserted(int parentNodeId, int previousNodeId, std::unique_ptr<protocol::DOM::Node> node);
    void childNodeRemoved(int parentNodeId, int nodeId);
    void distributedNodesUpdated(int insertionPointId, std::unique_ptr<protocol::Array<protocol::DOM::BackendNode>> distributedNodes);
    void documentUpdated();
    void inlineStyleInvalidated(std::unique_ptr<protocol::Array<int>> nodeIds);
    void pseudoElementAdded(int parentId, std::unique_ptr<protocol::DOM::Node> pseudoElement);
    void topLayerElementsUpdated();
    void scrollableFlagUpdated(int nodeId, bool isScrollable);
    void affectedByStartingStylesFlagUpdated(int nodeId, bool affectedByStartingStyles);
    void pseudoElementRemoved(int parentId, int pseudoElementId);
    void setChildNodes(int parentId, std::unique_ptr<protocol::Array<protocol::DOM::Node>> nodes);
    void shadowRootPopped(int hostId, int rootId);
    void shadowRootPushed(int hostId, std::unique_ptr<protocol::DOM::Node> root);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace DOM
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_DOM_h)
