// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_DeviceOrientation_h
#define blink_protocol_DeviceOrientation_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace blink {
namespace protocol {
namespace DeviceOrientation {

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse clearDeviceOrientationOverride() = 0;
    virtual DispatchResponse setDeviceOrientationOverride(double in_alpha, double in_beta, double in_gamma) = 0;

    virtual DispatchResponse disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace DeviceOrientation
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_DeviceOrientation_h)
