// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Audits_h
#define blink_protocol_Audits_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/network.h"

namespace blink {
namespace protocol {
namespace Audits {
class AffectedCookie;
class AffectedRequest;
class AffectedFrame;
using CookieExclusionReason = String;
using CookieWarningReason = String;
using CookieOperation = String;
using InsightType = String;
class CookieIssueInsight;
class CookieIssueDetails;
using MixedContentResolutionStatus = String;
using MixedContentResourceType = String;
class MixedContentIssueDetails;
using BlockedByResponseReason = String;
class BlockedByResponseIssueDetails;
using HeavyAdResolutionStatus = String;
using HeavyAdReason = String;
class HeavyAdIssueDetails;
using ContentSecurityPolicyViolationType = String;
class SourceCodeLocation;
class ContentSecurityPolicyIssueDetails;
using SharedArrayBufferIssueType = String;
class SharedArrayBufferIssueDetails;
class LowTextContrastIssueDetails;
class CorsIssueDetails;
using AttributionReportingIssueType = String;
using SharedDictionaryError = String;
using SRIMessageSignatureError = String;
using UnencodedDigestError = String;
class AttributionReportingIssueDetails;
class QuirksModeIssueDetails;
class NavigatorUserAgentIssueDetails;
class SharedDictionaryIssueDetails;
class SRIMessageSignatureIssueDetails;
class UnencodedDigestIssueDetails;
using GenericIssueErrorType = String;
class GenericIssueDetails;
class DeprecationIssueDetails;
class BounceTrackingIssueDetails;
class CookieDeprecationMetadataIssueDetails;
using ClientHintIssueReason = String;
class FederatedAuthRequestIssueDetails;
using FederatedAuthRequestIssueReason = String;
class FederatedAuthUserInfoRequestIssueDetails;
using FederatedAuthUserInfoRequestIssueReason = String;
class ClientHintIssueDetails;
class FailedRequestInfo;
using PartitioningBlobURLInfo = String;
class PartitioningBlobURLIssueDetails;
using ElementAccessibilityIssueReason = String;
class ElementAccessibilityIssueDetails;
using StyleSheetLoadingIssueReason = String;
class StylesheetLoadingIssueDetails;
using PropertyRuleIssueReason = String;
class PropertyRuleIssueDetails;
using UserReidentificationIssueType = String;
class UserReidentificationIssueDetails;
using InspectorIssueCode = String;
class InspectorIssueDetails;
using IssueId = String;
class InspectorIssue;

// ------------- Forward and enum declarations.

namespace CookieExclusionReasonEnum {
CORE_EXPORT extern const char ExcludeSameSiteUnspecifiedTreatedAsLax[];
CORE_EXPORT extern const char ExcludeSameSiteNoneInsecure[];
CORE_EXPORT extern const char ExcludeSameSiteLax[];
CORE_EXPORT extern const char ExcludeSameSiteStrict[];
CORE_EXPORT extern const char ExcludeInvalidSameParty[];
CORE_EXPORT extern const char ExcludeSamePartyCrossPartyContext[];
CORE_EXPORT extern const char ExcludeDomainNonASCII[];
CORE_EXPORT extern const char ExcludeThirdPartyCookieBlockedInFirstPartySet[];
CORE_EXPORT extern const char ExcludeThirdPartyPhaseout[];
CORE_EXPORT extern const char ExcludePortMismatch[];
CORE_EXPORT extern const char ExcludeSchemeMismatch[];
} // namespace CookieExclusionReasonEnum

namespace CookieWarningReasonEnum {
CORE_EXPORT extern const char WarnSameSiteUnspecifiedCrossSiteContext[];
CORE_EXPORT extern const char WarnSameSiteNoneInsecure[];
CORE_EXPORT extern const char WarnSameSiteUnspecifiedLaxAllowUnsafe[];
CORE_EXPORT extern const char WarnSameSiteStrictLaxDowngradeStrict[];
CORE_EXPORT extern const char WarnSameSiteStrictCrossDowngradeStrict[];
CORE_EXPORT extern const char WarnSameSiteStrictCrossDowngradeLax[];
CORE_EXPORT extern const char WarnSameSiteLaxCrossDowngradeStrict[];
CORE_EXPORT extern const char WarnSameSiteLaxCrossDowngradeLax[];
CORE_EXPORT extern const char WarnAttributeValueExceedsMaxSize[];
CORE_EXPORT extern const char WarnDomainNonASCII[];
CORE_EXPORT extern const char WarnThirdPartyPhaseout[];
CORE_EXPORT extern const char WarnCrossSiteRedirectDowngradeChangesInclusion[];
CORE_EXPORT extern const char WarnDeprecationTrialMetadata[];
CORE_EXPORT extern const char WarnThirdPartyCookieHeuristic[];
} // namespace CookieWarningReasonEnum

namespace CookieOperationEnum {
CORE_EXPORT extern const char SetCookie[];
CORE_EXPORT extern const char ReadCookie[];
} // namespace CookieOperationEnum

namespace InsightTypeEnum {
CORE_EXPORT extern const char GitHubResource[];
CORE_EXPORT extern const char GracePeriod[];
CORE_EXPORT extern const char Heuristics[];
} // namespace InsightTypeEnum

namespace MixedContentResolutionStatusEnum {
CORE_EXPORT extern const char MixedContentBlocked[];
CORE_EXPORT extern const char MixedContentAutomaticallyUpgraded[];
CORE_EXPORT extern const char MixedContentWarning[];
} // namespace MixedContentResolutionStatusEnum

namespace MixedContentResourceTypeEnum {
CORE_EXPORT extern const char AttributionSrc[];
CORE_EXPORT extern const char Audio[];
CORE_EXPORT extern const char Beacon[];
CORE_EXPORT extern const char CSPReport[];
CORE_EXPORT extern const char Download[];
CORE_EXPORT extern const char EventSource[];
CORE_EXPORT extern const char Favicon[];
CORE_EXPORT extern const char Font[];
CORE_EXPORT extern const char Form[];
CORE_EXPORT extern const char Frame[];
CORE_EXPORT extern const char Image[];
CORE_EXPORT extern const char Import[];
CORE_EXPORT extern const char JSON[];
CORE_EXPORT extern const char Manifest[];
CORE_EXPORT extern const char Ping[];
CORE_EXPORT extern const char PluginData[];
CORE_EXPORT extern const char PluginResource[];
CORE_EXPORT extern const char Prefetch[];
CORE_EXPORT extern const char Resource[];
CORE_EXPORT extern const char Script[];
CORE_EXPORT extern const char ServiceWorker[];
CORE_EXPORT extern const char SharedWorker[];
CORE_EXPORT extern const char SpeculationRules[];
CORE_EXPORT extern const char Stylesheet[];
CORE_EXPORT extern const char Track[];
CORE_EXPORT extern const char Video[];
CORE_EXPORT extern const char Worker[];
CORE_EXPORT extern const char XMLHttpRequest[];
CORE_EXPORT extern const char XSLT[];
} // namespace MixedContentResourceTypeEnum

namespace BlockedByResponseReasonEnum {
CORE_EXPORT extern const char CoepFrameResourceNeedsCoepHeader[];
CORE_EXPORT extern const char CoopSandboxedIFrameCannotNavigateToCoopPage[];
CORE_EXPORT extern const char CorpNotSameOrigin[];
CORE_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByCoep[];
CORE_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByDip[];
CORE_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip[];
CORE_EXPORT extern const char CorpNotSameSite[];
CORE_EXPORT extern const char SRIMessageSignatureMismatch[];
} // namespace BlockedByResponseReasonEnum

namespace HeavyAdResolutionStatusEnum {
CORE_EXPORT extern const char HeavyAdBlocked[];
CORE_EXPORT extern const char HeavyAdWarning[];
} // namespace HeavyAdResolutionStatusEnum

namespace HeavyAdReasonEnum {
CORE_EXPORT extern const char NetworkTotalLimit[];
CORE_EXPORT extern const char CpuTotalLimit[];
CORE_EXPORT extern const char CpuPeakLimit[];
} // namespace HeavyAdReasonEnum

namespace ContentSecurityPolicyViolationTypeEnum {
CORE_EXPORT extern const char KInlineViolation[];
CORE_EXPORT extern const char KEvalViolation[];
CORE_EXPORT extern const char KURLViolation[];
CORE_EXPORT extern const char KSRIViolation[];
CORE_EXPORT extern const char KTrustedTypesSinkViolation[];
CORE_EXPORT extern const char KTrustedTypesPolicyViolation[];
CORE_EXPORT extern const char KWasmEvalViolation[];
} // namespace ContentSecurityPolicyViolationTypeEnum

namespace SharedArrayBufferIssueTypeEnum {
CORE_EXPORT extern const char TransferIssue[];
CORE_EXPORT extern const char CreationIssue[];
} // namespace SharedArrayBufferIssueTypeEnum

namespace AttributionReportingIssueTypeEnum {
CORE_EXPORT extern const char PermissionPolicyDisabled[];
CORE_EXPORT extern const char UntrustworthyReportingOrigin[];
CORE_EXPORT extern const char InsecureContext[];
CORE_EXPORT extern const char InvalidHeader[];
CORE_EXPORT extern const char InvalidRegisterTriggerHeader[];
CORE_EXPORT extern const char SourceAndTriggerHeaders[];
CORE_EXPORT extern const char SourceIgnored[];
CORE_EXPORT extern const char TriggerIgnored[];
CORE_EXPORT extern const char OsSourceIgnored[];
CORE_EXPORT extern const char OsTriggerIgnored[];
CORE_EXPORT extern const char InvalidRegisterOsSourceHeader[];
CORE_EXPORT extern const char InvalidRegisterOsTriggerHeader[];
CORE_EXPORT extern const char WebAndOsHeaders[];
CORE_EXPORT extern const char NoWebOrOsSupport[];
CORE_EXPORT extern const char NavigationRegistrationWithoutTransientUserActivation[];
CORE_EXPORT extern const char InvalidInfoHeader[];
CORE_EXPORT extern const char NoRegisterSourceHeader[];
CORE_EXPORT extern const char NoRegisterTriggerHeader[];
CORE_EXPORT extern const char NoRegisterOsSourceHeader[];
CORE_EXPORT extern const char NoRegisterOsTriggerHeader[];
CORE_EXPORT extern const char NavigationRegistrationUniqueScopeAlreadySet[];
} // namespace AttributionReportingIssueTypeEnum

namespace SharedDictionaryErrorEnum {
CORE_EXPORT extern const char UseErrorCrossOriginNoCorsRequest[];
CORE_EXPORT extern const char UseErrorDictionaryLoadFailure[];
CORE_EXPORT extern const char UseErrorMatchingDictionaryNotUsed[];
CORE_EXPORT extern const char UseErrorUnexpectedContentDictionaryHeader[];
CORE_EXPORT extern const char WriteErrorCossOriginNoCorsRequest[];
CORE_EXPORT extern const char WriteErrorDisallowedBySettings[];
CORE_EXPORT extern const char WriteErrorExpiredResponse[];
CORE_EXPORT extern const char WriteErrorFeatureDisabled[];
CORE_EXPORT extern const char WriteErrorInsufficientResources[];
CORE_EXPORT extern const char WriteErrorInvalidMatchField[];
CORE_EXPORT extern const char WriteErrorInvalidStructuredHeader[];
CORE_EXPORT extern const char WriteErrorInvalidTTLField[];
CORE_EXPORT extern const char WriteErrorNavigationRequest[];
CORE_EXPORT extern const char WriteErrorNoMatchField[];
CORE_EXPORT extern const char WriteErrorNonIntegerTTLField[];
CORE_EXPORT extern const char WriteErrorNonListMatchDestField[];
CORE_EXPORT extern const char WriteErrorNonSecureContext[];
CORE_EXPORT extern const char WriteErrorNonStringIdField[];
CORE_EXPORT extern const char WriteErrorNonStringInMatchDestList[];
CORE_EXPORT extern const char WriteErrorNonStringMatchField[];
CORE_EXPORT extern const char WriteErrorNonTokenTypeField[];
CORE_EXPORT extern const char WriteErrorRequestAborted[];
CORE_EXPORT extern const char WriteErrorShuttingDown[];
CORE_EXPORT extern const char WriteErrorTooLongIdField[];
CORE_EXPORT extern const char WriteErrorUnsupportedType[];
} // namespace SharedDictionaryErrorEnum

namespace SRIMessageSignatureErrorEnum {
CORE_EXPORT extern const char MissingSignatureHeader[];
CORE_EXPORT extern const char MissingSignatureInputHeader[];
CORE_EXPORT extern const char InvalidSignatureHeader[];
CORE_EXPORT extern const char InvalidSignatureInputHeader[];
CORE_EXPORT extern const char SignatureHeaderValueIsNotByteSequence[];
CORE_EXPORT extern const char SignatureHeaderValueIsParameterized[];
CORE_EXPORT extern const char SignatureHeaderValueIsIncorrectLength[];
CORE_EXPORT extern const char SignatureInputHeaderMissingLabel[];
CORE_EXPORT extern const char SignatureInputHeaderValueNotInnerList[];
CORE_EXPORT extern const char SignatureInputHeaderValueMissingComponents[];
CORE_EXPORT extern const char SignatureInputHeaderInvalidComponentType[];
CORE_EXPORT extern const char SignatureInputHeaderInvalidComponentName[];
CORE_EXPORT extern const char SignatureInputHeaderInvalidHeaderComponentParameter[];
CORE_EXPORT extern const char SignatureInputHeaderInvalidDerivedComponentParameter[];
CORE_EXPORT extern const char SignatureInputHeaderKeyIdLength[];
CORE_EXPORT extern const char SignatureInputHeaderInvalidParameter[];
CORE_EXPORT extern const char SignatureInputHeaderMissingRequiredParameters[];
CORE_EXPORT extern const char ValidationFailedSignatureExpired[];
CORE_EXPORT extern const char ValidationFailedInvalidLength[];
CORE_EXPORT extern const char ValidationFailedSignatureMismatch[];
CORE_EXPORT extern const char ValidationFailedIntegrityMismatch[];
} // namespace SRIMessageSignatureErrorEnum

namespace UnencodedDigestErrorEnum {
CORE_EXPORT extern const char MalformedDictionary[];
CORE_EXPORT extern const char UnknownAlgorithm[];
CORE_EXPORT extern const char IncorrectDigestType[];
CORE_EXPORT extern const char IncorrectDigestLength[];
} // namespace UnencodedDigestErrorEnum

namespace GenericIssueErrorTypeEnum {
CORE_EXPORT extern const char FormLabelForNameError[];
CORE_EXPORT extern const char FormDuplicateIdForInputError[];
CORE_EXPORT extern const char FormInputWithNoLabelError[];
CORE_EXPORT extern const char FormAutocompleteAttributeEmptyError[];
CORE_EXPORT extern const char FormEmptyIdAndNameAttributesForInputError[];
CORE_EXPORT extern const char FormAriaLabelledByToNonExistingId[];
CORE_EXPORT extern const char FormInputAssignedAutocompleteValueToIdOrNameAttributeError[];
CORE_EXPORT extern const char FormLabelHasNeitherForNorNestedInput[];
CORE_EXPORT extern const char FormLabelForMatchesNonExistingIdError[];
CORE_EXPORT extern const char FormInputHasWrongButWellIntendedAutocompleteValueError[];
CORE_EXPORT extern const char ResponseWasBlockedByORB[];
} // namespace GenericIssueErrorTypeEnum

namespace ClientHintIssueReasonEnum {
CORE_EXPORT extern const char MetaTagAllowListInvalidOrigin[];
CORE_EXPORT extern const char MetaTagModifiedHTML[];
} // namespace ClientHintIssueReasonEnum

namespace FederatedAuthRequestIssueReasonEnum {
CORE_EXPORT extern const char ShouldEmbargo[];
CORE_EXPORT extern const char TooManyRequests[];
CORE_EXPORT extern const char WellKnownHttpNotFound[];
CORE_EXPORT extern const char WellKnownNoResponse[];
CORE_EXPORT extern const char WellKnownInvalidResponse[];
CORE_EXPORT extern const char WellKnownListEmpty[];
CORE_EXPORT extern const char WellKnownInvalidContentType[];
CORE_EXPORT extern const char ConfigNotInWellKnown[];
CORE_EXPORT extern const char WellKnownTooBig[];
CORE_EXPORT extern const char ConfigHttpNotFound[];
CORE_EXPORT extern const char ConfigNoResponse[];
CORE_EXPORT extern const char ConfigInvalidResponse[];
CORE_EXPORT extern const char ConfigInvalidContentType[];
CORE_EXPORT extern const char ClientMetadataHttpNotFound[];
CORE_EXPORT extern const char ClientMetadataNoResponse[];
CORE_EXPORT extern const char ClientMetadataInvalidResponse[];
CORE_EXPORT extern const char ClientMetadataInvalidContentType[];
CORE_EXPORT extern const char IdpNotPotentiallyTrustworthy[];
CORE_EXPORT extern const char DisabledInSettings[];
CORE_EXPORT extern const char DisabledInFlags[];
CORE_EXPORT extern const char ErrorFetchingSignin[];
CORE_EXPORT extern const char InvalidSigninResponse[];
CORE_EXPORT extern const char AccountsHttpNotFound[];
CORE_EXPORT extern const char AccountsNoResponse[];
CORE_EXPORT extern const char AccountsInvalidResponse[];
CORE_EXPORT extern const char AccountsListEmpty[];
CORE_EXPORT extern const char AccountsInvalidContentType[];
CORE_EXPORT extern const char IdTokenHttpNotFound[];
CORE_EXPORT extern const char IdTokenNoResponse[];
CORE_EXPORT extern const char IdTokenInvalidResponse[];
CORE_EXPORT extern const char IdTokenIdpErrorResponse[];
CORE_EXPORT extern const char IdTokenCrossSiteIdpErrorResponse[];
CORE_EXPORT extern const char IdTokenInvalidRequest[];
CORE_EXPORT extern const char IdTokenInvalidContentType[];
CORE_EXPORT extern const char ErrorIdToken[];
CORE_EXPORT extern const char Canceled[];
CORE_EXPORT extern const char RpPageNotVisible[];
CORE_EXPORT extern const char SilentMediationFailure[];
CORE_EXPORT extern const char ThirdPartyCookiesBlocked[];
CORE_EXPORT extern const char NotSignedInWithIdp[];
CORE_EXPORT extern const char MissingTransientUserActivation[];
CORE_EXPORT extern const char ReplacedByActiveMode[];
CORE_EXPORT extern const char InvalidFieldsSpecified[];
CORE_EXPORT extern const char RelyingPartyOriginIsOpaque[];
CORE_EXPORT extern const char TypeNotMatching[];
CORE_EXPORT extern const char UiDismissedNoEmbargo[];
CORE_EXPORT extern const char CorsError[];
CORE_EXPORT extern const char SuppressedBySegmentationPlatform[];
} // namespace FederatedAuthRequestIssueReasonEnum

namespace FederatedAuthUserInfoRequestIssueReasonEnum {
CORE_EXPORT extern const char NotSameOrigin[];
CORE_EXPORT extern const char NotIframe[];
CORE_EXPORT extern const char NotPotentiallyTrustworthy[];
CORE_EXPORT extern const char NoApiPermission[];
CORE_EXPORT extern const char NotSignedInWithIdp[];
CORE_EXPORT extern const char NoAccountSharingPermission[];
CORE_EXPORT extern const char InvalidConfigOrWellKnown[];
CORE_EXPORT extern const char InvalidAccountsResponse[];
CORE_EXPORT extern const char NoReturningUserFromFetchedAccounts[];
} // namespace FederatedAuthUserInfoRequestIssueReasonEnum

namespace PartitioningBlobURLInfoEnum {
CORE_EXPORT extern const char BlockedCrossPartitionFetching[];
CORE_EXPORT extern const char EnforceNoopenerForNavigation[];
} // namespace PartitioningBlobURLInfoEnum

namespace ElementAccessibilityIssueReasonEnum {
CORE_EXPORT extern const char DisallowedSelectChild[];
CORE_EXPORT extern const char DisallowedOptGroupChild[];
CORE_EXPORT extern const char NonPhrasingContentOptionChild[];
CORE_EXPORT extern const char InteractiveContentOptionChild[];
CORE_EXPORT extern const char InteractiveContentLegendChild[];
CORE_EXPORT extern const char InteractiveContentSummaryDescendant[];
} // namespace ElementAccessibilityIssueReasonEnum

namespace StyleSheetLoadingIssueReasonEnum {
CORE_EXPORT extern const char LateImportRule[];
CORE_EXPORT extern const char RequestFailed[];
} // namespace StyleSheetLoadingIssueReasonEnum

namespace PropertyRuleIssueReasonEnum {
CORE_EXPORT extern const char InvalidSyntax[];
CORE_EXPORT extern const char InvalidInitialValue[];
CORE_EXPORT extern const char InvalidInherits[];
CORE_EXPORT extern const char InvalidName[];
} // namespace PropertyRuleIssueReasonEnum

namespace UserReidentificationIssueTypeEnum {
CORE_EXPORT extern const char BlockedFrameNavigation[];
CORE_EXPORT extern const char BlockedSubresource[];
CORE_EXPORT extern const char NoisedCanvasReadback[];
} // namespace UserReidentificationIssueTypeEnum

namespace InspectorIssueCodeEnum {
CORE_EXPORT extern const char CookieIssue[];
CORE_EXPORT extern const char MixedContentIssue[];
CORE_EXPORT extern const char BlockedByResponseIssue[];
CORE_EXPORT extern const char HeavyAdIssue[];
CORE_EXPORT extern const char ContentSecurityPolicyIssue[];
CORE_EXPORT extern const char SharedArrayBufferIssue[];
CORE_EXPORT extern const char LowTextContrastIssue[];
CORE_EXPORT extern const char CorsIssue[];
CORE_EXPORT extern const char AttributionReportingIssue[];
CORE_EXPORT extern const char QuirksModeIssue[];
CORE_EXPORT extern const char PartitioningBlobURLIssue[];
CORE_EXPORT extern const char NavigatorUserAgentIssue[];
CORE_EXPORT extern const char GenericIssue[];
CORE_EXPORT extern const char DeprecationIssue[];
CORE_EXPORT extern const char ClientHintIssue[];
CORE_EXPORT extern const char FederatedAuthRequestIssue[];
CORE_EXPORT extern const char BounceTrackingIssue[];
CORE_EXPORT extern const char CookieDeprecationMetadataIssue[];
CORE_EXPORT extern const char StylesheetLoadingIssue[];
CORE_EXPORT extern const char FederatedAuthUserInfoRequestIssue[];
CORE_EXPORT extern const char PropertyRuleIssue[];
CORE_EXPORT extern const char SharedDictionaryIssue[];
CORE_EXPORT extern const char ElementAccessibilityIssue[];
CORE_EXPORT extern const char SRIMessageSignatureIssue[];
CORE_EXPORT extern const char UnencodedDigestIssue[];
CORE_EXPORT extern const char UserReidentificationIssue[];
} // namespace InspectorIssueCodeEnum

namespace GetEncodedResponse {
namespace EncodingEnum {
CORE_EXPORT extern const char* Webp;
CORE_EXPORT extern const char* Jpeg;
CORE_EXPORT extern const char* Png;
} // EncodingEnum
} // GetEncodedResponse

// ------------- Type and builder declarations.

class CORE_EXPORT AffectedCookie : public ::crdtp::ProtocolObject<AffectedCookie> {
public:
    ~AffectedCookie() override { }

    String getName() { return m_name; }
    void setName(const String& value) { m_name = value; }

    String getPath() { return m_path; }
    void setPath(const String& value) { m_path = value; }

    String getDomain() { return m_domain; }
    void setDomain(const String& value) { m_domain = value; }

    template<int STATE>
    class AffectedCookieBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            PathSet = 1 << 2,
            DomainSet = 1 << 3,
            AllFieldsSet = (NameSet | PathSet | DomainSet | 0)};


        AffectedCookieBuilder<STATE | NameSet>& setName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(value);
            return castState<NameSet>();
        }

        AffectedCookieBuilder<STATE | PathSet>& setPath(const String& value)
        {
            static_assert(!(STATE & PathSet), "property path should not be set yet");
            m_result->setPath(value);
            return castState<PathSet>();
        }

        AffectedCookieBuilder<STATE | DomainSet>& setDomain(const String& value)
        {
            static_assert(!(STATE & DomainSet), "property domain should not be set yet");
            m_result->setDomain(value);
            return castState<DomainSet>();
        }

        std::unique_ptr<AffectedCookie> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedCookie;
        AffectedCookieBuilder() : m_result(new AffectedCookie()) { }

        template<int STEP> AffectedCookieBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedCookieBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedCookie> m_result;
    };

    static AffectedCookieBuilder<0> create()
    {
        return AffectedCookieBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedCookie()
    {
    }

    String m_name;
    String m_path;
    String m_domain;
};


class CORE_EXPORT AffectedRequest : public ::crdtp::ProtocolObject<AffectedRequest> {
public:
    ~AffectedRequest() override { }

    bool hasRequestId() { return !!m_requestId; }
    String getRequestId(const String& defaultValue) const {
       return m_requestId.value_or(defaultValue);
    }
    const std::optional<String>& getRequestId() const {
       return m_requestId;
    }
    void setRequestId(const String& value) { m_requestId = value; }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    template<int STATE>
    class AffectedRequestBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            AllFieldsSet = (UrlSet | 0)};


        AffectedRequestBuilder<STATE>& setRequestId(const String& value)
        {
            m_result->setRequestId(value);
            return *this;
        }

        AffectedRequestBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        std::unique_ptr<AffectedRequest> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedRequest;
        AffectedRequestBuilder() : m_result(new AffectedRequest()) { }

        template<int STEP> AffectedRequestBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedRequestBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedRequest> m_result;
    };

    static AffectedRequestBuilder<0> create()
    {
        return AffectedRequestBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedRequest()
    {
    }

    std::optional<String> m_requestId;
    String m_url;
};


class CORE_EXPORT AffectedFrame : public ::crdtp::ProtocolObject<AffectedFrame> {
public:
    ~AffectedFrame() override { }

    String getFrameId() { return m_frameId; }
    void setFrameId(const String& value) { m_frameId = value; }

    template<int STATE>
    class AffectedFrameBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FrameIdSet = 1 << 1,
            AllFieldsSet = (FrameIdSet | 0)};


        AffectedFrameBuilder<STATE | FrameIdSet>& setFrameId(const String& value)
        {
            static_assert(!(STATE & FrameIdSet), "property frameId should not be set yet");
            m_result->setFrameId(value);
            return castState<FrameIdSet>();
        }

        std::unique_ptr<AffectedFrame> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedFrame;
        AffectedFrameBuilder() : m_result(new AffectedFrame()) { }

        template<int STEP> AffectedFrameBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedFrameBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedFrame> m_result;
    };

    static AffectedFrameBuilder<0> create()
    {
        return AffectedFrameBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedFrame()
    {
    }

    String m_frameId;
};


class CORE_EXPORT CookieIssueInsight : public ::crdtp::ProtocolObject<CookieIssueInsight> {
public:
    ~CookieIssueInsight() override { }

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    bool hasTableEntryUrl() { return !!m_tableEntryUrl; }
    String getTableEntryUrl(const String& defaultValue) const {
       return m_tableEntryUrl.value_or(defaultValue);
    }
    const std::optional<String>& getTableEntryUrl() const {
       return m_tableEntryUrl;
    }
    void setTableEntryUrl(const String& value) { m_tableEntryUrl = value; }

    template<int STATE>
    class CookieIssueInsightBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        CookieIssueInsightBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        CookieIssueInsightBuilder<STATE>& setTableEntryUrl(const String& value)
        {
            m_result->setTableEntryUrl(value);
            return *this;
        }

        std::unique_ptr<CookieIssueInsight> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookieIssueInsight;
        CookieIssueInsightBuilder() : m_result(new CookieIssueInsight()) { }

        template<int STEP> CookieIssueInsightBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieIssueInsightBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CookieIssueInsight> m_result;
    };

    static CookieIssueInsightBuilder<0> create()
    {
        return CookieIssueInsightBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookieIssueInsight()
    {
    }

    String m_type;
    std::optional<String> m_tableEntryUrl;
};


class CORE_EXPORT CookieIssueDetails : public ::crdtp::ProtocolObject<CookieIssueDetails> {
public:
    ~CookieIssueDetails() override { }

    bool hasCookie() { return !!m_cookie; }
    protocol::Audits::AffectedCookie* getCookie(protocol::Audits::AffectedCookie* defaultValue) {
       return m_cookie ? m_cookie.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedCookie>& getCookie() const {
       return m_cookie;
    }
    void setCookie(std::unique_ptr<protocol::Audits::AffectedCookie> value) { m_cookie = std::move(value); }

    bool hasRawCookieLine() { return !!m_rawCookieLine; }
    String getRawCookieLine(const String& defaultValue) const {
       return m_rawCookieLine.value_or(defaultValue);
    }
    const std::optional<String>& getRawCookieLine() const {
       return m_rawCookieLine;
    }
    void setRawCookieLine(const String& value) { m_rawCookieLine = value; }

    protocol::Array<String>* getCookieWarningReasons() { return m_cookieWarningReasons.get(); }
    void setCookieWarningReasons(std::unique_ptr<protocol::Array<String>> value) { m_cookieWarningReasons = std::move(value); }

    protocol::Array<String>* getCookieExclusionReasons() { return m_cookieExclusionReasons.get(); }
    void setCookieExclusionReasons(std::unique_ptr<protocol::Array<String>> value) { m_cookieExclusionReasons = std::move(value); }

    String getOperation() { return m_operation; }
    void setOperation(const String& value) { m_operation = value; }

    bool hasSiteForCookies() { return !!m_siteForCookies; }
    String getSiteForCookies(const String& defaultValue) const {
       return m_siteForCookies.value_or(defaultValue);
    }
    const std::optional<String>& getSiteForCookies() const {
       return m_siteForCookies;
    }
    void setSiteForCookies(const String& value) { m_siteForCookies = value; }

    bool hasCookieUrl() { return !!m_cookieUrl; }
    String getCookieUrl(const String& defaultValue) const {
       return m_cookieUrl.value_or(defaultValue);
    }
    const std::optional<String>& getCookieUrl() const {
       return m_cookieUrl;
    }
    void setCookieUrl(const String& value) { m_cookieUrl = value; }

    bool hasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* getRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& getRequest() const {
       return m_request;
    }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    bool hasInsight() { return !!m_insight; }
    protocol::Audits::CookieIssueInsight* getInsight(protocol::Audits::CookieIssueInsight* defaultValue) {
       return m_insight ? m_insight.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CookieIssueInsight>& getInsight() const {
       return m_insight;
    }
    void setInsight(std::unique_ptr<protocol::Audits::CookieIssueInsight> value) { m_insight = std::move(value); }

    template<int STATE>
    class CookieIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CookieWarningReasonsSet = 1 << 1,
            CookieExclusionReasonsSet = 1 << 2,
            OperationSet = 1 << 3,
            AllFieldsSet = (CookieWarningReasonsSet | CookieExclusionReasonsSet | OperationSet | 0)};


        CookieIssueDetailsBuilder<STATE>& setCookie(std::unique_ptr<protocol::Audits::AffectedCookie> value)
        {
            m_result->setCookie(std::move(value));
            return *this;
        }

        CookieIssueDetailsBuilder<STATE>& setRawCookieLine(const String& value)
        {
            m_result->setRawCookieLine(value);
            return *this;
        }

        CookieIssueDetailsBuilder<STATE | CookieWarningReasonsSet>& setCookieWarningReasons(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & CookieWarningReasonsSet), "property cookieWarningReasons should not be set yet");
            m_result->setCookieWarningReasons(std::move(value));
            return castState<CookieWarningReasonsSet>();
        }

        CookieIssueDetailsBuilder<STATE | CookieExclusionReasonsSet>& setCookieExclusionReasons(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & CookieExclusionReasonsSet), "property cookieExclusionReasons should not be set yet");
            m_result->setCookieExclusionReasons(std::move(value));
            return castState<CookieExclusionReasonsSet>();
        }

        CookieIssueDetailsBuilder<STATE | OperationSet>& setOperation(const String& value)
        {
            static_assert(!(STATE & OperationSet), "property operation should not be set yet");
            m_result->setOperation(value);
            return castState<OperationSet>();
        }

        CookieIssueDetailsBuilder<STATE>& setSiteForCookies(const String& value)
        {
            m_result->setSiteForCookies(value);
            return *this;
        }

        CookieIssueDetailsBuilder<STATE>& setCookieUrl(const String& value)
        {
            m_result->setCookieUrl(value);
            return *this;
        }

        CookieIssueDetailsBuilder<STATE>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            m_result->setRequest(std::move(value));
            return *this;
        }

        CookieIssueDetailsBuilder<STATE>& setInsight(std::unique_ptr<protocol::Audits::CookieIssueInsight> value)
        {
            m_result->setInsight(std::move(value));
            return *this;
        }

        std::unique_ptr<CookieIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookieIssueDetails;
        CookieIssueDetailsBuilder() : m_result(new CookieIssueDetails()) { }

        template<int STEP> CookieIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CookieIssueDetails> m_result;
    };

    static CookieIssueDetailsBuilder<0> create()
    {
        return CookieIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookieIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::AffectedCookie> m_cookie;
    std::optional<String> m_rawCookieLine;
    std::unique_ptr<protocol::Array<String>> m_cookieWarningReasons;
    std::unique_ptr<protocol::Array<String>> m_cookieExclusionReasons;
    String m_operation;
    std::optional<String> m_siteForCookies;
    std::optional<String> m_cookieUrl;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::CookieIssueInsight> m_insight;
};


class CORE_EXPORT MixedContentIssueDetails : public ::crdtp::ProtocolObject<MixedContentIssueDetails> {
public:
    ~MixedContentIssueDetails() override { }

    bool hasResourceType() { return !!m_resourceType; }
    String getResourceType(const String& defaultValue) const {
       return m_resourceType.value_or(defaultValue);
    }
    const std::optional<String>& getResourceType() const {
       return m_resourceType;
    }
    void setResourceType(const String& value) { m_resourceType = value; }

    String getResolutionStatus() { return m_resolutionStatus; }
    void setResolutionStatus(const String& value) { m_resolutionStatus = value; }

    String getInsecureURL() { return m_insecureURL; }
    void setInsecureURL(const String& value) { m_insecureURL = value; }

    String getMainResourceURL() { return m_mainResourceURL; }
    void setMainResourceURL(const String& value) { m_mainResourceURL = value; }

    bool hasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* getRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& getRequest() const {
       return m_request;
    }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    bool hasFrame() { return !!m_frame; }
    protocol::Audits::AffectedFrame* getFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_frame ? m_frame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& getFrame() const {
       return m_frame;
    }
    void setFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frame = std::move(value); }

    template<int STATE>
    class MixedContentIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ResolutionStatusSet = 1 << 1,
            InsecureURLSet = 1 << 2,
            MainResourceURLSet = 1 << 3,
            AllFieldsSet = (ResolutionStatusSet | InsecureURLSet | MainResourceURLSet | 0)};


        MixedContentIssueDetailsBuilder<STATE>& setResourceType(const String& value)
        {
            m_result->setResourceType(value);
            return *this;
        }

        MixedContentIssueDetailsBuilder<STATE | ResolutionStatusSet>& setResolutionStatus(const String& value)
        {
            static_assert(!(STATE & ResolutionStatusSet), "property resolutionStatus should not be set yet");
            m_result->setResolutionStatus(value);
            return castState<ResolutionStatusSet>();
        }

        MixedContentIssueDetailsBuilder<STATE | InsecureURLSet>& setInsecureURL(const String& value)
        {
            static_assert(!(STATE & InsecureURLSet), "property insecureURL should not be set yet");
            m_result->setInsecureURL(value);
            return castState<InsecureURLSet>();
        }

        MixedContentIssueDetailsBuilder<STATE | MainResourceURLSet>& setMainResourceURL(const String& value)
        {
            static_assert(!(STATE & MainResourceURLSet), "property mainResourceURL should not be set yet");
            m_result->setMainResourceURL(value);
            return castState<MainResourceURLSet>();
        }

        MixedContentIssueDetailsBuilder<STATE>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            m_result->setRequest(std::move(value));
            return *this;
        }

        MixedContentIssueDetailsBuilder<STATE>& setFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            m_result->setFrame(std::move(value));
            return *this;
        }

        std::unique_ptr<MixedContentIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class MixedContentIssueDetails;
        MixedContentIssueDetailsBuilder() : m_result(new MixedContentIssueDetails()) { }

        template<int STEP> MixedContentIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<MixedContentIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::MixedContentIssueDetails> m_result;
    };

    static MixedContentIssueDetailsBuilder<0> create()
    {
        return MixedContentIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    MixedContentIssueDetails()
    {
    }

    std::optional<String> m_resourceType;
    String m_resolutionStatus;
    String m_insecureURL;
    String m_mainResourceURL;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_frame;
};


class CORE_EXPORT BlockedByResponseIssueDetails : public ::crdtp::ProtocolObject<BlockedByResponseIssueDetails> {
public:
    ~BlockedByResponseIssueDetails() override { }

    protocol::Audits::AffectedRequest* getRequest() { return m_request.get(); }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    bool hasParentFrame() { return !!m_parentFrame; }
    protocol::Audits::AffectedFrame* getParentFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_parentFrame ? m_parentFrame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& getParentFrame() const {
       return m_parentFrame;
    }
    void setParentFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_parentFrame = std::move(value); }

    bool hasBlockedFrame() { return !!m_blockedFrame; }
    protocol::Audits::AffectedFrame* getBlockedFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_blockedFrame ? m_blockedFrame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& getBlockedFrame() const {
       return m_blockedFrame;
    }
    void setBlockedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_blockedFrame = std::move(value); }

    String getReason() { return m_reason; }
    void setReason(const String& value) { m_reason = value; }

    template<int STATE>
    class BlockedByResponseIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestSet = 1 << 1,
            ReasonSet = 1 << 2,
            AllFieldsSet = (RequestSet | ReasonSet | 0)};


        BlockedByResponseIssueDetailsBuilder<STATE | RequestSet>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            static_assert(!(STATE & RequestSet), "property request should not be set yet");
            m_result->setRequest(std::move(value));
            return castState<RequestSet>();
        }

        BlockedByResponseIssueDetailsBuilder<STATE>& setParentFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            m_result->setParentFrame(std::move(value));
            return *this;
        }

        BlockedByResponseIssueDetailsBuilder<STATE>& setBlockedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            m_result->setBlockedFrame(std::move(value));
            return *this;
        }

        BlockedByResponseIssueDetailsBuilder<STATE | ReasonSet>& setReason(const String& value)
        {
            static_assert(!(STATE & ReasonSet), "property reason should not be set yet");
            m_result->setReason(value);
            return castState<ReasonSet>();
        }

        std::unique_ptr<BlockedByResponseIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BlockedByResponseIssueDetails;
        BlockedByResponseIssueDetailsBuilder() : m_result(new BlockedByResponseIssueDetails()) { }

        template<int STEP> BlockedByResponseIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BlockedByResponseIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> m_result;
    };

    static BlockedByResponseIssueDetailsBuilder<0> create()
    {
        return BlockedByResponseIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BlockedByResponseIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_parentFrame;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_blockedFrame;
    String m_reason;
};


class CORE_EXPORT HeavyAdIssueDetails : public ::crdtp::ProtocolObject<HeavyAdIssueDetails> {
public:
    ~HeavyAdIssueDetails() override { }

    String getResolution() { return m_resolution; }
    void setResolution(const String& value) { m_resolution = value; }

    String getReason() { return m_reason; }
    void setReason(const String& value) { m_reason = value; }

    protocol::Audits::AffectedFrame* getFrame() { return m_frame.get(); }
    void setFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frame = std::move(value); }

    template<int STATE>
    class HeavyAdIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ResolutionSet = 1 << 1,
            ReasonSet = 1 << 2,
            FrameSet = 1 << 3,
            AllFieldsSet = (ResolutionSet | ReasonSet | FrameSet | 0)};


        HeavyAdIssueDetailsBuilder<STATE | ResolutionSet>& setResolution(const String& value)
        {
            static_assert(!(STATE & ResolutionSet), "property resolution should not be set yet");
            m_result->setResolution(value);
            return castState<ResolutionSet>();
        }

        HeavyAdIssueDetailsBuilder<STATE | ReasonSet>& setReason(const String& value)
        {
            static_assert(!(STATE & ReasonSet), "property reason should not be set yet");
            m_result->setReason(value);
            return castState<ReasonSet>();
        }

        HeavyAdIssueDetailsBuilder<STATE | FrameSet>& setFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            static_assert(!(STATE & FrameSet), "property frame should not be set yet");
            m_result->setFrame(std::move(value));
            return castState<FrameSet>();
        }

        std::unique_ptr<HeavyAdIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class HeavyAdIssueDetails;
        HeavyAdIssueDetailsBuilder() : m_result(new HeavyAdIssueDetails()) { }

        template<int STEP> HeavyAdIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<HeavyAdIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> m_result;
    };

    static HeavyAdIssueDetailsBuilder<0> create()
    {
        return HeavyAdIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    HeavyAdIssueDetails()
    {
    }

    String m_resolution;
    String m_reason;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_frame;
};


class CORE_EXPORT SourceCodeLocation : public ::crdtp::ProtocolObject<SourceCodeLocation> {
public:
    ~SourceCodeLocation() override { }

    bool hasScriptId() { return !!m_scriptId; }
    String getScriptId(const String& defaultValue) const {
       return m_scriptId.value_or(defaultValue);
    }
    const std::optional<String>& getScriptId() const {
       return m_scriptId;
    }
    void setScriptId(const String& value) { m_scriptId = value; }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    int getLineNumber() { return m_lineNumber; }
    void setLineNumber(int value) { m_lineNumber = value; }

    int getColumnNumber() { return m_columnNumber; }
    void setColumnNumber(int value) { m_columnNumber = value; }

    template<int STATE>
    class SourceCodeLocationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            LineNumberSet = 1 << 2,
            ColumnNumberSet = 1 << 3,
            AllFieldsSet = (UrlSet | LineNumberSet | ColumnNumberSet | 0)};


        SourceCodeLocationBuilder<STATE>& setScriptId(const String& value)
        {
            m_result->setScriptId(value);
            return *this;
        }

        SourceCodeLocationBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        SourceCodeLocationBuilder<STATE | LineNumberSet>& setLineNumber(int value)
        {
            static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
            m_result->setLineNumber(value);
            return castState<LineNumberSet>();
        }

        SourceCodeLocationBuilder<STATE | ColumnNumberSet>& setColumnNumber(int value)
        {
            static_assert(!(STATE & ColumnNumberSet), "property columnNumber should not be set yet");
            m_result->setColumnNumber(value);
            return castState<ColumnNumberSet>();
        }

        std::unique_ptr<SourceCodeLocation> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SourceCodeLocation;
        SourceCodeLocationBuilder() : m_result(new SourceCodeLocation()) { }

        template<int STEP> SourceCodeLocationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SourceCodeLocationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SourceCodeLocation> m_result;
    };

    static SourceCodeLocationBuilder<0> create()
    {
        return SourceCodeLocationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SourceCodeLocation()
    {
          m_lineNumber = 0;
          m_columnNumber = 0;
    }

    std::optional<String> m_scriptId;
    String m_url;
    int m_lineNumber;
    int m_columnNumber;
};


class CORE_EXPORT ContentSecurityPolicyIssueDetails : public ::crdtp::ProtocolObject<ContentSecurityPolicyIssueDetails> {
public:
    ~ContentSecurityPolicyIssueDetails() override { }

    bool hasBlockedURL() { return !!m_blockedURL; }
    String getBlockedURL(const String& defaultValue) const {
       return m_blockedURL.value_or(defaultValue);
    }
    const std::optional<String>& getBlockedURL() const {
       return m_blockedURL;
    }
    void setBlockedURL(const String& value) { m_blockedURL = value; }

    String getViolatedDirective() { return m_violatedDirective; }
    void setViolatedDirective(const String& value) { m_violatedDirective = value; }

    bool getIsReportOnly() { return m_isReportOnly; }
    void setIsReportOnly(bool value) { m_isReportOnly = value; }

    String getContentSecurityPolicyViolationType() { return m_contentSecurityPolicyViolationType; }
    void setContentSecurityPolicyViolationType(const String& value) { m_contentSecurityPolicyViolationType = value; }

    bool hasFrameAncestor() { return !!m_frameAncestor; }
    protocol::Audits::AffectedFrame* getFrameAncestor(protocol::Audits::AffectedFrame* defaultValue) {
       return m_frameAncestor ? m_frameAncestor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& getFrameAncestor() const {
       return m_frameAncestor;
    }
    void setFrameAncestor(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frameAncestor = std::move(value); }

    bool hasSourceCodeLocation() { return !!m_sourceCodeLocation; }
    protocol::Audits::SourceCodeLocation* getSourceCodeLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_sourceCodeLocation ? m_sourceCodeLocation.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& getSourceCodeLocation() const {
       return m_sourceCodeLocation;
    }
    void setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

    bool hasViolatingNodeId() { return !!m_violatingNodeId; }
    int getViolatingNodeId(int defaultValue) const {
       return m_violatingNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getViolatingNodeId() const {
       return m_violatingNodeId;
    }
    void setViolatingNodeId(int value) { m_violatingNodeId = value; }

    template<int STATE>
    class ContentSecurityPolicyIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ViolatedDirectiveSet = 1 << 1,
            IsReportOnlySet = 1 << 2,
            ContentSecurityPolicyViolationTypeSet = 1 << 3,
            AllFieldsSet = (ViolatedDirectiveSet | IsReportOnlySet | ContentSecurityPolicyViolationTypeSet | 0)};


        ContentSecurityPolicyIssueDetailsBuilder<STATE>& setBlockedURL(const String& value)
        {
            m_result->setBlockedURL(value);
            return *this;
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE | ViolatedDirectiveSet>& setViolatedDirective(const String& value)
        {
            static_assert(!(STATE & ViolatedDirectiveSet), "property violatedDirective should not be set yet");
            m_result->setViolatedDirective(value);
            return castState<ViolatedDirectiveSet>();
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE | IsReportOnlySet>& setIsReportOnly(bool value)
        {
            static_assert(!(STATE & IsReportOnlySet), "property isReportOnly should not be set yet");
            m_result->setIsReportOnly(value);
            return castState<IsReportOnlySet>();
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE | ContentSecurityPolicyViolationTypeSet>& setContentSecurityPolicyViolationType(const String& value)
        {
            static_assert(!(STATE & ContentSecurityPolicyViolationTypeSet), "property contentSecurityPolicyViolationType should not be set yet");
            m_result->setContentSecurityPolicyViolationType(value);
            return castState<ContentSecurityPolicyViolationTypeSet>();
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& setFrameAncestor(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            m_result->setFrameAncestor(std::move(value));
            return *this;
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            m_result->setSourceCodeLocation(std::move(value));
            return *this;
        }

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& setViolatingNodeId(int value)
        {
            m_result->setViolatingNodeId(value);
            return *this;
        }

        std::unique_ptr<ContentSecurityPolicyIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ContentSecurityPolicyIssueDetails;
        ContentSecurityPolicyIssueDetailsBuilder() : m_result(new ContentSecurityPolicyIssueDetails()) { }

        template<int STEP> ContentSecurityPolicyIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ContentSecurityPolicyIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> m_result;
    };

    static ContentSecurityPolicyIssueDetailsBuilder<0> create()
    {
        return ContentSecurityPolicyIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ContentSecurityPolicyIssueDetails()
    {
          m_isReportOnly = false;
    }

    std::optional<String> m_blockedURL;
    String m_violatedDirective;
    bool m_isReportOnly;
    String m_contentSecurityPolicyViolationType;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_frameAncestor;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    std::optional<int> m_violatingNodeId;
};


class CORE_EXPORT SharedArrayBufferIssueDetails : public ::crdtp::ProtocolObject<SharedArrayBufferIssueDetails> {
public:
    ~SharedArrayBufferIssueDetails() override { }

    protocol::Audits::SourceCodeLocation* getSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

    bool getIsWarning() { return m_isWarning; }
    void setIsWarning(bool value) { m_isWarning = value; }

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    template<int STATE>
    class SharedArrayBufferIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            IsWarningSet = 1 << 2,
            TypeSet = 1 << 3,
            AllFieldsSet = (SourceCodeLocationSet | IsWarningSet | TypeSet | 0)};


        SharedArrayBufferIssueDetailsBuilder<STATE | SourceCodeLocationSet>& setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
            m_result->setSourceCodeLocation(std::move(value));
            return castState<SourceCodeLocationSet>();
        }

        SharedArrayBufferIssueDetailsBuilder<STATE | IsWarningSet>& setIsWarning(bool value)
        {
            static_assert(!(STATE & IsWarningSet), "property isWarning should not be set yet");
            m_result->setIsWarning(value);
            return castState<IsWarningSet>();
        }

        SharedArrayBufferIssueDetailsBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        std::unique_ptr<SharedArrayBufferIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedArrayBufferIssueDetails;
        SharedArrayBufferIssueDetailsBuilder() : m_result(new SharedArrayBufferIssueDetails()) { }

        template<int STEP> SharedArrayBufferIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedArrayBufferIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> m_result;
    };

    static SharedArrayBufferIssueDetailsBuilder<0> create()
    {
        return SharedArrayBufferIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedArrayBufferIssueDetails()
    {
          m_isWarning = false;
    }

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    bool m_isWarning;
    String m_type;
};


class CORE_EXPORT LowTextContrastIssueDetails : public ::crdtp::ProtocolObject<LowTextContrastIssueDetails> {
public:
    ~LowTextContrastIssueDetails() override { }

    int getViolatingNodeId() { return m_violatingNodeId; }
    void setViolatingNodeId(int value) { m_violatingNodeId = value; }

    String getViolatingNodeSelector() { return m_violatingNodeSelector; }
    void setViolatingNodeSelector(const String& value) { m_violatingNodeSelector = value; }

    double getContrastRatio() { return m_contrastRatio; }
    void setContrastRatio(double value) { m_contrastRatio = value; }

    double getThresholdAA() { return m_thresholdAA; }
    void setThresholdAA(double value) { m_thresholdAA = value; }

    double getThresholdAAA() { return m_thresholdAAA; }
    void setThresholdAAA(double value) { m_thresholdAAA = value; }

    String getFontSize() { return m_fontSize; }
    void setFontSize(const String& value) { m_fontSize = value; }

    String getFontWeight() { return m_fontWeight; }
    void setFontWeight(const String& value) { m_fontWeight = value; }

    template<int STATE>
    class LowTextContrastIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ViolatingNodeIdSet = 1 << 1,
            ViolatingNodeSelectorSet = 1 << 2,
            ContrastRatioSet = 1 << 3,
            ThresholdAASet = 1 << 4,
            ThresholdAAASet = 1 << 5,
            FontSizeSet = 1 << 6,
            FontWeightSet = 1 << 7,
            AllFieldsSet = (ViolatingNodeIdSet | ViolatingNodeSelectorSet | ContrastRatioSet | ThresholdAASet | ThresholdAAASet | FontSizeSet | FontWeightSet | 0)};


        LowTextContrastIssueDetailsBuilder<STATE | ViolatingNodeIdSet>& setViolatingNodeId(int value)
        {
            static_assert(!(STATE & ViolatingNodeIdSet), "property violatingNodeId should not be set yet");
            m_result->setViolatingNodeId(value);
            return castState<ViolatingNodeIdSet>();
        }

        LowTextContrastIssueDetailsBuilder<STATE | ViolatingNodeSelectorSet>& setViolatingNodeSelector(const String& value)
        {
            static_assert(!(STATE & ViolatingNodeSelectorSet), "property violatingNodeSelector should not be set yet");
            m_result->setViolatingNodeSelector(value);
            return castState<ViolatingNodeSelectorSet>();
        }

        LowTextContrastIssueDetailsBuilder<STATE | ContrastRatioSet>& setContrastRatio(double value)
        {
            static_assert(!(STATE & ContrastRatioSet), "property contrastRatio should not be set yet");
            m_result->setContrastRatio(value);
            return castState<ContrastRatioSet>();
        }

        LowTextContrastIssueDetailsBuilder<STATE | ThresholdAASet>& setThresholdAA(double value)
        {
            static_assert(!(STATE & ThresholdAASet), "property thresholdAA should not be set yet");
            m_result->setThresholdAA(value);
            return castState<ThresholdAASet>();
        }

        LowTextContrastIssueDetailsBuilder<STATE | ThresholdAAASet>& setThresholdAAA(double value)
        {
            static_assert(!(STATE & ThresholdAAASet), "property thresholdAAA should not be set yet");
            m_result->setThresholdAAA(value);
            return castState<ThresholdAAASet>();
        }

        LowTextContrastIssueDetailsBuilder<STATE | FontSizeSet>& setFontSize(const String& value)
        {
            static_assert(!(STATE & FontSizeSet), "property fontSize should not be set yet");
            m_result->setFontSize(value);
            return castState<FontSizeSet>();
        }

        LowTextContrastIssueDetailsBuilder<STATE | FontWeightSet>& setFontWeight(const String& value)
        {
            static_assert(!(STATE & FontWeightSet), "property fontWeight should not be set yet");
            m_result->setFontWeight(value);
            return castState<FontWeightSet>();
        }

        std::unique_ptr<LowTextContrastIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LowTextContrastIssueDetails;
        LowTextContrastIssueDetailsBuilder() : m_result(new LowTextContrastIssueDetails()) { }

        template<int STEP> LowTextContrastIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LowTextContrastIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> m_result;
    };

    static LowTextContrastIssueDetailsBuilder<0> create()
    {
        return LowTextContrastIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LowTextContrastIssueDetails()
    {
          m_violatingNodeId = 0;
          m_contrastRatio = 0;
          m_thresholdAA = 0;
          m_thresholdAAA = 0;
    }

    int m_violatingNodeId;
    String m_violatingNodeSelector;
    double m_contrastRatio;
    double m_thresholdAA;
    double m_thresholdAAA;
    String m_fontSize;
    String m_fontWeight;
};


class CORE_EXPORT CorsIssueDetails : public ::crdtp::ProtocolObject<CorsIssueDetails> {
public:
    ~CorsIssueDetails() override { }

    protocol::Network::CorsErrorStatus* getCorsErrorStatus() { return m_corsErrorStatus.get(); }
    void setCorsErrorStatus(std::unique_ptr<protocol::Network::CorsErrorStatus> value) { m_corsErrorStatus = std::move(value); }

    bool getIsWarning() { return m_isWarning; }
    void setIsWarning(bool value) { m_isWarning = value; }

    protocol::Audits::AffectedRequest* getRequest() { return m_request.get(); }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    bool hasLocation() { return !!m_location; }
    protocol::Audits::SourceCodeLocation* getLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_location ? m_location.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& getLocation() const {
       return m_location;
    }
    void setLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_location = std::move(value); }

    bool hasInitiatorOrigin() { return !!m_initiatorOrigin; }
    String getInitiatorOrigin(const String& defaultValue) const {
       return m_initiatorOrigin.value_or(defaultValue);
    }
    const std::optional<String>& getInitiatorOrigin() const {
       return m_initiatorOrigin;
    }
    void setInitiatorOrigin(const String& value) { m_initiatorOrigin = value; }

    bool hasResourceIPAddressSpace() { return !!m_resourceIPAddressSpace; }
    String getResourceIPAddressSpace(const String& defaultValue) const {
       return m_resourceIPAddressSpace.value_or(defaultValue);
    }
    const std::optional<String>& getResourceIPAddressSpace() const {
       return m_resourceIPAddressSpace;
    }
    void setResourceIPAddressSpace(const String& value) { m_resourceIPAddressSpace = value; }

    bool hasClientSecurityState() { return !!m_clientSecurityState; }
    protocol::Network::ClientSecurityState* getClientSecurityState(protocol::Network::ClientSecurityState* defaultValue) {
       return m_clientSecurityState ? m_clientSecurityState.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::ClientSecurityState>& getClientSecurityState() const {
       return m_clientSecurityState;
    }
    void setClientSecurityState(std::unique_ptr<protocol::Network::ClientSecurityState> value) { m_clientSecurityState = std::move(value); }

    template<int STATE>
    class CorsIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CorsErrorStatusSet = 1 << 1,
            IsWarningSet = 1 << 2,
            RequestSet = 1 << 3,
            AllFieldsSet = (CorsErrorStatusSet | IsWarningSet | RequestSet | 0)};


        CorsIssueDetailsBuilder<STATE | CorsErrorStatusSet>& setCorsErrorStatus(std::unique_ptr<protocol::Network::CorsErrorStatus> value)
        {
            static_assert(!(STATE & CorsErrorStatusSet), "property corsErrorStatus should not be set yet");
            m_result->setCorsErrorStatus(std::move(value));
            return castState<CorsErrorStatusSet>();
        }

        CorsIssueDetailsBuilder<STATE | IsWarningSet>& setIsWarning(bool value)
        {
            static_assert(!(STATE & IsWarningSet), "property isWarning should not be set yet");
            m_result->setIsWarning(value);
            return castState<IsWarningSet>();
        }

        CorsIssueDetailsBuilder<STATE | RequestSet>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            static_assert(!(STATE & RequestSet), "property request should not be set yet");
            m_result->setRequest(std::move(value));
            return castState<RequestSet>();
        }

        CorsIssueDetailsBuilder<STATE>& setLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            m_result->setLocation(std::move(value));
            return *this;
        }

        CorsIssueDetailsBuilder<STATE>& setInitiatorOrigin(const String& value)
        {
            m_result->setInitiatorOrigin(value);
            return *this;
        }

        CorsIssueDetailsBuilder<STATE>& setResourceIPAddressSpace(const String& value)
        {
            m_result->setResourceIPAddressSpace(value);
            return *this;
        }

        CorsIssueDetailsBuilder<STATE>& setClientSecurityState(std::unique_ptr<protocol::Network::ClientSecurityState> value)
        {
            m_result->setClientSecurityState(std::move(value));
            return *this;
        }

        std::unique_ptr<CorsIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CorsIssueDetails;
        CorsIssueDetailsBuilder() : m_result(new CorsIssueDetails()) { }

        template<int STEP> CorsIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CorsIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CorsIssueDetails> m_result;
    };

    static CorsIssueDetailsBuilder<0> create()
    {
        return CorsIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CorsIssueDetails()
    {
          m_isWarning = false;
    }

    std::unique_ptr<protocol::Network::CorsErrorStatus> m_corsErrorStatus;
    bool m_isWarning;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_location;
    std::optional<String> m_initiatorOrigin;
    std::optional<String> m_resourceIPAddressSpace;
    std::unique_ptr<protocol::Network::ClientSecurityState> m_clientSecurityState;
};


class CORE_EXPORT AttributionReportingIssueDetails : public ::crdtp::ProtocolObject<AttributionReportingIssueDetails> {
public:
    ~AttributionReportingIssueDetails() override { }

    String getViolationType() { return m_violationType; }
    void setViolationType(const String& value) { m_violationType = value; }

    bool hasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* getRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& getRequest() const {
       return m_request;
    }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    bool hasViolatingNodeId() { return !!m_violatingNodeId; }
    int getViolatingNodeId(int defaultValue) const {
       return m_violatingNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getViolatingNodeId() const {
       return m_violatingNodeId;
    }
    void setViolatingNodeId(int value) { m_violatingNodeId = value; }

    bool hasInvalidParameter() { return !!m_invalidParameter; }
    String getInvalidParameter(const String& defaultValue) const {
       return m_invalidParameter.value_or(defaultValue);
    }
    const std::optional<String>& getInvalidParameter() const {
       return m_invalidParameter;
    }
    void setInvalidParameter(const String& value) { m_invalidParameter = value; }

    template<int STATE>
    class AttributionReportingIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ViolationTypeSet = 1 << 1,
            AllFieldsSet = (ViolationTypeSet | 0)};


        AttributionReportingIssueDetailsBuilder<STATE | ViolationTypeSet>& setViolationType(const String& value)
        {
            static_assert(!(STATE & ViolationTypeSet), "property violationType should not be set yet");
            m_result->setViolationType(value);
            return castState<ViolationTypeSet>();
        }

        AttributionReportingIssueDetailsBuilder<STATE>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            m_result->setRequest(std::move(value));
            return *this;
        }

        AttributionReportingIssueDetailsBuilder<STATE>& setViolatingNodeId(int value)
        {
            m_result->setViolatingNodeId(value);
            return *this;
        }

        AttributionReportingIssueDetailsBuilder<STATE>& setInvalidParameter(const String& value)
        {
            m_result->setInvalidParameter(value);
            return *this;
        }

        std::unique_ptr<AttributionReportingIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingIssueDetails;
        AttributionReportingIssueDetailsBuilder() : m_result(new AttributionReportingIssueDetails()) { }

        template<int STEP> AttributionReportingIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> m_result;
    };

    static AttributionReportingIssueDetailsBuilder<0> create()
    {
        return AttributionReportingIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingIssueDetails()
    {
    }

    String m_violationType;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::optional<int> m_violatingNodeId;
    std::optional<String> m_invalidParameter;
};


class CORE_EXPORT QuirksModeIssueDetails : public ::crdtp::ProtocolObject<QuirksModeIssueDetails> {
public:
    ~QuirksModeIssueDetails() override { }

    bool getIsLimitedQuirksMode() { return m_isLimitedQuirksMode; }
    void setIsLimitedQuirksMode(bool value) { m_isLimitedQuirksMode = value; }

    int getDocumentNodeId() { return m_documentNodeId; }
    void setDocumentNodeId(int value) { m_documentNodeId = value; }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    String getFrameId() { return m_frameId; }
    void setFrameId(const String& value) { m_frameId = value; }

    String getLoaderId() { return m_loaderId; }
    void setLoaderId(const String& value) { m_loaderId = value; }

    template<int STATE>
    class QuirksModeIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IsLimitedQuirksModeSet = 1 << 1,
            DocumentNodeIdSet = 1 << 2,
            UrlSet = 1 << 3,
            FrameIdSet = 1 << 4,
            LoaderIdSet = 1 << 5,
            AllFieldsSet = (IsLimitedQuirksModeSet | DocumentNodeIdSet | UrlSet | FrameIdSet | LoaderIdSet | 0)};


        QuirksModeIssueDetailsBuilder<STATE | IsLimitedQuirksModeSet>& setIsLimitedQuirksMode(bool value)
        {
            static_assert(!(STATE & IsLimitedQuirksModeSet), "property isLimitedQuirksMode should not be set yet");
            m_result->setIsLimitedQuirksMode(value);
            return castState<IsLimitedQuirksModeSet>();
        }

        QuirksModeIssueDetailsBuilder<STATE | DocumentNodeIdSet>& setDocumentNodeId(int value)
        {
            static_assert(!(STATE & DocumentNodeIdSet), "property documentNodeId should not be set yet");
            m_result->setDocumentNodeId(value);
            return castState<DocumentNodeIdSet>();
        }

        QuirksModeIssueDetailsBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        QuirksModeIssueDetailsBuilder<STATE | FrameIdSet>& setFrameId(const String& value)
        {
            static_assert(!(STATE & FrameIdSet), "property frameId should not be set yet");
            m_result->setFrameId(value);
            return castState<FrameIdSet>();
        }

        QuirksModeIssueDetailsBuilder<STATE | LoaderIdSet>& setLoaderId(const String& value)
        {
            static_assert(!(STATE & LoaderIdSet), "property loaderId should not be set yet");
            m_result->setLoaderId(value);
            return castState<LoaderIdSet>();
        }

        std::unique_ptr<QuirksModeIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class QuirksModeIssueDetails;
        QuirksModeIssueDetailsBuilder() : m_result(new QuirksModeIssueDetails()) { }

        template<int STEP> QuirksModeIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<QuirksModeIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> m_result;
    };

    static QuirksModeIssueDetailsBuilder<0> create()
    {
        return QuirksModeIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    QuirksModeIssueDetails()
    {
          m_isLimitedQuirksMode = false;
          m_documentNodeId = 0;
    }

    bool m_isLimitedQuirksMode;
    int m_documentNodeId;
    String m_url;
    String m_frameId;
    String m_loaderId;
};


class CORE_EXPORT NavigatorUserAgentIssueDetails : public ::crdtp::ProtocolObject<NavigatorUserAgentIssueDetails> {
public:
    ~NavigatorUserAgentIssueDetails() override { }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    bool hasLocation() { return !!m_location; }
    protocol::Audits::SourceCodeLocation* getLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_location ? m_location.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& getLocation() const {
       return m_location;
    }
    void setLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_location = std::move(value); }

    template<int STATE>
    class NavigatorUserAgentIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            AllFieldsSet = (UrlSet | 0)};


        NavigatorUserAgentIssueDetailsBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        NavigatorUserAgentIssueDetailsBuilder<STATE>& setLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            m_result->setLocation(std::move(value));
            return *this;
        }

        std::unique_ptr<NavigatorUserAgentIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class NavigatorUserAgentIssueDetails;
        NavigatorUserAgentIssueDetailsBuilder() : m_result(new NavigatorUserAgentIssueDetails()) { }

        template<int STEP> NavigatorUserAgentIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<NavigatorUserAgentIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> m_result;
    };

    static NavigatorUserAgentIssueDetailsBuilder<0> create()
    {
        return NavigatorUserAgentIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    NavigatorUserAgentIssueDetails()
    {
    }

    String m_url;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_location;
};


class CORE_EXPORT SharedDictionaryIssueDetails : public ::crdtp::ProtocolObject<SharedDictionaryIssueDetails> {
public:
    ~SharedDictionaryIssueDetails() override { }

    String getSharedDictionaryError() { return m_sharedDictionaryError; }
    void setSharedDictionaryError(const String& value) { m_sharedDictionaryError = value; }

    protocol::Audits::AffectedRequest* getRequest() { return m_request.get(); }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    template<int STATE>
    class SharedDictionaryIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SharedDictionaryErrorSet = 1 << 1,
            RequestSet = 1 << 2,
            AllFieldsSet = (SharedDictionaryErrorSet | RequestSet | 0)};


        SharedDictionaryIssueDetailsBuilder<STATE | SharedDictionaryErrorSet>& setSharedDictionaryError(const String& value)
        {
            static_assert(!(STATE & SharedDictionaryErrorSet), "property sharedDictionaryError should not be set yet");
            m_result->setSharedDictionaryError(value);
            return castState<SharedDictionaryErrorSet>();
        }

        SharedDictionaryIssueDetailsBuilder<STATE | RequestSet>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            static_assert(!(STATE & RequestSet), "property request should not be set yet");
            m_result->setRequest(std::move(value));
            return castState<RequestSet>();
        }

        std::unique_ptr<SharedDictionaryIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedDictionaryIssueDetails;
        SharedDictionaryIssueDetailsBuilder() : m_result(new SharedDictionaryIssueDetails()) { }

        template<int STEP> SharedDictionaryIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedDictionaryIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> m_result;
    };

    static SharedDictionaryIssueDetailsBuilder<0> create()
    {
        return SharedDictionaryIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedDictionaryIssueDetails()
    {
    }

    String m_sharedDictionaryError;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
};


class CORE_EXPORT SRIMessageSignatureIssueDetails : public ::crdtp::ProtocolObject<SRIMessageSignatureIssueDetails> {
public:
    ~SRIMessageSignatureIssueDetails() override { }

    String getError() { return m_error; }
    void setError(const String& value) { m_error = value; }

    String getSignatureBase() { return m_signatureBase; }
    void setSignatureBase(const String& value) { m_signatureBase = value; }

    protocol::Array<String>* getIntegrityAssertions() { return m_integrityAssertions.get(); }
    void setIntegrityAssertions(std::unique_ptr<protocol::Array<String>> value) { m_integrityAssertions = std::move(value); }

    protocol::Audits::AffectedRequest* getRequest() { return m_request.get(); }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    template<int STATE>
    class SRIMessageSignatureIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorSet = 1 << 1,
            SignatureBaseSet = 1 << 2,
            IntegrityAssertionsSet = 1 << 3,
            RequestSet = 1 << 4,
            AllFieldsSet = (ErrorSet | SignatureBaseSet | IntegrityAssertionsSet | RequestSet | 0)};


        SRIMessageSignatureIssueDetailsBuilder<STATE | ErrorSet>& setError(const String& value)
        {
            static_assert(!(STATE & ErrorSet), "property error should not be set yet");
            m_result->setError(value);
            return castState<ErrorSet>();
        }

        SRIMessageSignatureIssueDetailsBuilder<STATE | SignatureBaseSet>& setSignatureBase(const String& value)
        {
            static_assert(!(STATE & SignatureBaseSet), "property signatureBase should not be set yet");
            m_result->setSignatureBase(value);
            return castState<SignatureBaseSet>();
        }

        SRIMessageSignatureIssueDetailsBuilder<STATE | IntegrityAssertionsSet>& setIntegrityAssertions(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & IntegrityAssertionsSet), "property integrityAssertions should not be set yet");
            m_result->setIntegrityAssertions(std::move(value));
            return castState<IntegrityAssertionsSet>();
        }

        SRIMessageSignatureIssueDetailsBuilder<STATE | RequestSet>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            static_assert(!(STATE & RequestSet), "property request should not be set yet");
            m_result->setRequest(std::move(value));
            return castState<RequestSet>();
        }

        std::unique_ptr<SRIMessageSignatureIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SRIMessageSignatureIssueDetails;
        SRIMessageSignatureIssueDetailsBuilder() : m_result(new SRIMessageSignatureIssueDetails()) { }

        template<int STEP> SRIMessageSignatureIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SRIMessageSignatureIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> m_result;
    };

    static SRIMessageSignatureIssueDetailsBuilder<0> create()
    {
        return SRIMessageSignatureIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SRIMessageSignatureIssueDetails()
    {
    }

    String m_error;
    String m_signatureBase;
    std::unique_ptr<protocol::Array<String>> m_integrityAssertions;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
};


class CORE_EXPORT UnencodedDigestIssueDetails : public ::crdtp::ProtocolObject<UnencodedDigestIssueDetails> {
public:
    ~UnencodedDigestIssueDetails() override { }

    String getError() { return m_error; }
    void setError(const String& value) { m_error = value; }

    protocol::Audits::AffectedRequest* getRequest() { return m_request.get(); }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    template<int STATE>
    class UnencodedDigestIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorSet = 1 << 1,
            RequestSet = 1 << 2,
            AllFieldsSet = (ErrorSet | RequestSet | 0)};


        UnencodedDigestIssueDetailsBuilder<STATE | ErrorSet>& setError(const String& value)
        {
            static_assert(!(STATE & ErrorSet), "property error should not be set yet");
            m_result->setError(value);
            return castState<ErrorSet>();
        }

        UnencodedDigestIssueDetailsBuilder<STATE | RequestSet>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            static_assert(!(STATE & RequestSet), "property request should not be set yet");
            m_result->setRequest(std::move(value));
            return castState<RequestSet>();
        }

        std::unique_ptr<UnencodedDigestIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UnencodedDigestIssueDetails;
        UnencodedDigestIssueDetailsBuilder() : m_result(new UnencodedDigestIssueDetails()) { }

        template<int STEP> UnencodedDigestIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UnencodedDigestIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> m_result;
    };

    static UnencodedDigestIssueDetailsBuilder<0> create()
    {
        return UnencodedDigestIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UnencodedDigestIssueDetails()
    {
    }

    String m_error;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
};


class CORE_EXPORT GenericIssueDetails : public ::crdtp::ProtocolObject<GenericIssueDetails> {
public:
    ~GenericIssueDetails() override { }

    String getErrorType() { return m_errorType; }
    void setErrorType(const String& value) { m_errorType = value; }

    bool hasFrameId() { return !!m_frameId; }
    String getFrameId(const String& defaultValue) const {
       return m_frameId.value_or(defaultValue);
    }
    const std::optional<String>& getFrameId() const {
       return m_frameId;
    }
    void setFrameId(const String& value) { m_frameId = value; }

    bool hasViolatingNodeId() { return !!m_violatingNodeId; }
    int getViolatingNodeId(int defaultValue) const {
       return m_violatingNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getViolatingNodeId() const {
       return m_violatingNodeId;
    }
    void setViolatingNodeId(int value) { m_violatingNodeId = value; }

    bool hasViolatingNodeAttribute() { return !!m_violatingNodeAttribute; }
    String getViolatingNodeAttribute(const String& defaultValue) const {
       return m_violatingNodeAttribute.value_or(defaultValue);
    }
    const std::optional<String>& getViolatingNodeAttribute() const {
       return m_violatingNodeAttribute;
    }
    void setViolatingNodeAttribute(const String& value) { m_violatingNodeAttribute = value; }

    bool hasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* getRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& getRequest() const {
       return m_request;
    }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    template<int STATE>
    class GenericIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorTypeSet = 1 << 1,
            AllFieldsSet = (ErrorTypeSet | 0)};


        GenericIssueDetailsBuilder<STATE | ErrorTypeSet>& setErrorType(const String& value)
        {
            static_assert(!(STATE & ErrorTypeSet), "property errorType should not be set yet");
            m_result->setErrorType(value);
            return castState<ErrorTypeSet>();
        }

        GenericIssueDetailsBuilder<STATE>& setFrameId(const String& value)
        {
            m_result->setFrameId(value);
            return *this;
        }

        GenericIssueDetailsBuilder<STATE>& setViolatingNodeId(int value)
        {
            m_result->setViolatingNodeId(value);
            return *this;
        }

        GenericIssueDetailsBuilder<STATE>& setViolatingNodeAttribute(const String& value)
        {
            m_result->setViolatingNodeAttribute(value);
            return *this;
        }

        GenericIssueDetailsBuilder<STATE>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            m_result->setRequest(std::move(value));
            return *this;
        }

        std::unique_ptr<GenericIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class GenericIssueDetails;
        GenericIssueDetailsBuilder() : m_result(new GenericIssueDetails()) { }

        template<int STEP> GenericIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<GenericIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::GenericIssueDetails> m_result;
    };

    static GenericIssueDetailsBuilder<0> create()
    {
        return GenericIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    GenericIssueDetails()
    {
    }

    String m_errorType;
    std::optional<String> m_frameId;
    std::optional<int> m_violatingNodeId;
    std::optional<String> m_violatingNodeAttribute;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
};


class CORE_EXPORT DeprecationIssueDetails : public ::crdtp::ProtocolObject<DeprecationIssueDetails> {
public:
    ~DeprecationIssueDetails() override { }

    bool hasAffectedFrame() { return !!m_affectedFrame; }
    protocol::Audits::AffectedFrame* getAffectedFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_affectedFrame ? m_affectedFrame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& getAffectedFrame() const {
       return m_affectedFrame;
    }
    void setAffectedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_affectedFrame = std::move(value); }

    protocol::Audits::SourceCodeLocation* getSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    template<int STATE>
    class DeprecationIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            TypeSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | TypeSet | 0)};


        DeprecationIssueDetailsBuilder<STATE>& setAffectedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value)
        {
            m_result->setAffectedFrame(std::move(value));
            return *this;
        }

        DeprecationIssueDetailsBuilder<STATE | SourceCodeLocationSet>& setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
            m_result->setSourceCodeLocation(std::move(value));
            return castState<SourceCodeLocationSet>();
        }

        DeprecationIssueDetailsBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        std::unique_ptr<DeprecationIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DeprecationIssueDetails;
        DeprecationIssueDetailsBuilder() : m_result(new DeprecationIssueDetails()) { }

        template<int STEP> DeprecationIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DeprecationIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::DeprecationIssueDetails> m_result;
    };

    static DeprecationIssueDetailsBuilder<0> create()
    {
        return DeprecationIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DeprecationIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::AffectedFrame> m_affectedFrame;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_type;
};


class CORE_EXPORT BounceTrackingIssueDetails : public ::crdtp::ProtocolObject<BounceTrackingIssueDetails> {
public:
    ~BounceTrackingIssueDetails() override { }

    protocol::Array<String>* getTrackingSites() { return m_trackingSites.get(); }
    void setTrackingSites(std::unique_ptr<protocol::Array<String>> value) { m_trackingSites = std::move(value); }

    template<int STATE>
    class BounceTrackingIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TrackingSitesSet = 1 << 1,
            AllFieldsSet = (TrackingSitesSet | 0)};


        BounceTrackingIssueDetailsBuilder<STATE | TrackingSitesSet>& setTrackingSites(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & TrackingSitesSet), "property trackingSites should not be set yet");
            m_result->setTrackingSites(std::move(value));
            return castState<TrackingSitesSet>();
        }

        std::unique_ptr<BounceTrackingIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BounceTrackingIssueDetails;
        BounceTrackingIssueDetailsBuilder() : m_result(new BounceTrackingIssueDetails()) { }

        template<int STEP> BounceTrackingIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BounceTrackingIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> m_result;
    };

    static BounceTrackingIssueDetailsBuilder<0> create()
    {
        return BounceTrackingIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BounceTrackingIssueDetails()
    {
    }

    std::unique_ptr<protocol::Array<String>> m_trackingSites;
};


class CORE_EXPORT CookieDeprecationMetadataIssueDetails : public ::crdtp::ProtocolObject<CookieDeprecationMetadataIssueDetails> {
public:
    ~CookieDeprecationMetadataIssueDetails() override { }

    protocol::Array<String>* getAllowedSites() { return m_allowedSites.get(); }
    void setAllowedSites(std::unique_ptr<protocol::Array<String>> value) { m_allowedSites = std::move(value); }

    double getOptOutPercentage() { return m_optOutPercentage; }
    void setOptOutPercentage(double value) { m_optOutPercentage = value; }

    bool getIsOptOutTopLevel() { return m_isOptOutTopLevel; }
    void setIsOptOutTopLevel(bool value) { m_isOptOutTopLevel = value; }

    String getOperation() { return m_operation; }
    void setOperation(const String& value) { m_operation = value; }

    template<int STATE>
    class CookieDeprecationMetadataIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllowedSitesSet = 1 << 1,
            OptOutPercentageSet = 1 << 2,
            IsOptOutTopLevelSet = 1 << 3,
            OperationSet = 1 << 4,
            AllFieldsSet = (AllowedSitesSet | OptOutPercentageSet | IsOptOutTopLevelSet | OperationSet | 0)};


        CookieDeprecationMetadataIssueDetailsBuilder<STATE | AllowedSitesSet>& setAllowedSites(std::unique_ptr<protocol::Array<String>> value)
        {
            static_assert(!(STATE & AllowedSitesSet), "property allowedSites should not be set yet");
            m_result->setAllowedSites(std::move(value));
            return castState<AllowedSitesSet>();
        }

        CookieDeprecationMetadataIssueDetailsBuilder<STATE | OptOutPercentageSet>& setOptOutPercentage(double value)
        {
            static_assert(!(STATE & OptOutPercentageSet), "property optOutPercentage should not be set yet");
            m_result->setOptOutPercentage(value);
            return castState<OptOutPercentageSet>();
        }

        CookieDeprecationMetadataIssueDetailsBuilder<STATE | IsOptOutTopLevelSet>& setIsOptOutTopLevel(bool value)
        {
            static_assert(!(STATE & IsOptOutTopLevelSet), "property isOptOutTopLevel should not be set yet");
            m_result->setIsOptOutTopLevel(value);
            return castState<IsOptOutTopLevelSet>();
        }

        CookieDeprecationMetadataIssueDetailsBuilder<STATE | OperationSet>& setOperation(const String& value)
        {
            static_assert(!(STATE & OperationSet), "property operation should not be set yet");
            m_result->setOperation(value);
            return castState<OperationSet>();
        }

        std::unique_ptr<CookieDeprecationMetadataIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookieDeprecationMetadataIssueDetails;
        CookieDeprecationMetadataIssueDetailsBuilder() : m_result(new CookieDeprecationMetadataIssueDetails()) { }

        template<int STEP> CookieDeprecationMetadataIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieDeprecationMetadataIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> m_result;
    };

    static CookieDeprecationMetadataIssueDetailsBuilder<0> create()
    {
        return CookieDeprecationMetadataIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookieDeprecationMetadataIssueDetails()
    {
          m_optOutPercentage = 0;
          m_isOptOutTopLevel = false;
    }

    std::unique_ptr<protocol::Array<String>> m_allowedSites;
    double m_optOutPercentage;
    bool m_isOptOutTopLevel;
    String m_operation;
};


class CORE_EXPORT FederatedAuthRequestIssueDetails : public ::crdtp::ProtocolObject<FederatedAuthRequestIssueDetails> {
public:
    ~FederatedAuthRequestIssueDetails() override { }

    String getFederatedAuthRequestIssueReason() { return m_federatedAuthRequestIssueReason; }
    void setFederatedAuthRequestIssueReason(const String& value) { m_federatedAuthRequestIssueReason = value; }

    template<int STATE>
    class FederatedAuthRequestIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FederatedAuthRequestIssueReasonSet = 1 << 1,
            AllFieldsSet = (FederatedAuthRequestIssueReasonSet | 0)};


        FederatedAuthRequestIssueDetailsBuilder<STATE | FederatedAuthRequestIssueReasonSet>& setFederatedAuthRequestIssueReason(const String& value)
        {
            static_assert(!(STATE & FederatedAuthRequestIssueReasonSet), "property federatedAuthRequestIssueReason should not be set yet");
            m_result->setFederatedAuthRequestIssueReason(value);
            return castState<FederatedAuthRequestIssueReasonSet>();
        }

        std::unique_ptr<FederatedAuthRequestIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FederatedAuthRequestIssueDetails;
        FederatedAuthRequestIssueDetailsBuilder() : m_result(new FederatedAuthRequestIssueDetails()) { }

        template<int STEP> FederatedAuthRequestIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FederatedAuthRequestIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> m_result;
    };

    static FederatedAuthRequestIssueDetailsBuilder<0> create()
    {
        return FederatedAuthRequestIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FederatedAuthRequestIssueDetails()
    {
    }

    String m_federatedAuthRequestIssueReason;
};


class CORE_EXPORT FederatedAuthUserInfoRequestIssueDetails : public ::crdtp::ProtocolObject<FederatedAuthUserInfoRequestIssueDetails> {
public:
    ~FederatedAuthUserInfoRequestIssueDetails() override { }

    String getFederatedAuthUserInfoRequestIssueReason() { return m_federatedAuthUserInfoRequestIssueReason; }
    void setFederatedAuthUserInfoRequestIssueReason(const String& value) { m_federatedAuthUserInfoRequestIssueReason = value; }

    template<int STATE>
    class FederatedAuthUserInfoRequestIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FederatedAuthUserInfoRequestIssueReasonSet = 1 << 1,
            AllFieldsSet = (FederatedAuthUserInfoRequestIssueReasonSet | 0)};


        FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE | FederatedAuthUserInfoRequestIssueReasonSet>& setFederatedAuthUserInfoRequestIssueReason(const String& value)
        {
            static_assert(!(STATE & FederatedAuthUserInfoRequestIssueReasonSet), "property federatedAuthUserInfoRequestIssueReason should not be set yet");
            m_result->setFederatedAuthUserInfoRequestIssueReason(value);
            return castState<FederatedAuthUserInfoRequestIssueReasonSet>();
        }

        std::unique_ptr<FederatedAuthUserInfoRequestIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FederatedAuthUserInfoRequestIssueDetails;
        FederatedAuthUserInfoRequestIssueDetailsBuilder() : m_result(new FederatedAuthUserInfoRequestIssueDetails()) { }

        template<int STEP> FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> m_result;
    };

    static FederatedAuthUserInfoRequestIssueDetailsBuilder<0> create()
    {
        return FederatedAuthUserInfoRequestIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FederatedAuthUserInfoRequestIssueDetails()
    {
    }

    String m_federatedAuthUserInfoRequestIssueReason;
};


class CORE_EXPORT ClientHintIssueDetails : public ::crdtp::ProtocolObject<ClientHintIssueDetails> {
public:
    ~ClientHintIssueDetails() override { }

    protocol::Audits::SourceCodeLocation* getSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

    String getClientHintIssueReason() { return m_clientHintIssueReason; }
    void setClientHintIssueReason(const String& value) { m_clientHintIssueReason = value; }

    template<int STATE>
    class ClientHintIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            ClientHintIssueReasonSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | ClientHintIssueReasonSet | 0)};


        ClientHintIssueDetailsBuilder<STATE | SourceCodeLocationSet>& setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
            m_result->setSourceCodeLocation(std::move(value));
            return castState<SourceCodeLocationSet>();
        }

        ClientHintIssueDetailsBuilder<STATE | ClientHintIssueReasonSet>& setClientHintIssueReason(const String& value)
        {
            static_assert(!(STATE & ClientHintIssueReasonSet), "property clientHintIssueReason should not be set yet");
            m_result->setClientHintIssueReason(value);
            return castState<ClientHintIssueReasonSet>();
        }

        std::unique_ptr<ClientHintIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ClientHintIssueDetails;
        ClientHintIssueDetailsBuilder() : m_result(new ClientHintIssueDetails()) { }

        template<int STEP> ClientHintIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ClientHintIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::ClientHintIssueDetails> m_result;
    };

    static ClientHintIssueDetailsBuilder<0> create()
    {
        return ClientHintIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ClientHintIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_clientHintIssueReason;
};


class CORE_EXPORT FailedRequestInfo : public ::crdtp::ProtocolObject<FailedRequestInfo> {
public:
    ~FailedRequestInfo() override { }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    String getFailureMessage() { return m_failureMessage; }
    void setFailureMessage(const String& value) { m_failureMessage = value; }

    bool hasRequestId() { return !!m_requestId; }
    String getRequestId(const String& defaultValue) const {
       return m_requestId.value_or(defaultValue);
    }
    const std::optional<String>& getRequestId() const {
       return m_requestId;
    }
    void setRequestId(const String& value) { m_requestId = value; }

    template<int STATE>
    class FailedRequestInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            FailureMessageSet = 1 << 2,
            AllFieldsSet = (UrlSet | FailureMessageSet | 0)};


        FailedRequestInfoBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        FailedRequestInfoBuilder<STATE | FailureMessageSet>& setFailureMessage(const String& value)
        {
            static_assert(!(STATE & FailureMessageSet), "property failureMessage should not be set yet");
            m_result->setFailureMessage(value);
            return castState<FailureMessageSet>();
        }

        FailedRequestInfoBuilder<STATE>& setRequestId(const String& value)
        {
            m_result->setRequestId(value);
            return *this;
        }

        std::unique_ptr<FailedRequestInfo> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FailedRequestInfo;
        FailedRequestInfoBuilder() : m_result(new FailedRequestInfo()) { }

        template<int STEP> FailedRequestInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FailedRequestInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::FailedRequestInfo> m_result;
    };

    static FailedRequestInfoBuilder<0> create()
    {
        return FailedRequestInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FailedRequestInfo()
    {
    }

    String m_url;
    String m_failureMessage;
    std::optional<String> m_requestId;
};


class CORE_EXPORT PartitioningBlobURLIssueDetails : public ::crdtp::ProtocolObject<PartitioningBlobURLIssueDetails> {
public:
    ~PartitioningBlobURLIssueDetails() override { }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    String getPartitioningBlobURLInfo() { return m_partitioningBlobURLInfo; }
    void setPartitioningBlobURLInfo(const String& value) { m_partitioningBlobURLInfo = value; }

    template<int STATE>
    class PartitioningBlobURLIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            PartitioningBlobURLInfoSet = 1 << 2,
            AllFieldsSet = (UrlSet | PartitioningBlobURLInfoSet | 0)};


        PartitioningBlobURLIssueDetailsBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        PartitioningBlobURLIssueDetailsBuilder<STATE | PartitioningBlobURLInfoSet>& setPartitioningBlobURLInfo(const String& value)
        {
            static_assert(!(STATE & PartitioningBlobURLInfoSet), "property partitioningBlobURLInfo should not be set yet");
            m_result->setPartitioningBlobURLInfo(value);
            return castState<PartitioningBlobURLInfoSet>();
        }

        std::unique_ptr<PartitioningBlobURLIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PartitioningBlobURLIssueDetails;
        PartitioningBlobURLIssueDetailsBuilder() : m_result(new PartitioningBlobURLIssueDetails()) { }

        template<int STEP> PartitioningBlobURLIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PartitioningBlobURLIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> m_result;
    };

    static PartitioningBlobURLIssueDetailsBuilder<0> create()
    {
        return PartitioningBlobURLIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PartitioningBlobURLIssueDetails()
    {
    }

    String m_url;
    String m_partitioningBlobURLInfo;
};


class CORE_EXPORT ElementAccessibilityIssueDetails : public ::crdtp::ProtocolObject<ElementAccessibilityIssueDetails> {
public:
    ~ElementAccessibilityIssueDetails() override { }

    int getNodeId() { return m_nodeId; }
    void setNodeId(int value) { m_nodeId = value; }

    String getElementAccessibilityIssueReason() { return m_elementAccessibilityIssueReason; }
    void setElementAccessibilityIssueReason(const String& value) { m_elementAccessibilityIssueReason = value; }

    bool getHasDisallowedAttributes() { return m_hasDisallowedAttributes; }
    void setHasDisallowedAttributes(bool value) { m_hasDisallowedAttributes = value; }

    template<int STATE>
    class ElementAccessibilityIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NodeIdSet = 1 << 1,
            ElementAccessibilityIssueReasonSet = 1 << 2,
            HasDisallowedAttributesSet = 1 << 3,
            AllFieldsSet = (NodeIdSet | ElementAccessibilityIssueReasonSet | HasDisallowedAttributesSet | 0)};


        ElementAccessibilityIssueDetailsBuilder<STATE | NodeIdSet>& setNodeId(int value)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId should not be set yet");
            m_result->setNodeId(value);
            return castState<NodeIdSet>();
        }

        ElementAccessibilityIssueDetailsBuilder<STATE | ElementAccessibilityIssueReasonSet>& setElementAccessibilityIssueReason(const String& value)
        {
            static_assert(!(STATE & ElementAccessibilityIssueReasonSet), "property elementAccessibilityIssueReason should not be set yet");
            m_result->setElementAccessibilityIssueReason(value);
            return castState<ElementAccessibilityIssueReasonSet>();
        }

        ElementAccessibilityIssueDetailsBuilder<STATE | HasDisallowedAttributesSet>& setHasDisallowedAttributes(bool value)
        {
            static_assert(!(STATE & HasDisallowedAttributesSet), "property hasDisallowedAttributes should not be set yet");
            m_result->setHasDisallowedAttributes(value);
            return castState<HasDisallowedAttributesSet>();
        }

        std::unique_ptr<ElementAccessibilityIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ElementAccessibilityIssueDetails;
        ElementAccessibilityIssueDetailsBuilder() : m_result(new ElementAccessibilityIssueDetails()) { }

        template<int STEP> ElementAccessibilityIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ElementAccessibilityIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> m_result;
    };

    static ElementAccessibilityIssueDetailsBuilder<0> create()
    {
        return ElementAccessibilityIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ElementAccessibilityIssueDetails()
    {
          m_nodeId = 0;
          m_hasDisallowedAttributes = false;
    }

    int m_nodeId;
    String m_elementAccessibilityIssueReason;
    bool m_hasDisallowedAttributes;
};


class CORE_EXPORT StylesheetLoadingIssueDetails : public ::crdtp::ProtocolObject<StylesheetLoadingIssueDetails> {
public:
    ~StylesheetLoadingIssueDetails() override { }

    protocol::Audits::SourceCodeLocation* getSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

    String getStyleSheetLoadingIssueReason() { return m_styleSheetLoadingIssueReason; }
    void setStyleSheetLoadingIssueReason(const String& value) { m_styleSheetLoadingIssueReason = value; }

    bool hasFailedRequestInfo() { return !!m_failedRequestInfo; }
    protocol::Audits::FailedRequestInfo* getFailedRequestInfo(protocol::Audits::FailedRequestInfo* defaultValue) {
       return m_failedRequestInfo ? m_failedRequestInfo.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::FailedRequestInfo>& getFailedRequestInfo() const {
       return m_failedRequestInfo;
    }
    void setFailedRequestInfo(std::unique_ptr<protocol::Audits::FailedRequestInfo> value) { m_failedRequestInfo = std::move(value); }

    template<int STATE>
    class StylesheetLoadingIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            StyleSheetLoadingIssueReasonSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | StyleSheetLoadingIssueReasonSet | 0)};


        StylesheetLoadingIssueDetailsBuilder<STATE | SourceCodeLocationSet>& setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
            m_result->setSourceCodeLocation(std::move(value));
            return castState<SourceCodeLocationSet>();
        }

        StylesheetLoadingIssueDetailsBuilder<STATE | StyleSheetLoadingIssueReasonSet>& setStyleSheetLoadingIssueReason(const String& value)
        {
            static_assert(!(STATE & StyleSheetLoadingIssueReasonSet), "property styleSheetLoadingIssueReason should not be set yet");
            m_result->setStyleSheetLoadingIssueReason(value);
            return castState<StyleSheetLoadingIssueReasonSet>();
        }

        StylesheetLoadingIssueDetailsBuilder<STATE>& setFailedRequestInfo(std::unique_ptr<protocol::Audits::FailedRequestInfo> value)
        {
            m_result->setFailedRequestInfo(std::move(value));
            return *this;
        }

        std::unique_ptr<StylesheetLoadingIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StylesheetLoadingIssueDetails;
        StylesheetLoadingIssueDetailsBuilder() : m_result(new StylesheetLoadingIssueDetails()) { }

        template<int STEP> StylesheetLoadingIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StylesheetLoadingIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> m_result;
    };

    static StylesheetLoadingIssueDetailsBuilder<0> create()
    {
        return StylesheetLoadingIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StylesheetLoadingIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_styleSheetLoadingIssueReason;
    std::unique_ptr<protocol::Audits::FailedRequestInfo> m_failedRequestInfo;
};


class CORE_EXPORT PropertyRuleIssueDetails : public ::crdtp::ProtocolObject<PropertyRuleIssueDetails> {
public:
    ~PropertyRuleIssueDetails() override { }

    protocol::Audits::SourceCodeLocation* getSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

    String getPropertyRuleIssueReason() { return m_propertyRuleIssueReason; }
    void setPropertyRuleIssueReason(const String& value) { m_propertyRuleIssueReason = value; }

    bool hasPropertyValue() { return !!m_propertyValue; }
    String getPropertyValue(const String& defaultValue) const {
       return m_propertyValue.value_or(defaultValue);
    }
    const std::optional<String>& getPropertyValue() const {
       return m_propertyValue;
    }
    void setPropertyValue(const String& value) { m_propertyValue = value; }

    template<int STATE>
    class PropertyRuleIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            PropertyRuleIssueReasonSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | PropertyRuleIssueReasonSet | 0)};


        PropertyRuleIssueDetailsBuilder<STATE | SourceCodeLocationSet>& setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
            m_result->setSourceCodeLocation(std::move(value));
            return castState<SourceCodeLocationSet>();
        }

        PropertyRuleIssueDetailsBuilder<STATE | PropertyRuleIssueReasonSet>& setPropertyRuleIssueReason(const String& value)
        {
            static_assert(!(STATE & PropertyRuleIssueReasonSet), "property propertyRuleIssueReason should not be set yet");
            m_result->setPropertyRuleIssueReason(value);
            return castState<PropertyRuleIssueReasonSet>();
        }

        PropertyRuleIssueDetailsBuilder<STATE>& setPropertyValue(const String& value)
        {
            m_result->setPropertyValue(value);
            return *this;
        }

        std::unique_ptr<PropertyRuleIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PropertyRuleIssueDetails;
        PropertyRuleIssueDetailsBuilder() : m_result(new PropertyRuleIssueDetails()) { }

        template<int STEP> PropertyRuleIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PropertyRuleIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> m_result;
    };

    static PropertyRuleIssueDetailsBuilder<0> create()
    {
        return PropertyRuleIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PropertyRuleIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_propertyRuleIssueReason;
    std::optional<String> m_propertyValue;
};


class CORE_EXPORT UserReidentificationIssueDetails : public ::crdtp::ProtocolObject<UserReidentificationIssueDetails> {
public:
    ~UserReidentificationIssueDetails() override { }

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    bool hasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* getRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& getRequest() const {
       return m_request;
    }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

    bool hasSourceCodeLocation() { return !!m_sourceCodeLocation; }
    protocol::Audits::SourceCodeLocation* getSourceCodeLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_sourceCodeLocation ? m_sourceCodeLocation.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& getSourceCodeLocation() const {
       return m_sourceCodeLocation;
    }
    void setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

    template<int STATE>
    class UserReidentificationIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        UserReidentificationIssueDetailsBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        UserReidentificationIssueDetailsBuilder<STATE>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value)
        {
            m_result->setRequest(std::move(value));
            return *this;
        }

        UserReidentificationIssueDetailsBuilder<STATE>& setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value)
        {
            m_result->setSourceCodeLocation(std::move(value));
            return *this;
        }

        std::unique_ptr<UserReidentificationIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UserReidentificationIssueDetails;
        UserReidentificationIssueDetailsBuilder() : m_result(new UserReidentificationIssueDetails()) { }

        template<int STEP> UserReidentificationIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UserReidentificationIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> m_result;
    };

    static UserReidentificationIssueDetailsBuilder<0> create()
    {
        return UserReidentificationIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UserReidentificationIssueDetails()
    {
    }

    String m_type;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
};


class CORE_EXPORT InspectorIssueDetails : public ::crdtp::ProtocolObject<InspectorIssueDetails> {
public:
    ~InspectorIssueDetails() override { }

    bool hasCookieIssueDetails() { return !!m_cookieIssueDetails; }
    protocol::Audits::CookieIssueDetails* getCookieIssueDetails(protocol::Audits::CookieIssueDetails* defaultValue) {
       return m_cookieIssueDetails ? m_cookieIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CookieIssueDetails>& getCookieIssueDetails() const {
       return m_cookieIssueDetails;
    }
    void setCookieIssueDetails(std::unique_ptr<protocol::Audits::CookieIssueDetails> value) { m_cookieIssueDetails = std::move(value); }

    bool hasMixedContentIssueDetails() { return !!m_mixedContentIssueDetails; }
    protocol::Audits::MixedContentIssueDetails* getMixedContentIssueDetails(protocol::Audits::MixedContentIssueDetails* defaultValue) {
       return m_mixedContentIssueDetails ? m_mixedContentIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::MixedContentIssueDetails>& getMixedContentIssueDetails() const {
       return m_mixedContentIssueDetails;
    }
    void setMixedContentIssueDetails(std::unique_ptr<protocol::Audits::MixedContentIssueDetails> value) { m_mixedContentIssueDetails = std::move(value); }

    bool hasBlockedByResponseIssueDetails() { return !!m_blockedByResponseIssueDetails; }
    protocol::Audits::BlockedByResponseIssueDetails* getBlockedByResponseIssueDetails(protocol::Audits::BlockedByResponseIssueDetails* defaultValue) {
       return m_blockedByResponseIssueDetails ? m_blockedByResponseIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails>& getBlockedByResponseIssueDetails() const {
       return m_blockedByResponseIssueDetails;
    }
    void setBlockedByResponseIssueDetails(std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> value) { m_blockedByResponseIssueDetails = std::move(value); }

    bool hasHeavyAdIssueDetails() { return !!m_heavyAdIssueDetails; }
    protocol::Audits::HeavyAdIssueDetails* getHeavyAdIssueDetails(protocol::Audits::HeavyAdIssueDetails* defaultValue) {
       return m_heavyAdIssueDetails ? m_heavyAdIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::HeavyAdIssueDetails>& getHeavyAdIssueDetails() const {
       return m_heavyAdIssueDetails;
    }
    void setHeavyAdIssueDetails(std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> value) { m_heavyAdIssueDetails = std::move(value); }

    bool hasContentSecurityPolicyIssueDetails() { return !!m_contentSecurityPolicyIssueDetails; }
    protocol::Audits::ContentSecurityPolicyIssueDetails* getContentSecurityPolicyIssueDetails(protocol::Audits::ContentSecurityPolicyIssueDetails* defaultValue) {
       return m_contentSecurityPolicyIssueDetails ? m_contentSecurityPolicyIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails>& getContentSecurityPolicyIssueDetails() const {
       return m_contentSecurityPolicyIssueDetails;
    }
    void setContentSecurityPolicyIssueDetails(std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> value) { m_contentSecurityPolicyIssueDetails = std::move(value); }

    bool hasSharedArrayBufferIssueDetails() { return !!m_sharedArrayBufferIssueDetails; }
    protocol::Audits::SharedArrayBufferIssueDetails* getSharedArrayBufferIssueDetails(protocol::Audits::SharedArrayBufferIssueDetails* defaultValue) {
       return m_sharedArrayBufferIssueDetails ? m_sharedArrayBufferIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails>& getSharedArrayBufferIssueDetails() const {
       return m_sharedArrayBufferIssueDetails;
    }
    void setSharedArrayBufferIssueDetails(std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> value) { m_sharedArrayBufferIssueDetails = std::move(value); }

    bool hasLowTextContrastIssueDetails() { return !!m_lowTextContrastIssueDetails; }
    protocol::Audits::LowTextContrastIssueDetails* getLowTextContrastIssueDetails(protocol::Audits::LowTextContrastIssueDetails* defaultValue) {
       return m_lowTextContrastIssueDetails ? m_lowTextContrastIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails>& getLowTextContrastIssueDetails() const {
       return m_lowTextContrastIssueDetails;
    }
    void setLowTextContrastIssueDetails(std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> value) { m_lowTextContrastIssueDetails = std::move(value); }

    bool hasCorsIssueDetails() { return !!m_corsIssueDetails; }
    protocol::Audits::CorsIssueDetails* getCorsIssueDetails(protocol::Audits::CorsIssueDetails* defaultValue) {
       return m_corsIssueDetails ? m_corsIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CorsIssueDetails>& getCorsIssueDetails() const {
       return m_corsIssueDetails;
    }
    void setCorsIssueDetails(std::unique_ptr<protocol::Audits::CorsIssueDetails> value) { m_corsIssueDetails = std::move(value); }

    bool hasAttributionReportingIssueDetails() { return !!m_attributionReportingIssueDetails; }
    protocol::Audits::AttributionReportingIssueDetails* getAttributionReportingIssueDetails(protocol::Audits::AttributionReportingIssueDetails* defaultValue) {
       return m_attributionReportingIssueDetails ? m_attributionReportingIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails>& getAttributionReportingIssueDetails() const {
       return m_attributionReportingIssueDetails;
    }
    void setAttributionReportingIssueDetails(std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> value) { m_attributionReportingIssueDetails = std::move(value); }

    bool hasQuirksModeIssueDetails() { return !!m_quirksModeIssueDetails; }
    protocol::Audits::QuirksModeIssueDetails* getQuirksModeIssueDetails(protocol::Audits::QuirksModeIssueDetails* defaultValue) {
       return m_quirksModeIssueDetails ? m_quirksModeIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::QuirksModeIssueDetails>& getQuirksModeIssueDetails() const {
       return m_quirksModeIssueDetails;
    }
    void setQuirksModeIssueDetails(std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> value) { m_quirksModeIssueDetails = std::move(value); }

    bool hasPartitioningBlobURLIssueDetails() { return !!m_partitioningBlobURLIssueDetails; }
    protocol::Audits::PartitioningBlobURLIssueDetails* getPartitioningBlobURLIssueDetails(protocol::Audits::PartitioningBlobURLIssueDetails* defaultValue) {
       return m_partitioningBlobURLIssueDetails ? m_partitioningBlobURLIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails>& getPartitioningBlobURLIssueDetails() const {
       return m_partitioningBlobURLIssueDetails;
    }
    void setPartitioningBlobURLIssueDetails(std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> value) { m_partitioningBlobURLIssueDetails = std::move(value); }

    bool hasNavigatorUserAgentIssueDetails() { return !!m_navigatorUserAgentIssueDetails; }
    protocol::Audits::NavigatorUserAgentIssueDetails* getNavigatorUserAgentIssueDetails(protocol::Audits::NavigatorUserAgentIssueDetails* defaultValue) {
       return m_navigatorUserAgentIssueDetails ? m_navigatorUserAgentIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails>& getNavigatorUserAgentIssueDetails() const {
       return m_navigatorUserAgentIssueDetails;
    }
    void setNavigatorUserAgentIssueDetails(std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> value) { m_navigatorUserAgentIssueDetails = std::move(value); }

    bool hasGenericIssueDetails() { return !!m_genericIssueDetails; }
    protocol::Audits::GenericIssueDetails* getGenericIssueDetails(protocol::Audits::GenericIssueDetails* defaultValue) {
       return m_genericIssueDetails ? m_genericIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::GenericIssueDetails>& getGenericIssueDetails() const {
       return m_genericIssueDetails;
    }
    void setGenericIssueDetails(std::unique_ptr<protocol::Audits::GenericIssueDetails> value) { m_genericIssueDetails = std::move(value); }

    bool hasDeprecationIssueDetails() { return !!m_deprecationIssueDetails; }
    protocol::Audits::DeprecationIssueDetails* getDeprecationIssueDetails(protocol::Audits::DeprecationIssueDetails* defaultValue) {
       return m_deprecationIssueDetails ? m_deprecationIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::DeprecationIssueDetails>& getDeprecationIssueDetails() const {
       return m_deprecationIssueDetails;
    }
    void setDeprecationIssueDetails(std::unique_ptr<protocol::Audits::DeprecationIssueDetails> value) { m_deprecationIssueDetails = std::move(value); }

    bool hasClientHintIssueDetails() { return !!m_clientHintIssueDetails; }
    protocol::Audits::ClientHintIssueDetails* getClientHintIssueDetails(protocol::Audits::ClientHintIssueDetails* defaultValue) {
       return m_clientHintIssueDetails ? m_clientHintIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::ClientHintIssueDetails>& getClientHintIssueDetails() const {
       return m_clientHintIssueDetails;
    }
    void setClientHintIssueDetails(std::unique_ptr<protocol::Audits::ClientHintIssueDetails> value) { m_clientHintIssueDetails = std::move(value); }

    bool hasFederatedAuthRequestIssueDetails() { return !!m_federatedAuthRequestIssueDetails; }
    protocol::Audits::FederatedAuthRequestIssueDetails* getFederatedAuthRequestIssueDetails(protocol::Audits::FederatedAuthRequestIssueDetails* defaultValue) {
       return m_federatedAuthRequestIssueDetails ? m_federatedAuthRequestIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails>& getFederatedAuthRequestIssueDetails() const {
       return m_federatedAuthRequestIssueDetails;
    }
    void setFederatedAuthRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> value) { m_federatedAuthRequestIssueDetails = std::move(value); }

    bool hasBounceTrackingIssueDetails() { return !!m_bounceTrackingIssueDetails; }
    protocol::Audits::BounceTrackingIssueDetails* getBounceTrackingIssueDetails(protocol::Audits::BounceTrackingIssueDetails* defaultValue) {
       return m_bounceTrackingIssueDetails ? m_bounceTrackingIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails>& getBounceTrackingIssueDetails() const {
       return m_bounceTrackingIssueDetails;
    }
    void setBounceTrackingIssueDetails(std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> value) { m_bounceTrackingIssueDetails = std::move(value); }

    bool hasCookieDeprecationMetadataIssueDetails() { return !!m_cookieDeprecationMetadataIssueDetails; }
    protocol::Audits::CookieDeprecationMetadataIssueDetails* getCookieDeprecationMetadataIssueDetails(protocol::Audits::CookieDeprecationMetadataIssueDetails* defaultValue) {
       return m_cookieDeprecationMetadataIssueDetails ? m_cookieDeprecationMetadataIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails>& getCookieDeprecationMetadataIssueDetails() const {
       return m_cookieDeprecationMetadataIssueDetails;
    }
    void setCookieDeprecationMetadataIssueDetails(std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> value) { m_cookieDeprecationMetadataIssueDetails = std::move(value); }

    bool hasStylesheetLoadingIssueDetails() { return !!m_stylesheetLoadingIssueDetails; }
    protocol::Audits::StylesheetLoadingIssueDetails* getStylesheetLoadingIssueDetails(protocol::Audits::StylesheetLoadingIssueDetails* defaultValue) {
       return m_stylesheetLoadingIssueDetails ? m_stylesheetLoadingIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails>& getStylesheetLoadingIssueDetails() const {
       return m_stylesheetLoadingIssueDetails;
    }
    void setStylesheetLoadingIssueDetails(std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> value) { m_stylesheetLoadingIssueDetails = std::move(value); }

    bool hasPropertyRuleIssueDetails() { return !!m_propertyRuleIssueDetails; }
    protocol::Audits::PropertyRuleIssueDetails* getPropertyRuleIssueDetails(protocol::Audits::PropertyRuleIssueDetails* defaultValue) {
       return m_propertyRuleIssueDetails ? m_propertyRuleIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails>& getPropertyRuleIssueDetails() const {
       return m_propertyRuleIssueDetails;
    }
    void setPropertyRuleIssueDetails(std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> value) { m_propertyRuleIssueDetails = std::move(value); }

    bool hasFederatedAuthUserInfoRequestIssueDetails() { return !!m_federatedAuthUserInfoRequestIssueDetails; }
    protocol::Audits::FederatedAuthUserInfoRequestIssueDetails* getFederatedAuthUserInfoRequestIssueDetails(protocol::Audits::FederatedAuthUserInfoRequestIssueDetails* defaultValue) {
       return m_federatedAuthUserInfoRequestIssueDetails ? m_federatedAuthUserInfoRequestIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails>& getFederatedAuthUserInfoRequestIssueDetails() const {
       return m_federatedAuthUserInfoRequestIssueDetails;
    }
    void setFederatedAuthUserInfoRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> value) { m_federatedAuthUserInfoRequestIssueDetails = std::move(value); }

    bool hasSharedDictionaryIssueDetails() { return !!m_sharedDictionaryIssueDetails; }
    protocol::Audits::SharedDictionaryIssueDetails* getSharedDictionaryIssueDetails(protocol::Audits::SharedDictionaryIssueDetails* defaultValue) {
       return m_sharedDictionaryIssueDetails ? m_sharedDictionaryIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails>& getSharedDictionaryIssueDetails() const {
       return m_sharedDictionaryIssueDetails;
    }
    void setSharedDictionaryIssueDetails(std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> value) { m_sharedDictionaryIssueDetails = std::move(value); }

    bool hasElementAccessibilityIssueDetails() { return !!m_elementAccessibilityIssueDetails; }
    protocol::Audits::ElementAccessibilityIssueDetails* getElementAccessibilityIssueDetails(protocol::Audits::ElementAccessibilityIssueDetails* defaultValue) {
       return m_elementAccessibilityIssueDetails ? m_elementAccessibilityIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails>& getElementAccessibilityIssueDetails() const {
       return m_elementAccessibilityIssueDetails;
    }
    void setElementAccessibilityIssueDetails(std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> value) { m_elementAccessibilityIssueDetails = std::move(value); }

    bool hasSriMessageSignatureIssueDetails() { return !!m_sriMessageSignatureIssueDetails; }
    protocol::Audits::SRIMessageSignatureIssueDetails* getSriMessageSignatureIssueDetails(protocol::Audits::SRIMessageSignatureIssueDetails* defaultValue) {
       return m_sriMessageSignatureIssueDetails ? m_sriMessageSignatureIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails>& getSriMessageSignatureIssueDetails() const {
       return m_sriMessageSignatureIssueDetails;
    }
    void setSriMessageSignatureIssueDetails(std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> value) { m_sriMessageSignatureIssueDetails = std::move(value); }

    bool hasUnencodedDigestIssueDetails() { return !!m_unencodedDigestIssueDetails; }
    protocol::Audits::UnencodedDigestIssueDetails* getUnencodedDigestIssueDetails(protocol::Audits::UnencodedDigestIssueDetails* defaultValue) {
       return m_unencodedDigestIssueDetails ? m_unencodedDigestIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails>& getUnencodedDigestIssueDetails() const {
       return m_unencodedDigestIssueDetails;
    }
    void setUnencodedDigestIssueDetails(std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> value) { m_unencodedDigestIssueDetails = std::move(value); }

    bool hasUserReidentificationIssueDetails() { return !!m_userReidentificationIssueDetails; }
    protocol::Audits::UserReidentificationIssueDetails* getUserReidentificationIssueDetails(protocol::Audits::UserReidentificationIssueDetails* defaultValue) {
       return m_userReidentificationIssueDetails ? m_userReidentificationIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails>& getUserReidentificationIssueDetails() const {
       return m_userReidentificationIssueDetails;
    }
    void setUserReidentificationIssueDetails(std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> value) { m_userReidentificationIssueDetails = std::move(value); }

    template<int STATE>
    class InspectorIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        InspectorIssueDetailsBuilder<STATE>& setCookieIssueDetails(std::unique_ptr<protocol::Audits::CookieIssueDetails> value)
        {
            m_result->setCookieIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setMixedContentIssueDetails(std::unique_ptr<protocol::Audits::MixedContentIssueDetails> value)
        {
            m_result->setMixedContentIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setBlockedByResponseIssueDetails(std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> value)
        {
            m_result->setBlockedByResponseIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setHeavyAdIssueDetails(std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> value)
        {
            m_result->setHeavyAdIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setContentSecurityPolicyIssueDetails(std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> value)
        {
            m_result->setContentSecurityPolicyIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setSharedArrayBufferIssueDetails(std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> value)
        {
            m_result->setSharedArrayBufferIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setLowTextContrastIssueDetails(std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> value)
        {
            m_result->setLowTextContrastIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setCorsIssueDetails(std::unique_ptr<protocol::Audits::CorsIssueDetails> value)
        {
            m_result->setCorsIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setAttributionReportingIssueDetails(std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> value)
        {
            m_result->setAttributionReportingIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setQuirksModeIssueDetails(std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> value)
        {
            m_result->setQuirksModeIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setPartitioningBlobURLIssueDetails(std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> value)
        {
            m_result->setPartitioningBlobURLIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setNavigatorUserAgentIssueDetails(std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> value)
        {
            m_result->setNavigatorUserAgentIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setGenericIssueDetails(std::unique_ptr<protocol::Audits::GenericIssueDetails> value)
        {
            m_result->setGenericIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setDeprecationIssueDetails(std::unique_ptr<protocol::Audits::DeprecationIssueDetails> value)
        {
            m_result->setDeprecationIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setClientHintIssueDetails(std::unique_ptr<protocol::Audits::ClientHintIssueDetails> value)
        {
            m_result->setClientHintIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setFederatedAuthRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> value)
        {
            m_result->setFederatedAuthRequestIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setBounceTrackingIssueDetails(std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> value)
        {
            m_result->setBounceTrackingIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setCookieDeprecationMetadataIssueDetails(std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> value)
        {
            m_result->setCookieDeprecationMetadataIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setStylesheetLoadingIssueDetails(std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> value)
        {
            m_result->setStylesheetLoadingIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setPropertyRuleIssueDetails(std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> value)
        {
            m_result->setPropertyRuleIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setFederatedAuthUserInfoRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> value)
        {
            m_result->setFederatedAuthUserInfoRequestIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setSharedDictionaryIssueDetails(std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> value)
        {
            m_result->setSharedDictionaryIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setElementAccessibilityIssueDetails(std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> value)
        {
            m_result->setElementAccessibilityIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setSriMessageSignatureIssueDetails(std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> value)
        {
            m_result->setSriMessageSignatureIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setUnencodedDigestIssueDetails(std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> value)
        {
            m_result->setUnencodedDigestIssueDetails(std::move(value));
            return *this;
        }

        InspectorIssueDetailsBuilder<STATE>& setUserReidentificationIssueDetails(std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> value)
        {
            m_result->setUserReidentificationIssueDetails(std::move(value));
            return *this;
        }

        std::unique_ptr<InspectorIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InspectorIssueDetails;
        InspectorIssueDetailsBuilder() : m_result(new InspectorIssueDetails()) { }

        template<int STEP> InspectorIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InspectorIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::InspectorIssueDetails> m_result;
    };

    static InspectorIssueDetailsBuilder<0> create()
    {
        return InspectorIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InspectorIssueDetails()
    {
    }

    std::unique_ptr<protocol::Audits::CookieIssueDetails> m_cookieIssueDetails;
    std::unique_ptr<protocol::Audits::MixedContentIssueDetails> m_mixedContentIssueDetails;
    std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> m_blockedByResponseIssueDetails;
    std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> m_heavyAdIssueDetails;
    std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> m_contentSecurityPolicyIssueDetails;
    std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> m_sharedArrayBufferIssueDetails;
    std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> m_lowTextContrastIssueDetails;
    std::unique_ptr<protocol::Audits::CorsIssueDetails> m_corsIssueDetails;
    std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> m_attributionReportingIssueDetails;
    std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> m_quirksModeIssueDetails;
    std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> m_partitioningBlobURLIssueDetails;
    std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> m_navigatorUserAgentIssueDetails;
    std::unique_ptr<protocol::Audits::GenericIssueDetails> m_genericIssueDetails;
    std::unique_ptr<protocol::Audits::DeprecationIssueDetails> m_deprecationIssueDetails;
    std::unique_ptr<protocol::Audits::ClientHintIssueDetails> m_clientHintIssueDetails;
    std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> m_federatedAuthRequestIssueDetails;
    std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> m_bounceTrackingIssueDetails;
    std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> m_cookieDeprecationMetadataIssueDetails;
    std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> m_stylesheetLoadingIssueDetails;
    std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> m_propertyRuleIssueDetails;
    std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> m_federatedAuthUserInfoRequestIssueDetails;
    std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> m_sharedDictionaryIssueDetails;
    std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> m_elementAccessibilityIssueDetails;
    std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> m_sriMessageSignatureIssueDetails;
    std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> m_unencodedDigestIssueDetails;
    std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> m_userReidentificationIssueDetails;
};


class CORE_EXPORT InspectorIssue : public ::crdtp::ProtocolObject<InspectorIssue> {
public:
    ~InspectorIssue() override { }

    String getCode() { return m_code; }
    void setCode(const String& value) { m_code = value; }

    protocol::Audits::InspectorIssueDetails* getDetails() { return m_details.get(); }
    void setDetails(std::unique_ptr<protocol::Audits::InspectorIssueDetails> value) { m_details = std::move(value); }

    bool hasIssueId() { return !!m_issueId; }
    String getIssueId(const String& defaultValue) const {
       return m_issueId.value_or(defaultValue);
    }
    const std::optional<String>& getIssueId() const {
       return m_issueId;
    }
    void setIssueId(const String& value) { m_issueId = value; }

    template<int STATE>
    class InspectorIssueBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CodeSet = 1 << 1,
            DetailsSet = 1 << 2,
            AllFieldsSet = (CodeSet | DetailsSet | 0)};


        InspectorIssueBuilder<STATE | CodeSet>& setCode(const String& value)
        {
            static_assert(!(STATE & CodeSet), "property code should not be set yet");
            m_result->setCode(value);
            return castState<CodeSet>();
        }

        InspectorIssueBuilder<STATE | DetailsSet>& setDetails(std::unique_ptr<protocol::Audits::InspectorIssueDetails> value)
        {
            static_assert(!(STATE & DetailsSet), "property details should not be set yet");
            m_result->setDetails(std::move(value));
            return castState<DetailsSet>();
        }

        InspectorIssueBuilder<STATE>& setIssueId(const String& value)
        {
            m_result->setIssueId(value);
            return *this;
        }

        std::unique_ptr<InspectorIssue> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InspectorIssue;
        InspectorIssueBuilder() : m_result(new InspectorIssue()) { }

        template<int STEP> InspectorIssueBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InspectorIssueBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::InspectorIssue> m_result;
    };

    static InspectorIssueBuilder<0> create()
    {
        return InspectorIssueBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InspectorIssue()
    {
    }

    String m_code;
    std::unique_ptr<protocol::Audits::InspectorIssueDetails> m_details;
    std::optional<String> m_issueId;
};


// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse getEncodedResponse(const String& in_requestId, const String& in_encoding, std::optional<double> in_quality, std::optional<bool> in_sizeOnly, std::optional<Binary>* out_body, int* out_originalSize, int* out_encodedSize) = 0;
    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse checkContrast(std::optional<bool> in_reportAAA) = 0;
    virtual DispatchResponse checkFormsIssues(std::unique_ptr<protocol::Array<protocol::Audits::GenericIssueDetails>>* out_formIssues) = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void issueAdded(std::unique_ptr<protocol::Audits::InspectorIssue> issue);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Audits
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Audits_h)
