// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Accessibility_h
#define blink_protocol_Accessibility_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/dom.h"

namespace blink {
namespace protocol {
namespace Accessibility {
using AXNodeId = String;
using AXValueType = String;
using AXValueSourceType = String;
using AXValueNativeSourceType = String;
class AXValueSource;
class AXRelatedNode;
class AXProperty;
class AXValue;
using AXPropertyName = String;
class AXNode;

// ------------- Forward and enum declarations.

namespace AXValueTypeEnum {
CORE_EXPORT extern const char Boolean[];
CORE_EXPORT extern const char Tristate[];
CORE_EXPORT extern const char BooleanOrUndefined[];
CORE_EXPORT extern const char Idref[];
CORE_EXPORT extern const char IdrefList[];
CORE_EXPORT extern const char Integer[];
CORE_EXPORT extern const char Node[];
CORE_EXPORT extern const char NodeList[];
CORE_EXPORT extern const char Number[];
CORE_EXPORT extern const char String[];
CORE_EXPORT extern const char ComputedString[];
CORE_EXPORT extern const char Token[];
CORE_EXPORT extern const char TokenList[];
CORE_EXPORT extern const char DomRelation[];
CORE_EXPORT extern const char Role[];
CORE_EXPORT extern const char InternalRole[];
CORE_EXPORT extern const char ValueUndefined[];
} // namespace AXValueTypeEnum

namespace AXValueSourceTypeEnum {
CORE_EXPORT extern const char Attribute[];
CORE_EXPORT extern const char Implicit[];
CORE_EXPORT extern const char Style[];
CORE_EXPORT extern const char Contents[];
CORE_EXPORT extern const char Placeholder[];
CORE_EXPORT extern const char RelatedElement[];
} // namespace AXValueSourceTypeEnum

namespace AXValueNativeSourceTypeEnum {
CORE_EXPORT extern const char Description[];
CORE_EXPORT extern const char Figcaption[];
CORE_EXPORT extern const char Label[];
CORE_EXPORT extern const char Labelfor[];
CORE_EXPORT extern const char Labelwrapped[];
CORE_EXPORT extern const char Legend[];
CORE_EXPORT extern const char Rubyannotation[];
CORE_EXPORT extern const char Tablecaption[];
CORE_EXPORT extern const char Title[];
CORE_EXPORT extern const char Other[];
} // namespace AXValueNativeSourceTypeEnum

namespace AXPropertyNameEnum {
CORE_EXPORT extern const char Actions[];
CORE_EXPORT extern const char Busy[];
CORE_EXPORT extern const char Disabled[];
CORE_EXPORT extern const char Editable[];
CORE_EXPORT extern const char Focusable[];
CORE_EXPORT extern const char Focused[];
CORE_EXPORT extern const char Hidden[];
CORE_EXPORT extern const char HiddenRoot[];
CORE_EXPORT extern const char Invalid[];
CORE_EXPORT extern const char Keyshortcuts[];
CORE_EXPORT extern const char Settable[];
CORE_EXPORT extern const char Roledescription[];
CORE_EXPORT extern const char Live[];
CORE_EXPORT extern const char Atomic[];
CORE_EXPORT extern const char Relevant[];
CORE_EXPORT extern const char Root[];
CORE_EXPORT extern const char Autocomplete[];
CORE_EXPORT extern const char HasPopup[];
CORE_EXPORT extern const char Level[];
CORE_EXPORT extern const char Multiselectable[];
CORE_EXPORT extern const char Orientation[];
CORE_EXPORT extern const char Multiline[];
CORE_EXPORT extern const char Readonly[];
CORE_EXPORT extern const char Required[];
CORE_EXPORT extern const char Valuemin[];
CORE_EXPORT extern const char Valuemax[];
CORE_EXPORT extern const char Valuetext[];
CORE_EXPORT extern const char Checked[];
CORE_EXPORT extern const char Expanded[];
CORE_EXPORT extern const char Modal[];
CORE_EXPORT extern const char Pressed[];
CORE_EXPORT extern const char Selected[];
CORE_EXPORT extern const char Activedescendant[];
CORE_EXPORT extern const char Controls[];
CORE_EXPORT extern const char Describedby[];
CORE_EXPORT extern const char Details[];
CORE_EXPORT extern const char Errormessage[];
CORE_EXPORT extern const char Flowto[];
CORE_EXPORT extern const char Labelledby[];
CORE_EXPORT extern const char Owns[];
CORE_EXPORT extern const char Url[];
CORE_EXPORT extern const char ActiveFullscreenElement[];
CORE_EXPORT extern const char ActiveModalDialog[];
CORE_EXPORT extern const char ActiveAriaModalDialog[];
CORE_EXPORT extern const char AriaHiddenElement[];
CORE_EXPORT extern const char AriaHiddenSubtree[];
CORE_EXPORT extern const char EmptyAlt[];
CORE_EXPORT extern const char EmptyText[];
CORE_EXPORT extern const char InertElement[];
CORE_EXPORT extern const char InertSubtree[];
CORE_EXPORT extern const char LabelContainer[];
CORE_EXPORT extern const char LabelFor[];
CORE_EXPORT extern const char NotRendered[];
CORE_EXPORT extern const char NotVisible[];
CORE_EXPORT extern const char PresentationalRole[];
CORE_EXPORT extern const char ProbablyPresentational[];
CORE_EXPORT extern const char InactiveCarouselTabContent[];
CORE_EXPORT extern const char Uninteresting[];
} // namespace AXPropertyNameEnum

// ------------- Type and builder declarations.

class CORE_EXPORT AXValueSource : public ::crdtp::ProtocolObject<AXValueSource> {
public:
    ~AXValueSource() override { }

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    bool hasValue() { return !!m_value; }
    protocol::Accessibility::AXValue* getValue(protocol::Accessibility::AXValue* defaultValue) {
       return m_value ? m_value.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Accessibility::AXValue>& getValue() const {
       return m_value;
    }
    void setValue(std::unique_ptr<protocol::Accessibility::AXValue> value) { m_value = std::move(value); }

    bool hasAttribute() { return !!m_attribute; }
    String getAttribute(const String& defaultValue) const {
       return m_attribute.value_or(defaultValue);
    }
    const std::optional<String>& getAttribute() const {
       return m_attribute;
    }
    void setAttribute(const String& value) { m_attribute = value; }

    bool hasAttributeValue() { return !!m_attributeValue; }
    protocol::Accessibility::AXValue* getAttributeValue(protocol::Accessibility::AXValue* defaultValue) {
       return m_attributeValue ? m_attributeValue.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Accessibility::AXValue>& getAttributeValue() const {
       return m_attributeValue;
    }
    void setAttributeValue(std::unique_ptr<protocol::Accessibility::AXValue> value) { m_attributeValue = std::move(value); }

    bool hasSuperseded() { return !!m_superseded; }
    bool getSuperseded(bool defaultValue) const {
       return m_superseded.value_or(defaultValue);
    }
    const std::optional<bool>& getSuperseded() const {
       return m_superseded;
    }
    void setSuperseded(bool value) { m_superseded = value; }

    bool hasNativeSource() { return !!m_nativeSource; }
    String getNativeSource(const String& defaultValue) const {
       return m_nativeSource.value_or(defaultValue);
    }
    const std::optional<String>& getNativeSource() const {
       return m_nativeSource;
    }
    void setNativeSource(const String& value) { m_nativeSource = value; }

    bool hasNativeSourceValue() { return !!m_nativeSourceValue; }
    protocol::Accessibility::AXValue* getNativeSourceValue(protocol::Accessibility::AXValue* defaultValue) {
       return m_nativeSourceValue ? m_nativeSourceValue.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Accessibility::AXValue>& getNativeSourceValue() const {
       return m_nativeSourceValue;
    }
    void setNativeSourceValue(std::unique_ptr<protocol::Accessibility::AXValue> value) { m_nativeSourceValue = std::move(value); }

    bool hasInvalid() { return !!m_invalid; }
    bool getInvalid(bool defaultValue) const {
       return m_invalid.value_or(defaultValue);
    }
    const std::optional<bool>& getInvalid() const {
       return m_invalid;
    }
    void setInvalid(bool value) { m_invalid = value; }

    bool hasInvalidReason() { return !!m_invalidReason; }
    String getInvalidReason(const String& defaultValue) const {
       return m_invalidReason.value_or(defaultValue);
    }
    const std::optional<String>& getInvalidReason() const {
       return m_invalidReason;
    }
    void setInvalidReason(const String& value) { m_invalidReason = value; }

    template<int STATE>
    class AXValueSourceBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        AXValueSourceBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        AXValueSourceBuilder<STATE>& setValue(std::unique_ptr<protocol::Accessibility::AXValue> value)
        {
            m_result->setValue(std::move(value));
            return *this;
        }

        AXValueSourceBuilder<STATE>& setAttribute(const String& value)
        {
            m_result->setAttribute(value);
            return *this;
        }

        AXValueSourceBuilder<STATE>& setAttributeValue(std::unique_ptr<protocol::Accessibility::AXValue> value)
        {
            m_result->setAttributeValue(std::move(value));
            return *this;
        }

        AXValueSourceBuilder<STATE>& setSuperseded(bool value)
        {
            m_result->setSuperseded(value);
            return *this;
        }

        AXValueSourceBuilder<STATE>& setNativeSource(const String& value)
        {
            m_result->setNativeSource(value);
            return *this;
        }

        AXValueSourceBuilder<STATE>& setNativeSourceValue(std::unique_ptr<protocol::Accessibility::AXValue> value)
        {
            m_result->setNativeSourceValue(std::move(value));
            return *this;
        }

        AXValueSourceBuilder<STATE>& setInvalid(bool value)
        {
            m_result->setInvalid(value);
            return *this;
        }

        AXValueSourceBuilder<STATE>& setInvalidReason(const String& value)
        {
            m_result->setInvalidReason(value);
            return *this;
        }

        std::unique_ptr<AXValueSource> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AXValueSource;
        AXValueSourceBuilder() : m_result(new AXValueSource()) { }

        template<int STEP> AXValueSourceBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AXValueSourceBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Accessibility::AXValueSource> m_result;
    };

    static AXValueSourceBuilder<0> create()
    {
        return AXValueSourceBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AXValueSource()
    {
    }

    String m_type;
    std::unique_ptr<protocol::Accessibility::AXValue> m_value;
    std::optional<String> m_attribute;
    std::unique_ptr<protocol::Accessibility::AXValue> m_attributeValue;
    std::optional<bool> m_superseded;
    std::optional<String> m_nativeSource;
    std::unique_ptr<protocol::Accessibility::AXValue> m_nativeSourceValue;
    std::optional<bool> m_invalid;
    std::optional<String> m_invalidReason;
};


class CORE_EXPORT AXRelatedNode : public ::crdtp::ProtocolObject<AXRelatedNode> {
public:
    ~AXRelatedNode() override { }

    int getBackendDOMNodeId() { return m_backendDOMNodeId; }
    void setBackendDOMNodeId(int value) { m_backendDOMNodeId = value; }

    bool hasIdref() { return !!m_idref; }
    String getIdref(const String& defaultValue) const {
       return m_idref.value_or(defaultValue);
    }
    const std::optional<String>& getIdref() const {
       return m_idref;
    }
    void setIdref(const String& value) { m_idref = value; }

    bool hasText() { return !!m_text; }
    String getText(const String& defaultValue) const {
       return m_text.value_or(defaultValue);
    }
    const std::optional<String>& getText() const {
       return m_text;
    }
    void setText(const String& value) { m_text = value; }

    template<int STATE>
    class AXRelatedNodeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            BackendDOMNodeIdSet = 1 << 1,
            AllFieldsSet = (BackendDOMNodeIdSet | 0)};


        AXRelatedNodeBuilder<STATE | BackendDOMNodeIdSet>& setBackendDOMNodeId(int value)
        {
            static_assert(!(STATE & BackendDOMNodeIdSet), "property backendDOMNodeId should not be set yet");
            m_result->setBackendDOMNodeId(value);
            return castState<BackendDOMNodeIdSet>();
        }

        AXRelatedNodeBuilder<STATE>& setIdref(const String& value)
        {
            m_result->setIdref(value);
            return *this;
        }

        AXRelatedNodeBuilder<STATE>& setText(const String& value)
        {
            m_result->setText(value);
            return *this;
        }

        std::unique_ptr<AXRelatedNode> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AXRelatedNode;
        AXRelatedNodeBuilder() : m_result(new AXRelatedNode()) { }

        template<int STEP> AXRelatedNodeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AXRelatedNodeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Accessibility::AXRelatedNode> m_result;
    };

    static AXRelatedNodeBuilder<0> create()
    {
        return AXRelatedNodeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AXRelatedNode()
    {
          m_backendDOMNodeId = 0;
    }

    int m_backendDOMNodeId;
    std::optional<String> m_idref;
    std::optional<String> m_text;
};


class CORE_EXPORT AXProperty : public ::crdtp::ProtocolObject<AXProperty> {
public:
    ~AXProperty() override { }

    String getName() { return m_name; }
    void setName(const String& value) { m_name = value; }

    protocol::Accessibility::AXValue* getValue() { return m_value.get(); }
    void setValue(std::unique_ptr<protocol::Accessibility::AXValue> value) { m_value = std::move(value); }

    template<int STATE>
    class AXPropertyBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            ValueSet = 1 << 2,
            AllFieldsSet = (NameSet | ValueSet | 0)};


        AXPropertyBuilder<STATE | NameSet>& setName(const String& value)
        {
            static_assert(!(STATE & NameSet), "property name should not be set yet");
            m_result->setName(value);
            return castState<NameSet>();
        }

        AXPropertyBuilder<STATE | ValueSet>& setValue(std::unique_ptr<protocol::Accessibility::AXValue> value)
        {
            static_assert(!(STATE & ValueSet), "property value should not be set yet");
            m_result->setValue(std::move(value));
            return castState<ValueSet>();
        }

        std::unique_ptr<AXProperty> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AXProperty;
        AXPropertyBuilder() : m_result(new AXProperty()) { }

        template<int STEP> AXPropertyBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AXPropertyBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Accessibility::AXProperty> m_result;
    };

    static AXPropertyBuilder<0> create()
    {
        return AXPropertyBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AXProperty()
    {
    }

    String m_name;
    std::unique_ptr<protocol::Accessibility::AXValue> m_value;
};


class CORE_EXPORT AXValue : public ::crdtp::ProtocolObject<AXValue> {
public:
    ~AXValue() override { }

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    bool hasValue() { return !!m_value; }
    protocol::Value* getValue(protocol::Value* defaultValue) {
       return m_value ? m_value.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Value>& getValue() const {
       return m_value;
    }
    void setValue(std::unique_ptr<protocol::Value> value) { m_value = std::move(value); }

    bool hasRelatedNodes() { return !!m_relatedNodes; }
    protocol::Array<protocol::Accessibility::AXRelatedNode>* getRelatedNodes(protocol::Array<protocol::Accessibility::AXRelatedNode>* defaultValue) {
       return m_relatedNodes ? m_relatedNodes.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Accessibility::AXRelatedNode>>& getRelatedNodes() const {
       return m_relatedNodes;
    }
    void setRelatedNodes(std::unique_ptr<protocol::Array<protocol::Accessibility::AXRelatedNode>> value) { m_relatedNodes = std::move(value); }

    bool hasSources() { return !!m_sources; }
    protocol::Array<protocol::Accessibility::AXValueSource>* getSources(protocol::Array<protocol::Accessibility::AXValueSource>* defaultValue) {
       return m_sources ? m_sources.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Accessibility::AXValueSource>>& getSources() const {
       return m_sources;
    }
    void setSources(std::unique_ptr<protocol::Array<protocol::Accessibility::AXValueSource>> value) { m_sources = std::move(value); }

    template<int STATE>
    class AXValueBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        AXValueBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        AXValueBuilder<STATE>& setValue(std::unique_ptr<protocol::Value> value)
        {
            m_result->setValue(std::move(value));
            return *this;
        }

        AXValueBuilder<STATE>& setRelatedNodes(std::unique_ptr<protocol::Array<protocol::Accessibility::AXRelatedNode>> value)
        {
            m_result->setRelatedNodes(std::move(value));
            return *this;
        }

        AXValueBuilder<STATE>& setSources(std::unique_ptr<protocol::Array<protocol::Accessibility::AXValueSource>> value)
        {
            m_result->setSources(std::move(value));
            return *this;
        }

        std::unique_ptr<AXValue> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AXValue;
        AXValueBuilder() : m_result(new AXValue()) { }

        template<int STEP> AXValueBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AXValueBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Accessibility::AXValue> m_result;
    };

    static AXValueBuilder<0> create()
    {
        return AXValueBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AXValue()
    {
    }

    String m_type;
    std::unique_ptr<protocol::Value> m_value;
    std::unique_ptr<protocol::Array<protocol::Accessibility::AXRelatedNode>> m_relatedNodes;
    std::unique_ptr<protocol::Array<protocol::Accessibility::AXValueSource>> m_sources;
};


class CORE_EXPORT AXNode : public ::crdtp::ProtocolObject<AXNode> {
public:
    ~AXNode() override { }

    String getNodeId() { return m_nodeId; }
    void setNodeId(const String& value) { m_nodeId = value; }

    bool getIgnored() { return m_ignored; }
    void setIgnored(bool value) { m_ignored = value; }

    bool hasIgnoredReasons() { return !!m_ignoredReasons; }
    protocol::Array<protocol::Accessibility::AXProperty>* getIgnoredReasons(protocol::Array<protocol::Accessibility::AXProperty>* defaultValue) {
       return m_ignoredReasons ? m_ignoredReasons.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Accessibility::AXProperty>>& getIgnoredReasons() const {
       return m_ignoredReasons;
    }
    void setIgnoredReasons(std::unique_ptr<protocol::Array<protocol::Accessibility::AXProperty>> value) { m_ignoredReasons = std::move(value); }

    bool hasRole() { return !!m_role; }
    protocol::Accessibility::AXValue* getRole(protocol::Accessibility::AXValue* defaultValue) {
       return m_role ? m_role.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Accessibility::AXValue>& getRole() const {
       return m_role;
    }
    void setRole(std::unique_ptr<protocol::Accessibility::AXValue> value) { m_role = std::move(value); }

    bool hasChromeRole() { return !!m_chromeRole; }
    protocol::Accessibility::AXValue* getChromeRole(protocol::Accessibility::AXValue* defaultValue) {
       return m_chromeRole ? m_chromeRole.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Accessibility::AXValue>& getChromeRole() const {
       return m_chromeRole;
    }
    void setChromeRole(std::unique_ptr<protocol::Accessibility::AXValue> value) { m_chromeRole = std::move(value); }

    bool hasName() { return !!m_name; }
    protocol::Accessibility::AXValue* getName(protocol::Accessibility::AXValue* defaultValue) {
       return m_name ? m_name.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Accessibility::AXValue>& getName() const {
       return m_name;
    }
    void setName(std::unique_ptr<protocol::Accessibility::AXValue> value) { m_name = std::move(value); }

    bool hasDescription() { return !!m_description; }
    protocol::Accessibility::AXValue* getDescription(protocol::Accessibility::AXValue* defaultValue) {
       return m_description ? m_description.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Accessibility::AXValue>& getDescription() const {
       return m_description;
    }
    void setDescription(std::unique_ptr<protocol::Accessibility::AXValue> value) { m_description = std::move(value); }

    bool hasValue() { return !!m_value; }
    protocol::Accessibility::AXValue* getValue(protocol::Accessibility::AXValue* defaultValue) {
       return m_value ? m_value.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Accessibility::AXValue>& getValue() const {
       return m_value;
    }
    void setValue(std::unique_ptr<protocol::Accessibility::AXValue> value) { m_value = std::move(value); }

    bool hasProperties() { return !!m_properties; }
    protocol::Array<protocol::Accessibility::AXProperty>* getProperties(protocol::Array<protocol::Accessibility::AXProperty>* defaultValue) {
       return m_properties ? m_properties.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::Accessibility::AXProperty>>& getProperties() const {
       return m_properties;
    }
    void setProperties(std::unique_ptr<protocol::Array<protocol::Accessibility::AXProperty>> value) { m_properties = std::move(value); }

    bool hasParentId() { return !!m_parentId; }
    String getParentId(const String& defaultValue) const {
       return m_parentId.value_or(defaultValue);
    }
    const std::optional<String>& getParentId() const {
       return m_parentId;
    }
    void setParentId(const String& value) { m_parentId = value; }

    bool hasChildIds() { return !!m_childIds; }
    protocol::Array<String>* getChildIds(protocol::Array<String>* defaultValue) {
       return m_childIds ? m_childIds.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& getChildIds() const {
       return m_childIds;
    }
    void setChildIds(std::unique_ptr<protocol::Array<String>> value) { m_childIds = std::move(value); }

    bool hasBackendDOMNodeId() { return !!m_backendDOMNodeId; }
    int getBackendDOMNodeId(int defaultValue) const {
       return m_backendDOMNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getBackendDOMNodeId() const {
       return m_backendDOMNodeId;
    }
    void setBackendDOMNodeId(int value) { m_backendDOMNodeId = value; }

    bool hasFrameId() { return !!m_frameId; }
    String getFrameId(const String& defaultValue) const {
       return m_frameId.value_or(defaultValue);
    }
    const std::optional<String>& getFrameId() const {
       return m_frameId;
    }
    void setFrameId(const String& value) { m_frameId = value; }

    template<int STATE>
    class AXNodeBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NodeIdSet = 1 << 1,
            IgnoredSet = 1 << 2,
            AllFieldsSet = (NodeIdSet | IgnoredSet | 0)};


        AXNodeBuilder<STATE | NodeIdSet>& setNodeId(const String& value)
        {
            static_assert(!(STATE & NodeIdSet), "property nodeId should not be set yet");
            m_result->setNodeId(value);
            return castState<NodeIdSet>();
        }

        AXNodeBuilder<STATE | IgnoredSet>& setIgnored(bool value)
        {
            static_assert(!(STATE & IgnoredSet), "property ignored should not be set yet");
            m_result->setIgnored(value);
            return castState<IgnoredSet>();
        }

        AXNodeBuilder<STATE>& setIgnoredReasons(std::unique_ptr<protocol::Array<protocol::Accessibility::AXProperty>> value)
        {
            m_result->setIgnoredReasons(std::move(value));
            return *this;
        }

        AXNodeBuilder<STATE>& setRole(std::unique_ptr<protocol::Accessibility::AXValue> value)
        {
            m_result->setRole(std::move(value));
            return *this;
        }

        AXNodeBuilder<STATE>& setChromeRole(std::unique_ptr<protocol::Accessibility::AXValue> value)
        {
            m_result->setChromeRole(std::move(value));
            return *this;
        }

        AXNodeBuilder<STATE>& setName(std::unique_ptr<protocol::Accessibility::AXValue> value)
        {
            m_result->setName(std::move(value));
            return *this;
        }

        AXNodeBuilder<STATE>& setDescription(std::unique_ptr<protocol::Accessibility::AXValue> value)
        {
            m_result->setDescription(std::move(value));
            return *this;
        }

        AXNodeBuilder<STATE>& setValue(std::unique_ptr<protocol::Accessibility::AXValue> value)
        {
            m_result->setValue(std::move(value));
            return *this;
        }

        AXNodeBuilder<STATE>& setProperties(std::unique_ptr<protocol::Array<protocol::Accessibility::AXProperty>> value)
        {
            m_result->setProperties(std::move(value));
            return *this;
        }

        AXNodeBuilder<STATE>& setParentId(const String& value)
        {
            m_result->setParentId(value);
            return *this;
        }

        AXNodeBuilder<STATE>& setChildIds(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->setChildIds(std::move(value));
            return *this;
        }

        AXNodeBuilder<STATE>& setBackendDOMNodeId(int value)
        {
            m_result->setBackendDOMNodeId(value);
            return *this;
        }

        AXNodeBuilder<STATE>& setFrameId(const String& value)
        {
            m_result->setFrameId(value);
            return *this;
        }

        std::unique_ptr<AXNode> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AXNode;
        AXNodeBuilder() : m_result(new AXNode()) { }

        template<int STEP> AXNodeBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AXNodeBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Accessibility::AXNode> m_result;
    };

    static AXNodeBuilder<0> create()
    {
        return AXNodeBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AXNode()
    {
          m_ignored = false;
    }

    String m_nodeId;
    bool m_ignored;
    std::unique_ptr<protocol::Array<protocol::Accessibility::AXProperty>> m_ignoredReasons;
    std::unique_ptr<protocol::Accessibility::AXValue> m_role;
    std::unique_ptr<protocol::Accessibility::AXValue> m_chromeRole;
    std::unique_ptr<protocol::Accessibility::AXValue> m_name;
    std::unique_ptr<protocol::Accessibility::AXValue> m_description;
    std::unique_ptr<protocol::Accessibility::AXValue> m_value;
    std::unique_ptr<protocol::Array<protocol::Accessibility::AXProperty>> m_properties;
    std::optional<String> m_parentId;
    std::unique_ptr<protocol::Array<String>> m_childIds;
    std::optional<int> m_backendDOMNodeId;
    std::optional<String> m_frameId;
};


// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse getPartialAXTree(std::optional<int> in_nodeId, std::optional<int> in_backendNodeId, std::optional<String> in_objectId, std::optional<bool> in_fetchRelatives, std::unique_ptr<protocol::Array<protocol::Accessibility::AXNode>>* out_nodes) = 0;
    virtual DispatchResponse getFullAXTree(std::optional<int> in_depth, std::optional<String> in_frameId, std::unique_ptr<protocol::Array<protocol::Accessibility::AXNode>>* out_nodes) = 0;
    virtual DispatchResponse getRootAXNode(std::optional<String> in_frameId, std::unique_ptr<protocol::Accessibility::AXNode>* out_node) = 0;
    virtual DispatchResponse getAXNodeAndAncestors(std::optional<int> in_nodeId, std::optional<int> in_backendNodeId, std::optional<String> in_objectId, std::unique_ptr<protocol::Array<protocol::Accessibility::AXNode>>* out_nodes) = 0;
    virtual DispatchResponse getChildAXNodes(const String& in_id, std::optional<String> in_frameId, std::unique_ptr<protocol::Array<protocol::Accessibility::AXNode>>* out_nodes) = 0;
    class CORE_EXPORT QueryAXTreeCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<protocol::Accessibility::AXNode>> nodes) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~QueryAXTreeCallback() { }
    };
    virtual void queryAXTree(std::optional<int> in_nodeId, std::optional<int> in_backendNodeId, std::optional<String> in_objectId, std::optional<String> in_accessibleName, std::optional<String> in_role, std::unique_ptr<QueryAXTreeCallback> callback) = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void loadComplete(std::unique_ptr<protocol::Accessibility::AXNode> root);
    void nodesUpdated(std::unique_ptr<protocol::Array<protocol::Accessibility::AXNode>> nodes);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Accessibility
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Accessibility_h)
