// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_CSS_PARSER_AT_RULE_DESCRIPTORS_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_CSS_PARSER_AT_RULE_DESCRIPTORS_H_

#include "base/notreached.h"
#include "third_party/blink/renderer/core/css/css_property_names.h"
#include "third_party/blink/renderer/platform/wtf/text/string_view.h"
#include <string.h>

namespace blink {

enum class AtRuleDescriptorID {
  Invalid = 0,
  Variable = 1,
  AdditiveSymbols = 2,
  AscentOverride = 3,
  BasePalette = 4,
  DescentOverride = 5,
  FontDisplay = 6,
  FontFamily = 7,
  FontFeatureSettings = 8,
  FontVariationSettings = 9,
  FontStretch = 10,
  FontStyle = 11,
  FontVariant = 12,
  FontWeight = 13,
  Inherits = 14,
  InitialValue = 15,
  Fallback = 16,
  LineGapOverride = 17,
  Negative = 18,
  OverrideColors = 19,
  Pad = 20,
  Prefix = 21,
  Range = 22,
  Result = 23,
  Navigation = 24,
  Types = 25,
  SizeAdjust = 26,
  SpeakAs = 27,
  Src = 28,
  Suffix = 29,
  Symbols = 30,
  Syntax = 31,
  System = 32,
  UnicodeRange = 33,
};

const int numAtRuleDescriptors = 34;

const char* getValueName(AtRuleDescriptorID);

AtRuleDescriptorID AsAtRuleDescriptorID(StringView string);

CSSPropertyID AtRuleDescriptorIDAsCSSPropertyID(AtRuleDescriptorID);
AtRuleDescriptorID CSSPropertyIDAsAtRuleDescriptor(CSSPropertyID id);

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_CORE_CSS_PARSER_AT_RULE_DESCRIPTORS_H_
