// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_CSS_CSS_PROPERTY_NAMES_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_CSS_CSS_PROPERTY_NAMES_H_

#include <stddef.h>

#include "base/check_op.h"
#include "third_party/blink/public/mojom/use_counter/metrics/css_property_id.mojom-blink-forward.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/wtf/allocator/allocator.h"
#include "third_party/blink/renderer/platform/wtf/forward.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/hash_traits.h"

namespace blink {

class ExecutionContext;

enum class CSSPropertyID {
    kInvalid = 0,
    kVariable = 1,
    kColorScheme = 2,
    kForcedColorAdjust = 3,
    kMaskImage = 4,
    kMathDepth = 5,
    kPosition = 6,
    kPositionAnchor = 7,
    kTextSizeAdjust = 8,
    kInternalVisitedColor = 9,
    kAppearance = 10,
    kColor = 11,
    kDirection = 12,
    kFontFamily = 13,
    kFontFeatureSettings = 14,
    kFontKerning = 15,
    kFontLanguageOverride = 16,
    kFontOpticalSizing = 17,
    kFontPalette = 18,
    kFontSize = 19,
    kFontSizeAdjust = 20,
    kFontStretch = 21,
    kFontStyle = 22,
    kFontSynthesisSmallCaps = 23,
    kFontSynthesisStyle = 24,
    kFontSynthesisWeight = 25,
    kFontVariantAlternates = 26,
    kFontVariantCaps = 27,
    kFontVariantEastAsian = 28,
    kFontVariantEmoji = 29,
    kFontVariantLigatures = 30,
    kFontVariantNumeric = 31,
    kFontVariantPosition = 32,
    kFontVariationSettings = 33,
    kFontWeight = 34,
    kPositionArea = 35,
    kTextOrientation = 36,
    kTextRendering = 37,
    kTextSpacingTrim = 38,
    kWebkitFontSmoothing = 39,
    kWebkitLocale = 40,
    kWebkitTextOrientation = 41,
    kWebkitWritingMode = 42,
    kWritingMode = 43,
    kZoom = 44,
    kInternalForcedVisitedColor = 45,
    kInternalVisitedBackgroundColor = 46,
    kInternalVisitedBorderBlockEndColor = 47,
    kInternalVisitedBorderBlockStartColor = 48,
    kInternalVisitedBorderBottomColor = 49,
    kInternalVisitedBorderInlineEndColor = 50,
    kInternalVisitedBorderInlineStartColor = 51,
    kInternalVisitedBorderLeftColor = 52,
    kInternalVisitedBorderRightColor = 53,
    kInternalVisitedBorderTopColor = 54,
    kInternalVisitedCaretColor = 55,
    kInternalVisitedColumnRuleColor = 56,
    kInternalVisitedFill = 57,
    kInternalVisitedOutlineColor = 58,
    kInternalVisitedStroke = 59,
    kInternalVisitedTextDecorationColor = 60,
    kInternalVisitedTextEmphasisColor = 61,
    kInternalVisitedTextFillColor = 62,
    kInternalVisitedTextStrokeColor = 63,
    kAccentColor = 64,
    kAdditiveSymbols = 65,
    kAlignContent = 66,
    kAlignItems = 67,
    kAlignSelf = 68,
    kAlignmentBaseline = 69,
    kAll = 70,
    kAnchorName = 71,
    kAnchorScope = 72,
    kAnimationComposition = 73,
    kAnimationDelay = 74,
    kAnimationDirection = 75,
    kAnimationDuration = 76,
    kAnimationFillMode = 77,
    kAnimationIterationCount = 78,
    kAnimationName = 79,
    kAnimationPlayState = 80,
    kAnimationRangeEnd = 81,
    kAnimationRangeStart = 82,
    kAnimationTimeline = 83,
    kAnimationTimingFunction = 84,
    kAnimationTrigger = 85,
    kAppRegion = 86,
    kAscentOverride = 87,
    kAspectRatio = 88,
    kBackdropFilter = 89,
    kBackfaceVisibility = 90,
    kBackgroundAttachment = 91,
    kBackgroundBlendMode = 92,
    kBackgroundClip = 93,
    kBackgroundColor = 94,
    kBackgroundImage = 95,
    kBackgroundOrigin = 96,
    kBackgroundPositionX = 97,
    kBackgroundPositionY = 98,
    kBackgroundRepeat = 99,
    kBackgroundSize = 100,
    kBasePalette = 101,
    kBaselineShift = 102,
    kBaselineSource = 103,
    kBlockEllipsis = 104,
    kBlockSize = 105,
    kBorderBlockEndColor = 106,
    kBorderBlockEndStyle = 107,
    kBorderBlockEndWidth = 108,
    kBorderBlockStartColor = 109,
    kBorderBlockStartStyle = 110,
    kBorderBlockStartWidth = 111,
    kBorderBottomColor = 112,
    kBorderBottomLeftRadius = 113,
    kBorderBottomRightRadius = 114,
    kBorderBottomStyle = 115,
    kBorderBottomWidth = 116,
    kBorderCollapse = 117,
    kBorderEndEndRadius = 118,
    kBorderEndStartRadius = 119,
    kBorderImageOutset = 120,
    kBorderImageRepeat = 121,
    kBorderImageSlice = 122,
    kBorderImageSource = 123,
    kBorderImageWidth = 124,
    kBorderInlineEndColor = 125,
    kBorderInlineEndStyle = 126,
    kBorderInlineEndWidth = 127,
    kBorderInlineStartColor = 128,
    kBorderInlineStartStyle = 129,
    kBorderInlineStartWidth = 130,
    kBorderLeftColor = 131,
    kBorderLeftStyle = 132,
    kBorderLeftWidth = 133,
    kBorderRightColor = 134,
    kBorderRightStyle = 135,
    kBorderRightWidth = 136,
    kBorderShape = 137,
    kBorderStartEndRadius = 138,
    kBorderStartStartRadius = 139,
    kBorderTopColor = 140,
    kBorderTopLeftRadius = 141,
    kBorderTopRightRadius = 142,
    kBorderTopStyle = 143,
    kBorderTopWidth = 144,
    kBottom = 145,
    kBoxDecorationBreak = 146,
    kBoxShadow = 147,
    kBoxSizing = 148,
    kBreakAfter = 149,
    kBreakBefore = 150,
    kBreakInside = 151,
    kBufferedRendering = 152,
    kCaptionSide = 153,
    kCaretAnimation = 154,
    kCaretColor = 155,
    kCaretShape = 156,
    kClear = 157,
    kClip = 158,
    kClipPath = 159,
    kClipRule = 160,
    kColorInterpolation = 161,
    kColorInterpolationFilters = 162,
    kColorRendering = 163,
    kColumnCount = 164,
    kColumnFill = 165,
    kColumnGap = 166,
    kColumnHeight = 167,
    kColumnRuleBreak = 168,
    kColumnRuleColor = 169,
    kColumnRuleOutset = 170,
    kColumnRuleStyle = 171,
    kColumnRuleWidth = 172,
    kColumnSpan = 173,
    kColumnWidth = 174,
    kColumnWrap = 175,
    kContain = 176,
    kContainIntrinsicBlockSize = 177,
    kContainIntrinsicHeight = 178,
    kContainIntrinsicInlineSize = 179,
    kContainIntrinsicWidth = 180,
    kContainerName = 181,
    kContainerType = 182,
    kContent = 183,
    kContentVisibility = 184,
    kContinue = 185,
    kCornerBottomLeftShape = 186,
    kCornerBottomRightShape = 187,
    kCornerEndEndShape = 188,
    kCornerEndStartShape = 189,
    kCornerStartEndShape = 190,
    kCornerStartStartShape = 191,
    kCornerTopLeftShape = 192,
    kCornerTopRightShape = 193,
    kCounterIncrement = 194,
    kCounterReset = 195,
    kCounterSet = 196,
    kCursor = 197,
    kCx = 198,
    kCy = 199,
    kD = 200,
    kDescentOverride = 201,
    kDisplay = 202,
    kDominantBaseline = 203,
    kDynamicRangeLimit = 204,
    kEmptyCells = 205,
    kFallback = 206,
    kFieldSizing = 207,
    kFill = 208,
    kFillOpacity = 209,
    kFillRule = 210,
    kFilter = 211,
    kFlexBasis = 212,
    kFlexDirection = 213,
    kFlexGrow = 214,
    kFlexShrink = 215,
    kFlexWrap = 216,
    kFloat = 217,
    kFloodColor = 218,
    kFloodOpacity = 219,
    kFontDisplay = 220,
    kGapRuleOverlap = 221,
    kGridAutoColumns = 222,
    kGridAutoFlow = 223,
    kGridAutoRows = 224,
    kGridColumnEnd = 225,
    kGridColumnStart = 226,
    kGridRowEnd = 227,
    kGridRowStart = 228,
    kGridTemplateAreas = 229,
    kGridTemplateColumns = 230,
    kGridTemplateRows = 231,
    kHeight = 232,
    kHyphenateCharacter = 233,
    kHyphenateLimitChars = 234,
    kHyphens = 235,
    kImageOrientation = 236,
    kImageRendering = 237,
    kInherits = 238,
    kInitialLetter = 239,
    kInitialValue = 240,
    kInlineSize = 241,
    kInsetBlockEnd = 242,
    kInsetBlockStart = 243,
    kInsetInlineEnd = 244,
    kInsetInlineStart = 245,
    kInteractivity = 246,
    kInterestDelayEnd = 247,
    kInterestDelayStart = 248,
    kInternalAlignContentBlock = 249,
    kInternalEmptyLineHeight = 250,
    kInternalFontSizeDelta = 251,
    kInternalForcedBackgroundColor = 252,
    kInternalForcedBorderColor = 253,
    kInternalForcedColor = 254,
    kInternalForcedOutlineColor = 255,
    kInterpolateSize = 256,
    kIsolation = 257,
    kItemTolerance = 258,
    kJustifyContent = 259,
    kJustifyItems = 260,
    kJustifySelf = 261,
    kLeft = 262,
    kLetterSpacing = 263,
    kLightingColor = 264,
    kLineBreak = 265,
    kLineGapOverride = 266,
    kLineHeight = 267,
    kListStyleImage = 268,
    kListStylePosition = 269,
    kListStyleType = 270,
    kMarginBlockEnd = 271,
    kMarginBlockStart = 272,
    kMarginBottom = 273,
    kMarginInlineEnd = 274,
    kMarginInlineStart = 275,
    kMarginLeft = 276,
    kMarginRight = 277,
    kMarginTop = 278,
    kMarkerEnd = 279,
    kMarkerMid = 280,
    kMarkerStart = 281,
    kMaskClip = 282,
    kMaskComposite = 283,
    kMaskMode = 284,
    kMaskOrigin = 285,
    kMaskRepeat = 286,
    kMaskSize = 287,
    kMaskType = 288,
    kMasonryDirection = 289,
    kMasonryFill = 290,
    kMathShift = 291,
    kMathStyle = 292,
    kMaxBlockSize = 293,
    kMaxHeight = 294,
    kMaxInlineSize = 295,
    kMaxLines = 296,
    kMaxWidth = 297,
    kMinBlockSize = 298,
    kMinHeight = 299,
    kMinInlineSize = 300,
    kMinWidth = 301,
    kMixBlendMode = 302,
    kNavigation = 303,
    kNegative = 304,
    kObjectFit = 305,
    kObjectPosition = 306,
    kObjectViewBox = 307,
    kOffsetAnchor = 308,
    kOffsetDistance = 309,
    kOffsetPath = 310,
    kOffsetPosition = 311,
    kOffsetRotate = 312,
    kOpacity = 313,
    kOrder = 314,
    kOriginTrialTestProperty = 315,
    kOrphans = 316,
    kOutlineColor = 317,
    kOutlineOffset = 318,
    kOutlineStyle = 319,
    kOutlineWidth = 320,
    kOverflowAnchor = 321,
    kOverflowBlock = 322,
    kOverflowClipMargin = 323,
    kOverflowInline = 324,
    kOverflowWrap = 325,
    kOverflowX = 326,
    kOverflowY = 327,
    kOverlay = 328,
    kOverrideColors = 329,
    kOverscrollArea = 330,
    kOverscrollBehaviorBlock = 331,
    kOverscrollBehaviorInline = 332,
    kOverscrollBehaviorX = 333,
    kOverscrollBehaviorY = 334,
    kOverscrollPosition = 335,
    kPad = 336,
    kPaddingBlockEnd = 337,
    kPaddingBlockStart = 338,
    kPaddingBottom = 339,
    kPaddingInlineEnd = 340,
    kPaddingInlineStart = 341,
    kPaddingLeft = 342,
    kPaddingRight = 343,
    kPaddingTop = 344,
    kPage = 345,
    kPageOrientation = 346,
    kPaintOrder = 347,
    kPerspective = 348,
    kPerspectiveOrigin = 349,
    kPointerEvents = 350,
    kPositionTryFallbacks = 351,
    kPositionTryOrder = 352,
    kPositionVisibility = 353,
    kPrefix = 354,
    kPrintColorAdjust = 355,
    kQuotes = 356,
    kR = 357,
    kRange = 358,
    kReadingFlow = 359,
    kReadingOrder = 360,
    kResize = 361,
    kResult = 362,
    kRight = 363,
    kRotate = 364,
    kRowGap = 365,
    kRowRuleBreak = 366,
    kRowRuleColor = 367,
    kRowRuleOutset = 368,
    kRowRuleStyle = 369,
    kRowRuleWidth = 370,
    kRubyAlign = 371,
    kRubyOverhang = 372,
    kRubyPosition = 373,
    kRx = 374,
    kRy = 375,
    kScale = 376,
    kScrollBehavior = 377,
    kScrollInitialTarget = 378,
    kScrollMarginBlockEnd = 379,
    kScrollMarginBlockStart = 380,
    kScrollMarginBottom = 381,
    kScrollMarginInlineEnd = 382,
    kScrollMarginInlineStart = 383,
    kScrollMarginLeft = 384,
    kScrollMarginRight = 385,
    kScrollMarginTop = 386,
    kScrollMarkerGroup = 387,
    kScrollPaddingBlockEnd = 388,
    kScrollPaddingBlockStart = 389,
    kScrollPaddingBottom = 390,
    kScrollPaddingInlineEnd = 391,
    kScrollPaddingInlineStart = 392,
    kScrollPaddingLeft = 393,
    kScrollPaddingRight = 394,
    kScrollPaddingTop = 395,
    kScrollSnapAlign = 396,
    kScrollSnapStop = 397,
    kScrollSnapType = 398,
    kScrollStartBlock = 399,
    kScrollStartInline = 400,
    kScrollStartX = 401,
    kScrollStartY = 402,
    kScrollTargetGroup = 403,
    kScrollTimelineAxis = 404,
    kScrollTimelineName = 405,
    kScrollbarColor = 406,
    kScrollbarGutter = 407,
    kScrollbarWidth = 408,
    kShapeImageThreshold = 409,
    kShapeMargin = 410,
    kShapeOutside = 411,
    kShapeRendering = 412,
    kSize = 413,
    kSizeAdjust = 414,
    kSpeak = 415,
    kSpeakAs = 416,
    kSrc = 417,
    kStopColor = 418,
    kStopOpacity = 419,
    kStroke = 420,
    kStrokeDasharray = 421,
    kStrokeDashoffset = 422,
    kStrokeLinecap = 423,
    kStrokeLinejoin = 424,
    kStrokeMiterlimit = 425,
    kStrokeOpacity = 426,
    kStrokeWidth = 427,
    kSuffix = 428,
    kSymbols = 429,
    kSyntax = 430,
    kSystem = 431,
    kTabSize = 432,
    kTableLayout = 433,
    kTextAlign = 434,
    kTextAlignLast = 435,
    kTextAnchor = 436,
    kTextAutospace = 437,
    kTextBoxEdge = 438,
    kTextBoxTrim = 439,
    kTextCombineUpright = 440,
    kTextDecorationColor = 441,
    kTextDecorationLine = 442,
    kTextDecorationSkipInk = 443,
    kTextDecorationStyle = 444,
    kTextDecorationThickness = 445,
    kTextEmphasisColor = 446,
    kTextEmphasisPosition = 447,
    kTextEmphasisStyle = 448,
    kTextGrow = 449,
    kTextIndent = 450,
    kTextOverflow = 451,
    kTextShadow = 452,
    kTextShrink = 453,
    kTextTransform = 454,
    kTextUnderlineOffset = 455,
    kTextUnderlinePosition = 456,
    kTextWrapMode = 457,
    kTextWrapStyle = 458,
    kTimelineScope = 459,
    kTimelineTriggerBehavior = 460,
    kTimelineTriggerExitRangeEnd = 461,
    kTimelineTriggerExitRangeStart = 462,
    kTimelineTriggerName = 463,
    kTimelineTriggerRangeEnd = 464,
    kTimelineTriggerRangeStart = 465,
    kTimelineTriggerSource = 466,
    kTop = 467,
    kTouchAction = 468,
    kTransform = 469,
    kTransformBox = 470,
    kTransformOrigin = 471,
    kTransformStyle = 472,
    kTransitionBehavior = 473,
    kTransitionDelay = 474,
    kTransitionDuration = 475,
    kTransitionProperty = 476,
    kTransitionTimingFunction = 477,
    kTranslate = 478,
    kTypes = 479,
    kUnicodeBidi = 480,
    kUnicodeRange = 481,
    kUserSelect = 482,
    kVectorEffect = 483,
    kVerticalAlign = 484,
    kViewTimelineAxis = 485,
    kViewTimelineInset = 486,
    kViewTimelineName = 487,
    kViewTransitionClass = 488,
    kViewTransitionGroup = 489,
    kViewTransitionName = 490,
    kVisibility = 491,
    kWebkitBorderHorizontalSpacing = 492,
    kWebkitBorderImage = 493,
    kWebkitBorderVerticalSpacing = 494,
    kWebkitBoxAlign = 495,
    kWebkitBoxDecorationBreak = 496,
    kWebkitBoxDirection = 497,
    kWebkitBoxFlex = 498,
    kWebkitBoxOrdinalGroup = 499,
    kWebkitBoxOrient = 500,
    kWebkitBoxPack = 501,
    kWebkitBoxReflect = 502,
    kWebkitLineBreak = 503,
    kWebkitLineClamp = 504,
    kWebkitMaskBoxImageOutset = 505,
    kWebkitMaskBoxImageRepeat = 506,
    kWebkitMaskBoxImageSlice = 507,
    kWebkitMaskBoxImageSource = 508,
    kWebkitMaskBoxImageWidth = 509,
    kWebkitMaskPositionX = 510,
    kWebkitMaskPositionY = 511,
    kWebkitPerspectiveOriginX = 512,
    kWebkitPerspectiveOriginY = 513,
    kWebkitRtlOrdering = 514,
    kWebkitRubyPosition = 515,
    kWebkitTapHighlightColor = 516,
    kWebkitTextCombine = 517,
    kWebkitTextDecorationsInEffect = 518,
    kWebkitTextFillColor = 519,
    kWebkitTextSecurity = 520,
    kWebkitTextStrokeColor = 521,
    kWebkitTextStrokeWidth = 522,
    kWebkitTransformOriginX = 523,
    kWebkitTransformOriginY = 524,
    kWebkitTransformOriginZ = 525,
    kWebkitUserDrag = 526,
    kWebkitUserModify = 527,
    kWhiteSpaceCollapse = 528,
    kWidows = 529,
    kWidth = 530,
    kWillChange = 531,
    kWordBreak = 532,
    kWordSpacing = 533,
    kX = 534,
    kY = 535,
    kZIndex = 536,
    kAlternativeWebkitLineClamp = 537,
    kAnimation = 538,
    kAnimationRange = 539,
    kBackground = 540,
    kBackgroundPosition = 541,
    kBorder = 542,
    kBorderBlock = 543,
    kBorderBlockColor = 544,
    kBorderBlockEnd = 545,
    kBorderBlockStart = 546,
    kBorderBlockStyle = 547,
    kBorderBlockWidth = 548,
    kBorderBottom = 549,
    kBorderColor = 550,
    kBorderImage = 551,
    kBorderInline = 552,
    kBorderInlineColor = 553,
    kBorderInlineEnd = 554,
    kBorderInlineStart = 555,
    kBorderInlineStyle = 556,
    kBorderInlineWidth = 557,
    kBorderLeft = 558,
    kBorderRadius = 559,
    kBorderRight = 560,
    kBorderSpacing = 561,
    kBorderStyle = 562,
    kBorderTop = 563,
    kBorderWidth = 564,
    kColumnRule = 565,
    kColumns = 566,
    kContainIntrinsicSize = 567,
    kContainer = 568,
    kCornerBlockEndShape = 569,
    kCornerBlockStartShape = 570,
    kCornerBottomShape = 571,
    kCornerInlineEndShape = 572,
    kCornerInlineStartShape = 573,
    kCornerLeftShape = 574,
    kCornerRightShape = 575,
    kCornerShape = 576,
    kCornerTopShape = 577,
    kCorners = 578,
    kFlex = 579,
    kFlexFlow = 580,
    kFont = 581,
    kFontSynthesis = 582,
    kFontVariant = 583,
    kGap = 584,
    kGrid = 585,
    kGridArea = 586,
    kGridColumn = 587,
    kGridRow = 588,
    kGridTemplate = 589,
    kInset = 590,
    kInsetBlock = 591,
    kInsetInline = 592,
    kInterestDelay = 593,
    kLineClamp = 594,
    kListStyle = 595,
    kMargin = 596,
    kMarginBlock = 597,
    kMarginInline = 598,
    kMarker = 599,
    kMask = 600,
    kMaskPosition = 601,
    kMasonry = 602,
    kMasonryFlow = 603,
    kOffset = 604,
    kOutline = 605,
    kOverflow = 606,
    kOverscrollBehavior = 607,
    kPadding = 608,
    kPaddingBlock = 609,
    kPaddingInline = 610,
    kPageBreakAfter = 611,
    kPageBreakBefore = 612,
    kPageBreakInside = 613,
    kPlaceContent = 614,
    kPlaceItems = 615,
    kPlaceSelf = 616,
    kPositionTry = 617,
    kRowRule = 618,
    kRule = 619,
    kRuleColor = 620,
    kRuleStyle = 621,
    kRuleWidth = 622,
    kScrollMargin = 623,
    kScrollMarginBlock = 624,
    kScrollMarginInline = 625,
    kScrollPadding = 626,
    kScrollPaddingBlock = 627,
    kScrollPaddingInline = 628,
    kScrollStart = 629,
    kScrollTimeline = 630,
    kTextBox = 631,
    kTextDecoration = 632,
    kTextEmphasis = 633,
    kTextSpacing = 634,
    kTextWrap = 635,
    kTimelineTrigger = 636,
    kTransition = 637,
    kViewTimeline = 638,
    kWebkitColumnBreakAfter = 639,
    kWebkitColumnBreakBefore = 640,
    kWebkitColumnBreakInside = 641,
    kWebkitMaskBoxImage = 642,
    kWebkitTextStroke = 643,
    kWhiteSpace = 644,
    kAliasWebkitAppearance = 645,
    kAliasWebkitAppRegion = 646,
    kAliasWebkitMaskClip = 647,
    kAliasWebkitMaskComposite = 648,
    kAliasWebkitMaskImage = 649,
    kAliasWebkitMaskOrigin = 650,
    kAliasWebkitMaskRepeat = 651,
    kAliasWebkitMaskSize = 652,
    kAliasWebkitBorderEndColor = 653,
    kAliasWebkitBorderEndStyle = 654,
    kAliasWebkitBorderEndWidth = 655,
    kAliasWebkitBorderStartColor = 656,
    kAliasWebkitBorderStartStyle = 657,
    kAliasWebkitBorderStartWidth = 658,
    kAliasWebkitBorderBeforeColor = 659,
    kAliasWebkitBorderBeforeStyle = 660,
    kAliasWebkitBorderBeforeWidth = 661,
    kAliasWebkitBorderAfterColor = 662,
    kAliasWebkitBorderAfterStyle = 663,
    kAliasWebkitBorderAfterWidth = 664,
    kAliasWebkitMarginEnd = 665,
    kAliasWebkitMarginStart = 666,
    kAliasWebkitMarginBefore = 667,
    kAliasWebkitMarginAfter = 668,
    kAliasWebkitPaddingEnd = 669,
    kAliasWebkitPaddingStart = 670,
    kAliasWebkitPaddingBefore = 671,
    kAliasWebkitPaddingAfter = 672,
    kAliasWebkitLogicalWidth = 673,
    kAliasWebkitLogicalHeight = 674,
    kAliasWebkitMinLogicalWidth = 675,
    kAliasWebkitMinLogicalHeight = 676,
    kAliasWebkitMaxLogicalWidth = 677,
    kAliasWebkitMaxLogicalHeight = 678,
    kAliasWebkitPrintColorAdjust = 679,
    kAliasWebkitBorderAfter = 680,
    kAliasWebkitBorderBefore = 681,
    kAliasWebkitBorderEnd = 682,
    kAliasWebkitBorderStart = 683,
    kAliasWebkitMask = 684,
    kAliasWebkitMaskPosition = 685,
    kAliasEpubCaptionSide = 686,
    kAliasEpubTextCombine = 687,
    kAliasEpubTextEmphasis = 688,
    kAliasEpubTextEmphasisColor = 689,
    kAliasEpubTextEmphasisStyle = 690,
    kAliasEpubTextOrientation = 691,
    kAliasEpubTextTransform = 692,
    kAliasEpubWordBreak = 693,
    kAliasEpubWritingMode = 694,
    kAliasWebkitAlignContent = 695,
    kAliasWebkitAlignItems = 696,
    kAliasWebkitAlignSelf = 697,
    kAliasWebkitAnimation = 698,
    kAliasWebkitAnimationDelay = 699,
    kAliasWebkitAnimationDirection = 700,
    kAliasWebkitAnimationDuration = 701,
    kAliasWebkitAnimationFillMode = 702,
    kAliasWebkitAnimationIterationCount = 703,
    kAliasWebkitAnimationName = 704,
    kAliasWebkitAnimationPlayState = 705,
    kAliasWebkitAnimationTimingFunction = 706,
    kAliasWebkitBackfaceVisibility = 707,
    kAliasWebkitBackgroundClip = 708,
    kAliasWebkitBackgroundOrigin = 709,
    kAliasWebkitBackgroundSize = 710,
    kAliasWebkitBorderBottomLeftRadius = 711,
    kAliasWebkitBorderBottomRightRadius = 712,
    kAliasWebkitBorderRadius = 713,
    kAliasWebkitBorderTopLeftRadius = 714,
    kAliasWebkitBorderTopRightRadius = 715,
    kAliasWebkitBoxShadow = 716,
    kAliasWebkitBoxSizing = 717,
    kAliasWebkitClipPath = 718,
    kAliasWebkitColumnCount = 719,
    kAliasWebkitColumnGap = 720,
    kAliasWebkitColumnRule = 721,
    kAliasWebkitColumnRuleColor = 722,
    kAliasWebkitColumnRuleStyle = 723,
    kAliasWebkitColumnRuleWidth = 724,
    kAliasWebkitColumnSpan = 725,
    kAliasWebkitColumnWidth = 726,
    kAliasWebkitColumns = 727,
    kAliasWebkitFilter = 728,
    kAliasWebkitFlex = 729,
    kAliasWebkitFlexBasis = 730,
    kAliasWebkitFlexDirection = 731,
    kAliasWebkitFlexFlow = 732,
    kAliasWebkitFlexGrow = 733,
    kAliasWebkitFlexShrink = 734,
    kAliasWebkitFlexWrap = 735,
    kAliasWebkitFontFeatureSettings = 736,
    kAliasWebkitHyphenateCharacter = 737,
    kAliasWebkitJustifyContent = 738,
    kAliasWebkitOpacity = 739,
    kAliasWebkitOrder = 740,
    kAliasWebkitPerspective = 741,
    kAliasWebkitPerspectiveOrigin = 742,
    kAliasWebkitShapeImageThreshold = 743,
    kAliasWebkitShapeMargin = 744,
    kAliasWebkitShapeOutside = 745,
    kAliasWebkitTextEmphasis = 746,
    kAliasWebkitTextEmphasisColor = 747,
    kAliasWebkitTextEmphasisPosition = 748,
    kAliasWebkitTextEmphasisStyle = 749,
    kAliasWebkitTextSizeAdjust = 750,
    kAliasWebkitTransform = 751,
    kAliasWebkitTransformOrigin = 752,
    kAliasWebkitTransformStyle = 753,
    kAliasWebkitTransition = 754,
    kAliasWebkitTransitionDelay = 755,
    kAliasWebkitTransitionDuration = 756,
    kAliasWebkitTransitionProperty = 757,
    kAliasWebkitTransitionTimingFunction = 758,
    kAliasWebkitUserSelect = 759,
    kAliasWordWrap = 760,
    kAliasGridColumnGap = 761,
    kAliasGridRowGap = 762,
    kAliasGridGap = 763,
};

const CSSPropertyID kCSSPropertyAliasList[] = {
    CSSPropertyID::kAliasWebkitAppearance,
    CSSPropertyID::kAliasWebkitAppRegion,
    CSSPropertyID::kAliasWebkitMaskClip,
    CSSPropertyID::kAliasWebkitMaskComposite,
    CSSPropertyID::kAliasWebkitMaskImage,
    CSSPropertyID::kAliasWebkitMaskOrigin,
    CSSPropertyID::kAliasWebkitMaskRepeat,
    CSSPropertyID::kAliasWebkitMaskSize,
    CSSPropertyID::kAliasWebkitBorderEndColor,
    CSSPropertyID::kAliasWebkitBorderEndStyle,
    CSSPropertyID::kAliasWebkitBorderEndWidth,
    CSSPropertyID::kAliasWebkitBorderStartColor,
    CSSPropertyID::kAliasWebkitBorderStartStyle,
    CSSPropertyID::kAliasWebkitBorderStartWidth,
    CSSPropertyID::kAliasWebkitBorderBeforeColor,
    CSSPropertyID::kAliasWebkitBorderBeforeStyle,
    CSSPropertyID::kAliasWebkitBorderBeforeWidth,
    CSSPropertyID::kAliasWebkitBorderAfterColor,
    CSSPropertyID::kAliasWebkitBorderAfterStyle,
    CSSPropertyID::kAliasWebkitBorderAfterWidth,
    CSSPropertyID::kAliasWebkitMarginEnd,
    CSSPropertyID::kAliasWebkitMarginStart,
    CSSPropertyID::kAliasWebkitMarginBefore,
    CSSPropertyID::kAliasWebkitMarginAfter,
    CSSPropertyID::kAliasWebkitPaddingEnd,
    CSSPropertyID::kAliasWebkitPaddingStart,
    CSSPropertyID::kAliasWebkitPaddingBefore,
    CSSPropertyID::kAliasWebkitPaddingAfter,
    CSSPropertyID::kAliasWebkitLogicalWidth,
    CSSPropertyID::kAliasWebkitLogicalHeight,
    CSSPropertyID::kAliasWebkitMinLogicalWidth,
    CSSPropertyID::kAliasWebkitMinLogicalHeight,
    CSSPropertyID::kAliasWebkitMaxLogicalWidth,
    CSSPropertyID::kAliasWebkitMaxLogicalHeight,
    CSSPropertyID::kAliasWebkitPrintColorAdjust,
    CSSPropertyID::kAliasWebkitBorderAfter,
    CSSPropertyID::kAliasWebkitBorderBefore,
    CSSPropertyID::kAliasWebkitBorderEnd,
    CSSPropertyID::kAliasWebkitBorderStart,
    CSSPropertyID::kAliasWebkitMask,
    CSSPropertyID::kAliasWebkitMaskPosition,
    CSSPropertyID::kAliasEpubCaptionSide,
    CSSPropertyID::kAliasEpubTextCombine,
    CSSPropertyID::kAliasEpubTextEmphasis,
    CSSPropertyID::kAliasEpubTextEmphasisColor,
    CSSPropertyID::kAliasEpubTextEmphasisStyle,
    CSSPropertyID::kAliasEpubTextOrientation,
    CSSPropertyID::kAliasEpubTextTransform,
    CSSPropertyID::kAliasEpubWordBreak,
    CSSPropertyID::kAliasEpubWritingMode,
    CSSPropertyID::kAliasWebkitAlignContent,
    CSSPropertyID::kAliasWebkitAlignItems,
    CSSPropertyID::kAliasWebkitAlignSelf,
    CSSPropertyID::kAliasWebkitAnimation,
    CSSPropertyID::kAliasWebkitAnimationDelay,
    CSSPropertyID::kAliasWebkitAnimationDirection,
    CSSPropertyID::kAliasWebkitAnimationDuration,
    CSSPropertyID::kAliasWebkitAnimationFillMode,
    CSSPropertyID::kAliasWebkitAnimationIterationCount,
    CSSPropertyID::kAliasWebkitAnimationName,
    CSSPropertyID::kAliasWebkitAnimationPlayState,
    CSSPropertyID::kAliasWebkitAnimationTimingFunction,
    CSSPropertyID::kAliasWebkitBackfaceVisibility,
    CSSPropertyID::kAliasWebkitBackgroundClip,
    CSSPropertyID::kAliasWebkitBackgroundOrigin,
    CSSPropertyID::kAliasWebkitBackgroundSize,
    CSSPropertyID::kAliasWebkitBorderBottomLeftRadius,
    CSSPropertyID::kAliasWebkitBorderBottomRightRadius,
    CSSPropertyID::kAliasWebkitBorderRadius,
    CSSPropertyID::kAliasWebkitBorderTopLeftRadius,
    CSSPropertyID::kAliasWebkitBorderTopRightRadius,
    CSSPropertyID::kAliasWebkitBoxShadow,
    CSSPropertyID::kAliasWebkitBoxSizing,
    CSSPropertyID::kAliasWebkitClipPath,
    CSSPropertyID::kAliasWebkitColumnCount,
    CSSPropertyID::kAliasWebkitColumnGap,
    CSSPropertyID::kAliasWebkitColumnRule,
    CSSPropertyID::kAliasWebkitColumnRuleColor,
    CSSPropertyID::kAliasWebkitColumnRuleStyle,
    CSSPropertyID::kAliasWebkitColumnRuleWidth,
    CSSPropertyID::kAliasWebkitColumnSpan,
    CSSPropertyID::kAliasWebkitColumnWidth,
    CSSPropertyID::kAliasWebkitColumns,
    CSSPropertyID::kAliasWebkitFilter,
    CSSPropertyID::kAliasWebkitFlex,
    CSSPropertyID::kAliasWebkitFlexBasis,
    CSSPropertyID::kAliasWebkitFlexDirection,
    CSSPropertyID::kAliasWebkitFlexFlow,
    CSSPropertyID::kAliasWebkitFlexGrow,
    CSSPropertyID::kAliasWebkitFlexShrink,
    CSSPropertyID::kAliasWebkitFlexWrap,
    CSSPropertyID::kAliasWebkitFontFeatureSettings,
    CSSPropertyID::kAliasWebkitHyphenateCharacter,
    CSSPropertyID::kAliasWebkitJustifyContent,
    CSSPropertyID::kAliasWebkitOpacity,
    CSSPropertyID::kAliasWebkitOrder,
    CSSPropertyID::kAliasWebkitPerspective,
    CSSPropertyID::kAliasWebkitPerspectiveOrigin,
    CSSPropertyID::kAliasWebkitShapeImageThreshold,
    CSSPropertyID::kAliasWebkitShapeMargin,
    CSSPropertyID::kAliasWebkitShapeOutside,
    CSSPropertyID::kAliasWebkitTextEmphasis,
    CSSPropertyID::kAliasWebkitTextEmphasisColor,
    CSSPropertyID::kAliasWebkitTextEmphasisPosition,
    CSSPropertyID::kAliasWebkitTextEmphasisStyle,
    CSSPropertyID::kAliasWebkitTextSizeAdjust,
    CSSPropertyID::kAliasWebkitTransform,
    CSSPropertyID::kAliasWebkitTransformOrigin,
    CSSPropertyID::kAliasWebkitTransformStyle,
    CSSPropertyID::kAliasWebkitTransition,
    CSSPropertyID::kAliasWebkitTransitionDelay,
    CSSPropertyID::kAliasWebkitTransitionDuration,
    CSSPropertyID::kAliasWebkitTransitionProperty,
    CSSPropertyID::kAliasWebkitTransitionTimingFunction,
    CSSPropertyID::kAliasWebkitUserSelect,
    CSSPropertyID::kAliasWordWrap,
    CSSPropertyID::kAliasGridColumnGap,
    CSSPropertyID::kAliasGridRowGap,
    CSSPropertyID::kAliasGridGap,
};

const CSSPropertyID kCSSComputableProperties[] = {
    CSSPropertyID::kAccentColor,
    CSSPropertyID::kAlignContent,
    CSSPropertyID::kAlignItems,
    CSSPropertyID::kAlignSelf,
    CSSPropertyID::kAlignmentBaseline,
    CSSPropertyID::kAnchorName,
    CSSPropertyID::kAnchorScope,
    CSSPropertyID::kAnimationComposition,
    CSSPropertyID::kAnimationDelay,
    CSSPropertyID::kAnimationDirection,
    CSSPropertyID::kAnimationDuration,
    CSSPropertyID::kAnimationFillMode,
    CSSPropertyID::kAnimationIterationCount,
    CSSPropertyID::kAnimationName,
    CSSPropertyID::kAnimationPlayState,
    CSSPropertyID::kAnimationRangeEnd,
    CSSPropertyID::kAnimationRangeStart,
    CSSPropertyID::kAnimationTimeline,
    CSSPropertyID::kAnimationTimingFunction,
    CSSPropertyID::kAnimationTrigger,
    CSSPropertyID::kAppRegion,
    CSSPropertyID::kAppearance,
    CSSPropertyID::kBackdropFilter,
    CSSPropertyID::kBackfaceVisibility,
    CSSPropertyID::kBackgroundAttachment,
    CSSPropertyID::kBackgroundBlendMode,
    CSSPropertyID::kBackgroundClip,
    CSSPropertyID::kBackgroundColor,
    CSSPropertyID::kBackgroundImage,
    CSSPropertyID::kBackgroundOrigin,
    CSSPropertyID::kBackgroundPosition,
    CSSPropertyID::kBackgroundRepeat,
    CSSPropertyID::kBackgroundSize,
    CSSPropertyID::kBaselineShift,
    CSSPropertyID::kBaselineSource,
    CSSPropertyID::kBlockEllipsis,
    CSSPropertyID::kBlockSize,
    CSSPropertyID::kBorderBlockEndColor,
    CSSPropertyID::kBorderBlockEndStyle,
    CSSPropertyID::kBorderBlockEndWidth,
    CSSPropertyID::kBorderBlockStartColor,
    CSSPropertyID::kBorderBlockStartStyle,
    CSSPropertyID::kBorderBlockStartWidth,
    CSSPropertyID::kBorderBottomColor,
    CSSPropertyID::kBorderBottomLeftRadius,
    CSSPropertyID::kBorderBottomRightRadius,
    CSSPropertyID::kBorderBottomStyle,
    CSSPropertyID::kBorderBottomWidth,
    CSSPropertyID::kBorderCollapse,
    CSSPropertyID::kBorderEndEndRadius,
    CSSPropertyID::kBorderEndStartRadius,
    CSSPropertyID::kBorderImageOutset,
    CSSPropertyID::kBorderImageRepeat,
    CSSPropertyID::kBorderImageSlice,
    CSSPropertyID::kBorderImageSource,
    CSSPropertyID::kBorderImageWidth,
    CSSPropertyID::kBorderInlineEndColor,
    CSSPropertyID::kBorderInlineEndStyle,
    CSSPropertyID::kBorderInlineEndWidth,
    CSSPropertyID::kBorderInlineStartColor,
    CSSPropertyID::kBorderInlineStartStyle,
    CSSPropertyID::kBorderInlineStartWidth,
    CSSPropertyID::kBorderLeftColor,
    CSSPropertyID::kBorderLeftStyle,
    CSSPropertyID::kBorderLeftWidth,
    CSSPropertyID::kBorderRightColor,
    CSSPropertyID::kBorderRightStyle,
    CSSPropertyID::kBorderRightWidth,
    CSSPropertyID::kBorderShape,
    CSSPropertyID::kBorderStartEndRadius,
    CSSPropertyID::kBorderStartStartRadius,
    CSSPropertyID::kBorderTopColor,
    CSSPropertyID::kBorderTopLeftRadius,
    CSSPropertyID::kBorderTopRightRadius,
    CSSPropertyID::kBorderTopStyle,
    CSSPropertyID::kBorderTopWidth,
    CSSPropertyID::kBottom,
    CSSPropertyID::kBoxDecorationBreak,
    CSSPropertyID::kBoxShadow,
    CSSPropertyID::kBoxSizing,
    CSSPropertyID::kBreakAfter,
    CSSPropertyID::kBreakBefore,
    CSSPropertyID::kBreakInside,
    CSSPropertyID::kBufferedRendering,
    CSSPropertyID::kCaptionSide,
    CSSPropertyID::kCaretAnimation,
    CSSPropertyID::kCaretColor,
    CSSPropertyID::kCaretShape,
    CSSPropertyID::kClear,
    CSSPropertyID::kClip,
    CSSPropertyID::kClipPath,
    CSSPropertyID::kClipRule,
    CSSPropertyID::kColor,
    CSSPropertyID::kColorInterpolation,
    CSSPropertyID::kColorInterpolationFilters,
    CSSPropertyID::kColorRendering,
    CSSPropertyID::kColumnCount,
    CSSPropertyID::kColumnGap,
    CSSPropertyID::kColumnHeight,
    CSSPropertyID::kColumnRuleBreak,
    CSSPropertyID::kColumnRuleColor,
    CSSPropertyID::kColumnRuleOutset,
    CSSPropertyID::kColumnRuleStyle,
    CSSPropertyID::kColumnRuleWidth,
    CSSPropertyID::kColumnSpan,
    CSSPropertyID::kColumnWidth,
    CSSPropertyID::kColumnWrap,
    CSSPropertyID::kContainIntrinsicBlockSize,
    CSSPropertyID::kContainIntrinsicHeight,
    CSSPropertyID::kContainIntrinsicInlineSize,
    CSSPropertyID::kContainIntrinsicSize,
    CSSPropertyID::kContainIntrinsicWidth,
    CSSPropertyID::kContainerName,
    CSSPropertyID::kContainerType,
    CSSPropertyID::kContent,
    CSSPropertyID::kContinue,
    CSSPropertyID::kCornerBottomLeftShape,
    CSSPropertyID::kCornerBottomRightShape,
    CSSPropertyID::kCornerEndEndShape,
    CSSPropertyID::kCornerEndStartShape,
    CSSPropertyID::kCornerStartEndShape,
    CSSPropertyID::kCornerStartStartShape,
    CSSPropertyID::kCornerTopLeftShape,
    CSSPropertyID::kCornerTopRightShape,
    CSSPropertyID::kCursor,
    CSSPropertyID::kCx,
    CSSPropertyID::kCy,
    CSSPropertyID::kD,
    CSSPropertyID::kDirection,
    CSSPropertyID::kDisplay,
    CSSPropertyID::kDominantBaseline,
    CSSPropertyID::kDynamicRangeLimit,
    CSSPropertyID::kEmptyCells,
    CSSPropertyID::kFieldSizing,
    CSSPropertyID::kFill,
    CSSPropertyID::kFillOpacity,
    CSSPropertyID::kFillRule,
    CSSPropertyID::kFilter,
    CSSPropertyID::kFlexBasis,
    CSSPropertyID::kFlexDirection,
    CSSPropertyID::kFlexGrow,
    CSSPropertyID::kFlexShrink,
    CSSPropertyID::kFlexWrap,
    CSSPropertyID::kFloat,
    CSSPropertyID::kFloodColor,
    CSSPropertyID::kFloodOpacity,
    CSSPropertyID::kFontFamily,
    CSSPropertyID::kFontKerning,
    CSSPropertyID::kFontLanguageOverride,
    CSSPropertyID::kFontOpticalSizing,
    CSSPropertyID::kFontPalette,
    CSSPropertyID::kFontSize,
    CSSPropertyID::kFontSizeAdjust,
    CSSPropertyID::kFontStretch,
    CSSPropertyID::kFontStyle,
    CSSPropertyID::kFontSynthesisSmallCaps,
    CSSPropertyID::kFontSynthesisStyle,
    CSSPropertyID::kFontSynthesisWeight,
    CSSPropertyID::kFontVariant,
    CSSPropertyID::kFontVariantAlternates,
    CSSPropertyID::kFontVariantCaps,
    CSSPropertyID::kFontVariantEastAsian,
    CSSPropertyID::kFontVariantEmoji,
    CSSPropertyID::kFontVariantLigatures,
    CSSPropertyID::kFontVariantNumeric,
    CSSPropertyID::kFontVariantPosition,
    CSSPropertyID::kFontWeight,
    CSSPropertyID::kGapRuleOverlap,
    CSSPropertyID::kGridAutoColumns,
    CSSPropertyID::kGridAutoFlow,
    CSSPropertyID::kGridAutoRows,
    CSSPropertyID::kGridColumnEnd,
    CSSPropertyID::kGridColumnStart,
    CSSPropertyID::kGridRowEnd,
    CSSPropertyID::kGridRowStart,
    CSSPropertyID::kGridTemplateAreas,
    CSSPropertyID::kGridTemplateColumns,
    CSSPropertyID::kGridTemplateRows,
    CSSPropertyID::kHeight,
    CSSPropertyID::kHyphenateCharacter,
    CSSPropertyID::kHyphenateLimitChars,
    CSSPropertyID::kHyphens,
    CSSPropertyID::kImageOrientation,
    CSSPropertyID::kImageRendering,
    CSSPropertyID::kInitialLetter,
    CSSPropertyID::kInlineSize,
    CSSPropertyID::kInsetBlockEnd,
    CSSPropertyID::kInsetBlockStart,
    CSSPropertyID::kInsetInlineEnd,
    CSSPropertyID::kInsetInlineStart,
    CSSPropertyID::kInteractivity,
    CSSPropertyID::kInterestDelayEnd,
    CSSPropertyID::kInterestDelayStart,
    CSSPropertyID::kInterpolateSize,
    CSSPropertyID::kIsolation,
    CSSPropertyID::kItemTolerance,
    CSSPropertyID::kJustifyContent,
    CSSPropertyID::kJustifyItems,
    CSSPropertyID::kJustifySelf,
    CSSPropertyID::kLeft,
    CSSPropertyID::kLetterSpacing,
    CSSPropertyID::kLightingColor,
    CSSPropertyID::kLineBreak,
    CSSPropertyID::kLineHeight,
    CSSPropertyID::kListStyleImage,
    CSSPropertyID::kListStylePosition,
    CSSPropertyID::kListStyleType,
    CSSPropertyID::kMarginBlockEnd,
    CSSPropertyID::kMarginBlockStart,
    CSSPropertyID::kMarginBottom,
    CSSPropertyID::kMarginInlineEnd,
    CSSPropertyID::kMarginInlineStart,
    CSSPropertyID::kMarginLeft,
    CSSPropertyID::kMarginRight,
    CSSPropertyID::kMarginTop,
    CSSPropertyID::kMarkerEnd,
    CSSPropertyID::kMarkerMid,
    CSSPropertyID::kMarkerStart,
    CSSPropertyID::kMaskClip,
    CSSPropertyID::kMaskComposite,
    CSSPropertyID::kMaskImage,
    CSSPropertyID::kMaskMode,
    CSSPropertyID::kMaskOrigin,
    CSSPropertyID::kMaskPosition,
    CSSPropertyID::kMaskRepeat,
    CSSPropertyID::kMaskSize,
    CSSPropertyID::kMaskType,
    CSSPropertyID::kMasonryDirection,
    CSSPropertyID::kMasonryFill,
    CSSPropertyID::kMathDepth,
    CSSPropertyID::kMathShift,
    CSSPropertyID::kMathStyle,
    CSSPropertyID::kMaxBlockSize,
    CSSPropertyID::kMaxHeight,
    CSSPropertyID::kMaxInlineSize,
    CSSPropertyID::kMaxLines,
    CSSPropertyID::kMaxWidth,
    CSSPropertyID::kMinBlockSize,
    CSSPropertyID::kMinHeight,
    CSSPropertyID::kMinInlineSize,
    CSSPropertyID::kMinWidth,
    CSSPropertyID::kMixBlendMode,
    CSSPropertyID::kObjectFit,
    CSSPropertyID::kObjectPosition,
    CSSPropertyID::kObjectViewBox,
    CSSPropertyID::kOffsetAnchor,
    CSSPropertyID::kOffsetDistance,
    CSSPropertyID::kOffsetPath,
    CSSPropertyID::kOffsetPosition,
    CSSPropertyID::kOffsetRotate,
    CSSPropertyID::kOpacity,
    CSSPropertyID::kOrder,
    CSSPropertyID::kOrphans,
    CSSPropertyID::kOutlineColor,
    CSSPropertyID::kOutlineOffset,
    CSSPropertyID::kOutlineStyle,
    CSSPropertyID::kOutlineWidth,
    CSSPropertyID::kOverflowAnchor,
    CSSPropertyID::kOverflowBlock,
    CSSPropertyID::kOverflowClipMargin,
    CSSPropertyID::kOverflowInline,
    CSSPropertyID::kOverflowWrap,
    CSSPropertyID::kOverflowX,
    CSSPropertyID::kOverflowY,
    CSSPropertyID::kOverlay,
    CSSPropertyID::kOverscrollArea,
    CSSPropertyID::kOverscrollBehaviorBlock,
    CSSPropertyID::kOverscrollBehaviorInline,
    CSSPropertyID::kOverscrollPosition,
    CSSPropertyID::kPaddingBlockEnd,
    CSSPropertyID::kPaddingBlockStart,
    CSSPropertyID::kPaddingBottom,
    CSSPropertyID::kPaddingInlineEnd,
    CSSPropertyID::kPaddingInlineStart,
    CSSPropertyID::kPaddingLeft,
    CSSPropertyID::kPaddingRight,
    CSSPropertyID::kPaddingTop,
    CSSPropertyID::kPaintOrder,
    CSSPropertyID::kPerspective,
    CSSPropertyID::kPerspectiveOrigin,
    CSSPropertyID::kPointerEvents,
    CSSPropertyID::kPosition,
    CSSPropertyID::kPositionAnchor,
    CSSPropertyID::kPositionArea,
    CSSPropertyID::kPositionTryFallbacks,
    CSSPropertyID::kPositionTryOrder,
    CSSPropertyID::kPositionVisibility,
    CSSPropertyID::kPrintColorAdjust,
    CSSPropertyID::kR,
    CSSPropertyID::kReadingFlow,
    CSSPropertyID::kReadingOrder,
    CSSPropertyID::kResize,
    CSSPropertyID::kRight,
    CSSPropertyID::kRotate,
    CSSPropertyID::kRowGap,
    CSSPropertyID::kRowRuleBreak,
    CSSPropertyID::kRowRuleColor,
    CSSPropertyID::kRowRuleOutset,
    CSSPropertyID::kRowRuleStyle,
    CSSPropertyID::kRowRuleWidth,
    CSSPropertyID::kRubyAlign,
    CSSPropertyID::kRubyOverhang,
    CSSPropertyID::kRubyPosition,
    CSSPropertyID::kRx,
    CSSPropertyID::kRy,
    CSSPropertyID::kScale,
    CSSPropertyID::kScrollBehavior,
    CSSPropertyID::kScrollInitialTarget,
    CSSPropertyID::kScrollMarginBlockEnd,
    CSSPropertyID::kScrollMarginBlockStart,
    CSSPropertyID::kScrollMarginInlineEnd,
    CSSPropertyID::kScrollMarginInlineStart,
    CSSPropertyID::kScrollMarkerGroup,
    CSSPropertyID::kScrollPaddingBlockEnd,
    CSSPropertyID::kScrollPaddingBlockStart,
    CSSPropertyID::kScrollPaddingInlineEnd,
    CSSPropertyID::kScrollPaddingInlineStart,
    CSSPropertyID::kScrollStartBlock,
    CSSPropertyID::kScrollStartInline,
    CSSPropertyID::kScrollStartX,
    CSSPropertyID::kScrollStartY,
    CSSPropertyID::kScrollTargetGroup,
    CSSPropertyID::kScrollTimelineAxis,
    CSSPropertyID::kScrollTimelineName,
    CSSPropertyID::kScrollbarColor,
    CSSPropertyID::kScrollbarGutter,
    CSSPropertyID::kScrollbarWidth,
    CSSPropertyID::kShapeImageThreshold,
    CSSPropertyID::kShapeMargin,
    CSSPropertyID::kShapeOutside,
    CSSPropertyID::kShapeRendering,
    CSSPropertyID::kSpeak,
    CSSPropertyID::kStopColor,
    CSSPropertyID::kStopOpacity,
    CSSPropertyID::kStroke,
    CSSPropertyID::kStrokeDasharray,
    CSSPropertyID::kStrokeDashoffset,
    CSSPropertyID::kStrokeLinecap,
    CSSPropertyID::kStrokeLinejoin,
    CSSPropertyID::kStrokeMiterlimit,
    CSSPropertyID::kStrokeOpacity,
    CSSPropertyID::kStrokeWidth,
    CSSPropertyID::kTabSize,
    CSSPropertyID::kTableLayout,
    CSSPropertyID::kTextAlign,
    CSSPropertyID::kTextAlignLast,
    CSSPropertyID::kTextAnchor,
    CSSPropertyID::kTextAutospace,
    CSSPropertyID::kTextBoxEdge,
    CSSPropertyID::kTextBoxTrim,
    CSSPropertyID::kTextDecoration,
    CSSPropertyID::kTextDecorationColor,
    CSSPropertyID::kTextDecorationLine,
    CSSPropertyID::kTextDecorationSkipInk,
    CSSPropertyID::kTextDecorationStyle,
    CSSPropertyID::kTextEmphasisColor,
    CSSPropertyID::kTextEmphasisPosition,
    CSSPropertyID::kTextEmphasisStyle,
    CSSPropertyID::kTextGrow,
    CSSPropertyID::kTextIndent,
    CSSPropertyID::kTextOverflow,
    CSSPropertyID::kTextRendering,
    CSSPropertyID::kTextShadow,
    CSSPropertyID::kTextShrink,
    CSSPropertyID::kTextSizeAdjust,
    CSSPropertyID::kTextSpacingTrim,
    CSSPropertyID::kTextTransform,
    CSSPropertyID::kTextUnderlinePosition,
    CSSPropertyID::kTextWrapMode,
    CSSPropertyID::kTextWrapStyle,
    CSSPropertyID::kTimelineScope,
    CSSPropertyID::kTimelineTriggerBehavior,
    CSSPropertyID::kTimelineTriggerExitRangeEnd,
    CSSPropertyID::kTimelineTriggerExitRangeStart,
    CSSPropertyID::kTimelineTriggerName,
    CSSPropertyID::kTimelineTriggerRangeEnd,
    CSSPropertyID::kTimelineTriggerRangeStart,
    CSSPropertyID::kTimelineTriggerSource,
    CSSPropertyID::kTop,
    CSSPropertyID::kTouchAction,
    CSSPropertyID::kTransform,
    CSSPropertyID::kTransformOrigin,
    CSSPropertyID::kTransformStyle,
    CSSPropertyID::kTransitionBehavior,
    CSSPropertyID::kTransitionDelay,
    CSSPropertyID::kTransitionDuration,
    CSSPropertyID::kTransitionProperty,
    CSSPropertyID::kTransitionTimingFunction,
    CSSPropertyID::kTranslate,
    CSSPropertyID::kUnicodeBidi,
    CSSPropertyID::kUserSelect,
    CSSPropertyID::kVectorEffect,
    CSSPropertyID::kVerticalAlign,
    CSSPropertyID::kViewTimelineAxis,
    CSSPropertyID::kViewTimelineInset,
    CSSPropertyID::kViewTimelineName,
    CSSPropertyID::kViewTransitionClass,
    CSSPropertyID::kViewTransitionGroup,
    CSSPropertyID::kViewTransitionName,
    CSSPropertyID::kVisibility,
    CSSPropertyID::kWhiteSpaceCollapse,
    CSSPropertyID::kWidows,
    CSSPropertyID::kWidth,
    CSSPropertyID::kWillChange,
    CSSPropertyID::kWordBreak,
    CSSPropertyID::kWordSpacing,
    CSSPropertyID::kWritingMode,
    CSSPropertyID::kX,
    CSSPropertyID::kY,
    CSSPropertyID::kZIndex,
    CSSPropertyID::kZoom,
    CSSPropertyID::kWebkitBorderHorizontalSpacing,
    CSSPropertyID::kWebkitBorderImage,
    CSSPropertyID::kWebkitBorderVerticalSpacing,
    CSSPropertyID::kWebkitBoxAlign,
    CSSPropertyID::kWebkitBoxDecorationBreak,
    CSSPropertyID::kWebkitBoxDirection,
    CSSPropertyID::kWebkitBoxFlex,
    CSSPropertyID::kWebkitBoxOrdinalGroup,
    CSSPropertyID::kWebkitBoxOrient,
    CSSPropertyID::kWebkitBoxPack,
    CSSPropertyID::kWebkitBoxReflect,
    CSSPropertyID::kWebkitFontSmoothing,
    CSSPropertyID::kWebkitLineBreak,
    CSSPropertyID::kWebkitLineClamp,
    CSSPropertyID::kWebkitLocale,
    CSSPropertyID::kWebkitMaskBoxImage,
    CSSPropertyID::kWebkitMaskBoxImageOutset,
    CSSPropertyID::kWebkitMaskBoxImageRepeat,
    CSSPropertyID::kWebkitMaskBoxImageSlice,
    CSSPropertyID::kWebkitMaskBoxImageSource,
    CSSPropertyID::kWebkitMaskBoxImageWidth,
    CSSPropertyID::kWebkitRtlOrdering,
    CSSPropertyID::kWebkitTapHighlightColor,
    CSSPropertyID::kWebkitTextCombine,
    CSSPropertyID::kWebkitTextDecorationsInEffect,
    CSSPropertyID::kWebkitTextFillColor,
    CSSPropertyID::kWebkitTextOrientation,
    CSSPropertyID::kWebkitTextSecurity,
    CSSPropertyID::kWebkitTextStrokeColor,
    CSSPropertyID::kWebkitTextStrokeWidth,
    CSSPropertyID::kWebkitUserDrag,
    CSSPropertyID::kWebkitUserModify,
    CSSPropertyID::kWebkitWritingMode,
};

inline constexpr CSSPropertyID kCSSIncludesCurrentColorProperties[] = {
      CSSPropertyID::kMaskImage,
    CSSPropertyID::kAccentColor,
    CSSPropertyID::kBackdropFilter,
    CSSPropertyID::kBackgroundColor,
    CSSPropertyID::kBackgroundImage,
    CSSPropertyID::kBorderBottomColor,
    CSSPropertyID::kBorderImageSource,
    CSSPropertyID::kBorderLeftColor,
    CSSPropertyID::kBorderRightColor,
    CSSPropertyID::kBorderTopColor,
    CSSPropertyID::kBoxShadow,
    CSSPropertyID::kCaretColor,
    CSSPropertyID::kColumnRuleColor,
    CSSPropertyID::kFill,
    CSSPropertyID::kFilter,
    CSSPropertyID::kFloodColor,
    CSSPropertyID::kLightingColor,
    CSSPropertyID::kListStyleImage,
    CSSPropertyID::kOutlineColor,
    CSSPropertyID::kRowRuleColor,
    CSSPropertyID::kStopColor,
    CSSPropertyID::kStroke,
    CSSPropertyID::kTextDecorationColor,
    CSSPropertyID::kTextEmphasisColor,
    CSSPropertyID::kTextShadow,
    CSSPropertyID::kWebkitBoxReflect,
    CSSPropertyID::kWebkitMaskBoxImageSource,
    CSSPropertyID::kWebkitTapHighlightColor,
    CSSPropertyID::kWebkitTextStrokeColor,
};

// The lowest CSSPropertyID excluding kInvalid and kVariable.
const int kIntFirstCSSProperty = 2;
const CSSPropertyID kFirstCSSProperty =
    static_cast<CSSPropertyID>(kIntFirstCSSProperty);

// The number of unresolved CSS properties excluding kInvalid and kVariable.
const int kNumCSSProperties = 762;

// The highest resolved CSSPropertyID.
const int kIntLastCSSProperty = 644;
const CSSPropertyID kLastCSSProperty =
    static_cast<CSSPropertyID>(kIntLastCSSProperty);

// The highest unresolved CSSPropertyID.
const CSSPropertyID kLastUnresolvedCSSProperty =
    static_cast<CSSPropertyID>(763);

const CSSPropertyID kFirstHighPriorityCSSProperty = kFirstCSSProperty;
const CSSPropertyID kLastHighPriorityCSSProperty = CSSPropertyID::kZoom;

// 1 + <The highest unresolved CSSPropertyID>.
const int kNumCSSPropertyIDs = static_cast<int>(kLastUnresolvedCSSProperty) + 1;

const size_t kMaxCSSPropertyNameLength = 48;
constexpr size_t kCSSPropertyIDBitLength = 10;
constexpr size_t kMaxShorthandExpansion = 19;

static_assert((static_cast<size_t>(1) << kCSSPropertyIDBitLength) >
                  static_cast<size_t>(kLastUnresolvedCSSProperty),
              "kCSSPropertyIDBitLength has enough bits");

// These are basically just change-detector tests, so that we do not
// accidentally add new high-priority properties or break the code generator.
static_assert(CSSPropertyID::kColorScheme == kFirstHighPriorityCSSProperty);
static_assert(CSSPropertyID::kZoom == kLastHighPriorityCSSProperty);
static_assert((static_cast<int>(kLastHighPriorityCSSProperty) -
               static_cast<int>(kFirstHighPriorityCSSProperty)) == 42,
              "There should a low number of high-priority properties");

inline int GetCSSPropertyIDIndex(CSSPropertyID id) {
    DCHECK_GE(id, kFirstCSSProperty);
    DCHECK_LE(id, kLastCSSProperty);
    return static_cast<int>(id) - kIntFirstCSSProperty;
}

constexpr bool IsHighPriority(CSSPropertyID id) {
  return id >= kFirstHighPriorityCSSProperty &&
      id <= kLastHighPriorityCSSProperty;
}

inline bool IsCSSPropertyIDWithName(CSSPropertyID id)
{
    return id >= kFirstCSSProperty && id <= kLastUnresolvedCSSProperty;
}

inline bool IsValidCSSPropertyID(CSSPropertyID id)
{
    return id != CSSPropertyID::kInvalid;
}

inline CSSPropertyID ConvertToCSSPropertyID(int value)
{
    DCHECK_GE(value, static_cast<int>(CSSPropertyID::kInvalid));
    DCHECK_LE(value, kIntLastCSSProperty);
    return static_cast<CSSPropertyID>(value);
}

int CORE_EXPORT ResolveCSSPropertyAlias(int value);

inline bool IsPropertyAlias(CSSPropertyID id) {
  return static_cast<int>(id) >= 645;
}

inline CSSPropertyID ResolveCSSPropertyID(CSSPropertyID id)
{
  int int_id = static_cast<int>(id);
  if (IsPropertyAlias(id))
    int_id = ResolveCSSPropertyAlias(int_id);
  return ConvertToCSSPropertyID(int_id);
}

CSSPropertyID CORE_EXPORT CssPropertyID(const ExecutionContext*,
                                        const String&);

class CSSPropertyIDList {
  STACK_ALLOCATED();

 public:
  class Iterator {
    STACK_ALLOCATED();
   public:
    Iterator(int id) : id_(id) {}
    CSSPropertyID operator*() const { return ConvertToCSSPropertyID(id_); }
    Iterator& operator++() {
      id_++;
      return *this;
    }
    bool operator!=(const Iterator& i) const { return id_ != i.id_; }

   private:
    int id_;
  };
  Iterator begin() const { return Iterator(kIntFirstCSSProperty); }
  Iterator end() const { return Iterator(kIntLastCSSProperty + 1); }
};

mojom::blink::CSSSampleId CORE_EXPORT GetCSSSampleId(CSSPropertyID id);

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_CORE_CSS_CSS_PROPERTY_NAMES_H_
