// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_LIGHT_PROBE_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_LIGHT_PROBE_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_reflection_format.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT XRLightProbeInit : public bindings::InputDictionaryBase {
  
  public:
static XRLightProbeInit* Create() {
  return MakeGarbageCollected<XRLightProbeInit>();
}
static XRLightProbeInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRLightProbeInit>(isolate);
}
static XRLightProbeInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRLightProbeInit();
explicit  XRLightProbeInit(v8::Isolate* isolate);

bool hasReflectionFormat() const {
  return true;
}
V8XRReflectionFormat reflectionFormat() const {
  return member_reflection_format_;
}
void setReflectionFormat(V8XRReflectionFormat value) {
  member_reflection_format_ = value;
}
void setReflectionFormat(V8XRReflectionFormat::Enum value) {
  member_reflection_format_ = V8XRReflectionFormat(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8XRReflectionFormat member_reflection_format_{V8XRReflectionFormat::Enum::kSrgba8};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_LIGHT_PROBE_INIT_H_
