// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_LAYER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_LAYER_INIT_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_layer_layout.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class XRSpace;

class MODULES_EXPORT XRLayerInit : public bindings::InputDictionaryBase {
  
  public:
static XRLayerInit* Create() {
  return MakeGarbageCollected<XRLayerInit>();
}
static XRLayerInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRLayerInit>(isolate);
}
static XRLayerInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRLayerInit();
explicit  XRLayerInit(v8::Isolate* isolate);

bool hasClearOnAccess() const {
  return true;
}
bool clearOnAccess() const {
  return member_clear_on_access_;
}
void setClearOnAccess(bool value) {
  member_clear_on_access_ = value;
}

bool hasColorFormat() const {
  return true;
}
uint32_t colorFormat() const {
  return member_color_format_;
}
void setColorFormat(uint32_t value) {
  member_color_format_ = value;
}

bool hasDepthFormat() const {
  return has_depth_format_;
}
const std::optional<uint32_t>& depthFormat() const {
  DCHECK(hasDepthFormat());
return member_depth_format_;
}
std::optional<uint32_t> getDepthFormatOr(const std::optional<uint32_t>& fallback_value) const {
  if (!hasDepthFormat()) {
  return fallback_value;
}
return member_depth_format_;
}
void setDepthFormat(const std::optional<uint32_t>& value) {
  member_depth_format_ = value;
has_depth_format_ = true;
}
void setDepthFormat(uint32_t value) {
  member_depth_format_ = value;
has_depth_format_ = true;
}

bool hasIsStatic() const {
  return true;
}
bool isStatic() const {
  return member_is_static_;
}
void setIsStatic(bool value) {
  member_is_static_ = value;
}

bool hasLayout() const {
  return true;
}
V8XRLayerLayout layout() const {
  return member_layout_;
}
void setLayout(V8XRLayerLayout value) {
  member_layout_ = value;
}
void setLayout(V8XRLayerLayout::Enum value) {
  member_layout_ = V8XRLayerLayout(value);
}

bool hasMipLevels() const {
  return true;
}
uint32_t mipLevels() const {
  return member_mip_levels_;
}
void setMipLevels(uint32_t value) {
  member_mip_levels_ = value;
}

bool hasSpace() const {
  return true;
}
XRSpace* space() const {
  return member_space_.Get();
}
void setSpace(XRSpace* value) {
  member_space_ = value;
DCHECK(member_space_);
}

bool hasViewPixelHeight() const {
  return true;
}
uint32_t viewPixelHeight() const {
  return member_view_pixel_height_;
}
void setViewPixelHeight(uint32_t value) {
  member_view_pixel_height_ = value;
}

bool hasViewPixelWidth() const {
  return true;
}
uint32_t viewPixelWidth() const {
  return member_view_pixel_width_;
}
void setViewPixelWidth(uint32_t value) {
  member_view_pixel_width_ = value;
}


// Obsolete accessor functions
bool hasDepthFormatNonNull() const {
  return hasDepthFormat() && depthFormat().has_value();
}
uint32_t depthFormatNonNull() const {
  DCHECK(hasDepthFormatNonNull());
return depthFormat().value();
}

void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 9;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_depth_format_ = false;

bool member_clear_on_access_{true};
uint32_t member_color_format_{0x1908};
std::optional<uint32_t> member_depth_format_;
bool member_is_static_{false};
V8XRLayerLayout member_layout_{V8XRLayerLayout::Enum::kMono};
uint32_t member_mip_levels_{1};
Member<XRSpace> member_space_;
uint32_t member_view_pixel_height_;
uint32_t member_view_pixel_width_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_LAYER_INIT_H_
