// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_HIT_TEST_OPTIONS_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_HIT_TEST_OPTIONS_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_hit_test_trackable_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class XRRay;
class XRSpace;

class MODULES_EXPORT XRHitTestOptionsInit : public bindings::InputDictionaryBase {
  
  public:
static XRHitTestOptionsInit* Create() {
  return MakeGarbageCollected<XRHitTestOptionsInit>();
}
static XRHitTestOptionsInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRHitTestOptionsInit>(isolate);
}
static XRHitTestOptionsInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRHitTestOptionsInit();
explicit  XRHitTestOptionsInit(v8::Isolate* isolate);

bool hasEntityTypes() const {
  return has_entity_types_;
}
const Vector<V8XRHitTestTrackableType>& entityTypes() const {
  DCHECK(hasEntityTypes());
return member_entity_types_;
}
Vector<V8XRHitTestTrackableType> getEntityTypesOr(const Vector<V8XRHitTestTrackableType>& fallback_value) const;
Vector<V8XRHitTestTrackableType> getEntityTypesOr(Vector<V8XRHitTestTrackableType>&& fallback_value) const;
void setEntityTypes(const Vector<V8XRHitTestTrackableType>& value);
void setEntityTypes(Vector<V8XRHitTestTrackableType>&& value);

bool hasOffsetRay() const {
  return has_offset_ray_;
}
XRRay* offsetRay() const {
  DCHECK(hasOffsetRay());
return member_offset_ray_.Get();
}
XRRay* getOffsetRayOr(XRRay* fallback_value) const {
  if (!hasOffsetRay()) {
  return fallback_value;
}
return member_offset_ray_.Get();
}
void setOffsetRay(XRRay* value) {
  member_offset_ray_ = value;
has_offset_ray_ = true;
DCHECK(member_offset_ray_);
}

bool hasSpace() const {
  return true;
}
XRSpace* space() const {
  return member_space_.Get();
}
void setSpace(XRSpace* value) {
  member_space_ = value;
DCHECK(member_space_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_entity_types_ = false;
bool has_offset_ray_ = false;

Vector<V8XRHitTestTrackableType> member_entity_types_;
Member<XRRay> member_offset_ray_;
Member<XRSpace> member_space_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_HIT_TEST_OPTIONS_INIT_H_
