// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_DOM_OVERLAY_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_DOM_OVERLAY_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class Element;
class ExceptionState;

class MODULES_EXPORT XRDOMOverlayInit : public bindings::InputDictionaryBase {
  
  public:
static XRDOMOverlayInit* Create() {
  return MakeGarbageCollected<XRDOMOverlayInit>();
}
static XRDOMOverlayInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRDOMOverlayInit>(isolate);
}
static XRDOMOverlayInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRDOMOverlayInit();
explicit  XRDOMOverlayInit(v8::Isolate* isolate);

bool hasRoot() const {
  return true;
}
Element* root() const {
  return member_root_.Get();
}
void setRoot(Element* value) {
  member_root_ = value;
DCHECK(member_root_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<Element> member_root_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_DOM_OVERLAY_INIT_H_
