// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_websocket_open_info.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/streams/readable_stream.h"
#include "third_party/blink/renderer/core/streams/writable_stream.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"extensions",
"protocol",
"readable",
"writable",
};


}  // namespace 

WebSocketOpenInfo* WebSocketOpenInfo::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  WebSocketOpenInfo* dictionary = MakeGarbageCollected<WebSocketOpenInfo>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "WebSocketOpenInfo";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 WebSocketOpenInfo::WebSocketOpenInfo() {
  
}

 WebSocketOpenInfo::WebSocketOpenInfo(v8::Isolate* isolate) {
  
}



String WebSocketOpenInfo::getExtensionsOr(const String& fallback_value) const {
  if (!hasExtensions()) {
  return fallback_value;
}
return member_extensions_;
}

String WebSocketOpenInfo::getExtensionsOr(String&& fallback_value) const {
  if (!hasExtensions()) {
  return std::move(fallback_value);
}
return member_extensions_;
}

void WebSocketOpenInfo::setExtensions(const String& value) {
  member_extensions_ = value;
has_extensions_ = true;
}

void WebSocketOpenInfo::setExtensions(String&& value) {
  member_extensions_ = std::move(value);
has_extensions_ = true;
}




String WebSocketOpenInfo::getProtocolOr(const String& fallback_value) const {
  if (!hasProtocol()) {
  return fallback_value;
}
return member_protocol_;
}

String WebSocketOpenInfo::getProtocolOr(String&& fallback_value) const {
  if (!hasProtocol()) {
  return std::move(fallback_value);
}
return member_protocol_;
}

void WebSocketOpenInfo::setProtocol(const String& value) {
  member_protocol_ = value;
has_protocol_ = true;
}

void WebSocketOpenInfo::setProtocol(String&& value) {
  member_protocol_ = std::move(value);
has_protocol_ = true;
}


















void WebSocketOpenInfo::Trace(Visitor* visitor) const {
  visitor->Trace(member_readable_);
visitor->Trace(member_writable_);
bindings::DictionaryBase::Trace(visitor);
}

void WebSocketOpenInfo::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void WebSocketOpenInfo::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasExtensions()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_extensions_);
DCHECK(!values[0].IsEmpty());
}
if (hasProtocol()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_protocol_);
DCHECK(!values[1].IsEmpty());
}
if (hasReadable()) {
  values[2] = ToV8Traits<ReadableStream>::ToV8(script_state, member_readable_.Get());
DCHECK(!values[2].IsEmpty());
}
if (hasWritable()) {
  values[3] = ToV8Traits<WritableStream>::ToV8(script_state, member_writable_.Get());
DCHECK(!values[3].IsEmpty());
}
}

const void* WebSocketOpenInfo::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> WebSocketOpenInfo::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void WebSocketOpenInfo::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "WebSocketOpenInfo";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("extensions");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_extensions_, member_extensions_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("protocol");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_protocol_, member_protocol_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("readable");
if (!bindings::GetDictionaryMemberFromV8Object<ReadableStream, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_readable_, member_readable_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("writable");
if (!bindings::GetDictionaryMemberFromV8Object<WritableStream, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_writable_, member_writable_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> WebSocketOpenInfo::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
